/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.SimpleModelDataSource;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCatalog;
import com.cognos.xqe.metadata.provider.nativeodp.NativeDimension;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasure;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@BeanClassIntrospection(enabled=false)
public class NativeCube
extends NativeMetadata
implements ICube {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeCube.class);
    private SimpleModelDataSource dataSource = null;
    private final NativeCatalog catalog;
    private final CubeRecord record;
    private volatile List<NativeDimension> dimensions = null;
    private final Object dimensionsInitLock = new Object();
    private volatile NativeMeasure defaultMeasure = null;
    private volatile NativeDimension measuresDimension = null;
    private final Map<String, NativeDimension> dimensionCache = new HashMap<String, NativeDimension>();
    private final ReadWriteLock dimensionCacheLock = new ReentrantReadWriteLock(true);
    private final Map<String, NativeHierarchy> hierarchyCache = new HashMap<String, NativeHierarchy>();
    private final ReadWriteLock hierarchyCacheLock = new ReentrantReadWriteLock(true);
    private final Map<String, NativeLevel> levelCache = new HashMap<String, NativeLevel>();
    private final ReadWriteLock levelCacheLock = new ReentrantReadWriteLock(true);

    NativeCube(NativeMetadataConnection theMDConnection, CubeRecord theRecord, NativeCatalog theCatalog) {
        super(theMDConnection);
        this.record = theRecord;
        this.catalog = theCatalog;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public ICatalog getCatalog() {
        return this.catalog;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public DateTimeValue getCreatedDate() {
        return this.record.getCreatedDate();
    }

    @Override
    public IMeasure getDefaultMeasure() {
        if (null == this.defaultMeasure) {
            IHierarchy measuresHierarchy = this.getMeasuresHierarchy();
            if (null == measuresHierarchy) {
                return null;
            }
            IMember defaultMember = measuresHierarchy.getDefaultMember();
            if (null != defaultMember && defaultMember.isMeasure()) {
                this.defaultMeasure = (NativeMeasure)defaultMember;
            }
        }
        return this.defaultMeasure;
    }

    @Override
    public IDimension getDimension(String dimensionUniqueName) {
        NativeDimension result = this.getCachedDimension(dimensionUniqueName);
        if (null != result) {
            return result;
        }
        for (IDimension dimension : this.getDimensions()) {
            if (!dimension.getUniqueName().equals(dimensionUniqueName)) continue;
            return dimension;
        }
        return null;
    }

    @Override
    public IDimension getDimension(int index) {
        this.initializeDimensions();
        return this.dimensions.get(index);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getDimensionCount() {
        this.initializeDimensions();
        return this.dimensions.size();
    }

    @Override
    public int getDimensionIndex(IDimension d) {
        this.initializeDimensions();
        return this.dimensions.indexOf(d);
    }

    @Override
    public List<IDimension> getDimensions() {
        this.initializeDimensions();
        List<NativeDimension> result = Collections.unmodifiableList(this.dimensions);
        return CollectionCast.upcast(result, IDimension.class);
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName) {
        IHierarchy result = this.getCachedHierarchy(hierarchyUniqueName);
        if (null != result) {
            return result;
        }
        for (IDimension dimension : this.getDimensions()) {
            result = dimension.getHierarchy(hierarchyUniqueName);
            if (null == result) continue;
            return result;
        }
        return null;
    }

    public IDimension getMeasuresDimension() {
        if (null == this.measuresDimension) {
            for (IDimension dimension : this.getDimensions()) {
                if (!dimension.isMeasuresDimension()) continue;
                this.measuresDimension = (NativeDimension)dimension;
            }
        }
        return this.measuresDimension;
    }

    @Override
    public IHierarchy getMeasuresHierarchy() {
        IDimension dim = this.getMeasuresDimension();
        if (null != dim) {
            return dim.getDefaultHierarchy();
        }
        return null;
    }

    @Override
    public INamespace getNamespace() {
        return null;
    }

    @Override
    public boolean getPropagateNulls() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public DateTimeValue getSchemaUpdatedDate() {
        return this.record.getSchemaUpdateDate();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return this.record.getSuppressionType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public DateTimeValue getUpdatedDate() {
        return this.record.getDataUpdateDate();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getStringType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public final MetadataType getObjectType() {
        return MetadataType.CUBE;
    }

    @Override
    public IMetadata getParentObject() {
        return this.catalog;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        this.initializeDimensions();
        return this.dimensions.size() > 0;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        List<IDimension> result = this.getDimensions();
        return CollectionCast.upcast(result, IMetadata.class);
    }

    NativeDimension getCachedDimension(String dimensionUniqueName) {
        try {
            this.dimensionCacheLock.readLock().lock();
            NativeDimension nativeDimension = this.dimensionCache.get(dimensionUniqueName);
            return nativeDimension;
        }
        finally {
            this.dimensionCacheLock.readLock().unlock();
        }
    }

    NativeHierarchy getCachedHierarchy(String hierarchyUniqueName) {
        try {
            this.hierarchyCacheLock.readLock().lock();
            NativeHierarchy nativeHierarchy = this.hierarchyCache.get(hierarchyUniqueName);
            return nativeHierarchy;
        }
        finally {
            this.hierarchyCacheLock.readLock().unlock();
        }
    }

    NativeLevel getCachedLevel(String levelUniqueName) {
        try {
            this.levelCacheLock.readLock().lock();
            NativeLevel nativeLevel = this.levelCache.get(levelUniqueName);
            return nativeLevel;
        }
        finally {
            this.levelCacheLock.readLock().unlock();
        }
    }

    void putCachedDimension(NativeDimension theDimension) {
        try {
            this.dimensionCacheLock.writeLock().lock();
            this.dimensionCache.put(theDimension.getUniqueName(), theDimension);
        }
        finally {
            this.dimensionCacheLock.writeLock().unlock();
        }
    }

    void putCachedHierarchy(NativeHierarchy theHierarchy) {
        try {
            this.dimensionCacheLock.writeLock().lock();
            this.hierarchyCache.put(theHierarchy.getUniqueName(), theHierarchy);
        }
        finally {
            this.dimensionCacheLock.writeLock().unlock();
        }
    }

    void putCachedLevel(NativeLevel theLevel) {
        try {
            this.levelCacheLock.writeLock().lock();
            this.levelCache.put(theLevel.getUniqueName(), theLevel);
        }
        finally {
            this.levelCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDimensions() {
        if (null != this.dimensions) {
            return;
        }
        Object object = this.dimensionsInitLock;
        synchronized (object) {
            if (null == this.dimensions) {
                NativeMetadataConnection connection = this.getNativeConnection();
                ArrayList<NativeDimension> theList = new ArrayList<NativeDimension>();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, this.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, this.getName());
                List<DimensionRecord> dimensionRecords = this.getMetadataProvider().getDimensions(restrictions);
                for (DimensionRecord dimensionRecord : dimensionRecords) {
                    NativeDimension theDimension = new NativeDimension(connection, dimensionRecord, this);
                    theList.add(theDimension);
                    this.putCachedDimension(theDimension);
                }
                this.dimensions = theList;
            }
        }
    }

    @Override
    public IModelDataSource getModelDataSource() {
        if (this.dataSource == null) {
            NativeMetadataConnection nmdConnection = this.getNativeConnection();
            this.dataSource = new SimpleModelDataSource();
            this.dataSource.setConnection(nmdConnection);
            this.dataSource.setProperty("cube", this.getName());
            this.dataSource.setProperty("catalog", this.getCatalog().getName());
            this.dataSource.setProperty("interface", nmdConnection.getDataSource().getType());
        }
        return this.dataSource;
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public IDimension getMeasureDimension() {
        List<IDimension> dimension = this.getDimensions();
        if (dimension == null) {
            return null;
        }
        int dimCnt = dimension.size();
        for (int i = 0; i < dimCnt; ++i) {
            IDimension dim = dimension.get(i);
            if (!dim.isMeasuresDimension()) continue;
            return dim;
        }
        return null;
    }

    @Override
    public IDimension queryDimension(String dimensionUName) {
        return null;
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        return false;
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        return false;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

