/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.metadata.ActionTypeEnum;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class ActionRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement(callMethod="name")
    private ActionTypeEnum commandType = null;
    @XMLElement
    private String command = "";
    @XMLElement(callMethod="name")
    private ActionCoordinateTypeEnum coordinateType = ActionCoordinateTypeEnum.CELL;
    @XMLElement
    private String coordinateValue = "";

    @Override
    public RecordType getRecordType() {
        return RecordType.ACTION;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public ActionTypeEnum getCommandType() {
        return this.commandType;
    }

    public String getCommand() {
        return this.command;
    }

    public ActionCoordinateTypeEnum getCoordinateType() {
        return this.coordinateType;
    }

    public String getCoordinateValue() {
        return this.coordinateValue;
    }

    public void setCatalogName(String theCatalogName) {
        ActionRecord.assertNotNull(theCatalogName);
        this.catalogName = ActionRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        ActionRecord.assertNotNull(theSchemaName);
        this.schemaName = ActionRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        ActionRecord.assertNotNull(theCubeName);
        this.cubeName = ActionRecord.internalizeString(theCubeName);
    }

    public void setCommandType(ActionTypeEnum commandType1) {
        this.commandType = commandType1;
    }

    public void setCommand(String theCommand) {
        ActionRecord.assertNotNull(theCommand);
        this.command = theCommand;
    }

    public void setCoordinateType(ActionCoordinateTypeEnum theCoordinateType) {
        this.coordinateType = theCoordinateType;
    }

    public void setCoordinateValue(String theCoordinateValue) {
        ActionRecord.assertNotNull(theCoordinateValue);
        this.coordinateValue = theCoordinateValue;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        output.writeInt(this.getCommandType().ordinal());
        ExternalizeUtil.externalizeString(output, this.getCommand());
        output.writeInt(this.getCoordinateType().ordinal());
        ExternalizeUtil.externalizeString(output, this.getCoordinateValue());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setCommandType(ActionTypeEnum.valueOf(input.readInt()));
        this.setCommand(ExternalizeUtil.deexternalizeString(input));
        this.setCoordinateType(ActionCoordinateTypeEnum.valueOf(input.readInt()));
        this.setCoordinateValue(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(ActionRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setCommand(this.getCommand());
        theCopy.setCommandType(this.getCommandType());
        theCopy.setCoordinateType(this.getCoordinateType());
        theCopy.setCoordinateValue(this.getCoordinateValue());
    }

    @Override
    public Object copy() {
        ActionRecord clonedRecord = new ActionRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

