/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class LevelRecord
extends MetadataRecord {
    private static final String ATTRIBUTE_HIERARCHY_NAME = "Base_Attribute_Hierarchy";
    private static final String IS_HIDDEN = "Is_Hidden";
    private static final String IS_NOT_ACCESSIBLE = "Is_Not_Accessible";
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = "";
    @XMLElement
    private String hierarchyUniqueName = "";
    @XMLElement
    private int levelNumber = -1;
    @XMLElement
    private int cardinality = 0;
    @XMLElement(name="hasUniqueMemberNames")
    private boolean uniqueMemberNames = true;

    @Override
    public RecordType getRecordType() {
        return RecordType.LEVEL;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public boolean hasUniqueMemberNames() {
        return this.uniqueMemberNames;
    }

    public boolean isHidden() {
        Boolean hidden = this.getDynamicFieldAsBoolean(IS_HIDDEN);
        if (null != hidden) {
            return hidden;
        }
        return false;
    }

    public boolean isNotAccessible() {
        Boolean notAccessible = this.getDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE);
        if (null != notAccessible) {
            return notAccessible;
        }
        return false;
    }

    public void setCatalogName(String theCatalogName) {
        LevelRecord.assertNotNull(theCatalogName);
        this.catalogName = LevelRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        LevelRecord.assertNotNull(theSchemaName);
        this.schemaName = LevelRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        LevelRecord.assertNotNull(theCubeName);
        this.cubeName = LevelRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        LevelRecord.assertNotNull(theDimensionUniqueName);
        this.dimensionUniqueName = LevelRecord.internalizeString(theDimensionUniqueName);
    }

    public void setHierarchyUniqueName(String theHierarchyUniqueName) {
        LevelRecord.assertNotNull(theHierarchyUniqueName);
        this.hierarchyUniqueName = LevelRecord.internalizeString(theHierarchyUniqueName);
    }

    public void setLevelNumber(int theLevelNumber) {
        this.levelNumber = theLevelNumber;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    public void setUniqueMemberNames(boolean hasUniqueMemberNames) {
        this.uniqueMemberNames = hasUniqueMemberNames;
    }

    public void setHidden(Boolean theIsHidden) {
        this.setDynamicFieldAsBoolean(IS_HIDDEN, theIsHidden);
    }

    public void setNotAccessible(Boolean theIsNotAccessible) {
        this.setDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE, theIsNotAccessible);
    }

    public String getAttributeHierarchyName() {
        return this.getDynamicFieldAsString(ATTRIBUTE_HIERARCHY_NAME);
    }

    public void setAttributeHierarchyName(String attribHierName) {
        this.setDynamicFieldAsString(ATTRIBUTE_HIERARCHY_NAME, attribHierName);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyUniqueName());
        output.writeInt(this.getLevelNumber());
        output.writeInt(this.getCardinality());
        output.writeBoolean(this.hasUniqueMemberNames());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setLevelNumber(input.readInt());
        this.setCardinality(input.readInt());
        this.setUniqueMemberNames(input.readBoolean());
    }

    public void copyTo(LevelRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setHierarchyUniqueName(this.getHierarchyUniqueName());
        theCopy.setLevelNumber(this.getLevelNumber());
        theCopy.setCardinality(this.getCardinality());
        theCopy.setUniqueMemberNames(this.hasUniqueMemberNames());
    }

    @Override
    public Object copy() {
        LevelRecord clonedRecord = new LevelRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

