/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.virtual;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;

public class VirtualCube
extends Cube
implements ICube {
    protected MetadataConnection connection;

    public VirtualCube(MetadataConnection theConnection) {
        this.connection = theConnection;
        this.createdDate = DataValueFactory.createTimestampValue();
        this.name = "virtual_cube";
    }

    @Override
    public DateTimeValue getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public DateTimeValue getUpdatedDate() {
        return this.createdDate;
    }

    @Override
    public ICatalog getCatalog() {
        return this.getModelDataSource().getCatalog();
    }

    @Override
    public DateTimeValue getSchemaUpdatedDate() {
        return this.createdDate;
    }

    @Override
    public IMeasure getDefaultMeasure() {
        IHierarchy measuresHierarchy;
        if (null == this.defaultMeasure && (measuresHierarchy = this.getMeasuresHierarchy()) != null) {
            this.defaultMeasure = (IMeasure)measuresHierarchy.getDefaultMember();
        }
        return this.defaultMeasure;
    }

    @Override
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return ICube.CubeSuppressionTypeEnum.NULL;
    }

    @Override
    public IModelDataSource getModelDataSource() {
        return this.getMfwDatasource();
    }

    public IModelDataSource getMfwDatasource() {
        return this.datasource;
    }

    @Override
    public List<IVariable> getVariables() {
        return this.getMfwDatasource().getVariables();
    }

    @Override
    public String getUniqueName() {
        return UniqueNameGenerator.createUniqueName(this.getName());
    }

    @Override
    public String toString() {
        return this.getModelDataSource().toString() + "/" + this.getUniqueName();
    }

    @Override
    public String getCaption() {
        return this.name;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.connection;
    }
}

