/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Dimension;
import com.cognos.xqe.ast.v5.query.V5Fact;
import com.cognos.xqe.ast.v5.query.V5Key;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.SortItem;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CalculationWrapper;
import com.cognos.xqe.metadata.wrapper.DimensionWrapper;
import com.cognos.xqe.metadata.wrapper.DynamicDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.FilterWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.MonoHierarchyDimension;
import com.cognos.xqe.metadata.wrapper.QueryItemOfLevelWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfQuerySubjectToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfQuerySubjectToMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.ScopeRelationshipWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionCacheManager;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;

public class CubeWrapper
extends Cube {
    private static final String DESCRIPTION = "";
    private INamespace rootNamespace;
    private Dimension measuresDim = null;
    private Hierarchy measuresHier = null;
    private Level measuresLevel = null;
    private Map<IMetadata, IMetadata> wrappedToWrapperMap;
    private Map<IMetadata, IMetadata> wrappedToWrapperMapReverseLookup;
    private Lock wrappedToWrapperReadLock;
    private Lock wrappedToWrapperWriteLock;
    private Lock hierarchyToMonoDimReadLock;
    private Lock hierarchyToMonoDimWriteLock;
    private Map<IMetadata, IMetadata> hierarchyToMonoDimensionHierarchy;
    private Map<IMetadata, IMetadata> hierarchyToMonoDimensionHierarchyReverseLookup;
    public static final int THREE = 3;
    public static final String MEASURES = "Measures";
    private static final String RIGHT_BRACKET = "]";
    private static final String DOUBLE_RIGHT_BRACKET = "]]";
    private static final String DEFAULTMEASURE = "DefaultMeasure";
    private static final String MEASURE_DESCRIPTION = "Measure containing all measure from all name space.";
    protected static final String MISSING_DIMENSION_MESSAGE = "Dimension missing from cubeWrapper.";
    public static final String MISSING_METADATA_WRAPPER_MESSAGE = "Metadata missing from cubeWrapper.";
    private static final String MISSING_QUERYITEM_MESSAGE = "Unable to find QueryItem.";
    public static final String MONO_DIMENSION_DESCRIPTION = "Mono hierarchy dimension";
    public static final String DYNAMIC_DIMENSION_DESCRIPTION = "Dynamic dimension";
    static final String UNDERSCORE = "_";
    public static final String DUMMY = "dummy";
    public static final String SECOND_DUMMY = "secondDummy";
    public static final String TRUE = "true";
    public static final String ALL = "all";
    public static final String TAG_DIM_NAME = "tagDimension";
    public static final String TAG_COMPLETETUPLE_LEVEL_NAME = "tagLevelForCompleteTuple";
    public static final String TAG_COMPLETETUPLE_NAME = "tagCompleteTuple";
    private static final String DUMMY_DESCRIPTION = "Dummy dimension, with a single hierarchy, with a single levelthat has a single root member 'all'";
    private static final String NAME = "name";
    private static final String REFDATAITEM = "refDataItem";
    private List<CogMDXDetailFilter> detailFilters = new ArrayList<CogMDXDetailFilter>();
    private RQPPrePlan rqpPrePlan = null;
    private TabStreamWrapper mTabStreamWrapper = null;
    private String mTabularResultSetName = null;
    private boolean mDesignMode;
    private boolean relxtabDirect = false;
    private V5QuerySet v5QuerySetForV5Source = null;
    private V5QuerySet v5QuerySetForSubQueryInDetailFilter = null;
    private Level tagCompleteTupleLevel = null;
    private Governors mGovernors = null;
    private ArrayList<String> cubeParameters = null;
    private boolean singleQueryLoading = false;
    private DimensionCacheManager dimManager = null;
    private String fetchTopN = null;

    public CubeWrapper(MetadataConnection connection, Governors governors) {
        INamespace rRootNamespace = connection.getRootNamespace();
        this.mGovernors = governors;
        this.rootNamespace = rRootNamespace;
        if (this.rootNamespace != null) {
            this.name = this.rootNamespace.toString();
            this.caption = this.rootNamespace.getCaption();
        } else {
            this.name = connection.getModelName();
            this.caption = connection.getModelName();
        }
        this.namespace = rRootNamespace;
        this.mDesignMode = this.mGovernors != null && this.mGovernors.getDesignMode() == Boolean.TRUE;
        this.setConnection(connection);
        Dimension dim = this.createDummies(DUMMY, DUMMY_DESCRIPTION, DimensionTypeEnum.REGULAR);
        Dimension dim2 = this.createDummies(SECOND_DUMMY, DUMMY_DESCRIPTION, DimensionTypeEnum.REGULAR);
        dim.setProperty("isManual", TRUE);
        dim2.setProperty("isManual", TRUE);
        Hierarchy hier = (Hierarchy)dim.getHierarchies().get(0);
        hier.setProperty("isManual", TRUE);
        Hierarchy hier2 = (Hierarchy)dim2.getHierarchies().get(0);
        hier2.setProperty("isManual", TRUE);
        Level level = (Level)hier.getLevel(0);
        level.setProperty("isManual", TRUE);
        Level level2 = (Level)hier2.getLevel(0);
        level2.setProperty("isManual", TRUE);
        Member allMember = new Member(ALL);
        allMember.setUniqueName(this.buildAllMemberUniqueName(hier));
        level.addMember(allMember, allMember);
        level.addChildMetadataObject(allMember);
        hier.setDefaultMember(allMember);
        Member allMember2 = new Member(ALL);
        allMember2.setUniqueName(this.buildAllMemberUniqueName(hier2));
        level2.addMember(allMember2, allMember2);
        level2.addChildMetadataObject(allMember2);
        hier2.setDefaultMember(allMember2);
        this.createTagDimension();
        this.wrappedToWrapperMap = new HashMap<IMetadata, IMetadata>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.wrappedToWrapperReadLock = lock.readLock();
        this.wrappedToWrapperWriteLock = lock.writeLock();
        this.wrappedToWrapperMapReverseLookup = new HashMap<IMetadata, IMetadata>();
        this.hierarchyToMonoDimensionHierarchy = new HashMap<IMetadata, IMetadata>();
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock(true);
        this.hierarchyToMonoDimReadLock = lock2.readLock();
        this.hierarchyToMonoDimWriteLock = lock2.writeLock();
        this.hierarchyToMonoDimensionHierarchyReverseLookup = new HashMap<IMetadata, IMetadata>();
        this.createMeasuresDimension();
        this.createdDate = DataValueFactory.createTimestampValue();
        this.createdDate.set(Calendar.getInstance());
        this.description = DESCRIPTION;
    }

    protected void createTagDimension() {
        Dimension tagDimension = this.createDummies(TAG_DIM_NAME, TAG_DIM_NAME, DimensionTypeEnum.REGULAR);
        tagDimension.setProperty("isManual", TRUE);
        Hierarchy tagHier = (Hierarchy)tagDimension.getHierarchies().get(0);
        tagHier.setProperty("isManual", TRUE);
        Level tagAlllevel = (Level)tagHier.getLevel(0);
        tagAlllevel.setProperty("isManual", TRUE);
        Member tagAllMember = new Member(ALL);
        tagAllMember.setUniqueName(this.buildAllMemberUniqueName(tagHier));
        tagAlllevel.addMember(tagAllMember, tagAllMember);
        tagAlllevel.addChildMetadataObject(tagAllMember);
        tagHier.setDefaultMember(tagAllMember);
        this.tagCompleteTupleLevel = new Level();
        this.tagCompleteTupleLevel.setProperty("isManual", TRUE);
        this.tagCompleteTupleLevel.setName(TAG_COMPLETETUPLE_LEVEL_NAME);
        this.tagCompleteTupleLevel.setConnection(this.getConnection());
        tagHier.addLevel(this.tagCompleteTupleLevel);
        tagHier.addChildMetadataObject(this.tagCompleteTupleLevel);
        this.tagCompleteTupleLevel.setHierarchy(tagHier);
        this.tagCompleteTupleLevel.setUniqueName(UniqueNameGenerator.createUniqueName(TAG_DIM_NAME, TAG_DIM_NAME, TAG_COMPLETETUPLE_LEVEL_NAME));
        Member tagMember = new Member(TAG_COMPLETETUPLE_NAME);
        tagMember.setUniqueName(UniqueNameGenerator.appendUniqueName(this.tagCompleteTupleLevel.getUniqueName(), TAG_COMPLETETUPLE_NAME));
        this.tagCompleteTupleLevel.addMember(tagMember, tagAllMember);
        this.tagCompleteTupleLevel.addChildMetadataObject(tagMember);
    }

    private String buildAllMemberUniqueName(IHierarchy hier) {
        return UniqueNameGenerator.appendUniqueName(hier.getUniqueName(), ALL);
    }

    public List<CogMDXDetailFilter> getDetailFilters() {
        return this.detailFilters;
    }

    public void addDetailFilter(CogMDXDetailFilter detailFilter) {
        this.detailFilters.add(detailFilter);
    }

    @Override
    public void addDimension(IDimension dim) {
        if (!dim.isMeasuresDimension()) {
            super.addDimension(dim);
            return;
        }
        if (this.measuresDim == null) {
            this.createMeasuresDimension();
        }
        this.addChildWrapperObject(dim, this.measuresDim);
        int measuresCount = this.wrapMeasures(dim);
        this.measuresDim.setCardinality(this.measuresDim.getCardinality() + measuresCount);
    }

    private int wrapMeasures(IMetadata metadata) {
        int measuresCount = 0;
        List<IMetadata> list = metadata.getChildMetadataObjects();
        for (IMetadata child : list) {
            IMeasure measure;
            if (child.getObjectType() == MetadataType.FOLDER) {
                measuresCount += this.wrapMeasures(child);
                continue;
            }
            if (child.getObjectType() != MetadataType.MEMBER || !((IMember)child).isMeasure() || this.getWrapper(measure = (IMeasure)child) != null) continue;
            this.createMeasure(measure);
            ++measuresCount;
        }
        return measuresCount;
    }

    private void createMeasuresDimension() {
        this.measuresDim = this.createDummies(MEASURES, MEASURE_DESCRIPTION, DimensionTypeEnum.MEASURE);
        this.measuresHier = (Hierarchy)this.measuresDim.getDefaultHierarchy();
        this.measuresLevel = (Level)this.measuresHier.getLevels().get(0);
        this.measuresLevel.setUniqueName(UniqueNameGenerator.createUniqueName(MEASURES, MEASURES, "MeasuresLevel"));
    }

    private Dimension createDummies(String name, String description, DimensionTypeEnum dimType) {
        Dimension dummyDim = this.createDummyDimension(name, description, dimType);
        Hierarchy dummyHierarchy = new Hierarchy();
        dummyHierarchy.setName(dummyDim.getName());
        dummyHierarchy.setUniqueName(UniqueNameGenerator.createUniqueName(dummyDim.getName(), dummyDim.getName()));
        dummyHierarchy.setConnection(this.getConnection());
        dummyDim.addHierarchy(dummyHierarchy);
        dummyDim.addChildMetadataObject(dummyHierarchy);
        dummyHierarchy.setDimension(dummyDim);
        Level dummyLevel = new Level();
        dummyLevel.setName(dummyDim.getName());
        dummyLevel.setUniqueName(UniqueNameGenerator.createUniqueName(dummyDim.getName(), dummyDim.getName(), dummyDim.getName()));
        dummyLevel.setConnection(this.getConnection());
        dummyHierarchy.addLevel(dummyLevel);
        dummyHierarchy.addChildMetadataObject(dummyLevel);
        dummyLevel.setHierarchy(dummyHierarchy);
        dummyDim.setDefaultHierarchy(dummyHierarchy);
        dummyDim.setHierarchy(dummyHierarchy);
        super.addDimension(dummyDim);
        return dummyDim;
    }

    private Dimension createDummyDimension(String name, String description, DimensionTypeEnum dimType) {
        return this.createDummyDimension(name, description, dimType, null);
    }

    private Dimension createDummyDimension(String name, String description, DimensionTypeEnum dimType, IDimension toWrap) {
        Dimension dummyDim = null;
        dummyDim = toWrap != null ? new MonoHierarchyDimension(name, this, toWrap) : new Dimension(name);
        dummyDim.setCaption(name);
        dummyDim.setCube(this);
        dummyDim.setDescription(description);
        dummyDim.setType(dimType);
        dummyDim.setUniqueName(UniqueNameGenerator.createUniqueName(name));
        dummyDim.setV5UniqueName(UniqueNameGenerator.createV5UniqueName(dummyDim));
        dummyDim.setInitialised();
        dummyDim.setMembersRollup(false);
        return dummyDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDimension createMonoDimension(DimensionWrapper dim, IHierarchy hierarchy) {
        StringBuilder sb = new StringBuilder(dim.getName());
        sb.append(UNDERSCORE);
        sb.append(hierarchy.getName());
        Dimension monoDim = this.createDummyDimension(sb.toString(), MONO_DIMENSION_DESCRIPTION, DimensionTypeEnum.REGULAR, dim.getWrappedDimension());
        monoDim.setV5UniqueName(dim.getV5UniqueName());
        monoDim.setMembersRollup(dim.getMembersRollup());
        this.addDimension(monoDim);
        HierarchyWrapper hierWrapper = new HierarchyWrapper(monoDim, hierarchy);
        monoDim.addHierarchy(hierWrapper);
        IMetadata wrappedDim = this.getWrapped(dim);
        this.hierarchyToMonoDimWriteLock.lock();
        try {
            this.hierarchyToMonoDimensionHierarchy.put(hierarchy, hierWrapper);
            this.hierarchyToMonoDimensionHierarchyReverseLookup.put(hierWrapper, hierarchy);
            this.hierarchyToMonoDimensionHierarchy.put(wrappedDim, monoDim);
            this.hierarchyToMonoDimensionHierarchyReverseLookup.put(monoDim, wrappedDim);
        }
        finally {
            this.hierarchyToMonoDimWriteLock.unlock();
        }
        if (monoDim instanceof MonoHierarchyDimension) {
            ((MonoHierarchyDimension)monoDim).setMetadataContext(dim.getMetadataContext());
        }
        return monoDim;
    }

    public static String getMeasureDimensionV5UniqueName(String measureV5UniqueName) {
        String[] parts = null;
        try {
            parts = UniqueNameParser.parse(measureV5UniqueName);
        }
        catch (UniqueNameParserException e) {
            return null;
        }
        if (parts.length < 3) {
            throw new XQERuntimeException();
        }
        return UniqueNameGenerator.createUniqueName(new String[]{parts[0], parts[1]});
    }

    private void addChildWrapperObject(IMetadata wrapped, IMetadata wrapper) {
        this.wrappedToWrapperWriteLock.lock();
        try {
            this.wrappedToWrapperMap.put(wrapped, wrapper);
            this.wrappedToWrapperMapReverseLookup.put(wrapper, wrapped);
        }
        finally {
            this.wrappedToWrapperWriteLock.unlock();
        }
    }

    public List<QueryItemOfLevelWrapper> getQueryItemsWithNullDataType() {
        ArrayList<QueryItemOfLevelWrapper> queryItemsWithNullDataType = new ArrayList<QueryItemOfLevelWrapper>();
        for (IMetadata m : this.wrappedToWrapperMap.keySet()) {
            IMetadata wrapper = this.wrappedToWrapperMap.get(m);
            if (!(wrapper instanceof QueryItemOfLevelWrapper)) continue;
            QueryItemOfLevelWrapper qi = (QueryItemOfLevelWrapper)wrapper;
            queryItemsWithNullDataType.add(qi);
        }
        return queryItemsWithNullDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMetadata getWrapperFromMap(IMetadata wrapped) {
        IMetadata wrapper = null;
        if (wrapped.getObjectType() == MetadataType.HIERARCHY) {
            this.hierarchyToMonoDimReadLock.lock();
            try {
                wrapper = this.hierarchyToMonoDimensionHierarchy.get(wrapped);
            }
            finally {
                this.hierarchyToMonoDimReadLock.unlock();
            }
        }
        if (wrapper != null) {
            return wrapper;
        }
        this.wrappedToWrapperReadLock.lock();
        try {
            wrapper = this.wrappedToWrapperMap.get(wrapped);
        }
        finally {
            this.wrappedToWrapperReadLock.unlock();
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetadata getWrapped(IMetadata wrapper) {
        if (wrapper instanceof AbstractDimensionWrapper) {
            return ((AbstractDimensionWrapper)wrapper).getWrappedDimension();
        }
        if (wrapper instanceof HierarchyWrapper) {
            return ((HierarchyWrapper)wrapper).getWrappedHierarchy();
        }
        if (wrapper instanceof LevelWrapper) {
            return ((LevelWrapper)wrapper).getWrappedLevel();
        }
        IMetadata wrapped = null;
        if (wrapper.getObjectType() == MetadataType.HIERARCHY || wrapper.getObjectType() == MetadataType.DIMENSION) {
            this.hierarchyToMonoDimReadLock.lock();
            try {
                wrapped = this.hierarchyToMonoDimensionHierarchyReverseLookup.get(wrapper);
            }
            finally {
                this.hierarchyToMonoDimReadLock.unlock();
            }
            if (wrapped != null) {
                return wrapped;
            }
        }
        this.wrappedToWrapperReadLock.lock();
        try {
            wrapped = this.wrappedToWrapperMapReverseLookup.get(wrapper);
        }
        finally {
            this.wrappedToWrapperReadLock.unlock();
        }
        return wrapped;
    }

    public IMetadata getWrapper(IMetadata metadata) {
        MetadataType type = metadata.getObjectType();
        IMetadata wrapper = null;
        switch (type) {
            case DIMENSION: {
                if (metadata == this.measuresDim || metadata instanceof DimensionWrapper) {
                    return metadata;
                }
                if (((IDimension)metadata).isMeasuresDimension()) {
                    return this.measuresDim;
                }
                return this.getWrapperFromMap(metadata);
            }
            case HIERARCHY: {
                if (metadata == this.measuresHier || metadata instanceof HierarchyWrapper) {
                    return metadata;
                }
                IHierarchy hierarchy = (IHierarchy)metadata;
                IHierarchy hierWrapper = (IHierarchy)this.getWrapperFromMap(hierarchy);
                if (hierWrapper == null) {
                    IDimension dimension = hierarchy.getDimension();
                    IDimension dimWrapper = (IDimension)this.getWrapper(dimension);
                    if (dimWrapper == null) {
                        return null;
                    }
                    dimWrapper.getChildMetadataObjects();
                }
                return this.getWrapperFromMap(metadata);
            }
            case LEVEL: {
                if (metadata == this.measuresLevel || metadata instanceof LevelWrapper) {
                    return metadata;
                }
                ILevel levelWrapper = (ILevel)this.getWrapperFromMap(metadata);
                if (levelWrapper == null) {
                    IHierarchy hier = ((ILevel)metadata).getHierarchy();
                    IHierarchy hierarchyWrapper = (IHierarchy)this.getWrapper(hier);
                    if (hierarchyWrapper == null) {
                        IDimension dimension = hier.getDimension();
                        IDimension dimWrapper = (IDimension)this.getWrapper(dimension);
                        if (dimWrapper == null) {
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Dimension has not been created");
                        }
                        dimWrapper.getChildMetadataObjects();
                    }
                    IHierarchy hierWrapper = (IHierarchy)this.getWrapperFromMap(hier);
                    hierWrapper.getChildMetadataObjects();
                }
                return this.getWrapperFromMap(metadata);
            }
            case MEMBER: {
                return this.getWrapperFromMap(metadata);
            }
            case SCOPE_RELATIONSHIP: {
                IScopeRelationship scopeRel = (IScopeRelationship)this.getWrapperFromMap(metadata);
                if (scopeRel == null) {
                    scopeRel = this.createScopeRelationship((IScopeRelationship)metadata);
                }
                return scopeRel;
            }
            case QUERY_ITEM: {
                IQueryItem queryItem = (IQueryItem)metadata;
                if (queryItem.getLevel() != null) {
                    wrapper = this.getWrapperFromMap(queryItem);
                    if (wrapper == null) {
                        LevelWrapper levelOfQI = (LevelWrapper)this.getWrapper(queryItem.getLevel());
                        levelOfQI.populateChildren();
                    }
                    wrapper = this.getWrapperFromMap(queryItem);
                } else if (queryItem.getQuerySubject() != null && (wrapper = this.getWrapperFromMap(metadata)) == null) {
                    wrapper = this.createQueryItemOfSubject(queryItem);
                }
                return wrapper;
            }
            case FILTER: {
                wrapper = this.getWrapperFromMap(metadata);
                if (wrapper == null) {
                    wrapper = this.createFilter((IFilter)metadata);
                }
                return wrapper;
            }
            case SHORTCUT: {
                IMetadata metadataSc = ((IShortcut)metadata).getTargetWithShortcut();
                wrapper = this.getWrapperFromMap(metadataSc);
                if (wrapper == null) {
                    if (metadataSc instanceof IDimension) {
                        IDimension mfwDimension = (IDimension)metadataSc;
                        String[] namespaces = mfwDimension.getParentNamespaces();
                        wrapper = mfwDimension.isMeasuresDimension() ? this.measuresDim : this.createDimension(mfwDimension, namespaces);
                    } else if (metadataSc instanceof ICalculation) {
                        ICalculation mfwCalculation = (ICalculation)metadataSc;
                        wrapper = this.createCalculation(mfwCalculation);
                    }
                }
                return wrapper;
            }
            case CALCULATION: {
                wrapper = this.getWrapperFromMap(metadata);
                if (wrapper == null) {
                    wrapper = this.createCalculation((ICalculation)metadata);
                }
                return wrapper;
            }
        }
        return null;
    }

    public DimensionWrapper createDimension(IDimension toWrap, String[] namespaces) {
        IMetadataContextManager contextMgr;
        DimensionWrapper dimWrapper = new DimensionWrapper(this, toWrap);
        dimWrapper.setName(this.buildDimensionName(namespaces, toWrap));
        this.addChildMetadataObject(dimWrapper);
        this.addChildWrapperObject(toWrap, dimWrapper);
        this.addDimension(dimWrapper);
        MetadataConnection conn = this.getConnection();
        if (conn != null && (contextMgr = conn.getMetadataContextManager()) != null) {
            dimWrapper.setMetadataContext(contextMgr.generateContextIfRequired(toWrap.getV5UniqueName(), toWrap.getDescription()));
        }
        return dimWrapper;
    }

    public void createDimension(V5Dimension v5Dim) {
        String name = (String)v5Dim.getPropertyValue(NAME);
        if (this.getDimension(name) != null) {
            return;
        }
        Dimension dimension = this.createDummyDimension(name, "DimensionInfo", DimensionTypeEnum.REGULAR);
        Hierarchy hierarchy = new Hierarchy(name);
        String[] dimParts = null;
        try {
            dimParts = UniqueNameParser.parse(dimension.getUniqueName());
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        String[] hierarchyParts = new String[dimParts.length + 1];
        System.arraycopy(dimParts, 0, hierarchyParts, 0, dimParts.length);
        hierarchyParts[hierarchyParts.length - 1] = name;
        hierarchy.setUniqueName(UniqueNameGenerator.createUniqueName(hierarchyParts));
        hierarchy.setAutoGenerated(true);
        hierarchy.setDimension(dimension);
        dimension.setDefaultHierarchy(hierarchy);
        dimension.addHierarchy(hierarchy);
        for (IXQEQueryNode v5Level : v5Dim.getChildrenOfType(101030)) {
            V5Query v5Query;
            V5Key key = (V5Key)v5Level.getFirstChildByType(101031);
            String refDataItem = (String)key.getPropertyValue(REFDATAITEM);
            IQueryItem queryItem = this.findQueryItem(refDataItem, v5Query = (V5Query)v5Dim.getAncestorOfType(101006));
            if (queryItem == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, MISSING_QUERYITEM_MESSAGE);
            }
            QueryItemOfQuerySubjectToLevelWrapper level = new QueryItemOfQuerySubjectToLevelWrapper(queryItem);
            level.setName((String)v5Level.getPropertyValue(NAME));
            String[] levelParts = new String[hierarchyParts.length + 1];
            System.arraycopy(hierarchyParts, 0, levelParts, 0, hierarchyParts.length);
            levelParts[levelParts.length - 1] = name;
            level.setUniqueName(UniqueNameGenerator.createUniqueName(levelParts));
            level.setAutoGenerated(true);
            level.setHierarchy(hierarchy);
            hierarchy.addLevel(level);
            for (IXQEQueryNode child : v5Level.getChildrenOfType(101056)) {
                String nullPlacementString;
                SortItem sortItem = new SortItem();
                String sortOrderString = (String)child.getPropertyValue("sortOrder");
                if (sortOrderString != null) {
                    if (sortOrderString.equals("ascending")) {
                        sortItem.setSort(ISortItem.SortType.ASCENDING);
                    } else if (sortOrderString.equals("descending")) {
                        sortItem.setSort(ISortItem.SortType.DESCENDING);
                    }
                }
                if ((nullPlacementString = (String)child.getPropertyValue("nullPlacement")) != null) {
                    if (nullPlacementString.equals("nullsFirst")) {
                        sortItem.setNullPlacement(ISortItem.NullPlacementType.NULL_FIRST);
                    } else if (nullPlacementString.equals("nullsLast")) {
                        sortItem.setNullPlacement(ISortItem.NullPlacementType.NULL_LAST);
                    }
                }
                sortItem.setRefObject((String)child.getPropertyValue(REFDATAITEM));
                level.addSortItem(sortItem);
            }
        }
    }

    public void createMeasure(V5Fact factNode) {
        if (this.measuresDim == null) {
            this.createMeasuresDimension();
        }
        V5Query v5Query = (V5Query)factNode.getAncestorOfType(101006);
        String refDataItem = (String)factNode.getPropertyValue(REFDATAITEM);
        IQueryItem queryItem = this.findQueryItem(refDataItem, v5Query);
        if (queryItem == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, MISSING_QUERYITEM_MESSAGE);
        }
        QueryItemOfQuerySubjectToMeasureWrapper measure = new QueryItemOfQuerySubjectToMeasureWrapper(queryItem);
        measure.setName((String)factNode.getPropertyValue(NAME));
        measure.setUniqueName(UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), measure.getName()));
        measure.setParentMetadataObject(this.measuresDim);
        this.measuresDim.addChildMetadataObject(measure);
        this.measuresLevel.addMember(measure, null);
    }

    private IQueryItem findQueryItem(String refDataItem, V5Query v5Query) {
        V5DataItem dataItem = null;
        for (IXQEQueryNode child : v5Query.getOriginalV5Query().getDescendantsOfType(101003, false)) {
            dataItem = (V5DataItem)child;
            String dataItemName = (String)dataItem.getPropertyValue(NAME);
            if (!dataItemName.equals(refDataItem)) continue;
            V5BoundModelIdentifier multipartId = (V5BoundModelIdentifier)dataItem.getFirstDescendantOfTypeOrdered(201116, false);
            return (IQueryItem)multipartId.getMetadata();
        }
        return null;
    }

    HierarchyWrapper createHierarchy(DimensionWrapper dimension, IHierarchy toWrap) {
        HierarchyWrapper hierWrapper = new HierarchyWrapper(dimension, toWrap);
        dimension.addHierarchy(hierWrapper);
        this.addChildWrapperObject(toWrap, hierWrapper);
        return hierWrapper;
    }

    LevelWrapper createLevel(HierarchyWrapper hierarchy, ILevel toWrap) {
        LevelWrapper levelWrapper = new LevelWrapper(hierarchy, toWrap);
        this.addChildWrapperObject(toWrap, levelWrapper);
        hierarchy.addLevel(levelWrapper);
        return levelWrapper;
    }

    ScopeRelationshipWrapper createScopeRelationship(IScopeRelationship toWrap) {
        ScopeRelationshipWrapper wrapper = new ScopeRelationshipWrapper(toWrap, this);
        this.addChildWrapperObject(toWrap, wrapper);
        return wrapper;
    }

    QueryItemOfLevelWrapper createQueryItemOfLevel(LevelWrapper level, IQueryItem queryItem) {
        if (queryItem.getLevel() == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Parent of QueryItemOfLevelWrapper must be of type LevelWrapper");
        }
        QueryItemOfLevelWrapper wrapper = new QueryItemOfLevelWrapper(queryItem, level);
        level.addChildMetadataObject(wrapper);
        this.addChildWrapperObject(queryItem, wrapper);
        return wrapper;
    }

    private IMetadata createQueryItemOfSubject(IQueryItem queryItem) {
        if (queryItem.getQuerySubject() == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "QuerySubject must not be null");
        }
        String name = queryItem.getUniqueName();
        if (name == null) {
            name = queryItem.getName();
        }
        if (queryItem.isFact()) {
            if (this.measuresHier == null) {
                this.createMeasuresDimension();
            }
            QueryItemOfQuerySubjectToMeasureWrapper measureWrapper = new QueryItemOfQuerySubjectToMeasureWrapper(queryItem);
            measureWrapper.setParentMetadataObject(this.measuresDim);
            this.measuresLevel.addMember(measureWrapper, null);
            this.measuresHier.setDefaultMember(measureWrapper);
            this.measuresDim.addChildMetadataObject(measureWrapper);
            this.addChildWrapperObject(queryItem, measureWrapper);
            return measureWrapper;
        }
        Dimension dimensionn = new Dimension(name);
        dimensionn.setType(DimensionTypeEnum.REGULAR);
        dimensionn.setProperty("isManual", TRUE);
        Hierarchy hierarchy = new Hierarchy(name);
        hierarchy.setDimension(dimensionn);
        hierarchy.setProperty("isManual", TRUE);
        Level level = (Level)hierarchy.getLevel(0);
        level.setProperty("isManual", TRUE);
        Member allMember = new Member(ALL);
        allMember.setUniqueName(this.buildAllMemberUniqueName(hierarchy));
        level.addMember(allMember, allMember);
        level.addChildMetadataObject(allMember);
        hierarchy.setDefaultMember(allMember);
        QueryItemOfQuerySubjectToLevelWrapper wrapper = new QueryItemOfQuerySubjectToLevelWrapper(queryItem);
        hierarchy.addLevel(wrapper);
        dimensionn.addHierarchy(hierarchy);
        dimensionn.setDefaultHierarchy(hierarchy);
        this.addDimension(dimensionn);
        dimensionn.setConnection(this.getConnection());
        this.addChildWrapperObject(queryItem, wrapper);
        return wrapper;
    }

    private MeasureWrapper createMeasure(IMeasure toWrap) {
        boolean isDefaultMember = false;
        IMeasure measure = toWrap;
        if (this.measuresLevel.getHierarchy().getDefaultMember() == null && measure.getHierarchy().getDefaultMember() == measure) {
            isDefaultMember = true;
        }
        MeasureWrapper measureWrapper = new MeasureWrapper(measure);
        String mWrapperName = this.buildMeasureName(measure);
        measureWrapper.setName(mWrapperName);
        String mWrapperUniqueName = UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), measureWrapper.getName());
        measureWrapper.setUniqueName(mWrapperUniqueName);
        measureWrapper.setParentMetadataObject(this.measuresDim);
        this.measuresLevel.addMember(measureWrapper, null);
        if (isDefaultMember) {
            this.measuresHier.setDefaultMember(measureWrapper);
        }
        this.measuresDim.addChildMetadataObject(measureWrapper);
        this.addChildWrapperObject(toWrap, measureWrapper);
        if (this.defaultMeasure == null) {
            this.defaultMeasure = measureWrapper;
        }
        return measureWrapper;
    }

    private FilterWrapper createFilter(IFilter toWrap) {
        FilterWrapper filterWrapper2 = new FilterWrapper(toWrap);
        this.addChildMetadataObject(filterWrapper2);
        this.addChildWrapperObject(toWrap, filterWrapper2);
        return filterWrapper2;
    }

    private CalculationWrapper createCalculation(ICalculation toWrap) {
        CalculationWrapper calculationWrapper = new CalculationWrapper(toWrap);
        this.addChildMetadataObject(calculationWrapper);
        this.addChildWrapperObject(toWrap, calculationWrapper);
        return calculationWrapper;
    }

    private String buildDimensionName(String[] parents, IDimension dim) {
        StringBuilder sb = new StringBuilder();
        for (String namespace : parents) {
            sb.append(namespace);
            sb.append(UNDERSCORE);
        }
        sb.append(dim.getName());
        return sb.toString();
    }

    public String buildMeasureName(IMeasure measure) {
        if (measure instanceof MeasureWrapper) {
            return measure.getName();
        }
        String[] parts = null;
        try {
            parts = UniqueNameParser.parse(measure.getV5UniqueName());
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        StringBuilder buffer = new StringBuilder();
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            parts[i] = StringUtils.replace((String)parts[i], (String)RIGHT_BRACKET, (String)DOUBLE_RIGHT_BRACKET);
            buffer.append(parts[i]);
            buffer.append(UNDERSCORE);
        }
        parts[lastPart] = StringUtils.replace((String)parts[lastPart], (String)RIGHT_BRACKET, (String)DOUBLE_RIGHT_BRACKET);
        buffer.append(parts[lastPart]);
        return buffer.toString();
    }

    public void setTabStreamWrapper(TabStreamWrapper tabStream) {
        this.mTabStreamWrapper = tabStream;
    }

    public TabStreamWrapper getTabStreamWrapper() {
        return this.mTabStreamWrapper;
    }

    public V5QuerySet createV5QuerySet(PlanningEnvironment planningEnv, List<IMetadata> projectedColumns, String queryName, boolean isV5QueryToLoadmembers) {
        if (this.mTabStreamWrapper != null) {
            V5QuerySet querySet = this.mTabStreamWrapper.createV5QuerySet(planningEnv, projectedColumns, queryName, isV5QueryToLoadmembers);
            querySet.setPropertyValue("MultiDimensionalSubquery", Boolean.TRUE);
            return querySet;
        }
        return null;
    }

    public Dimension createAndReturnMeasuresDimension() {
        if (this.measuresDim == null) {
            this.measuresDim = this.createDummies(MEASURES, MEASURE_DESCRIPTION, DimensionTypeEnum.MEASURE);
            this.measuresHier = (Hierarchy)this.measuresDim.getDefaultHierarchy();
            this.measuresLevel = (Level)this.measuresHier.getLevels().get(0);
        }
        return this.measuresDim;
    }

    public void setDefaultMeasure() {
        if (this.defaultMeasure == null) {
            Measure defMeasure = new Measure(DEFAULTMEASURE);
            defMeasure.setUniqueID(defMeasure.getUniqueName());
            defMeasure.setCaption(DEFAULTMEASURE);
            defMeasure.setDescription(this.description);
            defMeasure.setType(MemberTypeEnum.REGULAR);
            defMeasure.setUniqueName(UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), DEFAULTMEASURE));
            defMeasure.setV5UniqueName(defMeasure.getUniqueName());
            defMeasure.setParentMetadataObject(this.measuresDim);
            this.measuresDim.addChildMetadataObject(defMeasure);
            this.measuresLevel.addMember(defMeasure, null);
            defMeasure.setLevel(this.measuresLevel);
            this.measuresHier.setDefaultMember(defMeasure);
            defMeasure.setProperty("isManual", TRUE);
            this.defaultMeasure = defMeasure;
        }
    }

    public boolean containsNonDefaultMeasure() {
        if (this.measuresLevel.getMembers().size() == 1) {
            IMeasure measure = (IMeasure)this.measuresLevel.getMembers().get(0);
            return measure.getName() != DEFAULTMEASURE;
        }
        return true;
    }

    @Override
    public IMeasure getDefaultMeasure() {
        return this.defaultMeasure;
    }

    public List<MeasureWrapper> getMeasures(IMeasure measure) {
        String mName = measure.getName();
        ArrayList<MeasureWrapper> result = new ArrayList<MeasureWrapper>();
        for (IMetadata m : this.measuresDim.getChildMetadataObjects()) {
            MeasureWrapper mw;
            String wrappedName;
            if (!(m instanceof MeasureWrapper) || !(wrappedName = (mw = (MeasureWrapper)m).getWrapped().getName()).equals(mName)) continue;
            result.add(mw);
        }
        return result;
    }

    public MeasureWrapper createMeasureWrapper(MeasureWrapper measureWrapper) {
        IMeasure measure = measureWrapper.getWrapped();
        String mName = measure.getName();
        int index = 0;
        for (IMetadata m : this.measuresDim.getChildMetadataObjects()) {
            MeasureWrapper mw;
            String wrappedName;
            if (!(m instanceof MeasureWrapper) || !(wrappedName = (mw = (MeasureWrapper)m).getWrapped().getName()).equals(mName)) continue;
            ++index;
        }
        MeasureWrapper newMeasure = new MeasureWrapper(measure);
        String newMeasureName = measureWrapper.getName();
        if (index > 0) {
            newMeasureName = newMeasureName + String.valueOf(index);
        }
        newMeasure.setName(newMeasureName);
        String uniqueName = UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), newMeasure.getName());
        newMeasure.setUniqueName(uniqueName);
        newMeasure.setParentMetadataObject(this.measuresDim);
        this.measuresLevel.addMember(newMeasure, null);
        this.measuresDim.addChildMetadataObject(newMeasure);
        return newMeasure;
    }

    public MeasureWrapper createMeasureWrapperWithDifferentAggregate(MeasureWrapper wrapper, String newName, String aggregate) {
        MeasureWrapper newMeasure = new MeasureWrapper(wrapper.getWrapped());
        newMeasure.setName(newName);
        newMeasure.setV5AggregateAttribute(aggregate);
        String uniqueName = UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), newMeasure.getName());
        newMeasure.setUniqueName(uniqueName);
        newMeasure.setParentMetadataObject(this.measuresDim);
        this.measuresLevel.addMember(newMeasure, null);
        this.measuresDim.addChildMetadataObject(newMeasure);
        return newMeasure;
    }

    public void setRQPPrePlanQuery(RQPPrePlan prePlanQuery) {
        this.rqpPrePlan = prePlanQuery;
    }

    public RQPPrePlan getRQPPrePlanQuery() {
        return this.rqpPrePlan;
    }

    public String getTabularResultSetName() {
        return this.mTabularResultSetName;
    }

    public void setTabularResultSetName(String resultName) {
        this.mTabularResultSetName = resultName;
    }

    public List<IModelDataSource> getModelDatasources() {
        return this.getConnection().getModelDataSources();
    }

    public boolean isDesignMode() {
        return this.mDesignMode;
    }

    public boolean getDirectReturnCellValues() {
        return this.relxtabDirect;
    }

    public void setDirectReturnCellValues(boolean b) {
        this.relxtabDirect = b;
    }

    public V5QuerySet getV5QuerySetForV5Source() {
        return this.v5QuerySetForV5Source;
    }

    public void setV5QuerySetForV5Source(V5QuerySet v5QuerySet) {
        this.v5QuerySetForV5Source = v5QuerySet;
    }

    public V5QuerySet getV5QuerySetForV5DetailFilter() {
        return this.v5QuerySetForSubQueryInDetailFilter;
    }

    public void setV5QuerySetForV5DetailFilter(V5QuerySet v5QuerySet) {
        this.v5QuerySetForSubQueryInDetailFilter = v5QuerySet;
    }

    public ILevel getTagCompleteTupleLevel() {
        return this.tagCompleteTupleLevel;
    }

    public Governors getGovernors() {
        return this.mGovernors;
    }

    public ArrayList<String> getCubeParameters() {
        return this.cubeParameters;
    }

    public void setCubeParameters(ArrayList<String> params) {
        this.cubeParameters = params;
    }

    public void setSingleQueryLoading(boolean b) {
        this.singleQueryLoading = b;
    }

    public boolean getSingleQueryLoading() {
        return this.singleQueryLoading;
    }

    public void setGovernors(Governors governors) {
        this.mGovernors = governors;
        this.mDesignMode = this.mGovernors != null && this.mGovernors.getDesignMode() == Boolean.TRUE;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.DMR;
    }

    public DimensionCacheManager getDimensionContextManager() {
        return this.dimManager;
    }

    public void setDimensionContextManager(DimensionCacheManager dimMng) {
        this.dimManager = dimMng;
    }

    public void setTopN(String topN) {
        this.fetchTopN = topN;
    }

    public String getTopN() {
        return this.fetchTopN;
    }

    public DynamicDimensionWrapper createDynamicDimension(AbstractDimensionWrapper dim, String extname) {
        StringBuilder sb = new StringBuilder(dim.getName());
        sb.append(UNDERSCORE);
        sb.append(extname);
        DynamicDimensionWrapper dynamicDim = new DynamicDimensionWrapper(sb.toString(), this, dim);
        dynamicDim.setType(DimensionTypeEnum.REGULAR);
        dynamicDim.setDescription(DYNAMIC_DIMENSION_DESCRIPTION);
        dynamicDim.setMembersRollup(dim.getMembersRollup());
        this.addDimension(dynamicDim);
        dynamicDim.setMetadataContext(dim.getMetadataContext());
        return dynamicDim;
    }

    public DynamicDimensionWrapper cloneToDynamicDimension(HierarchyWrapper srcHier, String extname) {
        AbstractDimensionWrapper srcDim = (AbstractDimensionWrapper)srcHier.getDimension();
        DynamicDimensionWrapper dynamicDim = this.createDynamicDimension(srcDim, extname);
        HierarchyWrapper hierWrapper = new HierarchyWrapper(dynamicDim, srcHier, true);
        dynamicDim.addHierarchy(hierWrapper);
        for (ILevel lvl : srcHier.getLevels()) {
            LevelWrapper srcLvl = (LevelWrapper)lvl;
            LevelWrapper levelWrapper = new LevelWrapper(hierWrapper, srcLvl);
            hierWrapper.addLevel(levelWrapper);
        }
        return dynamicDim;
    }

    public List<IMeasure> getMeasuresForCustomValues() {
        ArrayList<IMeasure> rt = new ArrayList<IMeasure>();
        for (IMetadata m : this.measuresDim.getChildMetadataObjects()) {
            MeasureWrapper mw;
            String name;
            if (!(m instanceof MeasureWrapper) || (name = (mw = (MeasureWrapper)m).getName()) == null || !name.endsWith("_FactDrivenMDXCustomValue")) continue;
            rt.add(mw);
        }
        return rt;
    }

    public void addMeasureForCustomValue(String name, IXQEQueryNode expr) {
        MeasureWrapper measureWrapper = new MeasureWrapper();
        measureWrapper.setName(name);
        measureWrapper.setBinaryExpression(expr);
        String mWrapperUniqueName = UniqueNameGenerator.createUniqueName(this.measuresDim.getName(), this.measuresHier.getName(), measureWrapper.getName());
        measureWrapper.setUniqueName(mWrapperUniqueName);
        measureWrapper.setParentMetadataObject(this.measuresDim);
        this.measuresLevel.addMember(measureWrapper, null);
        this.measuresDim.addChildMetadataObject(measureWrapper);
    }

    public static boolean isDummyDimension(IDimension dim) {
        String dimName = dim.getName();
        return dimName.equals(DUMMY) || dimName.equals(SECOND_DUMMY) || dimName.equals(TAG_DIM_NAME);
    }
}

