/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.macro.MXNodeFactory;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;

public class HierarchyWrapper
extends Hierarchy {
    private static final String V5_MEMBER_SEPARATOR = "->";
    private IHierarchy hierarchy;

    public HierarchyWrapper(IDimension dim, IHierarchy hierar) {
        this.dimension = dim;
        this.hierarchy = hierar;
    }

    public HierarchyWrapper(IDimension dim, IHierarchy hierar, boolean initCHild) {
        this.dimension = dim;
        this.hierarchy = hierar;
        this.initialisedChildren = initCHild;
    }

    public IHierarchy getWrappedHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    protected synchronized void initialiseChildren() {
        if (this.initialisedChildren) {
            return;
        }
        boolean manualAllLevelFound = false;
        for (IMetadata level : this.hierarchy.getChildMetadataObjects()) {
            if (level.getObjectType() != MetadataType.LEVEL) continue;
            if (!manualAllLevelFound && level.getProperty("isManual") == null) {
                String hierarchyUN = this.hierarchy.getV5UniqueName();
                throw new XQERuntimeException(XQEMessageKeys.PLN_DMRHierarchyMissingManualAllMember, hierarchyUN);
            }
            manualAllLevelFound = true;
            ((CubeWrapper)this.getDimension().getCube()).createLevel(this, (ILevel)level);
        }
        this.initialisedChildren = true;
        this.initialised = this.initialisedProperties && this.initialisedChildren;
    }

    private void initDefaultMember() {
        ILevel level;
        List<IMember> members;
        if (this.defaultMemberName != null) {
            return;
        }
        try {
            this.defaultMember = this.hierarchy.getDefaultMember();
            if (this.defaultMember != null) {
                this.defaultMemberName = this.defaultMember.isMFW() ? this.getMemberName(this.defaultMember) : this.defaultMember.getName();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        this.initRootMember();
        this.initialiseChildren();
        if (this.defaultMemberName != null) {
            this.defaultMemberName = UniqueNameGenerator.createEscapedUniqueName(this.getDimension().getName(), this.name, this.defaultMemberName);
            this.defaultMember = this.getMember(this.defaultMemberName);
        }
        if (this.defaultMember == null) {
            this.defaultMember = this.getRootMember();
        }
        if (this.defaultMember == null && (members = (level = this.getLevel(0)).getMembers()).size() > 0) {
            this.defaultMember = members.get(0);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.initialiseProperties();
        }
        return this.name;
    }

    @Override
    public IMember getRootMember() {
        if (this.rootMember == null) {
            this.initRootMember();
        }
        return this.rootMember;
    }

    private void initRootMember() {
        IMember wrappedRootMember = this.hierarchy.getRootMember();
        if (wrappedRootMember != null) {
            String rootMun = wrappedRootMember.getName();
            String rootCaption = wrappedRootMember.getCaptionValue().getString();
            if (wrappedRootMember.isMFW()) {
                rootMun = this.getMemberName(wrappedRootMember);
            }
            String v5MemberName = null;
            for (ILevel level : this.getLevels()) {
                if (!rootMun.equals(level.getName())) continue;
                v5MemberName = rootMun;
                rootMun = DMRMember.wrapNamePart(rootMun);
                break;
            }
            rootMun = UniqueNameGenerator.createEscapedUniqueName(this.getDimension().getName(), this.name, rootMun);
            List<ILevel> levelList = this.getLevels();
            Level rootLevel = null;
            if (levelList.size() == 0) {
                rootLevel = new Level();
                rootLevel.setHierarchy(this);
            } else {
                rootLevel = (Level)levelList.get(0);
            }
            IMember rootMember = rootLevel.getMember(rootMun);
            if (rootMember == null) {
                rootMember = new Member(rootCaption);
                ((Member)rootMember).setUniqueName(rootMun);
                if (v5MemberName != null) {
                    ((Member)rootMember).setProperty("_v5MemberName", v5MemberName);
                }
                ((Member)rootMember).setLevel(rootLevel);
                ((Member)rootMember).setConnection(this.getConnection());
                ((Member)rootMember).setInitialised();
            }
            this.setRootMember(rootMember);
            return;
        }
        this.initialiseChildren();
        ILevel level = this.getLevel(0);
        List<IMember> members = level.getMembers();
        if (members.size() == 1) {
            this.setRootMember(members.get(0));
        }
    }

    private String getMemberName(IMember member) {
        String memberName = null;
        String uniqueName = member.getUniqueName();
        if (uniqueName.contains(V5_MEMBER_SEPARATOR)) {
            IXQEQueryNode node = this.parseUniqueName(uniqueName);
            if (node.getType() == 201028) {
                uniqueName = ((V5MemberUniqueName)node).getLogical();
            } else if (node.getType() != 201030) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid member name");
            }
        }
        String[] nameParts = null;
        try {
            nameParts = UniqueNameParser.parse(uniqueName);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        memberName = nameParts[nameParts.length - 1];
        return memberName;
    }

    private IXQEQueryNode parseUniqueName(String uniqueName) {
        MetadataConnection connection = this.hierarchy.getConnection();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment());
        planEnv.setMetdataConnection(connection);
        XQETrace trace = new XQETrace();
        XQEIDGenerator idGenerator = new XQEIDGenerator();
        XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
        nodeFactory.addNodeFactory(new V5NodeFactory());
        nodeFactory.addNodeFactory(new V5ExpNodeFactory());
        nodeFactory.addNodeFactory(new MXNodeFactory());
        nodeFactory.setNodeIDGenerator(idGenerator);
        nodeFactory.setTrace(trace);
        nodeFactory.setPlanningEnvironment(planEnv);
        planEnv.setTrace(trace);
        planEnv.setNodeFactory(nodeFactory);
        IXQEQueryNode node = V5ExpressionProcessor.process(uniqueName, planEnv, connection.getDefaultLocale(this.hierarchy));
        return node;
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.hierarchy.getConnection());
        this.dataType = this.hierarchy.getDataType();
        this.caption = this.hierarchy.getCaption();
        this.description = this.hierarchy.getDescription();
        this.dimensionUniqueName = this.getDimension().getUniqueName();
        this.multiRoot = this.hierarchy.isMultiRoot();
        this.parentChild = this.hierarchy.isParentChild();
        this.ragged = this.hierarchy.isRagged();
        this.autoGenerated = this.hierarchy.isAutoGenerated();
        this.v5UniqueName = this.hierarchy.getV5UniqueName();
        this.parentChild = this.isParentChild();
        this.balanced = this.isBalanced();
        this.ragged = this.isRagged();
        this.name = this.hierarchy.getName();
        this.uniqueName = UniqueNameGenerator.createEscapedUniqueName(this.getDimension().getName(), this.name);
        this.initialisedProperties = true;
        this.initDefaultMember();
    }

    @Override
    public synchronized IMember getDefaultMember() {
        if (this.defaultMember == null) {
            this.initDefaultMember();
        }
        return this.defaultMember;
    }

    @Override
    public Level addLevel(String name) {
        ILevel level = this.hierarchy.getLevel(name);
        if (level == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot find level in wrapped hierarchy");
        }
        return ((CubeWrapper)this.getDimension().getCube()).createLevel(this, level);
    }

    @Override
    public ILevel getLevel(String uniqueName) {
        if (!this.isInitialised()) {
            this.initialiseChildren();
        }
        return super.getLevel(uniqueName);
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        return UniqueNameGenerator.appendUniqueName(this.getDimension().getUniqueName(), suffix);
    }

    @Override
    public boolean isParentChild() {
        return false;
    }

    public boolean isBalanced() {
        boolean tempUnbalanced = this.hierarchy.isUnbalanced();
        if (tempUnbalanced) {
            IMessageKey.Param1 messageKey = XQEMessageKeys.PLN_DMRHierarchyBalancePropertyFalse;
            String nagMsg = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), this.hierarchy.getName());
            ExecutionEnvironmentContext.getExecutionEnvironment().addNag(nagMsg);
        }
        return true;
    }

    @Override
    public boolean isRagged() {
        boolean tempRagged = this.hierarchy.isRagged();
        if (tempRagged) {
            IMessageKey.Param1 messageKey = XQEMessageKeys.PLN_DMRHierarchyRaggedPropertyTrue;
            String nagMsg = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), this.hierarchy.getName());
            ExecutionEnvironmentContext.getExecutionEnvironment().addNag(nagMsg);
        }
        return false;
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        return this.hierarchy.getCalculatedMembers();
    }
}

