/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.IMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.ScopeRelationshipWrapper;
import com.cognos.xqe.rsapi.RSAPIUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MeasureWrapper
extends Measure
implements IMeasureWrapper {
    private IMeasure measure;
    private Lock scopeRelationshipWriteLock;
    private List<IScopeRelationship> scopeRelationships;
    private IXQEQueryNode binaryExpression;
    private String v5AggregateAttribute;
    private boolean reUseable = true;
    private AggregateTypeEnum resolvedRegularAggregate = null;
    private boolean refined = false;
    private AllocationRule allocationRule = null;
    private Map<IDimension, Integer> scopeOverride = new HashMap<IDimension, Integer>();
    private Map<String, String> levelApplyTo = new HashMap<String, String>();

    public MeasureWrapper() {
        this.initialisedProperties = true;
        this.reUseable = false;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.scopeRelationshipWriteLock = lock.writeLock();
        this.scopeRelationships = new ArrayList<IScopeRelationship>();
    }

    public MeasureWrapper(IMeasure mMeasure) {
        this.measure = mMeasure;
        this.initialiseProperties();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.scopeRelationshipWriteLock = lock.writeLock();
    }

    @Override
    public List<IMember> getChildren() {
        if (!this.initialisedChildren) {
            this.initialiseChildren();
        }
        return super.getChildren();
    }

    @Override
    public IDimension getDimension() {
        return this.getLevel().getHierarchy().getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.getDimension().getDefaultHierarchy();
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setPrecision(this.measure.getPrecision());
        this.setRegularAggregate(this.measure.getRegularAggregate());
        this.setScale(this.measure.getScale());
        this.setSemiAggregate(this.measure.getSemiAggregate());
        this.setUnits(this.measure.getUnits());
        this.v5UniqueName = this.measure.getV5UniqueName();
        this.setRollupType(this.measure.getRollupType());
        this.setSuppressed(this.measure.isSuppressed());
        this.setType(this.measure.getType());
        this.setConnection(this.measure.getConnection());
        this.dataType = this.measure.getDataType();
        if (this.measure.isNull()) {
            this.setNull();
        }
        this.caption = this.measure.getCaptionValue().getString();
        this.description = this.measure.getDescription();
        this.parentLevelNumber = this.measure.getParentLevelNumber();
        this.initialisedProperties = true;
        this.numberOfParents = 1;
    }

    @Override
    protected synchronized void initialiseChildren() {
        for (IMember child : this.measure.getChildMembers()) {
            if (!(child instanceof Member)) continue;
            this.addChild((Member)child);
        }
        this.initialisedChildren = true;
    }

    @Override
    public synchronized ILevel getLevel() {
        if (this.level == null) {
            this.level = this.getHierarchy().getLevel(0);
        }
        return this.level;
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public Object getProperty(String propertyName) {
        if ("usage".equals(propertyName)) {
            return RSAPIUsage.FACT.toString();
        }
        if (this.measure != null) {
            return this.measure.getProperty(propertyName);
        }
        return null;
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        if (this.measure != null) {
            return this.measure.getAggregateRules();
        }
        return new IAggregateRule[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeScopeRelationship() {
        if (this.scopeRelationships != null) {
            return;
        }
        this.scopeRelationships = new ArrayList<IScopeRelationship>();
        CubeWrapper cubeWrapper = (CubeWrapper)this.getDimension().getCube();
        for (IScopeRelationship scopeRelationship : this.measure.getScopeRelationships()) {
            ScopeRelationshipWrapper scopeRelWrapper = cubeWrapper.createScopeRelationship(scopeRelationship);
            try {
                this.scopeRelationshipWriteLock.lock();
                this.scopeRelationships.add(scopeRelWrapper);
            }
            finally {
                this.scopeRelationshipWriteLock.unlock();
            }
        }
    }

    @Override
    public AllocationRule getAllocationRule() {
        if (this.allocationRule != null) {
            return this.allocationRule;
        }
        if (this.measure instanceof IMeasure) {
            return this.measure.getAllocationRule();
        }
        return AllocationRule.DEFAULT;
    }

    public void setAllocationRule(AllocationRule r) {
        this.allocationRule = r;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        this.initializeScopeRelationship();
        CubeWrapper cubeWrapper = (CubeWrapper)this.getDimension().getCube();
        IDimension dimWrapper = cubeWrapper.getDimension(otherMetadata.getUniqueName());
        IMetadata wrappedDim = cubeWrapper.getWrapped(dimWrapper);
        if (wrappedDim == null || this.measure == null) {
            return null;
        }
        IScopeRelationship scopeRelationship = this.measure.getScopeRelationship(wrappedDim);
        if (scopeRelationship == null) {
            return null;
        }
        return (IScopeRelationship)cubeWrapper.getWrapper(scopeRelationship);
    }

    @Override
    public String getUniqueID() {
        if (this.measure != null) {
            return this.measure.getUniqueID();
        }
        return this.getName();
    }

    public String getRegularAggregateV5Type() {
        if (this.measure != null) {
            return this.measure.getRegularAggregate().toV5Type();
        }
        return "unsupported";
    }

    public IXQEQueryNode getBinaryExpression() {
        return this.binaryExpression;
    }

    public void setBinaryExpression(IXQEQueryNode binary) {
        this.binaryExpression = binary;
    }

    public String getV5AggregateAttribute() {
        return this.v5AggregateAttribute;
    }

    public void setV5AggregateAttribute(String aggregate) {
        this.v5AggregateAttribute = aggregate;
    }

    public IMeasure getWrapped() {
        return this.measure;
    }

    public boolean isReUseable() {
        return this.reUseable;
    }

    public void setReUseable(boolean reuse) {
        this.reUseable = reuse;
    }

    @Override
    public boolean isFromSameDimension(IMeasure other) {
        if (!(other instanceof MeasureWrapper)) {
            throw new XQERuntimeException();
        }
        MeasureWrapper m = (MeasureWrapper)other;
        return m.getWrapped().getDimension() == this.measure.getDimension();
    }

    @Override
    public IDimension getModelDimension() {
        if (this.measure != null) {
            return this.measure.getDimension();
        }
        return null;
    }

    public AggregateTypeEnum getResolvedRegularAggregate() {
        return this.resolvedRegularAggregate;
    }

    public void setResolvedRegularAggregate(AggregateTypeEnum resolved) {
        this.resolvedRegularAggregate = resolved;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        if (this.resolvedRegularAggregate != null) {
            return this.resolvedRegularAggregate;
        }
        return super.getRegularAggregate();
    }

    public void setRefined() {
        this.refined = true;
    }

    public boolean getRefined() {
        return this.refined;
    }

    public Integer getOverrideScope(IDimension d) {
        return this.scopeOverride.get(d);
    }

    public void setOverrideScope(IDimension d, Integer lvlPos) {
        this.scopeOverride.put(d, lvlPos);
    }

    public String getLevelApplyTo(String levelV5UniqueName) {
        return this.levelApplyTo.get(levelV5UniqueName);
    }

    public void addLevelApplyTo(String levelV5UniqueName, String at) {
        this.levelApplyTo.put(levelV5UniqueName, at);
    }
}

