/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.QueryItem;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import java.util.List;

public class QueryItemOfLevelWrapper
extends QueryItem
implements IProperty,
QueryItemWrapper {
    private ILevel level;
    private IQueryItem queryItem;

    public QueryItemOfLevelWrapper(IQueryItem qi, ILevel lev) {
        this.queryItem = qi;
        this.level = lev;
        this.initialiseProperties();
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.queryItem.getConnection());
        this.caption = this.queryItem.getCaption();
        this.description = this.queryItem.getDescription();
        this.v5UniqueName = this.queryItem.getV5UniqueName();
        this.name = this.queryItem.getName();
        this.initialised = true;
        StringBuilder sb = new StringBuilder(this.level.getUniqueName());
        sb.append(".");
        sb.append("[");
        sb.append(this.name);
        sb.append("]");
        this.uniqueName = sb.toString();
        this.initialisedProperties = true;
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public ILevel getLevel() {
        return this.level;
    }

    @Override
    public IDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    @Override
    public List<String> getRoles() {
        if (this.queryItem instanceof IProperty) {
            return ((IProperty)((Object)this.queryItem)).getRoles();
        }
        return null;
    }

    @Override
    public synchronized IQuerySubject getQuerySubject() {
        return this.queryItem.getQuerySubject();
    }

    @Override
    public String getUsage() {
        return this.queryItem.getUsage();
    }

    @Override
    public boolean isProperty() {
        return this.queryItem.isProperty();
    }

    @Override
    public boolean isCustomProperty() {
        if (this.queryItem instanceof IProperty) {
            return ((IProperty)((Object)this.queryItem)).isCustomProperty();
        }
        return false;
    }

    @Override
    public String getExpression() {
        return this.queryItem.getExpression();
    }

    @Override
    public String getExpressionOrExternalName() {
        return this.queryItem.getExpressionOrExternalName();
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.compareTo("expression") == 0) {
            return null;
        }
        return this.queryItem.getProperty(propertyName);
    }

    @Override
    public IQueryItem getQueryItem() {
        return this.queryItem;
    }

    @Override
    public IDataType getDataType() {
        return this.queryItem.getDataType();
    }

    @Override
    public void setDataType(IDataType theDataType) {
        throw new UnsupportedOperationException();
    }
}

