/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.provider.ScopeRelationship;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;

public class ScopeRelationshipWrapper
extends ScopeRelationship {
    private IScopeRelationship scopeRelationship;
    private CubeWrapper cubeWrapper;
    private IMetadata left;
    private IMetadata right;
    public static final IScopeRelationship NULL_SCOPEREL = new ScopeRelationshipWrapper();
    static final long serialVersionUID = 7647274105530911872L;

    private ScopeRelationshipWrapper() {
    }

    ScopeRelationshipWrapper(IScopeRelationship sScopeRel, CubeWrapper cWrapper) {
        this.scopeRelationship = sScopeRel;
        this.cubeWrapper = cWrapper;
    }

    @Override
    public synchronized IMetadata getLeftRefObject() {
        if (this.left == null) {
            this.left = this.cubeWrapper.getWrapper(this.scopeRelationship.getLeftRefObject());
        }
        return this.left;
    }

    @Override
    public synchronized IMetadata getRightRefObject() {
        if (this.right == null) {
            this.right = this.cubeWrapper.getWrapper(this.scopeRelationship.getRightRefObject());
        }
        return this.right;
    }

    @Override
    public String getLeftRefObjectId() {
        return this.getLeftRefObject().getUniqueName();
    }

    @Override
    public String getRightRefObjectId() {
        return this.getRightRefObject().getUniqueName();
    }

    @Override
    public Enum<IRelationship.Cardinality> getLeftCardinality() {
        return this.scopeRelationship.getLeftCardinality();
    }

    @Override
    public Enum<IRelationship.Cardinality> getRightCardinality() {
        return this.scopeRelationship.getRightCardinality();
    }

    @Override
    public ILevel getLowestLevel(IMeasure measure, ILevel levelOfDimension) {
        IMeasure m = measure instanceof MeasureWrapper ? ((MeasureWrapper)measure).getWrapped() : measure;
        ILevel level = levelOfDimension instanceof LevelWrapper ? (ILevel)this.cubeWrapper.getWrapped(levelOfDimension) : levelOfDimension;
        if (level == null) {
            return null;
        }
        ILevel lowestLevel = this.scopeRelationship.getLowestLevel(m, level);
        if (lowestLevel == null) {
            return null;
        }
        if (this.getNonMeasureDimension() == null) {
            return null;
        }
        CubeWrapper cube = (CubeWrapper)this.getNonMeasureDimension().getCube();
        lowestLevel = (ILevel)cube.getWrapper(lowestLevel);
        return lowestLevel;
    }

    @Override
    public String toString() {
        return this.scopeRelationship.getUniqueID();
    }

    @Override
    public IDimension getNonMeasureDimension() {
        return (IDimension)this.cubeWrapper.getWrapper(this.scopeRelationship.getNonMeasureDimension());
    }

    @Override
    public IDimension getMeasureDimension() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unsupported.");
    }

    public IScopeRelationship getWrappedScopeRelationship() {
        return this.scopeRelationship;
    }
}

