/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.metrics.IProfiledIterator;
import com.cognos.xqe.metrics.ProfileObject;
import com.cognos.xqe.util.context.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class IteratorProfilingContext
extends Context {
    private final HashMap<Integer, ArrayList<ProfileObject>> id2ProfileObj;

    public IteratorProfilingContext() {
        this.id2ProfileObj = new HashMap();
    }

    private IteratorProfilingContext(HashMap<Integer, ArrayList<ProfileObject>> profileObjs) {
        this.id2ProfileObj = profileObjs;
    }

    public void addProfileObject(ProfileObject object) {
        if (!(object.getData() instanceof IProfiledIterator)) {
            return;
        }
        IProfiledIterator ite = (IProfiledIterator)object.getData();
        Integer nodeId = ite.getNodeId();
        if (nodeId != null) {
            ArrayList<ProfileObject> profileObjects = this.id2ProfileObj.get(nodeId);
            if (profileObjects == null) {
                profileObjects = new ArrayList();
                this.id2ProfileObj.put(nodeId, profileObjects);
            }
            profileObjects.add(object);
        }
    }

    public void clear() {
        Iterator<ArrayList<ProfileObject>> ite = this.id2ProfileObj.values().iterator();
        while (ite.hasNext()) {
            ite.next().clear();
        }
        this.id2ProfileObj.clear();
    }

    public ProfileObject[] getProfileObjects(Object nodeId) {
        if (!(nodeId instanceof Integer)) {
            return new ProfileObject[0];
        }
        ArrayList<ProfileObject> list = this.id2ProfileObj.get(nodeId);
        if (list != null) {
            return list.toArray(new ProfileObject[0]);
        }
        return new ProfileObject[0];
    }

    public Object[] getKeys() {
        return this.id2ProfileObj.keySet().toArray(new Object[0]);
    }

    @Override
    protected boolean isTransferable() {
        return true;
    }

    @Override
    protected Context transferableClone() throws UnsupportedOperationException {
        return new IteratorProfilingContext((HashMap)this.id2ProfileObj.clone());
    }

    @Override
    protected void onEnter() {
    }

    @Override
    protected void onExit() {
    }

    public static IteratorProfilingContext enter() {
        IteratorProfilingContext context = new IteratorProfilingContext();
        Context.enter(context);
        return context;
    }

    public void exit() {
        this.exitContext(IteratorProfilingContext.class);
    }

    public static IteratorProfilingContext get() {
        return IteratorProfilingContext.getCurrent(IteratorProfilingContext.class);
    }
}

