/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.IMetricsMBean;
import com.cognos.xqe.metrics.Metric;
import com.cognos.xqe.metrics.MetricsCounterDoesNotExist;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Timer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class MetricsManager {
    public static final String XQE_METRICS_MBEAN_NAME = "com.cognos.xqe:type=serviceMetrics,service=xqeService";
    public static final String XQE_METRICS_MBEAN = "com.cognos.xqe:type=Metrics,service=queryService";
    private MBeanServer mBeanServer = null;
    private IMetricsMBean mBean = null;
    private static MetricsManager manager = null;
    private ObjectName objName = null;
    private Timer threadTimer = new Timer("MetricsManager-Timer", true);
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    private static final String[] METRICS = new String[]{"NumberOfReceivedRequests", "NumberOfSuccessfulRequests", "NumberOfFailedRequests", "NumberOfCriticalFailures", "ServiceTimeAllRequests", "ServiceTimeSuccessfulRequests", "ServiceTimeFailedRequests", "ResponseTimeHighWaterMark", "ResponseTimeLowWaterMark", "MillisecondsPerSuccessfulRequest", "SuccessfulRequestsPerMinute", "XqeQueriesPlanned", "XqeSuccessfulQueriesPlanned", "XqeFailedQueriesPlanned", "XqeQueriesExecuted", "XqeSuccessfulQueriesExecuted", "XqeFailedQueriesExecuted", "XqeQueriesPlannedTime", "XqeSuccessfulQueriesPlannedTime", "XqeFailedQueriesPlannedTime", "XqeQueriesExecutedTime", "XqeSuccessfulQueriesExecutedTime", "XqeFailedQueriesExecutedTime", "FailedRequestPercent", "SuccessfulRequestPercent"};

    public ObjectName getObjName() {
        return this.objName;
    }

    public static MetricsManager getManager() {
        if (manager == null) {
            throw new XQERuntimeException();
        }
        return manager;
    }

    public static void start(MBeanServer server) {
        if (manager == null) {
            manager = new MetricsManager(server);
        }
    }

    public static void start(MBeanServer server, IMetricsMBean bean) {
        if (manager == null) {
            manager = new MetricsManager(server, bean);
        }
    }

    public static void stop() {
        if (manager != null) {
            try {
                MetricsManager.manager.mBeanServer.unregisterMBean(MetricsManager.manager.objName);
            }
            catch (MBeanRegistrationException e) {
                mLogger.log(e);
            }
            catch (InstanceNotFoundException e) {
                mLogger.log(e);
            }
            MetricsManager.manager.threadTimer.cancel();
            manager = null;
        }
    }

    public static String getMBeanName(String url) {
        if (url.equals("*")) {
            return "com.cognos.xqe:type=Metrics,service=queryService,*";
        }
        return "com.cognos.xqe:type=Metrics,service=queryService,server=\"" + url + "\"";
    }

    private MetricsManager(MBeanServer server) {
        this.mBeanServer = server;
    }

    private MetricsManager(MBeanServer server, IMetricsMBean bean) {
        this.mBeanServer = server;
        this.mBean = bean;
        try {
            this.objName = new ObjectName(XQE_METRICS_MBEAN_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        try {
            this.mBeanServer.registerMBean(this.mBean, this.objName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new XQERuntimeException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new XQERuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new XQERuntimeException(e);
        }
    }

    public static void createAllMetrics() {
        for (String metric : METRICS) {
            MetricsManager.createMetric(metric);
        }
    }

    public static Metric createMetric(String name) {
        return MetricsManager.createMetric(name, 0L);
    }

    public static Metric createMetric(String name, long value) {
        if (manager != null && MetricsManager.manager.mBean != null) {
            return manager.createXqeMetrics(name, value);
        }
        return null;
    }

    private Metric createXqeMetrics(String name, long value) {
        if (mLogger.isOn(LogLevel.INFO)) {
            StringBuilder message = new StringBuilder();
            message.append("Creating metrics ");
            message.append(name);
            mLogger.log(LogLevel.INFO, message.toString());
        }
        Metric metric = MetricsManager.manager.mBean.createMetric(name, value);
        return metric;
    }

    public static long incrementCounter(String name, long num) throws MetricsCounterDoesNotExist {
        if (num == 0L) {
            return 0L;
        }
        if (manager != null && MetricsManager.manager.mBean != null) {
            return MetricsManager.manager.mBean.incrementCounter(name, num);
        }
        return -1L;
    }

    public static long incrementCounter(String name) throws MetricsCounterDoesNotExist {
        return MetricsManager.incrementCounter(name, 1L);
    }

    public static long decrementCounter(String name, long num) throws MetricsCounterDoesNotExist {
        if (manager != null && MetricsManager.manager.mBean != null) {
            return MetricsManager.manager.mBean.decrementCounter(name, num);
        }
        return -1L;
    }

    public static long decrementCounter(String name) throws MetricsCounterDoesNotExist {
        return MetricsManager.decrementCounter(name, 1L);
    }

    protected static void reset() {
        if (manager != null && MetricsManager.manager.mBean != null) {
            MetricsManager.manager.mBean.reset();
        }
    }

    protected static void resetCounter(String counter) {
        if (manager != null && MetricsManager.manager.mBean != null) {
            MetricsManager.manager.mBean.resetCounter(counter);
        }
    }

    public static long getCounterLongValue(String name) throws MetricsCounterDoesNotExist {
        if (manager != null && MetricsManager.manager.mBean != null) {
            return MetricsManager.manager.mBean.getCounterLongValue(name);
        }
        return -1L;
    }

    public static void downOperationalStatus() {
        if (manager != null && MetricsManager.manager.mBean != null) {
            MetricsManager.manager.mBean.setOperationalStatus(ServiceStatus.PARTIALLYAVAILABLE);
        }
    }

    public static Object[] getSnapshot(String[] counterNames) {
        if (manager != null && MetricsManager.manager.mBean != null) {
            return MetricsManager.manager.mBean.getSnapshot(counterNames);
        }
        return null;
    }

    public IMetricsMBean getMBean() {
        return this.mBean;
    }

    public static long setMetricValue(String name, long value) throws MetricsCounterDoesNotExist {
        if (value == 0L) {
            return 0L;
        }
        if (manager != null && MetricsManager.manager.mBean != null) {
            return MetricsManager.manager.mBean.setMetricValue(name, value);
        }
        return -1L;
    }
}

