/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.Element;

public final class MetricsService {
    public static final String XQE_REQUESTS_COUNTER = "NumberOfReceivedRequests";
    public static final String XQE_REQUESTS_TIME = "ServiceTimeAllRequests";
    public static final String XQE_SUCCESSFUL_REQUESTS_COUNTER = "NumberOfSuccessfulRequests";
    public static final String XQE_SUCCESSFUL_REQUESTS_TIME = "ServiceTimeSuccessfulRequests";
    public static final String XQE_FAILED_REQUESTS_COUNTER = "NumberOfFailedRequests";
    public static final String XQE_CRITICAL_FAILURES_COUNTER = "NumberOfCriticalFailures";
    public static final String XQE_FAILED_REQUESTS_TIME = "ServiceTimeFailedRequests";
    public static final String XQE_RESPONSE_TIME_HIGH_WATER_MARK = "ResponseTimeHighWaterMark";
    public static final String XQE_RESPONSE_TIME_LOW_WATER_MARK = "ResponseTimeLowWaterMark";
    public static final String XQE_OPERATIONAL_STATUS = "OperationalStatus";
    public static final String XQE_LAST_RESPONSE_TIME = "LastResponseTime";
    public static final String XQE_CONSOLIDATED_LAST_RESPONSE_TIME = "ConsolidatedLastResponseTime";
    public static final String XQE_QUERIES_EXECUTED_COUNTER = "XqeQueriesExecuted";
    public static final String XQE_QUERIES_EXECUTED_TIME = "XqeQueriesExecutedTime";
    public static final String XQE_QUERIES_EXECUTED_SUCCESS_COUNTER = "XqeSuccessfulQueriesExecuted";
    public static final String XQE_QUERIES_EXECUTED_SUCCESS_TIME = "XqeSuccessfulQueriesExecutedTime";
    public static final String XQE_QUERIES_EXECUTED_FAILED_COUNTER = "XqeFailedQueriesExecuted";
    public static final String XQE_QUERIES_EXECUTED_FAILED_TIME = "XqeFailedQueriesExecutedTime";
    public static final String XQE_QUERIES_PLANNED_COUNTER = "XqeQueriesPlanned";
    public static final String XQE_QUERIES_PLANNED_TIME = "XqeQueriesPlannedTime";
    public static final String XQE_QUERIES_PLANNED_SUCCESS_COUNTER = "XqeSuccessfulQueriesPlanned";
    public static final String XQE_QUERIES_PLANNED_SUCCESS_TIME = "XqeSuccessfulQueriesPlannedTime";
    public static final String XQE_QUERIES_PLANNED_FAILED_COUNTER = "XqeFailedQueriesPlanned";
    public static final String XQE_QUERIES_PLANNED_FAILED_TIME = "XqeFailedQueriesPlannedTime";
    public static final String XQE_CURRENT_TIME = "CurrentTime";
    public static final String XQE_MS_PER_SUCCESSFUL_REQUEST = "MillisecondsPerSuccessfulRequest";
    public static final String XQE_SUCCESSFUL_REQ_PER_MINUTE = "SuccessfulRequestsPerMinute";
    public static final String FAILED_REQ_PERCENT = "FailedRequestPercent";
    public static final String SUCCESS_REQ_PERCENT = "SuccessfulRequestPercent";
    public static final String ALL_REQUESTS_LAST_UPDATE_TIME = "AllRequestsLastUpdateTime";
    public static final String FAILED_REQUESTS_LAST_UPDATE_TIME = "FailedRequestsLastUpdateTime";
    public static final String LAST_REQUEST_RESET_TIME = "LastRequestResetTime";
    public static final String LAST_RESPONSE_TIME_LAST_UPDATE_TIME = "LastResponseTimeLastUpdateTime";
    public static final String LAST_UPDATE_TIME = "LastUpdateTime";
    public static final String LAST_RESET_TIME = "LastResetTime";
    public static final String OPERATIONAL_STATUS_LAST_UPDATE_TIME = "OperationalStatusLastUpdateTime";
    public static final String RECEIVED_REQUESTS_LAST_UPDATE_TIME = "ReceivedRequestsLastUpdateTime";
    public static final String SUCCESSFUL_REQUESTS_LAST_UPDATE_TIME = "SuccessfulRequestsLastUpdateTime";
    public static final String XQE_ROLAP_START_CUBES = "startCubes";
    public static final String XQE_ROLAP_FORCE_START_CUBES = "forceStartCubes";
    public static final String XQE_ROLAP_STOP_CUBES = "stopCubes";
    public static final String XQE_ROLAP_FORCE_STOP_CUBES = "forceStopCubes";
    public static final String XQE_ROLAP_RESTART_CUBES = "restartCubes";
    public static final String XQE_ROLAP_REFRESH_MEMBER_CACHE = "refreshCubeMemberCache";
    public static final String XQE_ROLAP_REFRESH_DATA_CACHE = "refreshCubeDataCache";
    public static final String XQE_ROLAP_ENABLE_RESULT_SET_CACHE = "enableResultSetCache";
    public static final String XQE_ROLAP_DISABLE_RESULT_SET_CACHE = "disableResultSetCache";
    public static final String XQE_ROLAP_REFRESH_SECURITY = "refreshCubeSecurity";
    public static final String XQE_ROLAP_CLEAR_WORKLOAD_LOG = "clearCubeWorkloadLog";
    public static final String XQE_ROLAP_PAUSE_CUBES = "pauseCubes";
    public static final String XQE_ROLAP_INCREMENTALLY_LOAD_CUBES = "incrementallyLoadCubes";
    public static final String XQE_ROLAP_ADD_CUBES = "addCubes";
    public static final String XQE_ROLAP_DELETE_CUBES = "deleteCubes";
    public static final String XQE_ROLAP_SET_CUBE_PROPERTY = "setCubeProperty";
    public static final String XQE_ROLAP_CUBE_STATE = "CubeState";
    public static final String XQE_ROLAP_CUBE_STATES_NAME = "cubeStates";
    public static final String XQE_ROLAP_CUBE_STATES_DESC = "Cube states";
    public static final String XQE_ROLAP_CUBE_NAME_FIELD = "cubeName";
    public static final String XQE_ROLAP_CUBE_STATE_FIELD = "state";
    public static final String XQE_ROLAP_CUBE_MESSAGES_FIELD = "messages";
    public static final String XQE_ROLAP_CUBE_DEPENDENTS_FIELD = "dependents";
    public static final String XQE_ROLAP_CUBE_SOURCES_FIELD = "sources";
    public static final String XQE_ROLAP_CUBE_STOPPED_SOURCES_FIELD = "stoppedSources";
    public static final String XQE_ROLAP_CUBE_RUNNING_DEPENDENTS_FIELD = "runningDependents";
    public static final String SIGNATURE_STRING = "java.lang.String";
    public static final String STRING_ARRAY_SIGNATURE = "[Ljava.lang.String;";
    public static final String XQE_PKG_CACHE_STATE = "PackageCacheState";
    public static final String XQE_PKG_CACHE_STATE_DESC = "Package cache state";
    private static MetricsService mMetricsService = null;
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String LOG_FILE_NAME = "Metrics-";
    private static final String DOT = ".";
    private static final String XML_ELEMENT_TRACE_ATTRIBUTE_ENABLED = "metrics[@enabled]";
    private static final String XML_ELEMENT_TRACE_ATTRIBUTE_ZIPFILE = "metrics[@compressedFile]";
    private static final String DUMP_TO_DATABASE_ENABLED = "metrics[@databaseEnabled]";
    private static final String DATABASE_CONNECTION = "metrics[@databaseConnection]";
    private static final String DATABASE_UID = "metrics[@databaseUID]";
    private static final String DATABASE_PWD = "metrics[@databasePWD]";
    private Map<RequestEnvironment, Map<String, Object>> mData = new Hashtable<RequestEnvironment, Map<String, Object>>();
    private static final String METRICS_TIME_TO_COMPARE_WITH = "requestTimes";
    private XQETrace mTrace = null;
    private Connection con = null;
    private static final String XML_ELEMENT_REQUEST = "request";
    public static final String V5QUERY_TO_BINARY = "v5QueryToBinaryTree";
    public static final String PLAN_V5_QUERY = "planV5Query";
    public static final String EXECUTEMDX_POPULATEHRESULT = "executeMDXPopulateHResult";
    public static final String GENERATE_XML_MDQUERY_SPEC = "generateXMLMDQuerySpec";
    public static final String GENERATE_RSAPI_XML = "generateRSAPIXML";
    public static final String MFW_REQUEST = "mfwRequest";
    public static final String OLD_STACK = "oldStack";
    public static final String NEW_STACK = "newStack";
    public static final String PLAN_V5_QUERY_SUCCESS = "isV5QueryPlanned";
    public static final String PREPARE_V5_QUERY_SUCCESS = "isQuerySetPrepared";
    public static final String RELEASE_V5_QUERY_SUCCESS = "isQuerySetReleased";
    public static final String EXECUTE_V5_QUERY_SUCCESS = "isV5QueryExecuted";
    public static final String REQUEST_TYPE = "requestType";
    public static final String INFO_TRUE = "true";
    public static final String INFO_FALSE = "false";
    public static final String INFO_FAILED = "failed";
    public static final String MACRO_PREFIX = "$";
    public static final String BUILD_TAG = "build_tag";
    public static final String BUILD_ID = "build_id";
    public static final String METRICS_ENABLED = "metrics_enabled";
    public static final String DB_ENABLED = "database_enabled";
    private static final int SQL_FIELD_POS_1 = 1;
    private static final int SQL_FIELD_POS_2 = 2;
    private static final int SQL_FIELD_POS_3 = 3;
    private static final int SQL_FIELD_POS_4 = 4;
    private static final int SQL_FIELD_POS_5 = 5;
    private static final int SQL_FIELD_POS_6 = 6;
    private static final int SQL_FIELD_POS_7 = 7;
    private long latestRequestId = 0L;
    private String testcaseName = null;
    private String testcaseClassName = null;
    private static String metricsLogSubfolderName = null;
    private static boolean isHudsonBuild = false;
    private boolean isMetricsServiceEnabled = false;
    private boolean isDBEnabled = false;
    private static Map<String, Long[]> latestMetricCollectTimeMap = new HashMap<String, Long[]>();
    private static XQELogger mErrorLogger;

    public static void updateStartTimeForMetric(String serviceName, Long startTime) {
        Long[] timeList = latestMetricCollectTimeMap.get(serviceName);
        if (timeList == null) {
            timeList = new Long[2];
        }
        timeList[0] = startTime;
        latestMetricCollectTimeMap.put(serviceName, timeList);
    }

    public static Long getStartTimeForMetric(String serviceName) {
        Long[] timeList = latestMetricCollectTimeMap.get(serviceName);
        if (timeList != null) {
            return timeList[0];
        }
        return null;
    }

    public static void updateEndTimeForMetric(String serviceName, Long endTime) {
        Long[] timeList = latestMetricCollectTimeMap.get(serviceName);
        if (timeList == null) {
            timeList = new Long[]{endTime, endTime};
        }
        latestMetricCollectTimeMap.put(serviceName, timeList);
    }

    private MetricsService() {
        this(null, null);
    }

    private MetricsService(String testCaseName, String testClassName) {
        this.testcaseName = testCaseName;
        this.testcaseClassName = testClassName;
        this.setMetricsServiceEnabledFlag();
        this.setNextLogOutputStream();
        if (this.mTrace != null) {
            this.mTrace.beginElement("metrics", -1);
            this.mTrace.beginElement("completedRequests", -1);
        }
    }

    private void setMetricsServiceEnabledFlag() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean traceEnabledProperty = configuration.getBooleanProperty(XML_ELEMENT_TRACE_ATTRIBUTE_ENABLED, false);
        String traceEnabledFlag = System.getProperty(METRICS_ENABLED);
        boolean dbEnabledProperty = configuration.getBooleanProperty(DUMP_TO_DATABASE_ENABLED, false);
        String dbEnablebledFlag = System.getProperty(DB_ENABLED);
        if (traceEnabledProperty || INFO_TRUE.equalsIgnoreCase(traceEnabledFlag)) {
            this.isMetricsServiceEnabled = true;
        }
        if (this.isMetricsServiceEnabled && (dbEnabledProperty || INFO_TRUE.equalsIgnoreCase(dbEnablebledFlag))) {
            this.isDBEnabled = true;
        }
    }

    private File getNextLogFile() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String xqeLogsFolder = configuration.getXqeLogsDirectory();
        boolean zipEnabled = configuration.getBooleanProperty(XML_ELEMENT_TRACE_ATTRIBUTE_ZIPFILE, false);
        File logFile = null;
        String ext = null;
        ext = zipEnabled ? ZIP_FILE_EXTENSION : XML_FILE_EXTENSION;
        if (this.testcaseName != null) {
            StringBuilder fileNameBuf = new StringBuilder();
            fileNameBuf.append(this.testcaseClassName).append(DOT).append(this.testcaseName);
            StringBuilder folderName = new StringBuilder();
            folderName.append(xqeLogsFolder).append(File.separator).append(metricsLogSubfolderName);
            File folder = new File(folderName.toString());
            if (!folder.exists()) {
                folder.mkdir();
            }
            String fileName = MetricsService.buildMetricsLogFileName(folderName.toString(), fileNameBuf.toString(), ext);
            logFile = new File(fileName);
        } else {
            String fileName;
            int idx = 0;
            while ((logFile = new File(fileName = MetricsService.buildMetricsLogFileName(xqeLogsFolder, Integer.toString(idx++), ext))).exists()) {
            }
        }
        return logFile;
    }

    private static String buildMetricsLogFileName(String pathName, String fileName, String extension) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(pathName).append(File.separator).append(LOG_FILE_NAME);
        fullName.append(fileName).append(extension);
        return fullName.toString();
    }

    private OutputStream getNextLogOutputStream(File logFile) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        try {
            boolean zipEnabled = configuration.getBooleanProperty(XML_ELEMENT_TRACE_ATTRIBUTE_ZIPFILE, false);
            FilterOutputStream outputStream = null;
            if (zipEnabled) {
                ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(logFile));
                try {
                    zipStream.putNextEntry(new ZipEntry("trace.xml"));
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                outputStream = zipStream;
            } else {
                outputStream = new BufferedOutputStream(new FileOutputStream(logFile));
            }
            return outputStream;
        }
        catch (FileNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    private void setNextLogOutputStream() {
        if (this.isMetricsServiceEnabled && !this.isDBEnabled) {
            File logFile = this.getNextLogFile();
            OutputStream fos = this.getNextLogOutputStream(logFile);
            this.mTrace = new XQETrace();
            this.mTrace.setTraceLevelAll();
            if (fos != null) {
                try {
                    this.mTrace.addStream(new OutputStreamWriter(fos, "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)uee);
                }
            }
        }
    }

    public static void startRequest(RequestEnvironment env) {
        if (mMetricsService != null) {
            mMetricsService.initRequest(env);
        }
    }

    public static synchronized void start() {
        if (mMetricsService == null) {
            mMetricsService = new MetricsService();
            if (MetricsService.mMetricsService.mTrace == null && !MetricsService.mMetricsService.isDBEnabled) {
                mMetricsService = null;
            }
        }
    }

    public static synchronized void start(String traceFileName, String testClassName) {
        if (mMetricsService == null) {
            mMetricsService = new MetricsService(traceFileName, testClassName);
            if (MetricsService.mMetricsService.mTrace == null && !MetricsService.mMetricsService.isDBEnabled) {
                mMetricsService = null;
            }
        } else {
            MetricsService.mMetricsService.testcaseName = traceFileName;
            MetricsService.mMetricsService.testcaseClassName = testClassName;
        }
    }

    public static synchronized void stop() {
        if (mMetricsService != null) {
            mMetricsService.stopService();
            mMetricsService = null;
        }
    }

    public static boolean isEnabled() {
        return mMetricsService != null;
    }

    public static void endRequest(RequestEnvironment env) {
        if (mMetricsService != null) {
            mMetricsService.finalizeRequest(env);
        }
    }

    private void initRequest(RequestEnvironment env) {
        Hashtable requestInfo = new Hashtable();
        this.mData.put(env, requestInfo);
        this.collectMetricStartTime(env, METRICS_TIME_TO_COMPARE_WITH);
    }

    private void collectMetricStartTime(RequestEnvironment env, String name) {
        Long startTime = new Long(System.currentTimeMillis());
        Map<String, Object> requestInfo = this.mData.get(env);
        if (requestInfo == null) {
            this.initRequest(env);
            requestInfo = this.mData.get(env);
        }
        List<Long> timeInfo = null;
        if (requestInfo.get(name) == null) {
            timeInfo = new ArrayList(2);
            timeInfo.add(new Long(0L));
            requestInfo.put(name, timeInfo);
        } else {
            timeInfo = (List)requestInfo.get(name);
        }
        if (timeInfo.size() == 2 || (Long)timeInfo.get(0) == -1L) {
            timeInfo.clear();
            timeInfo.add(new Long(-1L));
        } else {
            timeInfo.add(startTime);
        }
    }

    private void collectMetricTime(RequestEnvironment env, String name, Long time) {
        Map<String, Object> requestInfo = this.mData.get(env);
        if (requestInfo == null) {
            this.initRequest(env);
            requestInfo = this.mData.get(env);
        }
        List<Long> timeInfo = null;
        if (requestInfo.get(name) == null) {
            timeInfo = new ArrayList(1);
            timeInfo.add(new Long(time));
            requestInfo.put(name, timeInfo);
        } else {
            timeInfo = (List)requestInfo.get(name);
            Long elapsedTime = new Long((Long)timeInfo.get(0) + time);
            timeInfo.clear();
            timeInfo.add(elapsedTime);
        }
    }

    private void collectMetricEndTime(RequestEnvironment env, String name) {
        Long endTime = new Long(System.currentTimeMillis());
        Map<String, Object> requestInfo = this.mData.get(env);
        if (requestInfo == null) {
            return;
        }
        List timeInfo = (List)requestInfo.get(name);
        if (requestInfo != null && timeInfo.size() == 2) {
            Long elapsedTime = (Long)timeInfo.get(0);
            Long startTime = (Long)timeInfo.get(1);
            elapsedTime = new Long(elapsedTime + (endTime - startTime));
            timeInfo.clear();
            timeInfo.add(elapsedTime);
            if (name.compareTo(METRICS_TIME_TO_COMPARE_WITH) != 0) {
                MetricsService.collectMetric(env, name, null, elapsedTime);
            }
        }
    }

    private void collectMetricData(RequestEnvironment env, String name, String value) {
        Map<String, Object> requestInfo = this.mData.get(env);
        if (requestInfo != null) {
            requestInfo.put(name, value);
        }
    }

    private void finalizeRequest(RequestEnvironment env) {
        this.collectMetricEndTime(env, METRICS_TIME_TO_COMPARE_WITH);
        if (this.isDBEnabled) {
            this.dumpToDatabase(env);
        } else {
            this.dumpToTrace(env);
        }
        this.mData.remove(env);
    }

    private void stopService() {
        if (this.isDBEnabled) {
            this.clearRequests();
        } else {
            this.mTrace.endElement();
            this.clearRequests();
            this.mTrace.endElement();
            this.mTrace.flush();
        }
    }

    private void clearRequests() {
        Set<RequestEnvironment> requests = this.mData.keySet();
        Iterator<RequestEnvironment> requestIterator = requests.iterator();
        if (!this.isDBEnabled) {
            this.mTrace.beginElement("activeAndDeathRequests", -1);
            this.mTrace.attribute("numberRequests", requests.size());
        }
        while (requestIterator.hasNext()) {
            RequestEnvironment request = requestIterator.next();
            if (this.isDBEnabled) {
                this.dumpToDatabase(request);
                continue;
            }
            this.dumpToTrace(request);
        }
        if (!this.isDBEnabled) {
            this.mTrace.endElement();
        }
        this.mData.clear();
    }

    public static void collectingMetric(RequestEnvironment env, String metricName, Long time) {
        if (mMetricsService != null) {
            mMetricsService.collectMetricTime(env, metricName, time);
        }
    }

    public static void startCollectingMetric(RequestEnvironment env, String metricName) {
        if (mMetricsService != null) {
            mMetricsService.collectMetricStartTime(env, metricName);
        } else {
            MetricsService.collectMetricsStartTime(env, metricName);
        }
    }

    public static void endCollectingMetric(RequestEnvironment env, String metricName) {
        if (mMetricsService != null) {
            mMetricsService.collectMetricEndTime(env, metricName);
        } else {
            MetricsService.collectMetricsEndTime(env, metricName, null);
        }
    }

    public static void collectMetricInfo(RequestEnvironment env, String metricName, String value) {
        MetricsService.collectMetricInfo(env, metricName, value, 0L);
    }

    public static void collectMetricInfo(RequestEnvironment env, String metricName, String value, long time) {
        if (mMetricsService != null) {
            mMetricsService.collectMetricData(env, metricName, value);
        }
        MetricsService.collectMetric(env, metricName, value, time);
    }

    public static void collectMetric(RequestEnvironment env, String metricName, String status, long time) {
        boolean requestSucceeded;
        boolean bl = requestSucceeded = !INFO_FAILED.equals(status) && !INFO_FALSE.equals(status);
        if (time < 0L) {
            time = 0L;
        }
        if (time != 0L) {
            ROLAPCubeMetrics.recordGlobalMetrics(env, time, requestSucceeded);
        }
        MetricsManager.incrementCounter(XQE_REQUESTS_COUNTER);
        MetricsManager.incrementCounter(XQE_REQUESTS_TIME, time);
        if (metricName.equals(PLAN_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_TIME, time);
        } else if (metricName.equals(EXECUTE_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_TIME, time);
        }
        if (requestSucceeded) {
            MetricsService.collectSuccessMetric(env, metricName, status, time);
        } else {
            MetricsService.collectFailureMetric(env, metricName, status, time);
        }
    }

    public static void collectFailureMetric(RequestEnvironment env, String metricName, String status, long time) {
        MetricsManager.incrementCounter(XQE_FAILED_REQUESTS_COUNTER);
        MetricsManager.incrementCounter(XQE_FAILED_REQUESTS_TIME, time);
        MetricsService.collectMetricsEndTime(env, metricName, status);
        if (metricName.equals(PLAN_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_FAILED_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_FAILED_TIME, time);
        } else if (metricName.equals(EXECUTE_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_FAILED_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_FAILED_TIME, time);
        }
    }

    public static void collectSuccessMetric(RequestEnvironment env, String metricName, String status, long time) {
        MetricsManager.incrementCounter(XQE_SUCCESSFUL_REQUESTS_COUNTER);
        MetricsManager.incrementCounter(XQE_SUCCESSFUL_REQUESTS_TIME, time);
        if (metricName.equals(PLAN_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_SUCCESS_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_PLANNED_SUCCESS_TIME, time);
        } else if (metricName.equals(EXECUTE_V5_QUERY_SUCCESS)) {
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_SUCCESS_COUNTER);
            MetricsManager.incrementCounter(XQE_QUERIES_EXECUTED_SUCCESS_TIME, time);
        }
    }

    public static synchronized void collectMetricsStartTime(RequestEnvironment env, String name) {
        Long startTime = new Long(System.currentTimeMillis());
        MetricsService.updateStartTimeForMetric(name, startTime);
    }

    public static synchronized void collectMetricsEndTime(RequestEnvironment env, String name, String status) {
        long responseTimeLowWaterMark;
        Long startTime = MetricsService.getStartTimeForMetric(name);
        if (startTime == null || startTime == 0L) {
            startTime = new Long(System.currentTimeMillis());
            MetricsService.updateStartTimeForMetric(name, startTime);
        }
        Long endTime = new Long(System.currentTimeMillis());
        MetricsService.updateEndTimeForMetric(name, endTime);
        Long time = endTime - startTime;
        MetricsManager.resetCounter(XQE_LAST_RESPONSE_TIME);
        MetricsManager.incrementCounter(XQE_LAST_RESPONSE_TIME, time);
        long responseTimeHighWaterMark = MetricsManager.getCounterLongValue(XQE_RESPONSE_TIME_HIGH_WATER_MARK);
        if (responseTimeHighWaterMark < time) {
            MetricsManager.resetCounter(XQE_RESPONSE_TIME_HIGH_WATER_MARK);
            MetricsManager.incrementCounter(XQE_RESPONSE_TIME_HIGH_WATER_MARK, time);
        }
        if ((responseTimeLowWaterMark = MetricsManager.getCounterLongValue(XQE_RESPONSE_TIME_LOW_WATER_MARK)) > time || responseTimeLowWaterMark == 0L && time > 0L) {
            MetricsManager.resetCounter(XQE_RESPONSE_TIME_LOW_WATER_MARK);
            MetricsManager.incrementCounter(XQE_RESPONSE_TIME_LOW_WATER_MARK, time);
        }
        MetricsManager.incrementCounter(XQE_REQUESTS_TIME, time);
        if (status == null) {
            MetricsManager.incrementCounter(XQE_SUCCESSFUL_REQUESTS_TIME, time);
        } else {
            MetricsManager.incrementCounter(XQE_FAILED_REQUESTS_TIME, time);
        }
    }

    private synchronized void dumpToTrace(RequestEnvironment env) {
        Element reportElement;
        Map requestInfo = (Map)((Hashtable)this.mData.get(env)).clone();
        this.mTrace.beginElement(XML_ELEMENT_REQUEST, -1);
        Element infoElement = env.getInfo();
        if (infoElement != null && (reportElement = infoElement.element("report")) != null) {
            this.mTrace.attribute("reportName", reportElement.getText());
        }
        this.mTrace.attribute("testcase", this.testcaseClassName + DOT + this.testcaseName);
        List timeInfo = (List)requestInfo.get(METRICS_TIME_TO_COMPARE_WITH);
        long elapsedTime = -1L;
        if (timeInfo.size() == 1) {
            elapsedTime = (Long)timeInfo.get(0);
        }
        this.mTrace.attribute("totalElapsedTime", elapsedTime);
        Set metrics = requestInfo.keySet();
        metrics.remove(METRICS_TIME_TO_COMPARE_WITH);
        for (String metric : metrics) {
            Object obj = requestInfo.get(metric);
            this.mTrace.beginElement(metric, -1);
            if (obj instanceof String) {
                this.mTrace.attribute("info", obj);
            } else {
                timeInfo = (List)obj;
                elapsedTime = -1L;
                if (timeInfo.size() == 1) {
                    elapsedTime = (Long)timeInfo.get(0);
                }
                this.mTrace.attribute("elapsedTime", elapsedTime);
            }
            this.mTrace.endElement();
        }
        this.mTrace.endElement();
    }

    private synchronized void dumpToDatabase(RequestEnvironment env) {
        try {
            Element reportElement;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String conn = configuration.getStringProperty(DATABASE_CONNECTION, "");
            String uid = configuration.getStringProperty(DATABASE_UID, "");
            String pwd = configuration.getStringProperty(DATABASE_PWD, "");
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            this.con = DriverManager.getConnection(conn, uid, pwd);
            PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO Metrics(service, environment, name, info, time, testcase, build_id)VALUES (?,?,?,?,?,?,?);");
            String environment = "";
            if (this.testcaseName != null) {
                environment = this.testcaseName;
            }
            String info = "";
            Timestamp buildID = null;
            long time = -1L;
            String service = System.getProperty(BUILD_TAG);
            String buildIDString = System.getProperty(BUILD_ID);
            if (service != null && !service.startsWith(MACRO_PREFIX) && buildIDString != null && !buildIDString.startsWith(MACRO_PREFIX)) {
                SimpleDateFormat formater = new SimpleDateFormat();
                formater.applyPattern("yyyy-MM-dd'_'HH-mm-ss");
                Date buildIDDate = formater.parse(buildIDString);
                Calendar c = Calendar.getInstance();
                c.setTime(buildIDDate);
                buildID = new Timestamp(c.getTimeInMillis());
            } else {
                long currentID;
                for (currentID = System.currentTimeMillis(); currentID <= this.latestRequestId; ++currentID) {
                }
                this.latestRequestId = currentID;
                service = String.valueOf(currentID);
                buildID = new Timestamp(currentID);
            }
            Map requestInfo = (Map)((Hashtable)this.mData.get(env)).clone();
            Element infoElement = env.getInfo();
            if (infoElement != null && (reportElement = infoElement.element("report")) != null) {
                environment = reportElement.getText();
            }
            String name = METRICS_TIME_TO_COMPARE_WITH;
            List timeInfo = (List)requestInfo.get(METRICS_TIME_TO_COMPARE_WITH);
            if (timeInfo.size() == 1) {
                time = (Long)timeInfo.get(0);
            }
            if (time <= 0L && info.length() == 0) {
                return;
            }
            pstmt.setString(1, service);
            pstmt.setString(2, environment);
            pstmt.setString(3, name);
            pstmt.setString(4, info);
            pstmt.setLong(5, time);
            pstmt.setString(6, this.testcaseClassName + DOT + this.testcaseName);
            pstmt.setTimestamp(7, buildID);
            pstmt.execute();
            Set metrics = requestInfo.keySet();
            metrics.remove(METRICS_TIME_TO_COMPARE_WITH);
            for (String metric : metrics) {
                Object obj = requestInfo.get(metric);
                info = "";
                time = -1L;
                if (obj instanceof String) {
                    info = (String)obj;
                } else {
                    timeInfo = (List)obj;
                    if (timeInfo.size() == 1) {
                        time = (Long)timeInfo.get(0);
                    }
                }
                if (time <= 0L && info.length() == 0) continue;
                pstmt.setString(1, service);
                pstmt.setString(2, environment);
                pstmt.setString(3, metric);
                pstmt.setString(4, info);
                pstmt.setLong(5, time);
                pstmt.setString(6, this.testcaseClassName + DOT + this.testcaseName);
                pstmt.setTimestamp(7, buildID);
                pstmt.execute();
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
    }

    public static void initialize() {
    }

    static {
        String buildTag = System.getProperty(BUILD_TAG);
        String buildIDString = System.getProperty(BUILD_ID);
        if (buildTag != null && !buildTag.startsWith(MACRO_PREFIX) && buildIDString != null && !buildIDString.startsWith(MACRO_PREFIX)) {
            isHudsonBuild = true;
        }
        if (isHudsonBuild) {
            metricsLogSubfolderName = LOG_FILE_NAME + buildTag;
        } else {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            metricsLogSubfolderName = LOG_FILE_NAME + df.format(calendar.getTime());
        }
        mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    }
}

