/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagCollector;
import com.cognos.xqe.query.engine.PersistentPlan;
import com.cognos.xqe.query.engine.PersistentPlanDiskCacheStatistics;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.decoration.rulesfactory.OLAPDecorationRulesFactory;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogWriter;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.MemoryWalker;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class PersistentPlanDiskCache {
    private static final String STRING_XML_FILENAME_EXTENSION = ".xml";
    private static final String STRING_UNDERSCORE = "_";
    private static final String STRING_ARROW_NEWLINE = "-->\n";
    private static final String STRING_PLANKEY = "planKey";
    private static final String STRING_DOC = "doc";
    private static final String EXMSG_QUERYSETSTRING_WAS_NULL = "querySetString was null";
    private static final String EXMSG_PLANTREE_WAS_NULL = "planTree was null";
    private static final String NEWLINE = "\n";
    private static String jarVersion = null;
    private final ReadWriteLock planCacheLock = new ReentrantReadWriteLock(true);
    private PersistentPlanDiskCacheStatistics persistentPlanDiskCacheStatistics = new PersistentPlanDiskCacheStatistics();
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DiskPlanCache", LogLevel.INFO);
    private static int fileSeqNumber = 1;

    PersistentPlanDiskCache() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        TRACE_LOGGER.log(LogLevel.INFO, "DiskPlanCache initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storePlanTree(PlannedV5QuerySet planTree, IRequestEnvironment reqEnv) {
        PlanningEnvironment planEnv;
        String planFileName;
        boolean enableStats;
        boolean includeSelf;
        boolean disableXMdx;
        boolean disableXFunctionCursor;
        boolean includeSelf2;
        List<IXQEQueryNode> nodes;
        if (null == planTree) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
            throw new IllegalArgumentException(EXMSG_PLANTREE_WAS_NULL);
        }
        if (planTree.getReadFromPersistentStore()) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.PLAN_WAS_READ_FROM_PPDC);
            return true;
        }
        this.persistentPlanDiskCacheStatistics.halfHeartedReset();
        if (!planTree.isCacheable()) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.PLAN_MARKED_NOT_CACHEABLE);
            return false;
        }
        boolean filterOnOperationName = true;
        if (filterOnOperationName && !"execute".equals(planTree.getOperationName()) && !"getParameters".equals(planTree.getOperationName())) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.UNSUPPORTED_COMMAND);
            return false;
        }
        boolean disableRelationalXTab = true;
        if (disableRelationalXTab && (nodes = planTree.getFirstDescendantsOfTypeOrdered(501088, includeSelf2 = false)).size() > 0) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.UNSUPPORTED_XRELATIONAL_CROSSTAB);
            return false;
        }
        boolean disableDMR = true;
        if (disableDMR) {
            IXQEQueryNode[] nodes2;
            boolean includeSelf3 = false;
            for (IXQEQueryNode n : nodes2 = planTree.getDescendantsOfType(501053, includeSelf3)) {
                XMdxLocal xMdxLocal = (XMdxLocal)n;
                if (!xMdxLocal.isDMR()) continue;
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.UNSUPPORTED_XMDXLOCAL_ISDMR);
                return false;
            }
        }
        if (disableXFunctionCursor = true) {
            IXQEQueryNode[] nodes3;
            boolean includeSelf4 = false;
            for (IXQEQueryNode n : nodes3 = planTree.getDescendantsOfType(501015, includeSelf4)) {
                XTableFunction tableFunction = (XTableFunction)n;
                if (!"Cursor".equalsIgnoreCase(tableFunction.getFunction().getName())) continue;
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.UNSUPPORTED_XTABLEFUNCTION_OVER_CURSOR);
                return false;
            }
        }
        if ((disableXMdx = true) && (planTree.getFirstDescendantOfTypeOrdered(501017, includeSelf = true) != null || planTree.getFirstDescendantOfTypeOrdered(501137, includeSelf) != null)) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.UNSUPPORTED_XMDX_OR_XMDXNODE);
            return false;
        }
        String querySetString = planTree.getPlanKey();
        if (null == querySetString) {
            boolean throwException = false;
            if (throwException) {
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
                throw new IllegalArgumentException(EXMSG_QUERYSETSTRING_WAS_NULL);
            }
            return false;
        }
        ArrayWrapper<String> planCacheKey = this.constructPlanCacheKey(querySetString, reqEnv);
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Stored plan tree for plan cache key ").append(querySetString);
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (enableStats = false) {
            MemoryWalker.MemoryStatistics stats = MemoryWalker.deepStatistics(planCacheKey);
            stats.printStats("CacheManager::storePlanTree planCacheKey");
            stats = MemoryWalker.deepStatistics(planTree);
            stats.printStats("CacheManager::storePlanTree planTree");
        }
        if ((planFileName = this.getPlanFileName(reqEnv, planEnv = (PlanningEnvironment)planTree.getPlanningEnvironment(), planCacheKey, planTree.getReportName(), planTree.getRetrieveDatasets())) != null) {
            this.persistentPlanDiskCacheStatistics.setLastFileName(planFileName);
            try {
                this.planCacheLock.writeLock().lock();
                this.writePlanToFile(reqEnv, planTree, planFileName);
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.SUCCESS);
                if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("Stored plan tree for report: ");
                    buffer.append(planTree.getReportName());
                    buffer.append(" to file: ");
                    buffer.append(planFileName);
                    TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.planCacheLock.writeLock().unlock();
            }
        }
        this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.FILENAME_CAN_NOT_BE_COMPUTED);
        return false;
    }

    void removePlanTree(PlannedV5QuerySet querySet) {
    }

    private ArrayWrapper<String> constructPlanCacheKey(String queryKey, IRequestEnvironment reqEnv) {
        String[] keyArray = new String[]{reqEnv.getCAMPassport(), LocaleConverter.localeToStr(reqEnv.getRunLocale()), LocaleConverter.localeToStr(reqEnv.getProductLocale()), queryKey};
        return new ArrayWrapper<String>(keyArray);
    }

    private String getPlanFileName(IRequestEnvironment reqEnv, PlanningEnvironment planEnv, ArrayWrapper<String> planCacheKey, String reportName, String[] retrieveDatasetNames) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String fn = null;
        String buildNumber = PersistentPlanDiskCache.getXqeServiceJarVersion();
        if (reqEnv.getModelPath() == null) {
            return null;
        }
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(reqEnv.getModelType(), reqEnv.getModelPath()), reqEnv.getModelPath(), (IExecutionEnvironment)reqEnv.getExecutionEnvironment(), true);
        long modelModificationTime = 0L;
        String modelPart = null;
        modelPart = metadataConnection.getPackageName();
        if (modelPart != null) {
            Object obj = metadataConnection.getModelConnectionItem("cmModificationTime");
            if (obj != null && obj instanceof Long) {
                modelModificationTime = (Long)obj;
            }
        } else {
            modelPart = (String)metadataConnection.getModelConnectionItem("modelFilePath");
            File modelXML = new File(modelPart);
            modelModificationTime = modelXML.lastModified();
            modelPart = modelPart.replace("/model.xml", "");
        }
        String dataPath = config.getXqeDataDirectory();
        StringBuilder cachePlanDirectory = new StringBuilder(dataPath);
        cachePlanDirectory.append(File.separatorChar);
        cachePlanDirectory.append("PPCs");
        if (buildNumber != null) {
            cachePlanDirectory.append(STRING_UNDERSCORE);
            cachePlanDirectory.append(FileUtil.makeJavaIdentifier(buildNumber, '_'));
        }
        cachePlanDirectory.append(File.separatorChar);
        cachePlanDirectory.append(FileUtil.makeJavaIdentifier(modelPart, '_'));
        cachePlanDirectory.append(File.separatorChar);
        String ctime = DateFormatUtils.format((long)modelModificationTime, (String)"yyyyMMdd_HHmmss_SSS");
        cachePlanDirectory.append(ctime);
        cachePlanDirectory.append(File.separatorChar);
        cachePlanDirectory.append(reportName);
        for (String queryName : retrieveDatasetNames) {
            cachePlanDirectory.append(STRING_UNDERSCORE);
            cachePlanDirectory.append(queryName);
        }
        cachePlanDirectory.append(STRING_XML_FILENAME_EXTENSION);
        fn = cachePlanDirectory.toString();
        ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
        fn = cclConfig.resolveEffectivePath(fn);
        return fn;
    }

    public static String getXqeServiceJarVersion() {
        if (jarVersion == null) {
            String version = null;
            ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            StringBuilder sb = new StringBuilder(config.getBinDirectory());
            sb.append("/../webapps/p2pd/WEB-INF/lib/xqeService.jar");
            try {
                Attributes attrs;
                String jarFilename = cclConfig.resolveEffectivePath(sb.toString());
                JarFile jarfile = new JarFile(jarFilename);
                Manifest manifest = jarfile.getManifest();
                if (manifest != null && (attrs = manifest.getAttributes("com/cognos/xqe")) != null) {
                    version = attrs.getValue("Specification-Version");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            jarVersion = version;
        }
        return jarVersion;
    }

    public PlannedV5QuerySet getPlanTree(String querySetString, PlanningEnvironment planEnv) {
        PlannedV5QuerySet p;
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        this.persistentPlanDiskCacheStatistics.halfHeartedReset();
        if (null == querySetString) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
            throw new IllegalArgumentException(EXMSG_QUERYSETSTRING_WAS_NULL);
        }
        ArrayWrapper<String> planCacheKey = this.constructPlanCacheKey(querySetString, reqEnv);
        PlannedV5QuerySet planTree = null;
        String planFileName = null;
        planFileName = this.getPlanFileName(reqEnv, planEnv, planCacheKey, reqEnv.getReportName(), reqEnv.getRetrieveDatasets());
        if (planFileName == null) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.FILENAME_CAN_NOT_BE_COMPUTED);
            TRACE_LOGGER.log(LogLevel.WARN, "Reuse from file, unable to determine the filename for reportName=" + reqEnv.getReportName());
            return null;
        }
        File f = new File(planFileName);
        if (!f.exists()) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.PLAN_NOT_FOUND);
            this.persistentPlanDiskCacheStatistics.incrMissCount();
            return null;
        }
        if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
            TRACE_LOGGER.log(LogLevel.INFO, "Reuse from file, did not check if macros evaluated to same value reportName=" + reqEnv.getReportName());
        }
        if ((p = this.readPlanFromFile(reqEnv, planFileName)) != null) {
            this.persistentPlanDiskCacheStatistics.setLastFileName(planFileName);
            boolean planKeysAreTheSame = p.getPlanKey().equals(querySetString);
            if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                if (planKeysAreTheSame) {
                    buffer.append("Plan key matches plan key ");
                } else {
                    buffer.append("Plan key does NOT match plan key ");
                }
                buffer.append(" from file: ");
                buffer.append(planFileName);
                TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
            if (!planKeysAreTheSame) {
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.KEYS_DO_NOT_MATCH);
                p = null;
            }
        }
        if (p != null) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.SUCCESS);
            planTree = p;
            planTree.setPlanKey(querySetString);
            planTree.setPlanTime(System.currentTimeMillis());
            planTree.setReadFromPersistentStore(true);
            planTree.incrementUseCount();
            this.persistentPlanDiskCacheStatistics.incrHitCount();
        } else {
            this.persistentPlanDiskCacheStatistics.incrMissCount();
            if (TRACE_LOGGER.isOn(LogLevel.WARN)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Failed to read plan from file: ");
                buffer.append(planFileName);
                TRACE_LOGGER.log(LogLevel.WARN, buffer.toString());
            }
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean macrosResolveToSameValues(TreeMap<String, String> macroMap, IPlanningEnvironment planEnv, RequestEnvironment reqEnv) {
        if (macroMap == null || macroMap.size() == 0) {
            return true;
        }
        planEnv.setPlanningActive(reqEnv);
        try {
            MacroExpander macroExpander = new MacroExpander();
            for (Map.Entry<String, String> entry : macroMap.entrySet()) {
                String strToExpand = entry.getKey();
                String storedValue = entry.getValue();
                String expandedString = macroExpander.expand(null, planEnv, strToExpand);
                if (expandedString.equals(storedValue)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            planEnv.setPlanningInactive();
        }
        return true;
    }

    void clearAll() {
    }

    protected static String getDumpFilePath(StringBuilder filename) {
        StringBuilder leadFilePath = new StringBuilder(PersistentPlanDiskCache.getDumpFilePath());
        leadFilePath.append(File.separatorChar);
        leadFilePath.append(FileUtil.makeJavaIdentifier(filename.toString()));
        StringBuilder tempFilePath = null;
        File f = null;
        do {
            tempFilePath = new StringBuilder(leadFilePath);
            tempFilePath.append(STRING_UNDERSCORE);
            tempFilePath.append(fileSeqNumber);
            tempFilePath.append(STRING_XML_FILENAME_EXTENSION);
            f = new File(tempFilePath.toString());
            ++fileSeqNumber;
        } while (f.exists());
        return tempFilePath.toString();
    }

    private static String getDumpFilePath() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String logsDir = configuration.getXqeLogsDirectory();
        ICCLConfiguration cclConfig = null;
        cclConfig = XQECCLConfigurationFactory.getInstance();
        String epath = cclConfig.resolveEffectivePath(logsDir);
        return epath;
    }

    protected void writePlanToFile(IRequestEnvironment reqEnv, PlannedV5QuerySet p, String planFileName) {
        File planFile = new File(planFileName);
        if (!planFile.exists()) {
            planFile.getParentFile().mkdirs();
        } else {
            planFile.delete();
        }
        TraceLogWriter tlw = new TraceLogWriter(planFile);
        XQETrace xx = new XQETrace();
        xx.addStream(tlw);
        xx.setTraceLevelAll();
        PersistentPlan pp = new PersistentPlan();
        ResponseMessageFolder rmf = reqEnv.getResponseMessageFolder();
        List<ResponseMessage> planningRMs = rmf.getPlanningResponseMessages();
        pp.setPlanningResponseMessages(planningRMs);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        NagCollector nagCollector = execEnv.getNagCollector();
        List<Nag> nags = nagCollector.getNagMessages();
        pp.setNags(nags);
        pp.setReportName(p.getReportName());
        pp.setPlanDurationMilli(p.getPlanningEnvironment().getPlanTime());
        pp.setPlanKey(p.getPlanKey());
        pp.setPlannedV5QuerySet(p);
        pp.setRequestParameters(p.getRequestParameters());
        String ppfVersion = "1.0";
        xx.beginElement("PersistentPlanFile");
        xx.writeAttribute("version", ppfVersion);
        pp.dumpPlan(xx);
        xx.endElement();
        xx.flush();
        xx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlannedV5QuerySet readPlanFromFile(RequestEnvironment reqEnv, String planFileName) {
        Document doc = null;
        XQESAXReaderPool readerPool = XQESAXReaderPool.getInstance();
        SAXReader aReader = null;
        InputStream fileInputStream = null;
        try {
            aReader = readerPool.borrowReader();
            fileInputStream = new BufferedInputStream(new FileInputStream(planFileName));
            doc = aReader.read(fileInputStream);
        }
        catch (Exception ex) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.SAX_READ_FAILURE);
            TRACE_LOGGER.log(LogLevel.WARN, ex.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
            PlannedV5QuerySet plannedV5QuerySet = null;
            return plannedV5QuerySet;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (aReader != null) {
                    readerPool.returnReader(aReader);
                }
            }
            catch (Exception ex) {
                TRACE_LOGGER.log(LogLevel.WARN, ex.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
            }
        }
        if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Succesfully read plan from file: ");
            buffer.append(planFileName);
            TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        XQEDebugLog.out.println("Succesful read plan from file: " + planFileName);
        this.persistentPlanDiskCacheStatistics.setLastFileName(planFileName);
        PersistentPlan pp = this.convertDocToPlan(reqEnv, doc);
        PlannedV5QuerySet p = pp.getPlannedV5QuerySet();
        p.setPlanKey(pp.getPlanKey());
        p.setReadFromPersistentStore(true);
        p.setRequestParameters(pp.getRequestParameters());
        p.setResolvedMacros(pp.getResolvedMacros());
        return p;
    }

    private PersistentPlan convertDocToPlan(RequestEnvironment reqEnv, Document doc) {
        if (doc == null) {
            return null;
        }
        Element startNode = doc.getRootElement();
        if (startNode == null) {
            return null;
        }
        PersistentPlan pp = new PersistentPlan();
        PlanningEnvironment planningEnvironment = this.setupEnvironment(reqEnv);
        PlannedV5QuerySet pv5queryset = new PlannedV5QuerySet();
        pv5queryset.setPlanningEnvironment(planningEnvironment);
        if (startNode.getName().equals(STRING_DOC)) {
            Parameters parameters = pv5queryset.getRequestParameters();
            Element parametersElement = startNode.element("parameters");
            if (parameters != null) {
                parameters.capture(planningEnvironment, parametersElement);
            }
            Element planKeyElement = startNode.element(STRING_PLANKEY);
            String planKey = null;
            if (planKeyElement != null) {
                planKey = planKeyElement.getText();
            }
            pp.setPlanKey(planKey);
            pp.setRequestParameters(parameters);
            pp.setPlannedV5QuerySet(pv5queryset);
        } else {
            List elems = startNode.elements("PersistentPlan");
            for (Element e : elems) {
                pp.capture(planningEnvironment, e);
                ResponseMessageFolder messageFolder = reqEnv.getResponseMessageFolder();
                List<ResponseMessage> msgs = pp.getResponseMessages();
                for (ResponseMessage m : msgs) {
                    messageFolder.appendPlanningResponseMessage(m);
                }
                List<Nag> nags = pp.getNags();
                if (nags == null) continue;
                for (Nag n : nags) {
                    ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).addNag(n);
                }
            }
        }
        return pp;
    }

    private PlanningEnvironment setupEnvironment(RequestEnvironment reqEnv) {
        PlanningEnvironment planEnv = reqEnv.getEnvFactory().createPlanningEnvironment();
        XQETrace trace = new XQETrace();
        XQEIDGenerator idGenerator = new XQEIDGenerator();
        XNodeFactory uberNodeFactory = new XNodeFactory();
        uberNodeFactory.setNodeIDGenerator(idGenerator);
        uberNodeFactory.setTrace(trace);
        uberNodeFactory.setPlanningEnvironment(planEnv);
        planEnv.setTrace(trace);
        planEnv.setNodeFactory(uberNodeFactory);
        planEnv.setPlanningActive(reqEnv);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        planEnv.setRuleFactory(ruleFactory);
        return planEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePlanForUnresolvedParameter(String planKey, IRequestEnvironment reqEnv, PlanningEnvironment planEnv) {
        String planFileName;
        this.persistentPlanDiskCacheStatistics.halfHeartedReset();
        if (null == planKey) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
            throw new IllegalArgumentException("planKey was null");
        }
        if (null == reqEnv) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
            throw new IllegalArgumentException("reqEnv was null");
        }
        if (null == planEnv) {
            this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.BAD_ARGUMENTS);
            throw new IllegalArgumentException("planEnv was null");
        }
        String querySetString = planKey;
        ArrayWrapper<String> planCacheKey = this.constructPlanCacheKey(querySetString, reqEnv);
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("storePlanForUnresolvedParameter plan cache key= ").append(querySetString);
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if ((planFileName = this.getPlanFileName(reqEnv, planEnv, planCacheKey, reqEnv.getReportName(), reqEnv.getRetrieveDatasets())) != null) {
            this.planCacheLock.writeLock().lock();
            try {
                this.persistentPlanDiskCacheStatistics.setLastFileName(planFileName);
                this.writeUnresolvedParameterFile(reqEnv, planEnv, planKey, planFileName);
                this.persistentPlanDiskCacheStatistics.setReason(PersistentPlanDiskCacheStatistics.Reason.SUCCESS);
                if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("storePlanForUnresolvedParameter for report: ");
                    buffer.append(reqEnv.getReportName());
                    buffer.append(" written to file: ");
                    buffer.append(planFileName);
                    TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
                }
            }
            finally {
                this.planCacheLock.writeLock().unlock();
            }
        }
    }

    private void writeUnresolvedParameterFile(IRequestEnvironment reqEnv, PlanningEnvironment planEnv, String planKey, String planFileName) {
        File planFile = new File(planFileName);
        if (!planFile.exists()) {
            planFile.getParentFile().mkdirs();
        } else {
            planFile.delete();
        }
        TraceLogWriter tlw = new TraceLogWriter(planFile);
        XQETrace xx = new XQETrace();
        xx.addStream(tlw);
        xx.setTraceLevelAll();
        xx.writeXML("<!-- testcase: " + reqEnv.getReportName() + STRING_ARROW_NEWLINE);
        xx.writeXML("<!-- planTime(ms): " + planEnv.getPlanTime() + STRING_ARROW_NEWLINE);
        String command = reqEnv.getOperationName();
        if (command == null) {
            command = "*unknown*";
        }
        xx.writeXML("<!-- command: " + command + STRING_ARROW_NEWLINE);
        xx.beginElement(STRING_DOC);
        StringBuilder pbuf = new StringBuilder();
        Parameters parms = reqEnv.getRequestParameters();
        boolean needFilter = false;
        for (Parameter pv : parms.values()) {
            if (!pv.isMasterDetailLinkParameter()) continue;
            needFilter = true;
        }
        if (needFilter) {
            Parameters fparms = new Parameters();
            for (Map.Entry pe : parms.entrySet()) {
                if (((Parameter)pe.getValue()).isMasterDetailLinkParameter()) continue;
                fparms.addParameter((String)pe.getKey(), (Parameter)pe.getValue());
            }
            fparms.createParametersString(pbuf);
        } else {
            reqEnv.getRequestParameters().createParametersString(pbuf);
        }
        xx.xml(pbuf.toString());
        xx.xml(NEWLINE);
        xx.beginElement(STRING_PLANKEY);
        xx.cdata(planKey);
        xx.endElement();
        xx.endElement();
        xx.flush();
        xx.close();
    }

    public PersistentPlanDiskCacheStatistics getPersistentPlanDiskCacheStatistics() {
        return this.persistentPlanDiskCacheStatistics;
    }
}

