/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class QueryContext {
    static final String LOGMSG_STACK_TRACE = "; Stack Trace: ";
    private final String mQueryContextID;
    private boolean mReleased;
    private volatile boolean mInUse;
    private volatile long mLastAccessTime;
    private final Map<String, String> requestIDsMap = new HashMap<String, String>();
    private static final XQELogger QUERYCONTEXT_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Session", LogLevel.INFO);
    private final ReadWriteLock contextLock = new ReentrantReadWriteLock(true);

    public QueryContext(String queryContextID) {
        this.mQueryContextID = queryContextID;
        this.mReleased = false;
        this.mInUse = false;
        this.mLastAccessTime = System.currentTimeMillis();
        if (QUERYCONTEXT_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Created SessionContext:").append(queryContextID);
            QUERYCONTEXT_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
    }

    public String getQueryContextID() {
        return this.mQueryContextID;
    }

    public boolean isInUse() {
        return this.mInUse;
    }

    public void setInUse(boolean inUse) {
        this.mInUse = inUse;
        this.setLastAccessTime(System.currentTimeMillis());
    }

    public long getLastAccessTime() {
        return this.mLastAccessTime;
    }

    private void setLastAccessTime(long lastAccessTime) {
        this.mLastAccessTime = lastAccessTime;
    }

    public boolean accessedSince(long timeStamp) {
        boolean live;
        long accTime = this.mLastAccessTime;
        boolean bl = live = accTime >= timeStamp;
        if (!live) {
            long currTime = System.currentTimeMillis();
            String str = String.format("QueryContext %s is expiring:\n  Current time: %s (%,d ms)\n  Last valid time: %s (%,d ms)\n  Last accessed: %s (%,d ms)\n", this.mQueryContextID, LoggingConstants.TIMESTAMP_FORMAT.format((Object)currTime), currTime, LoggingConstants.TIMESTAMP_FORMAT.format((Object)timeStamp), timeStamp, LoggingConstants.TIMESTAMP_FORMAT.format((Object)accTime), accTime);
            QUERYCONTEXT_LOGGER.log(LogLevel.ERROR, str);
        }
        return live;
    }

    public void release() {
        if (this.mReleased) {
            return;
        }
        try {
            StringBuilder buffer = new StringBuilder();
            if (QUERYCONTEXT_LOGGER.isOn(LogLevel.INFO)) {
                buffer.append("Releasing QueryContext with id=").append(this.getQueryContextID());
                QUERYCONTEXT_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
        }
        finally {
            this.mReleased = true;
        }
    }

    public String toString() {
        long now = System.currentTimeMillis();
        String msg = String.format("QueryContext %s:\n   In use: %s\n   Time since last access: %d (ms)\n", this.mQueryContextID, Boolean.toString(this.mInUse), now - this.mLastAccessTime);
        return msg;
    }

    public void registerRequest(String requestIDKey, String requestID) {
        this.contextLock.writeLock().lock();
        try {
            this.requestIDsMap.put(requestIDKey, requestID);
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
    }

    public String unregisterRequest(String requestIDKey) {
        this.contextLock.writeLock().lock();
        try {
            String string = this.requestIDsMap.remove(requestIDKey);
            return string;
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterRequestByID(String requestID) {
        this.contextLock.writeLock().lock();
        try {
            for (Map.Entry<String, String> mapEntry : this.requestIDsMap.entrySet()) {
                if (!mapEntry.getValue().equals(requestID)) continue;
                boolean bl = this.requestIDsMap.remove(mapEntry.getKey()) != null;
                return bl;
            }
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
        return false;
    }

    public List<String> getRequestIDKeys() {
        this.contextLock.writeLock().lock();
        try {
            ArrayList<String> requestIDKeys = new ArrayList<String>();
            requestIDKeys.addAll(this.requestIDsMap.keySet());
            ArrayList<String> arrayList = requestIDKeys;
            return arrayList;
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
    }

    public String getRequestIDValue(String requestIDKey) {
        this.contextLock.writeLock().lock();
        try {
            String string = this.requestIDsMap.get(requestIDKey);
            return string;
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
    }
}

