/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEEventListener;
import com.cognos.xqeqte.QTEPassTransformations;
import com.cognos.xqeqte.QTETransformationLibrary;
import com.cognos.xqeqte.QTETransformationLibraryManager;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class TransformationEventListener
implements QTEEventListener<IXQEQueryNode, IPlanningEnvironment> {
    private QTETransformationLibraryManager<IXQEQueryNode, IPlanningEnvironment> libraryManager;

    public TransformationEventListener(QTETransformationLibraryManager<IXQEQueryNode, IPlanningEnvironment> libMgr) {
        this.libraryManager = libMgr;
    }

    @Override
    public void beginQueryTransformations(IPlanningEnvironment environment, IXQEQueryNode root) {
        XQETrace trace = environment.getTrace();
        if (this.isAnyTrackingEnabled(trace)) {
            trace.beginElement("queryTransformations");
            if (environment.getRandomizeTransformations()) {
                trace.attribute("randomSeed", environment.getRandomSeed());
            }
        }
        this.traceInitialQuery(root, trace);
    }

    @Override
    public void endQueryTransformations(IPlanningEnvironment environment, IXQEQueryNode root) {
        XQETrace trace = environment.getTrace();
        if (this.isAnyTrackingEnabled(trace)) {
            this.traceFinalQuery(root, trace);
            trace.endElement();
        }
    }

    @Override
    public void beginTransformationPasses(IPlanningEnvironment environment, IXQEQueryNode root) {
        environment.saveCurrentTraceWriter();
    }

    @Override
    public void endTransformationPasses(IPlanningEnvironment environment, IXQEQueryNode root) {
        XQETrace trace = environment.getTrace();
        Writer planningTraceWriter = environment.getSavedTraceWriter();
        if (planningTraceWriter != null) {
            this.closeCurrentTraceWriter(environment);
            this.setCurrentTraceWriter(trace, environment, planningTraceWriter);
        }
    }

    @Override
    public void beginPassNumber(IPlanningEnvironment environment, IXQEQueryNode root, int passNumber) {
        XQETrace trace = environment.getTrace();
        if (this.isAnyTrackingEnabled(trace)) {
            if (passNumber > 1) {
                this.closeCurrentTraceWriter(environment);
            }
            this.setCurrentTraceWriter(trace, environment, this.getPassLogWriter(environment, passNumber));
        }
        trace.beginElement(1, "pass");
        trace.attribute(1, "passNumber", passNumber);
    }

    @Override
    public void endPassNumber(IPlanningEnvironment environment, IXQEQueryNode root, int passNumber, int numTransformsAppliedPerPass, QTEPassTransformations<IXQEQueryNode, IPlanningEnvironment> passTransformations) {
        XQETrace trace = environment.getTrace();
        trace.property(1, "nTransformsApplied", numTransformsAppliedPerPass);
        trace.endElement(1);
        trace.flush();
        if (passTransformations == null) {
            trace.deleteDeferredTraceStatements();
        }
    }

    @Override
    public void beginPassIteration(IPlanningEnvironment environment, IXQEQueryNode root, int passNumber, int iteration) {
        XQETrace trace = environment.getTrace();
        if (iteration == 0) {
            if ((trace.getTraceLevel() & 1) == 0) {
                return;
            }
            List<QTETransformationLibrary<IXQEQueryNode, IPlanningEnvironment>> libraries = this.libraryManager.getPassLibraryMap(passNumber);
            if (libraries == null || libraries.size() == 0) {
                return;
            }
            trace.beginElement("libraries");
            for (QTETransformationLibrary<IXQEQueryNode, IPlanningEnvironment> library : libraries) {
                trace.beginElement("library");
                trace.attribute("name", library.getLibraryName());
                trace.attribute("passName", library.getPassName(passNumber));
                trace.endElement();
            }
            trace.endElement();
        }
        trace.beginElement(1, "passIteration");
        trace.attribute(1, "iteration", iteration);
    }

    @Override
    public void endPassIteration(IPlanningEnvironment environment, IXQEQueryNode root, int passNumber, int iteration, int numTransformsAppliedPerIteration) {
        XQETrace trace = environment.getTrace();
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.property(1, "nTransformsApplied", numTransformsAppliedPerIteration);
            if (0 != numTransformsAppliedPerIteration) {
                trace.beginElement("query");
                root.dump(trace);
                trace.endElement();
            }
        }
        trace.endElement(1);
    }

    @Override
    public void beginTransformationGroup(IPlanningEnvironment environment, int lockNodeType) {
        XQETrace trace = environment.getTrace();
        trace.beginElement(1, "transformationGroup");
        trace.attribute(1, "nodeType", lockNodeType);
    }

    @Override
    public void endTransformationGroup(IPlanningEnvironment environment) {
        environment.getTrace().endElement(1);
    }

    @Override
    public void beginApplyTransformation(IPlanningEnvironment environment, QTEAbstractTransformation<IXQEQueryNode, IPlanningEnvironment> transformation, IXQEQueryNode node) {
        XQETrace trace = environment.getTrace();
        if ((trace.getTraceLevel() & 1) != 0) {
            if ((trace.getTraceLevel() & 4) == 0) {
                trace.deferTracing();
            }
            trace.beginElement("transformation");
            trace.attribute("name", transformation.getName());
            trace.attribute("nodeType", node.getType());
            trace.attribute("nodeId", node.getId());
            trace.attribute("className", transformation.getClass().getName());
            ((Transformation)transformation).dumpSpecificationReferences(trace);
        }
    }

    @Override
    public void endApplyTransformation(IPlanningEnvironment environment, IXQEQueryNode node, boolean applied) {
        XQETrace trace = environment.getTrace();
        if (!applied) {
            if ((trace.getTraceLevel() & 4) != 0) {
                trace.traceDeferredStatements();
            } else {
                trace.deleteDeferredTraceStatements();
                return;
            }
        }
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.endElement();
        }
    }

    @Override
    public void beginTreeOperations(IPlanningEnvironment environment, QTEAbstractTransformation<IXQEQueryNode, IPlanningEnvironment> transformation, IXQEQueryNode node) {
        XQETrace trace = environment.getTrace();
        trace.traceDeferredStatements();
        trace.beginElement(256, "treeOperations");
    }

    @Override
    public void endTreeOperations(IPlanningEnvironment environment, QTEAbstractTransformation<IXQEQueryNode, IPlanningEnvironment> transformation, IXQEQueryNode node) {
        XQETrace trace = environment.getTrace();
        boolean traceEnabled = (trace.getTraceLevel() & 1) != 0;
        boolean traceTreeAfterTrans = (trace.getTraceLevel() & 8) != 0;
        trace.endElement(256);
        if (traceEnabled && traceTreeAfterTrans) {
            environment.getRoot().dump(trace);
        }
    }

    private void traceInitialQuery(IXQEQueryNode root, XQETrace trace) {
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.beginElement("initialQuery");
            root.dump(trace);
            trace.endElement();
        }
    }

    private void traceFinalQuery(IXQEQueryNode root, XQETrace trace) {
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.beginElement("finalQuery");
            root.dump(trace);
            trace.endElement();
        }
    }

    private boolean isAnyTrackingEnabled(XQETrace trace) {
        return (trace.getTraceLevel() & 7) != 0;
    }

    private Writer getPassLogWriter(IPlanningEnvironment environment, int passNumber) {
        return TraceLogManager.getInstance().createPlanningPassTraceWriter((IRequestEnvironment)environment.getRequestEnvironment(), passNumber);
    }

    private void setCurrentTraceWriter(XQETrace trace, IPlanningEnvironment environment, Writer writer) {
        trace.removeStream(environment.getCurrentTraceWriter());
        trace.addStream(writer);
        environment.setCurrentTraceWriter(writer);
    }

    private void closeCurrentTraceWriter(IPlanningEnvironment environment) {
        Writer currentWriter = environment.getCurrentTraceWriter();
        try {
            currentWriter.close();
        }
        catch (IOException ioe) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ioe);
        }
    }
}

