/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationLibrary;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTENodeIndex;
import com.cognos.xqeqte.QTEPassTransformations;
import com.cognos.xqeqte.QTETransformationLibraryManager;
import java.lang.reflect.Constructor;
import java.util.Collections;

public final class TransformationLibraryManager
extends QTETransformationLibraryManager<IXQEQueryNode, IPlanningEnvironment> {
    private static TransformationLibraryManager instance;

    private TransformationLibraryManager() {
    }

    public static synchronized TransformationLibraryManager getInstance() {
        if (instance == null) {
            instance = new TransformationLibraryManager();
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean newIndexMode = config.getBooleanProperty("queryPlanning.newIndexMode", true);
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.INFO);
            if (logger.isOn(LogLevel.INFO)) {
                logger.log("QTENodeIndex newIndexMode=" + newIndexMode);
            }
            QTENodeIndex.setUseNewIndexMode(newIndexMode);
        }
        return instance;
    }

    @Override
    protected void loadTransformationLibraries() {
        this.loadTestLibrary();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        XQESubConfiguration library = config.getChildren("TransformationLibraryManager.libraries.library");
        while (library.hasNext()) {
            library.next();
            String className = library.getString("[@name]", null);
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                TransformationLibrary transformationLibrary = (TransformationLibrary)constructor.newInstance(this.getMaximumPassNumber());
                this.addTransformationLibraryToList(transformationLibrary);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.transformationLibraries = Collections.unmodifiableList(this.getLibraryList());
    }

    public void loadTestLibrary() {
        TransformationLibrary library = null;
        try {
            Class<?> aClass = Class.forName("com.cognos.xqe.test.transformations.TestTransformationLibrary");
            library = (TransformationLibrary)aClass.newInstance();
        }
        catch (Exception exception) {
            library = null;
        }
        if (library != null) {
            this.addTransformationLibraryToList(library);
            this.setMaximumPassNumber(1);
        }
    }

    public void dumpTransformations(XQETrace trace) {
        trace.beginElement("TransformationLibraryContents");
        if (this.transformsByPass.size() > 0) {
            trace.beginElement("passSpecificTransformations");
            trace.attribute("maximumPassNumber", this.mMaximumPassNumber);
            for (int i = 0; i <= this.mMaximumPassNumber; ++i) {
                Integer key = i;
                QTEPassTransformations passTransformations = (QTEPassTransformations)this.transformsByPass.get(key);
                if (passTransformations == null) continue;
                trace.beginElement("pass");
                trace.attribute("passNumber", i);
                trace.endElement();
            }
            trace.endElement();
        }
        trace.endElement();
    }
}

