/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.masterdetail;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQEPersistCreate;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemContext;
import com.cognos.xqe.ast.v5.result.V5DetailContext;
import com.cognos.xqe.ast.v5.result.V5MasterContext;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5ParameterContext;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class MasterDetailLink
implements IXQEPersist {
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_NAME_FOR_MESSAGE = "nameForMessage";
    private static final String ATTRIBUTE_IS_SINGLE_QUERY = "isSingleQuery";
    private static final String ATTRIBUTE_IS_SINGLE_DATAITEM = "isSingleDataItem";
    private static final String ELEMENT_MASTER_CONTEXT = "masterContext";
    private static final String ELEMENT_DETAIL_CONTEXT = "detailContext";
    private static final String ELEMENT_PARENT_MD_LINK = "parentMDLink";
    private static final String ELEMENT_SIBLING_MD_LINK = "siblingMDLink";
    private static final String ELEMENT_QUERY_REFS = "queryRefs";
    private static final String ELEMENT_MASTER_LINK_SET = "masterLinkSet";
    private static final String LINK_CHAR = "_";
    private static final String HYPHEN = "-";
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN = ">";
    private String parameterName;
    private String name;
    private String nameForMessage;
    private MDLinkContext masterContext;
    private MDLinkContext detailContext;
    private MasterDetailLink parentMDLink = null;
    private List<MasterDetailLink> siblingMDLinks = new ArrayList<MasterDetailLink>();
    private Set<String> detailQueryRefs = new HashSet<String>();
    private Set<String> masterQueryRefs = new HashSet<String>();
    private AbstractMDXSet masterLinkSet = null;
    private boolean isSingleQuery = false;
    private boolean isSingleDataItem = false;

    public MasterDetailLink(V5MasterDetailLink linkNode, V5QuerySet querySet) {
        String masterQrdName = new String();
        String detailQrdName = new String();
        V5MasterContext masterContextNode = new V5MasterContext();
        V5DetailContext detailContextNode = new V5DetailContext();
        IXQEQueryNode[] children = linkNode.getChildrenOfTypes(new int[]{101060, 101061});
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getType() == 101060) {
                masterContextNode = (V5MasterContext)children[i];
                masterQrdName = masterContextNode.getRefQueryResultDefinition();
                continue;
            }
            detailContextNode = (V5DetailContext)children[i];
            detailQrdName = detailContextNode.getRefQueryResultDefinition();
        }
        String masterQueryName = "";
        String detailQueryName = "";
        String refQueryNameOrig = "";
        IXQEQueryNode[] qrds = querySet.getDescendantsOfType(101055, true);
        for (int i = 0; i < qrds.length; ++i) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrds[i];
            String qrdName = (String)qrd.getPropertyValue(ATTRIBUTE_NAME);
            if (qrdName.equals(masterQrdName)) {
                masterQueryName = qrd.getRefQueryProperty();
            }
            if (!qrdName.equals(detailQrdName)) continue;
            detailQueryName = qrd.getRefQueryProperty();
            refQueryNameOrig = (String)qrd.getV5Query().getPropertyValue("originalQueryName");
        }
        this.addMasterContext(masterQueryName, masterQrdName, masterContextNode);
        this.addDetailContext(detailQueryName, detailQrdName, detailContextNode);
        if (refQueryNameOrig != null && refQueryNameOrig.length() > 0) {
            this.setDetailQueryNameOrig(refQueryNameOrig);
        }
        this.name = this.generateUniqueLinkName();
        this.nameForMessage = this.generateUniqueLinkNameForMessage();
        this.parameterName = this.detailContext.isParameterContext() ? this.detailContext.getRefDataItem() : this.name;
        this.isSingleQuery = linkNode.getBooleanPropertyValue("singleQuery", Boolean.FALSE);
        this.isSingleDataItem = linkNode.getBooleanPropertyValue("singleDataItem", Boolean.FALSE);
    }

    public MasterDetailLink() {
    }

    private String generateUniqueLinkName() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(this.masterContext.getQrdName());
        strBuf.append(LINK_CHAR);
        strBuf.append(this.masterContext.getRefDataItem());
        strBuf.append(LINK_CHAR);
        strBuf.append(this.detailContext.getQrdName());
        strBuf.append(LINK_CHAR);
        strBuf.append(this.detailContext.getRefDataItem());
        return strBuf.toString();
    }

    private String generateUniqueLinkNameForMessage() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(this.masterContext.getNameForMessage());
        strBuf.append(LESS_THAN);
        strBuf.append(HYPHEN);
        strBuf.append(GREATER_THAN);
        strBuf.append(this.detailContext.getNameForMessage());
        return strBuf.toString();
    }

    public void addMasterContext(String masterQueryName, String masterQrdName, V5MasterContext context) {
        String refDataItemName = new String();
        IXQEQueryNode refDataItem = context.getChild(0);
        if (null != refDataItem && refDataItem.getType() == 101062) {
            refDataItemName = ((V5DataItemContext)refDataItem).getRefDataItem();
        }
        this.masterContext = new MDLinkContext(masterQueryName, masterQrdName, refDataItemName, false);
    }

    public void addDetailContext(String detailQueryName, String detailQrdName, V5DetailContext context) {
        String refDataItemName = new String();
        boolean paramContext = false;
        IXQEQueryNode refDataItem = context.getChild(0);
        if (null != refDataItem) {
            if (refDataItem.getType() == 101062) {
                refDataItemName = ((V5DataItemContext)refDataItem).getRefDataItem();
            } else if (refDataItem.getType() == 101063) {
                paramContext = true;
                refDataItemName = ((V5ParameterContext)refDataItem).getParameter();
            }
        }
        this.detailContext = new MDLinkContext(detailQueryName, detailQrdName, refDataItemName, paramContext);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForMessage() {
        return this.nameForMessage;
    }

    public MDLinkContext getMasterContext() {
        return this.masterContext;
    }

    public MDLinkContext getDetailContext() {
        return this.detailContext;
    }

    public String getMasterQrdName() {
        return this.masterContext.getQrdName();
    }

    public String getMasterQueryNameOrig() {
        return this.masterContext.getQueryNameOrig();
    }

    public String getMasterQueryName() {
        return this.masterContext.getQueryName();
    }

    public void setMasterQueryName(String queryName) {
        this.masterContext.setQueryName(queryName);
    }

    public String getMasterRefDataItem() {
        return this.masterContext.getRefDataItem();
    }

    public String getDetailQrdName() {
        return this.detailContext.getQrdName();
    }

    public String getDetailQueryName() {
        return this.detailContext.getQueryName();
    }

    public void setDetailQueryName(String queryName) {
        this.detailContext.setQueryName(queryName);
    }

    public String getDetailQueryNameOrig() {
        return this.detailContext.getQueryNameOrig();
    }

    public void setDetailQueryNameOrig(String queryName) {
        this.detailContext.setQueryNameOrig(queryName);
    }

    public String getDetailRefDataItem() {
        return this.detailContext.getRefDataItem();
    }

    public String getDetailNameForMessage() {
        return this.detailContext.getNameForMessage();
    }

    public boolean isParameterLink() {
        return this.detailContext.isParameterContext();
    }

    public void setParentMDLink(MasterDetailLink parent) {
        this.parentMDLink = parent;
    }

    public MasterDetailLink getParentMDLink() {
        return this.parentMDLink;
    }

    public void setSiblingMDLink(MasterDetailLink sibling) {
        this.siblingMDLinks.add(sibling);
    }

    public List<MasterDetailLink> getSiblingMDLinks() {
        return this.siblingMDLinks;
    }

    public boolean isSectionedCrosstab() {
        return this.isSingleDataItem;
    }

    public boolean isSingleQuery() {
        return this.isSingleQuery;
    }

    protected boolean isMasterDetailLinkParameter(String paramName, String queryName) {
        if (this.getParameterName() != null && this.getParameterName().equals(paramName)) {
            boolean queryReferencedInDetail;
            boolean isInDetailReferenced = this.isDetailQueryRefName(queryName);
            boolean isInMasterReferenced = this.isMasterQueryRefName(queryName);
            boolean queryReferencedInMaster = this.getMasterQueryName().equals(queryName) || isInMasterReferenced;
            boolean bl = queryReferencedInDetail = this.getDetailQueryName().equals(queryName) || isInDetailReferenced;
            if (this.isParameterLink() && queryReferencedInMaster) {
                return false;
            }
            if (queryReferencedInDetail) {
                return true;
            }
        }
        return false;
    }

    public void setMasterLinkSetExpr(AbstractMDXSet set) {
        this.masterLinkSet = set;
    }

    public AbstractMDXSet getMasterLinkSetExpr() {
        return this.masterLinkSet;
    }

    public void setDetailQueryRefNames(Set<String> queryRefNames) {
        this.detailQueryRefs = queryRefNames;
    }

    private boolean isDetailQueryRefName(String queryName) {
        return this.detailQueryRefs.contains(queryName);
    }

    public void setMasterQueryRefNames(Set<String> queryRefNames) {
        this.masterQueryRefs = queryRefNames;
    }

    private boolean isMasterQueryRefName(String queryName) {
        return this.masterQueryRefs.contains(queryName);
    }

    public V5DataItem getV5DataItemFromQuery(V5Query v5Query) {
        V5Selection selection = v5Query.getV5Selection();
        V5DataItem linkItem = selection.getDataItemByRefName(this.getParameterName());
        if (linkItem == null) {
            linkItem = selection.getDataItemByRefNameFromV5Parameter(this.getParameterName());
        }
        return linkItem;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_PARAMETER_NAME, this.parameterName);
        ctx.property(ATTRIBUTE_NAME, this.name);
        ctx.property(ATTRIBUTE_NAME_FOR_MESSAGE, this.nameForMessage);
        ctx.property(ATTRIBUTE_IS_SINGLE_QUERY, this.isSingleQuery);
        ctx.property(ATTRIBUTE_IS_SINGLE_DATAITEM, this.isSingleDataItem);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.masterContext != null) {
            ctx.elementProperty(ELEMENT_MASTER_CONTEXT, this.masterContext);
        }
        if (this.detailContext != null) {
            ctx.elementProperty(ELEMENT_DETAIL_CONTEXT, this.detailContext);
        }
        if (this.parentMDLink != null) {
            ctx.elementProperty(ELEMENT_PARENT_MD_LINK, this.parentMDLink);
        }
        if (this.siblingMDLinks != null) {
            ctx.elementProperty(ELEMENT_SIBLING_MD_LINK, this.siblingMDLinks);
        }
        if (this.detailQueryRefs != null) {
            ctx.elementProperty(ELEMENT_QUERY_REFS, this.detailQueryRefs);
        }
        if (this.masterLinkSet != null) {
            ctx.elementProperty(ELEMENT_MASTER_LINK_SET, this.masterLinkSet);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_PARAMETER_NAME)) {
            Object val = ctx.attributeValue(att);
            this.parameterName = (String)val;
        } else if (attName.equals(ATTRIBUTE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        } else if (attName.equals(ATTRIBUTE_NAME_FOR_MESSAGE)) {
            Object val = ctx.attributeValue(att);
            this.nameForMessage = (String)val;
        } else if (attName.equals(ATTRIBUTE_IS_SINGLE_QUERY)) {
            Object val = ctx.attributeValue(att);
            this.isSingleQuery = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_SINGLE_DATAITEM)) {
            Object val = ctx.attributeValue(att);
            this.isSingleDataItem = (Boolean)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_MASTER_CONTEXT)) {
            Object val = ctx.elementValue(node, new MasterDetailLinkCreator());
            this.masterContext = (MDLinkContext)val;
        } else if (pname.equals(ELEMENT_DETAIL_CONTEXT)) {
            Object val = ctx.elementValue(node, new MasterDetailLinkCreator());
            this.detailContext = (MDLinkContext)val;
        } else if (pname.equals(ELEMENT_PARENT_MD_LINK)) {
            Object val = ctx.elementValue(node);
            this.parentMDLink = (MasterDetailLink)val;
        } else if (pname.equals(ELEMENT_SIBLING_MD_LINK)) {
            Object val = ctx.elementValue(node);
            this.siblingMDLinks = (List)val;
        } else if (pname.equals(ELEMENT_QUERY_REFS)) {
            Object val = ctx.elementValue(node);
            this.detailQueryRefs = (Set)val;
        } else if (pname.equals(ELEMENT_MASTER_LINK_SET)) {
            Object val = ctx.elementValue(node);
            this.masterLinkSet = (AbstractMDXSet)val;
        }
    }

    private class MasterDetailLinkCreator
    extends XQEPersistCreate {
        private MasterDetailLinkCreator() {
        }

        @Override
        public IXQEPersist create(XQERestoreContext ctx, Element inputNode) {
            IXQEPersist result = null;
            String nodeName = inputNode.getName();
            if (nodeName.equals("MDLinkContext")) {
                result = new MDLinkContext();
                result.restore(ctx, inputNode);
            } else {
                result = super.create(ctx, inputNode);
            }
            return result;
        }
    }

    private class MDLinkContext
    implements IXQEPersist {
        public static final String ATTRIBUTE_QRD_NAME = "qrdName";
        public static final String ATTRIBUTE_QUERY_NAME = "queryName";
        public static final String ATTRIBUTE_QUERY_NAME_ORIG = "queryNameOrig";
        public static final String ATTRIBUTE_REF_DATAITEM = "refDataItem";
        public static final String ATTRIBUTE_IS_PARAMETER_CONTEXT = "isParameterContext";
        private static final String OPEN_BRACKET = "[";
        private static final String CLOSE_BRACKET = "]";
        private static final String PERIOD = ".";
        private String qrdName;
        private String queryName;
        private String queryNameOrig;
        private String refDataItem;
        private boolean isParameterContext;

        MDLinkContext() {
        }

        MDLinkContext(String aqueryName, String aqrdName, String arefDataItem, boolean paramContext) {
            this.queryName = aqueryName;
            this.queryNameOrig = aqueryName;
            this.qrdName = aqrdName;
            this.refDataItem = arefDataItem;
            this.isParameterContext = paramContext;
        }

        public String getQrdName() {
            return this.qrdName;
        }

        public String getQueryName() {
            return this.queryName;
        }

        public String getQueryNameOrig() {
            return this.queryNameOrig;
        }

        public String getRefDataItem() {
            return this.refDataItem;
        }

        public boolean isParameterContext() {
            return this.isParameterContext;
        }

        public void setQueryName(String theQueryName) {
            this.queryName = theQueryName;
        }

        public void setQueryNameOrig(String theQueryName) {
            this.queryNameOrig = theQueryName;
        }

        public String getNameForMessage() {
            StringBuilder strBuf = new StringBuilder();
            strBuf.append(OPEN_BRACKET);
            strBuf.append(this.getQueryNameOrig());
            strBuf.append(CLOSE_BRACKET);
            strBuf.append(PERIOD);
            strBuf.append(OPEN_BRACKET);
            strBuf.append(this.getRefDataItem());
            strBuf.append(CLOSE_BRACKET);
            return strBuf.toString();
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(ATTRIBUTE_QRD_NAME, this.qrdName);
            ctx.property(ATTRIBUTE_QUERY_NAME, this.queryName);
            ctx.property(ATTRIBUTE_QUERY_NAME_ORIG, this.queryNameOrig);
            ctx.property(ATTRIBUTE_REF_DATAITEM, this.refDataItem);
            ctx.property(ATTRIBUTE_IS_PARAMETER_CONTEXT, this.isParameterContext);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(ATTRIBUTE_QRD_NAME)) {
                Object val = ctx.attributeValue(att);
                this.qrdName = (String)val;
            } else if (attName.equals(ATTRIBUTE_QUERY_NAME)) {
                Object val = ctx.attributeValue(att);
                this.queryName = (String)val;
            } else if (attName.equals(ATTRIBUTE_QUERY_NAME_ORIG)) {
                Object val = ctx.attributeValue(att);
                this.queryNameOrig = (String)val;
            } else if (attName.equals(ATTRIBUTE_REF_DATAITEM)) {
                Object val = ctx.attributeValue(att);
                this.refDataItem = (String)val;
            } else if (attName.equals(ATTRIBUTE_IS_PARAMETER_CONTEXT)) {
                Object val = ctx.attributeValue(att);
                this.isParameterContext = (Boolean)val;
            }
        }
    }
}

