/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.missingMember;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.missingMember.MissingMember;
import java.io.IOException;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MissingMemberException
extends XQERuntimeException {
    private static final long serialVersionUID = 1L;
    private final Map<String, MissingMember> missingMembers;

    public MissingMemberException(RequestEnvironment reqEnv, String message) {
        super(XQEMessageKeys.PLN_MissingMembers, message);
        this.missingMembers = reqEnv.getRequestMissingMembers();
    }

    public MissingMemberException(RequestEnvironment reqEnv, XQERuntimeException cause, String message) {
        super(XQEMessageKeys.PLN_MissingMembers, (Throwable)cause, message);
        this.missingMembers = reqEnv.getRequestMissingMembers();
    }

    public Element getMissingMembersResponse() {
        return this.generateMissingMembersResponse(this.missingMembers);
    }

    @Override
    public String getFaultCode() {
        return "QF-5000101";
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element responseElement = this.getMissingMembersResponse();
        Element detailElement = faultEnvelope.getFaultDetail();
        detailElement.add(responseElement);
        return faultEnvelope;
    }

    @Override
    public Fault getFault() {
        return this.getFaultFromEnvelope();
    }

    private Element generateMissingMembersResponse(Map<String, MissingMember> missingMunMap) {
        Element responseElement = DocumentHelper.createElement((String)"response");
        if (missingMunMap.size() > 0) {
            Element missingMMs = responseElement.addElement("missingMembers");
            for (Map.Entry<String, MissingMember> entry : missingMunMap.entrySet()) {
                Element missingMember = missingMMs.addElement("missingMember");
                missingMember.addAttribute("memberUniqueName", entry.getKey());
                MissingMember tNodeMM = entry.getValue();
                missingMember.addAttribute("queryRef", tNodeMM.getQueryName());
                missingMember.addAttribute("refDataItem", tNodeMM.getRefDataItem());
            }
        }
        return responseElement;
    }

    public String getResult() {
        BIBusEnvelope envelope = this.getFaultEnvelope();
        String sResult = new String();
        try {
            sResult = envelope.getAsString();
        }
        catch (IOException e) {
            sResult = "";
        }
        return sResult;
    }
}

