/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public final class GlobalParametersUtil {
    private GlobalParametersUtil() {
    }

    public static Map<String, Parameter> loadGlobalParamsFromCM(IRequestEnvironment reqEnv) {
        CMEntity entity = new CMEntity();
        boolean needToGetGlobalParamsFromCM = true;
        CMSession cmSession = entity.getSessionViaDispatcher(reqEnv, needToGetGlobalParamsFromCM);
        return cmSession.getEffectiveGlobalParametersMap();
    }

    public static void addGlobalParamMapToPAC(ParameterAccessCoordinator pac, MultiRequestContext mrc, RequestEnvironment reqEnv) {
        if (!pac.containsGlobalParametersMap()) {
            if (mrc.getGlobalParametersMap() == null) {
                return;
            }
            ParameterMapsApp globParamValuesMapApp = new ParameterMapsApp("_env", IParameterMaps.EPRIORITY.GLOBAL_PARAMETERS.getKey());
            Map<String, Parameter> map = mrc.getGlobalParametersMap();
            for (Map.Entry<String, Parameter> entry : map.entrySet()) {
                String paramName = entry.getKey();
                Parameter param = entry.getValue();
                ParameterValues paramValues = param.getParameterValueItems();
                if (paramValues.isValueExplicitlyNotSupplied()) continue;
                ArrayList<String> valueList = new ArrayList<String>();
                for (ParameterValueItem pvi : paramValues) {
                    if (!(pvi instanceof V5ParameterValueItem) || pvi.hasNullValue()) continue;
                    valueList.add(((V5ParameterValueItem)pvi).getInternalValue());
                }
                globParamValuesMapApp.setArray("_env", paramName, valueList);
            }
            if (globParamValuesMapApp.getSize() > 0) {
                pac.addParameterMap(globParamValuesMapApp);
            }
        }
    }

    public static Map<String, Parameter> parseGlobalParametersFromElement(Element globalParametersValueElement, MultiRequestContext mrc) {
        List<Element> items = CollectionCast.uncheckedCast(globalParametersValueElement.elements("item"));
        HashMap<String, Parameter> globalParams = new HashMap<String, Parameter>();
        for (Element anItem : items) {
            Element nameElm = anItem.element("name");
            if (nameElm.getText() == null) continue;
            String paramName = nameElm.getText();
            Parameters requestParameters = mrc.getRequestParameters().getParameters();
            Parameter reqParam = requestParameters.getParameter(paramName);
            if (reqParam == null) {
                reqParam = new Parameter(paramName);
                reqParam.setIsGlobalParameter(true);
            }
            if (!reqParam.hasValueProvidedWithRequest()) {
                reqParam.parse(anItem);
            }
            globalParams.put(paramName, reqParam);
        }
        return globalParams;
    }
}

