/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.runtree.XDataContext;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ParameterInfo
implements IXQEPersist {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_USE_PARAMETERIZED_SQL = "useParameterizedSQL";
    private static final String ATTRIBUTE_VALUE_PREFIX = "valuePrefix";
    private static final String ATTRIBUTE_VALUE_SUFFIX = "valueSuffix";
    private String name = new String();
    private boolean useParameterizedSQL;
    private boolean isParamDescendantOfLike;
    private String valuePrefix;
    private String valueSuffix;

    public ParameterInfo(String paramName) {
        this.name = paramName;
        this.useParameterizedSQL = false;
        this.isParamDescendantOfLike = false;
        this.valuePrefix = new String();
        this.valueSuffix = new String();
    }

    public String getName() {
        return this.name;
    }

    public boolean getUseParameterizedSQL() {
        return this.useParameterizedSQL;
    }

    public void setUseParameterizedSQL(boolean flag) {
        this.useParameterizedSQL = flag;
    }

    public boolean getIsParamDescendantOfLike() {
        return this.isParamDescendantOfLike;
    }

    public void setIsParamDescendantOfLike(boolean value) {
        this.isParamDescendantOfLike = value;
    }

    public String getValuePrefix() {
        return this.valuePrefix;
    }

    public void setValuePrefix(String prefix) {
        this.valuePrefix = prefix;
    }

    public String getValueSuffix() {
        return this.valueSuffix;
    }

    public void setValueSuffix(String suffix) {
        this.valueSuffix = suffix;
    }

    public String generateLiteralValueStringForSQL(XDataContext context, IDataSourceCapabilities capabilities) {
        Parameter parameter = context.getParameter(this.name);
        return parameter.getParameterValueItems().asSQLString(this.valuePrefix, this.valueSuffix, capabilities);
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            ctx.property(ATTRIBUTE_NAME, this.name);
            ctx.property(ATTRIBUTE_USE_PARAMETERIZED_SQL, this.useParameterizedSQL);
            ctx.property(ATTRIBUTE_VALUE_PREFIX, this.valuePrefix);
            ctx.property(ATTRIBUTE_VALUE_SUFFIX, this.valueSuffix);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Object value;
            Attribute att = node.attribute(i);
            String attname = att.getName();
            if (attname.equals(ATTRIBUTE_NAME)) {
                value = ctx.attributeValue(att);
                this.name = (String)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_USE_PARAMETERIZED_SQL)) {
                value = ctx.attributeValue(att);
                this.useParameterizedSQL = (Boolean)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_VALUE_PREFIX)) {
                value = ctx.attributeValue(att);
                this.valuePrefix = (String)value;
                continue;
            }
            if (!attname.equals(ATTRIBUTE_VALUE_SUFFIX)) continue;
            value = ctx.attributeValue(att);
            this.valueSuffix = (String)value;
        }
    }
}

