/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.v5.utils.SimpleSaxParser;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class Parameters
extends HashMap<String, Parameter>
implements IXQEPersist {
    private static final String STRING_XSD_DURATION = "xsdDuration";
    private static final String ELEEMNT_TYPE = "type";
    public static final long serialVersionUID = 1L;
    private static final String PARAMETERS_ELEMENT = "parameters";
    private static final String ATTRIBUTE_PARAMETER_NAME_SEED = "parameterNameSeed";
    public static final int TRACE_QUERY_PLANNING = 1;
    public static final String XSI_TYPE_ATTRIBUTE = "xsi:type";
    public static final String XSD_STRING_ATTRIBUTE_VALUE = "xsd:string";
    public static final String SOAP_ENC_ARRAY_ATTRIBUTE_VALUE = "SOAP-ENC:Array";
    public static final String SOAP_ENC_ARRAY_TYPE_ATTRIBUTE = "SOAP-ENC:arrayType";
    private static final String STRING_NAME = "name";
    private static final String STRING_ITEM = "item";
    private int parameterNameSeed = 0;
    private static final String UTF_8 = "UTF-8";

    public void capture(PlanningEnvironment planEnv, Element parametersElement) {
        List items = parametersElement.elements();
        for (Element pitem : items) {
            this.captureParameter(planEnv, pitem);
        }
    }

    private void captureParameter(PlanningEnvironment planEnv, Element paramElement) {
        Element eDefaultValue;
        Element eItem;
        Element eCaption;
        String ptype;
        Element eName = paramElement.element(STRING_NAME);
        String name = null;
        if (eName != null) {
            name = eName.getText().trim();
        }
        Element eType = paramElement.element(ELEEMNT_TYPE);
        IDataType dType = null;
        String type = null;
        if (eType != null && (type = eType.getText().trim()) != null) {
            dType = this.getDataTypeByXSDName(type);
            if (type.equals(STRING_XSD_DURATION)) {
                List children = paramElement.selectNodes("//use");
                for (Node c : children) {
                    String content = c.getText();
                    if (!content.contains("year") && (!content.startsWith("P") || !content.contains("Y"))) continue;
                    dType = DataTypeFactory.getDataType((byte)17);
                }
            }
        }
        Parameter parameter = new Parameter(name);
        this.put(name, parameter);
        Attribute aType = paramElement.attribute(ELEEMNT_TYPE);
        if (aType != null && (ptype = aType.getStringValue()) != null && "bus:parameterDataSource".equals(ptype)) {
            parameter.setIsDataSourceParameter(true);
        }
        parameter.setOrderIndex(this.size());
        if (dType != null) {
            parameter.setDataType(dType);
        }
        ParameterCapabilities cap = parameter.getCapabilities();
        Element eCapabilities = paramElement.element("capabilities");
        if (eCapabilities != null) {
            List capabilities = eCapabilities.elements();
            for (Element cElement : capabilities) {
                String cString = cElement.getText().trim();
                if (cString.equals("multivalued")) {
                    cap.setMultivalued(true);
                    continue;
                }
                if (cString.equals("discreteValue")) {
                    cap.setCapability(ParameterCapabilityEnum.discreteValue, true);
                    continue;
                }
                if (cString.equals("optional")) {
                    cap.setCapability(ParameterCapabilityEnum.optional, true);
                    continue;
                }
                if (cString.equals("unboundedRange")) {
                    cap.setCapability(ParameterCapabilityEnum.unboundedRange, true);
                    continue;
                }
                if (cString.equals("boundRange")) {
                    cap.setCapability(ParameterCapabilityEnum.boundRange, true);
                    continue;
                }
                if (!cString.equals("excludeValues")) continue;
                cap.setCapability(ParameterCapabilityEnum.excludeValues, true);
            }
        }
        Element eModelFilterItem = paramElement.element("modelFilterItem");
        String modelFilterItem = null;
        if (eModelFilterItem != null) {
            modelFilterItem = eModelFilterItem.getText().trim();
        }
        if (modelFilterItem != null && modelFilterItem.length() > 0) {
            parameter.setModelItem(modelFilterItem);
            parameter.setDataItemRef(modelFilterItem);
        }
        Element ePromptType = paramElement.element("promptType");
        String promptType = null;
        if (ePromptType != null) {
            promptType = ePromptType.getText().trim();
            parameter.setPromptType(promptType);
        }
        if ((eCaption = paramElement.element("caption")) != null && (eItem = eCaption.element(STRING_ITEM)) != null) {
            List children = eItem.elements();
            for (Element c : children) {
                String cName = c.getName();
                String cText = c.getText();
                if ("value".equals(cName)) {
                    parameter.setCaption(cText);
                    continue;
                }
                if (!"locale".equals(cName) || cText == null) continue;
                Locale theCaptionLocale = LocaleConverter.strToLocale(cText);
                parameter.setCaptionLocale(theCaptionLocale);
            }
        }
        if ((eDefaultValue = paramElement.element("defaultValue")) != null) {
            parameter.getDefaultValues().parse(eDefaultValue);
        }
    }

    public IDataType getDataTypeByXSDName(String typeName) {
        if (typeName.equals("xsdInt")) {
            return DataTypeFactory.getDataType((byte)6);
        }
        if (typeName.equals("xsdLong")) {
            return DataTypeFactory.getDataType((byte)8);
        }
        if (typeName.equals("xsdShort")) {
            return DataTypeFactory.getDataType((byte)4);
        }
        if (typeName.equals("xsdString")) {
            return DataTypeFactory.getDataType((byte)1);
        }
        if (typeName.equals("xsdDate")) {
            return DataTypeFactory.getDataType((byte)57);
        }
        if (typeName.equals("xsdDateTime")) {
            return DataTypeFactory.getDataType((byte)59);
        }
        if (typeName.equals(STRING_XSD_DURATION)) {
            return DataTypeFactory.getDataType((byte)60);
        }
        if (typeName.equals("xsdDouble")) {
            return DataTypeFactory.getDataType((byte)11);
        }
        if (typeName.equals("xsdFloat")) {
            return DataTypeFactory.getDataType((byte)10);
        }
        if (typeName.equals("xsdTime")) {
            return DataTypeFactory.getDataType((byte)58);
        }
        if (typeName.equals("xsdDecimal")) {
            return DataTypeFactory.getDataType((byte)12);
        }
        if (typeName.equals("memberUniqueName")) {
            return DataTypeFactory.getDataType((byte)25);
        }
        return null;
    }

    public boolean prepare(Element parametersElement, PlanningEnvironment planEnv) {
        Parameter parameter;
        String name;
        Element propElement;
        boolean bRet = true;
        List items = parametersElement.elements();
        for (Element element : items) {
            propElement = element.element(STRING_NAME);
            name = propElement.getText().trim();
            parameter = this.getParameter(name);
            Element parent = parametersElement.getParent();
            if (parent.getName().equals("detailQuery")) {
                String queryName = parent.attributeValue("queryName");
                if (null == parameter || !parameter.isMasterDetailLinkParameter()) {
                    parameter = this.getParameter(name, queryName);
                    if (null == parameter) {
                        parameter = new Parameter(name, queryName);
                    }
                    parameter.setMasterDetailLinkParameter(true);
                }
            }
            if (null == parameter) {
                parameter = new Parameter(name);
            }
            if (parent.getName().equals("testParameters")) {
                parameter.setMasterDetailLinkParameter(true);
            }
            this.addParameter(parameter.getParameterName(), parameter);
            if (!(bRet = bRet && parameter.parse(element))) continue;
            parameter.setHasValueProvidedWithRequest(true);
        }
        if (bRet) {
            for (Element element : items) {
                propElement = element.element(STRING_NAME);
                name = propElement.getText().trim();
                parameter = (Parameter)this.get(name);
                if (parameter.getDataType() == null || planEnv == null) continue;
                parameter.setExternalValues(planEnv);
            }
        }
        return bRet;
    }

    public boolean prepareJSON(String parameters, PlanningEnvironment planEnv) {
        boolean bRet = true;
        JSONArray jsonParameters = null;
        try {
            jsonParameters = JSONArray.parse((String)parameters);
        }
        catch (IOException e1) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat);
        }
        for (int i = 0; i < jsonParameters.size(); ++i) {
            JSONObject item = (JSONObject)jsonParameters.get(i);
            String name = (String)item.get((Object)STRING_NAME);
            Parameter parameter = this.getParameter(name);
            if (null == parameter) {
                parameter = new Parameter(name);
            }
            this.addParameter(parameter.getParameterName(), parameter);
            bRet = bRet && parameter.parseJSON(item);
        }
        return bRet;
    }

    public void addParameter(String parameterName, Parameter parameter) {
        this.put(parameterName, parameter);
    }

    public void removeParameter(String parameterName) {
        this.remove(parameterName);
    }

    public boolean hasUnresolvedParameters() {
        if (this.size() == 0) {
            return false;
        }
        for (Parameter parameter : this.values()) {
            if (parameter.isMasterDetailLinkParameter() || parameter.isResolved()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedQueryParameters() {
        if (this.size() == 0) {
            return false;
        }
        for (Parameter parameter : this.values()) {
            if (parameter.isMasterDetailLinkParameter() || parameter.isResolved() || parameter.isDataSourceParameter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedDatasourceParameters() {
        if (this.size() == 0) {
            return false;
        }
        for (Parameter parameter : this.values()) {
            if (parameter.isMasterDetailLinkParameter() || parameter.isResolved() || !parameter.isDataSourceParameter()) continue;
            return true;
        }
        return false;
    }

    public Parameters getNonMasterDetailParameters() {
        Parameters nonMasterDetailParameters = new Parameters();
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (parameter.isMasterDetailLinkParameter() || parameter.isSAPVariableIgnored()) continue;
            String name = (String)entry.getKey();
            nonMasterDetailParameters.put(name, parameter);
        }
        return nonMasterDetailParameters;
    }

    public Parameters getUnresolvedParameters() {
        Parameters unresolvedParameters = new Parameters();
        boolean hasDatasourceParameters = this.hasUnresolvedDatasourceParameters();
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (parameter.isMasterDetailLinkParameter() || parameter.isResolved() || hasDatasourceParameters && !parameter.isDataSourceParameter()) continue;
            String name = (String)entry.getKey();
            unresolvedParameters.put(name, parameter);
        }
        return unresolvedParameters;
    }

    public Parameters getUnresolvedParameters(Set<String> queries) {
        Parameters unresolvedParameters = new Parameters();
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!queries.contains(parameter.getQueryName())) continue;
            String name = (String)entry.getKey();
            unresolvedParameters.put(name, parameter);
        }
        return unresolvedParameters;
    }

    public boolean isResolvedParameter(String parameterName) {
        Parameter parameter = (Parameter)this.get(parameterName);
        if (null == parameter) {
            return false;
        }
        return parameter.isResolved();
    }

    public Parameter getParameter(String parameterName) {
        return (Parameter)this.get(parameterName);
    }

    public Parameter getParameter(String paramName, String queryName) {
        if (paramName == null || queryName == null) {
            return null;
        }
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.getQueryName().equals(queryName)) continue;
            String name = parameter.getParameterName();
            if (!parameter.getName().equals(paramName) && !name.equals(paramName) && (!parameter.isDataSourceParameter() || !name.endsWith(paramName))) continue;
            return parameter;
        }
        return null;
    }

    public boolean hasParameters() {
        for (Parameter parameter : this.values()) {
            if (!parameter.isResolved()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedMasterDetailParameters() {
        for (Parameter parameter : this.values()) {
            if (!parameter.isMasterDetailLinkParameter() || parameter.isResolved()) continue;
            return false;
        }
        return true;
    }

    public boolean hasMasterDetailParameter() {
        for (Parameter parameter : this.values()) {
            if (!parameter.isMasterDetailLinkParameter()) continue;
            return true;
        }
        return false;
    }

    public static Element createParametersElement() {
        Element parametersElement = DocumentHelper.createElement((String)PARAMETERS_ELEMENT);
        parametersElement.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        parametersElement.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        parametersElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        parametersElement.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        parametersElement.addAttribute(XSI_TYPE_ATTRIBUTE, SOAP_ENC_ARRAY_ATTRIBUTE_VALUE);
        return parametersElement;
    }

    public void createParametersString(StringBuilder parameters) {
        this.createParametersString(parameters, false);
    }

    public void createParametersString(StringBuilder parameters, boolean includeInfo) {
        parameters.append("<parameters SOAP-ENC:arrayType=\"bus:baseParameter[" + this.size() + "]\"");
        parameters.append(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        parameters.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        parameters.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        parameters.append(" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"");
        parameters.append(" xsi:type=\"SOAP-ENC:Array\">");
        ArrayList sortedParameters = new ArrayList(this.values());
        Collections.sort(sortedParameters, new OrderComparator());
        for (Parameter parameter : sortedParameters) {
            boolean resolvedParameter = false;
            if (parameter.getDataTypeName().length() == 0 && parameter.isResolved()) {
                resolvedParameter = true;
            }
            parameter.appendItemString(parameters, resolvedParameter);
        }
        parameters.append("</parameters>");
        if (includeInfo) {
            parameters.append("<parameterInfo>");
            for (Parameter parameter : sortedParameters) {
                parameters.append("<parameter name=\"");
                parameters.append(StringSubstitutionEngine.escapeString(parameter.getParameterName()));
                parameters.append("\" variableName=\"");
                String value = parameter.getNameVariable() ? "true" : "false";
                parameters.append(value);
                parameters.append("\"/>");
            }
            parameters.append("</parameterInfo>");
        }
    }

    public static void setParametersArraySize(Element parametersElem, int size) {
        StringBuilder buff = new StringBuilder();
        buff.append("bus:baseParameter[");
        buff.append(size);
        buff.append("]");
        Attribute attr = parametersElem.attribute("arrayType");
        if (null == attr) {
            parametersElem.addAttribute(SOAP_ENC_ARRAY_TYPE_ATTRIBUTE, buff.toString());
        } else {
            attr.setValue(buff.toString());
        }
    }

    public String getParameterName(String promptName, String queryName, boolean isMasterDetail, IPlanningEnvironment environment) {
        Parameter parameter = this.getParameter(promptName, queryName);
        if (parameter != null) {
            return parameter.getName();
        }
        parameter = this.getParameter(promptName);
        boolean newParameterIsNeeded = false;
        if (parameter != null && parameter.getQueryName() != null && parameter.getQueryName().length() > 0 && parameter.isMasterDetailLinkParameter() == isMasterDetail) {
            for (Map.Entry entry : this.entrySet()) {
                Parameter pp = (Parameter)entry.getValue();
                if (pp == parameter || !pp.getParameterName().equals(promptName) || pp.isMasterDetailLinkParameter() == isMasterDetail) continue;
                newParameterIsNeeded = true;
                break;
            }
        }
        if (parameter != null && (newParameterIsNeeded || isMasterDetail != parameter.isMasterDetailLinkParameter() || isMasterDetail && !parameter.getQueryName().equals(queryName))) {
            return this.getNewParameterName(promptName);
        }
        return promptName;
    }

    private String getNewParameterName(String oldParameterName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(oldParameterName);
        buffer.append("$");
        buffer.append(this.parameterNameSeed);
        ++this.parameterNameSeed;
        return buffer.toString();
    }

    public String asString() {
        StringBuilder string = new StringBuilder();
        for (String parameterName : this.keySet()) {
            if (string.length() > 0) {
                string.append(", ");
            }
            Parameter parameter = this.getParameter(parameterName);
            string.append(parameter.getParameterName());
        }
        return string.toString();
    }

    public boolean hasMDLinkParameterValueRequiredBeforePlanning(String queryName) {
        boolean hasParameterRequireValue = false;
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isParameterValueRequiredBeforePlanning() || !queryName.equals(parameter.getQueryName()) || !parameter.isMasterDetailLinkParameter()) continue;
            hasParameterRequireValue = true;
            break;
        }
        return hasParameterRequireValue;
    }

    public boolean hasParameterValueRequiredBeforePlanning() {
        boolean hasParameterRequireValue = false;
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isParameterValueRequiredBeforePlanning()) continue;
            hasParameterRequireValue = true;
            break;
        }
        return hasParameterRequireValue;
    }

    public boolean containsParameterWithNullOrNilValue() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (parameter.getParameterValueItems().hasNullValue()) {
                return true;
            }
            if (parameter.getParameterValueItems().isValueExplicitlyNotSupplied()) {
                return true;
            }
            ParameterValues pvs = parameter.getParameterValueItems();
            for (int i = 0; i < pvs.size(); ++i) {
                if (((ParameterValueItem)pvs.get(i)).getInclusive()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsParameterUsedByScrollCursor() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isUsedByScrollCursor()) continue;
            return true;
        }
        return false;
    }

    public boolean containsParameterWithNullValue() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.getParameterValueItems().hasNullValue()) continue;
            return true;
        }
        return false;
    }

    public boolean containsParameterWithInvertedValue() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            ParameterValues pvs = parameter.getParameterValueItems();
            for (int i = 0; i < pvs.size(); ++i) {
                if (((ParameterValueItem)pvs.get(i)).getInclusive()) continue;
                return true;
            }
        }
        return false;
    }

    public StringBuilder generateStringBuilderResponse(boolean includeInfo) {
        StringBuilder parametersBuffer = new StringBuilder("<response>");
        if (this.size() > 0) {
            this.createParametersString(parametersBuffer, includeInfo);
        }
        parametersBuffer.append("</response>");
        return parametersBuffer;
    }

    public Element generateDOMResponse(boolean includeInfo) {
        StringBuilder parametersBuffer = this.generateStringBuilderResponse(includeInfo);
        SimpleSaxParser saxParser = new SimpleSaxParser();
        try {
            saxParser.parseStream(new ByteArrayInputStream(parametersBuffer.toString().getBytes(UTF_8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XQERuntimeException(e);
        }
        Element responseElement = saxParser.getDocument().getRootElement();
        return responseElement;
    }

    public String generateStringResponse(boolean includeInfo) {
        StringBuilder stringBuilder = this.generateStringBuilderResponse(includeInfo);
        return stringBuilder.toString();
    }

    public boolean hasOptionalParameter() {
        for (Parameter parameter : this.values()) {
            if (!parameter.getCapabilities().isOptional()) continue;
            return true;
        }
        return false;
    }

    public void clearParametersRequiredValuesBeforePlanning() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isParameterValueRequiredBeforePlanning()) continue;
            String name = (String)entry.getKey();
            this.removeParameter(name);
            break;
        }
        if (this.hasParameterValueRequiredBeforePlanning()) {
            this.clearParametersRequiredValuesBeforePlanning();
        }
    }

    public void clearMasterDetailParameters() {
        for (Map.Entry entry : this.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (!parameter.isMasterDetailLinkParameter()) continue;
            String name = (String)entry.getKey();
            this.removeParameter(name);
            break;
        }
        if (this.hasMasterDetailParameter()) {
            this.clearMasterDetailParameters();
        }
    }

    public boolean hasParameterWithBadValue() {
        boolean hasBadValue = false;
        for (Parameter parameter : this.values()) {
            UnresolvedParameterException.ParameterErrorCodeEnum paramErrCode = parameter.getErrorCode();
            if (paramErrCode == null || paramErrCode != UnresolvedParameterException.ParameterErrorCodeEnum.INVALID_FORMAT) continue;
            hasBadValue = true;
            break;
        }
        return hasBadValue;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_PARAMETER_NAME_SEED, this.parameterNameSeed);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        for (Map.Entry entry : this.entrySet()) {
            ctx.getWriter().beginElement("entry", -1);
            ctx.elementProperty(null, entry.getKey());
            ctx.elementProperty(null, entry.getValue());
            ctx.getWriter().endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_PARAMETER_NAME_SEED)) {
            Object val = ctx.attributeValue(att);
            this.parameterNameSeed = (Integer)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element entry = (Element)childList.get(i);
            List entryList = entry.elements();
            if (entryList.size() != 2) continue;
            Object key = ctx.elementValue((Element)entryList.get(0));
            Object val = ctx.elementValue((Element)entryList.get(1));
            if (key == null) continue;
            this.put((String)key, (Parameter)val);
        }
    }

    public void appendUnresolvedParametersResponseJSON(boolean includeInfo, JSONObject owner) {
        JSONArray jItems = new JSONArray();
        owner.put((Object)PARAMETERS_ELEMENT, (Object)jItems);
        ArrayList sortedParameters = new ArrayList(this.values());
        Collections.sort(sortedParameters, new OrderComparator());
        for (Parameter parameter : sortedParameters) {
            boolean resolvedParameter = false;
            if (parameter.getDataTypeName().length() == 0 && parameter.isResolved()) {
                resolvedParameter = true;
            }
            parameter.appendItemJSON(jItems, resolvedParameter);
        }
        if (includeInfo) {
            JSONArray jInfoItems = new JSONArray();
            owner.put((Object)"parameterInfo", (Object)jInfoItems);
            for (Parameter parameter : sortedParameters) {
                JSONObject jInfoParam = new JSONObject();
                jInfoItems.add((Object)jInfoParam);
                jInfoParam.put((Object)STRING_NAME, (Object)parameter.getParameterName());
                jInfoParam.put((Object)"variableName", (Object)parameter.getNameVariable());
            }
        }
    }

    public static List<String> getParameterNames(Element parametersElement) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Element itemElem : parametersElement.elements(STRING_ITEM)) {
            parameterNames.add(itemElem.element(STRING_NAME).getText().trim());
        }
        return parameterNames;
    }

    private class OrderComparator
    implements Comparator<Parameter> {
        private OrderComparator() {
        }

        @Override
        public int compare(Parameter parameter1, Parameter parameter2) {
            int index2;
            int index1 = parameter1.getOrderIndex();
            if (index1 == (index2 = parameter2.getOrderIndex())) {
                return parameter1.getName().compareTo(parameter2.getName());
            }
            return Integer.signum(index1 - index2);
        }
    }
}

