/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.util.SQLAbstractUnformattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import org.dom4j.Element;

public class SimpleParameterValueItem
extends ParameterValueItem {
    private static final String ELEMENT_VALUE = "valueObj";
    private static final String ELEMENT_ASSOCIATED_PARAMETER = "associatedParameter";
    private IValue valueObj;
    protected Parameter associatedParameter = null;

    public SimpleParameterValueItem() {
    }

    SimpleParameterValueItem(Parameter theAssociatedParameter) {
        this.associatedParameter = theAssociatedParameter;
    }

    public Parameter getAssociatedParameter() {
        return this.associatedParameter;
    }

    protected void setAssociatedParameter(Parameter theAssociatedParameter) {
        this.associatedParameter = theAssociatedParameter;
    }

    void setValue(IValue value) {
        this.valueObj = value;
    }

    @Override
    public boolean hasNullValue() {
        return this.valueObj == null || this.valueObj.isNull();
    }

    public IValue getValue() {
        return this.valueObj;
    }

    public IValue getValueFromInternalValue() {
        return this.valueObj;
    }

    @Override
    public void asSQLString(StringBuilder buffer, String prefix, String suffix, IDataSourceCapabilities capabilities) {
        SQLLiteral sqlLiteral = new SQLLiteral();
        sqlLiteral.setDataType(this.valueObj.getDataType());
        sqlLiteral.setValue((Value)this.valueObj);
        SQLPlainQueryFormatter formatter = new SQLPlainQueryFormatter();
        sqlLiteral.accept(formatter, capabilities);
        buffer.append(((SQLAbstractUnformattedQueryFormatter)formatter).bufferToString());
    }

    public int hashCode() {
        if (this.valueObj != null) {
            return this.valueObj.hashCode();
        }
        return 0;
    }

    public boolean equals(Object pvi) {
        if (pvi instanceof SimpleParameterValueItem) {
            return this.valueObj != null && this.valueObj.equals(((SimpleParameterValueItem)pvi).getValue());
        }
        return false;
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.valueObj != null) {
            ctx.elementProperty(ELEMENT_VALUE, this.valueObj);
        }
        if (this.associatedParameter != null) {
            ctx.elementProperty(ELEMENT_ASSOCIATED_PARAMETER, this.associatedParameter);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_VALUE)) {
            Object val = ctx.elementValue(node);
            this.valueObj = (IValue)val;
        } else if (pname.equals(ELEMENT_VALUE)) {
            Object val = ctx.elementValue(node);
            this.associatedParameter = (Parameter)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

