/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.util.SQLAbstractUnformattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.ast.v5.V5SyntaxException;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5LiteralNull;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.util.V5MunUtil;
import com.cognos.xqe.ast.v5Exp_new2.parser.TokenMgrError;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.SimpleParameterValueItem;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.binding.BindV5MemberUniqueName;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.ibm.json.java.JSONObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5ParameterValueItem
extends SimpleParameterValueItem {
    public static final String ELEMENT_TYPE_NAME_DISPLAY = "display";
    public static final String ELEMENT_TYPE_NAME_USE = "use";
    public static final String ELEMENT_EXTERNAL_VALUE = "externalValue";
    public static final int TEN = 10;
    public static final String UPPER_CASE_E = "E";
    public static final String LOWER_CASE_E = "e";
    public static final String SPLIT_CHARACTER = "\\.";
    public static final String UNIQUENAME_SEPARATOR = "].[";
    static final Pattern PATTERN_NUMBER = Pattern.compile("^[0-9]+$");
    static final Pattern PATTERN_SCI_FLOAT = Pattern.compile("^[E|e]?[0-9]+[.|,]?[0-9]+$");
    static final Pattern PATTERN_FIXED_POINT = Pattern.compile("(-|\\+)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)");
    protected String internalValue;
    protected String displayValue = new String();
    protected String externalValue = new String();

    public V5ParameterValueItem(Parameter theAssociatedParameter) {
        super(theAssociatedParameter);
    }

    public V5ParameterValueItem() {
    }

    public void setAll(boolean inclusive, String theDisplayValue, String theInternalValue) {
        this.setInclusive(inclusive);
        this.setDisplayValue(theDisplayValue);
        this.setInternalValue(theInternalValue);
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String value) {
        this.displayValue = value;
    }

    public String getInternalValue() {
        return this.internalValue;
    }

    public void setInternalValue(String value) {
        this.internalValue = value;
    }

    @Override
    public boolean hasNullValue() {
        return this.internalValue == null;
    }

    @Override
    public Value getValueFromInternalValue() {
        IntervalQualifier qualifier;
        IDataType dataType = this.associatedParameter.getDataType();
        Value dataValue = null;
        String stringValue = this.internalValue;
        if (dataType instanceof IntervalYearMonthType) {
            IntervalQualifier qualifier2 = IntervalQualifier.getQualifierFromValue(stringValue);
            if (qualifier2 != IntervalQualifier.INTERVAL_UNKNOWN) {
                int idx = stringValue.toLowerCase().indexOf(qualifier2.getDescriptor());
                if (idx != -1) {
                    stringValue = stringValue.substring(0, idx - 1);
                }
                dataValue = (Value)DataTypeFactory.getIntervalYearMonthType(qualifier2).createValue();
                dataValue.set(stringValue);
            }
        } else if (dataType instanceof IntervalDayTimeType && (qualifier = IntervalQualifier.getQualifierFromValue(stringValue)) != IntervalQualifier.INTERVAL_UNKNOWN) {
            int idx = stringValue.toLowerCase().indexOf(qualifier.getDescriptor());
            if (idx != -1) {
                stringValue = stringValue.substring(0, idx - 1);
            }
            dataValue = (Value)DataTypeFactory.getIntervalDayTimeType(qualifier).createValue();
            dataValue.set(stringValue);
        }
        if (dataValue == null) {
            if (dataType == null) {
                dataType = DataTypeFactory.getVarcharType(stringValue.length());
            }
            dataType = this.getAdjustedDataType(dataType, stringValue);
            dataValue = (Value)dataType.createValue();
            dataValue.set(stringValue);
        }
        return dataValue;
    }

    private boolean isDataTypeThatCanHaveDecimalSeparatorInValue(IDataType dt) {
        return dt != null && dt.getBaseDataType().isNumeric();
    }

    IDataType getAdjustedDataType(IDataType dType, String value) {
        IDataType dataType = dType;
        if (value == null || value.compareTo("") == 0) {
            return dataType;
        }
        if (dType == null) {
            return null;
        }
        if (dataType == VariantType.VARIANT) {
            dataType = VarcharType.DEFAULTVARCHARTYPE;
        }
        if (dataType.isInteger() && this.associatedParameter.getModelSize() == 2) {
            dataType = SmallintType.SMALLINTTYPE;
        }
        switch (dataType.getCCLTypeCode()) {
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                if (value.contains(UPPER_CASE_E) || value.contains(LOWER_CASE_E)) {
                    dataType = DataTypeFactory.getDoubleType();
                    break;
                }
                Matcher match = PATTERN_FIXED_POINT.matcher(value);
                if (!match.matches()) break;
                int precision = 0;
                int scale = 0;
                String[] parts = value.split(SPLIT_CHARACTER);
                parts[0] = parts[0].replace('-', ' ');
                parts[0] = parts[0].replace('+', ' ').trim();
                if (parts.length > 1) {
                    scale = parts[1].length();
                }
                precision = parts[0].length() + scale;
                dataType = DataTypeFactory.getDecimalType(precision, scale);
                break;
            }
            case 26: {
                if (!DataSourceTypeEnum.isRelational(this.associatedParameter.getProviderName())) break;
                dataType = DataTypeFactory.getVarcharType(value.length());
                break;
            }
            case 45: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getVarcharType(value.length());
                    this.addToLog(value, e);
                }
                break;
            }
            case 56: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getNVarcharType(value.length());
                    this.addToLog(value, e);
                }
                break;
            }
            case 55: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getNCharType(value.length());
                    this.addToLog(value, e);
                }
                break;
            }
            default: {
                dataType = dType;
            }
        }
        return dataType;
    }

    private void addToLog(String value, ValueConversionException e) {
        XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LogLevel.TRACE);
        String msg = "parameter substituted with out of range value '" + value + "': " + e.getFaultString();
        infoLogger.log(msg);
    }

    public String getSAPTypeInRangeVariableValue() {
        int index;
        if (!this.internalValue.contains("[") && (index = this.externalValue.indexOf(UNIQUENAME_SEPARATOR)) != -1) {
            return this.externalValue.substring(index + UNIQUENAME_SEPARATOR.length(), this.externalValue.length() - 1);
        }
        return this.externalValue;
    }

    @Override
    public void parse(Element itemElement) {
        if (itemElement != null) {
            Element useElement;
            super.parse(itemElement);
            Element displayElement = itemElement.element(ELEMENT_TYPE_NAME_DISPLAY);
            if (displayElement != null) {
                this.setDisplayValue(displayElement.getText());
            }
            if ((useElement = itemElement.element(ELEMENT_TYPE_NAME_USE)) != null && !ParameterValues.isNil(useElement)) {
                this.setInternalValue(useElement.getText());
            }
        }
    }

    @Override
    public void parseJSON(JSONObject jValue) {
        if (jValue != null) {
            String use;
            super.parseJSON(jValue);
            String display = (String)jValue.get((Object)ELEMENT_TYPE_NAME_DISPLAY);
            if (display != null) {
                this.setDisplayValue(display);
            }
            if ((use = (String)jValue.get((Object)ELEMENT_TYPE_NAME_USE)) != null && !use.isEmpty()) {
                this.setInternalValue(use);
            }
        }
    }

    public String getExternalValue() {
        return this.externalValue;
    }

    @Override
    void setExternalValue(PlanningEnvironment environment) {
        block28: {
            this.externalValue = this.internalValue;
            if (this.internalValue != null && this.internalValue.length() > 0) {
                IDataType dataType = this.associatedParameter.getDataType();
                if (!this.associatedParameter.isLiteral()) {
                    if (dataType.equals(DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) || dataType.equals(HierarchyType.HIERARCHYTYPE) || dataType.equals(MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE) || dataType.equals(LevelType.LEVELTYPE) || dataType.equals(MemberType.MEMBERTYPE)) {
                        try {
                            IXQEQueryNode node = V5ExpressionProcessor.parse(this.internalValue, environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                            if (node.getType() == 201028) {
                                V5MemberUniqueName v5MemberUniqueName = (V5MemberUniqueName)node;
                                if (this.associatedParameter.isMasterDetailLinkParameter() && !this.associatedParameter.isSameMasterDetailLinkLevel(node)) {
                                    this.externalValue = this.adjustExternalValue(v5MemberUniqueName);
                                    this.associatedParameter.resetModel(v5MemberUniqueName, null);
                                    this.associatedParameter.validateValue(node, null);
                                } else {
                                    if (this.associatedParameter.isDMRParameter()) {
                                        V5MunUtil.setPropertyDMRMUN(v5MemberUniqueName, true);
                                    }
                                    this.externalValue = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, false);
                                    String providerName = this.associatedParameter.getProviderName();
                                    if (DataSourceTypeEnum.isPowerCube(providerName) || DataSourceTypeEnum.isTM1(providerName)) {
                                        this.externalValue = V5MunUtil.getExternalMUNWithEscapedSquareBrackets(v5MemberUniqueName, false);
                                    }
                                    if (this.associatedParameter.doResolveExternalName()) {
                                        this.externalValue = UniqueNameGenerator.resolveExternalNameForMUN(v5MemberUniqueName, environment);
                                    }
                                }
                            } else if (node.getType() != 201030) {
                                this.externalValue = this.convertStringToMUN(this.internalValue);
                            }
                        }
                        catch (V5SyntaxException ex) {
                            this.externalValue = this.convertStringToMUN(this.internalValue);
                        }
                        catch (TokenMgrError ex) {
                            this.externalValue = this.convertStringToMUN(this.internalValue);
                        }
                    } else if (dataType.equals(DateType.DATETYPE) && this.associatedParameter.isDataSourceParameter()) {
                        try {
                            IXQEQueryNode node = V5ExpressionProcessor.parse(this.internalValue, environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                            if (node.getType() == 201028) {
                                V5MemberUniqueName v5MemberUniqueName = (V5MemberUniqueName)node;
                                this.externalValue = V5MunUtil.getExternalMemberUniqueName(v5MemberUniqueName, false);
                                break block28;
                            }
                            this.externalValue = this.convertDateToMUN(this.externalValue);
                        }
                        catch (V5SyntaxException ex) {
                            this.externalValue = this.convertDateToMUN(this.externalValue);
                        }
                        catch (TokenMgrError ex) {
                            this.externalValue = this.convertDateToMUN(this.externalValue);
                        }
                    }
                } else if (dataType.equals(TimestampType.TIMESTAMPTYPE)) {
                    this.externalValue = this.externalValue.replace('T', ' ').trim();
                    if (this.associatedParameter.doResolveExternalName()) {
                        this.externalValue = UniqueNameGenerator.resolveExternalNameForDateTimeConstant(this.externalValue, environment);
                    }
                } else if (dataType.equals(DateType.DATETYPE)) {
                    String providerName = this.associatedParameter.getProviderName();
                    if (providerName != null && providerName.equals("BW")) {
                        this.externalValue = this.externalValue.replaceAll("-", "").trim();
                    }
                } else if (this.isDataTypeThatCanHaveDecimalSeparatorInValue(dataType)) {
                    this.externalValue = this.externalValue.replace(',', '.');
                }
            }
        }
    }

    @Override
    public void bind(PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (this.internalValue == null) {
            V5LiteralNull literalValue = (V5LiteralNull)nodeFactory.createNode(201023);
            literalValue.setInclusive(this.getInclusive());
            this.boundValue = literalValue;
        } else if (nodeFactory != null) {
            if (this.associatedParameter.isLiteral()) {
                IDataType dataType = this.associatedParameter.getDataType();
                if (this.isDataTypeThatCanHaveDecimalSeparatorInValue(dataType)) {
                    this.internalValue = this.internalValue.replace(',', '.');
                }
                V5LiteralValue literalValue = (V5LiteralValue)nodeFactory.createNode(201026);
                literalValue.setInclusive(this.getInclusive());
                this.boundValue = literalValue;
                Value dataValue = this.getValue();
                if (dataValue != null) {
                    literalValue.setValue(dataValue);
                    literalValue.setDataType(dataValue.getDataType());
                    literalValue.setInclusive(this.getInclusive());
                    this.boundValue = literalValue;
                } else {
                    this.associatedParameter.setErrorCode(UnresolvedParameterException.ParameterErrorCodeEnum.INVALID_FORMAT);
                }
            } else {
                try {
                    IXQEQueryNode node = V5ExpressionProcessor.parse(this.internalValue, environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
                    if (node instanceof V5MemberUniqueName) {
                        V5MemberUniqueName munNode = (V5MemberUniqueName)node;
                        this.associatedParameter.resetModel(munNode, null);
                        IMetadata[] metadata = new IMetadata[1];
                        if (this.associatedParameter.isDMRParameter()) {
                            V5MunUtil.setPropertyDMRMUN(munNode, true);
                        }
                        V5BoundMemberUniqueName munValue = BindV5MemberUniqueName.convertV5MemberUniqueNameToV5BoundMemberUniqueName(munNode, environment, metadata);
                        this.associatedParameter.resetModel(munNode, munValue);
                        if (munNode.getPhysical() == null && !this.associatedParameter.getLevels().isEmpty()) {
                            IHierarchy hierarchy = this.associatedParameter.getLevels().get(0).getHierarchy();
                            this.externalValue = UniqueNameGenerator.join(hierarchy.getUniqueName(), this.externalValue);
                        }
                        this.boundValue = munValue;
                        this.associatedParameter.validateValue(node, munValue);
                    } else if (this.associatedParameter.getProviderHierarchyUniqueName() == null) {
                        this.associatedParameter.validateValue(node, null);
                    }
                }
                catch (V5SyntaxException v5SyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void asDOMString(StringBuilder buffer) {
        this.asDOMString(buffer, "item");
    }

    public void asDOMString(StringBuilder buffer, String wrapper) {
        buffer.append("<" + wrapper + " xsi:type=\"bus:simpleParmValueItem\">");
        super.asDOMString(buffer);
        if (this.displayValue != null && this.displayValue.length() > 0) {
            buffer.append("<display xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.displayValue));
            buffer.append("</display>");
        }
        if (this.internalValue != null && this.internalValue.length() > 0) {
            buffer.append("<use xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.internalValue));
            buffer.append("</use>");
        }
        buffer.append("</" + wrapper + ">");
    }

    public void appendJSON(JSONObject owner, String wrapper) {
        JSONObject jObj = new JSONObject();
        owner.put((Object)wrapper, (Object)jObj);
        jObj.put((Object)"type", (Object)"simpleParmValueItem");
        this.addInclusive(jObj);
        if (this.displayValue != null && this.displayValue.length() > 0) {
            jObj.put((Object)ELEMENT_TYPE_NAME_DISPLAY, (Object)this.displayValue);
        }
        if (this.internalValue != null && this.internalValue.length() > 0) {
            jObj.put((Object)ELEMENT_TYPE_NAME_USE, (Object)this.internalValue);
        }
    }

    @Override
    public void asSAPVariablesString(StringBuilder buffer, PlanningEnvironment environment) {
        if (null == this.externalValue || this.externalValue.length() == 0) {
            this.setExternalValue(environment);
        }
        super.asSAPVariablesString(buffer, environment);
        if (this.associatedParameter.getDataType() == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
            int index = this.externalValue.indexOf(UNIQUENAME_SEPARATOR);
            if (index != -1) {
                buffer.append(this.externalValue.substring(0, index + 1));
            } else {
                buffer.append(this.externalValue);
            }
        } else {
            buffer.append(this.externalValue);
        }
    }

    public String convertDateToMUN(String date) {
        DateValue dateValue = DataValueFactory.createDateValue();
        dateValue.set(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(dateValue.getYear());
        if (dateValue.getMonth() < 10) {
            buffer.append(0);
        }
        buffer.append(dateValue.getMonth());
        if (dateValue.getDay() < 10) {
            buffer.append(0);
        }
        buffer.append(dateValue.getDay());
        return this.convertStringToMUN(buffer.toString());
    }

    public String convertStringToMUN(String value) {
        String mun = null;
        String hierUniqueName = this.associatedParameter.getProviderHierarchyUniqueName();
        mun = hierUniqueName != null ? UniqueNameGenerator.appendUniqueName(hierUniqueName, value) : UniqueNameGenerator.createSingleNamePart(value);
        return mun;
    }

    public String adjustExternalValue(V5MemberUniqueName node) {
        String retValue = "";
        IHierarchy hierarchy = this.associatedParameter.getLevels().get(0).getHierarchy();
        String[] nodeParts = null;
        String[] paramParts = null;
        String parameterModel = this.associatedParameter.getModelItem();
        if (parameterModel == null || parameterModel.length() == 0) {
            parameterModel = hierarchy.getV5UniqueName();
        }
        UniqueNameParser parser = new UniqueNameParser();
        try {
            nodeParts = parser.parse(node.getModel());
            paramParts = parser.parse(parameterModel);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        if (nodeParts[0].equals(paramParts[0]) && nodeParts[1].equals(paramParts[1]) && nodeParts[2].equals(paramParts[2])) {
            return retValue;
        }
        if (!(node.getPhysical() == null || !nodeParts[0].equals(paramParts[0]) || nodeParts[1].equals(paramParts[1]) && nodeParts[2].equals(paramParts[2]))) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedDifferentDimMasterDetailLink, node.getModel(), parameterModel);
        }
        int length = nodeParts.length;
        if (paramParts.length < length) {
            length = paramParts.length;
        }
        System.arraycopy(paramParts, 0, nodeParts, 0, length);
        node.setModel(UniqueNameGenerator.createUniqueName(nodeParts));
        this.associatedParameter.setModelItem(node.getModel());
        String externalName = node.getLogical();
        if (externalName == null) {
            externalName = node.getPhysical();
            if (this.associatedParameter.getDataType() instanceof MemberType) {
                externalName = UniqueNameParser.parseLastIdentifier(externalName);
            }
        }
        retValue = UniqueNameGenerator.createProviderMemberUniqueName(hierarchy, externalName);
        if (this.associatedParameter.doResolveExternalName()) {
            retValue = UniqueNameGenerator.resolveExternalNameForMUN(node, (PlanningEnvironment)node.getPlanningEnvironment());
        }
        return retValue;
    }

    @Override
    public Value getValue() {
        IDataType dataType = this.associatedParameter.getDataType();
        Value dataValue = null;
        String providerName = this.associatedParameter.getProviderName();
        String value = this.externalValue;
        try {
            if (dataType instanceof IntervalYearMonthType) {
                IntervalQualifier qualifier = IntervalQualifier.getQualifierFromValue(value);
                if (qualifier != IntervalQualifier.INTERVAL_UNKNOWN) {
                    int idx = value.toLowerCase().indexOf(qualifier.getDescriptor());
                    if (idx != -1) {
                        value = value.substring(0, idx - 1);
                    }
                    dataValue = (Value)DataTypeFactory.getIntervalYearMonthType(qualifier).createValue();
                    dataValue.set(value);
                }
            } else if (dataType instanceof IntervalDayTimeType) {
                IntervalQualifier qualifier = IntervalQualifier.getQualifierFromValue(value);
                if (qualifier != IntervalQualifier.INTERVAL_UNKNOWN) {
                    int idx = value.toLowerCase().indexOf(qualifier.getDescriptor());
                    if (idx != -1) {
                        value = value.substring(0, idx - 1);
                    }
                    dataValue = (Value)DataTypeFactory.getIntervalDayTimeType(qualifier).createValue();
                    dataValue.set(value);
                }
            } else if (dataType instanceof DateType) {
                dataValue = (Value)dataType.createValue();
                if (providerName != null && providerName.equals("BW")) {
                    ((DateValue)dataValue).setFormat("yyyyMMdd");
                }
                dataValue.set(value);
            }
            if (dataValue == null) {
                if (dataType == null) {
                    dataType = DataTypeFactory.getVarcharType(value.length());
                }
                dataType = this.getAdjustedDataType(dataType, value);
                this.associatedParameter.setDataType(dataType);
                dataValue = (Value)dataType.createValue();
                dataValue.set(value);
            }
        }
        catch (ValueConversionException e) {
            dataValue = null;
        }
        return dataValue;
    }

    @Override
    public void asSQLString(StringBuilder buffer, String prefix, String suffix, IDataSourceCapabilities capabilities) {
        DataSubType dataSubType;
        String stringValue = null;
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        stringValue = this.getExternalValue() != null && this.getExternalValue().length() > 0 ? prefix + this.getExternalValue() + suffix : prefix + this.getInternalValue() + suffix;
        IDataType dataType = this.associatedParameter.getDataType();
        if (dataType == null) {
            dataType = DataTypeFactory.getVarcharType(stringValue.length());
        }
        if ((dataSubType = dataType.getSubType()) == DataSubType.NUMERICTYPE) {
            buffer.append(stringValue);
        } else {
            int idx;
            IntervalQualifier qualifier;
            if (dataType instanceof IntervalYearMonthType) {
                qualifier = IntervalQualifier.getQualifierFromValue(stringValue);
                if (qualifier != IntervalQualifier.INTERVAL_UNKNOWN) {
                    dataType = DataTypeFactory.getIntervalYearMonthType(qualifier);
                    idx = stringValue.toLowerCase().indexOf(qualifier.getDescriptor());
                    if (idx != -1) {
                        stringValue = stringValue.substring(0, idx - 1);
                    }
                }
            } else if (dataType instanceof IntervalDayTimeType) {
                qualifier = IntervalQualifier.getQualifierFromValue(stringValue);
                if (qualifier == IntervalQualifier.INTERVAL_YEAR || qualifier == IntervalQualifier.INTERVAL_YEAR_TO_MONTH || qualifier == IntervalQualifier.INTERVAL_MONTH) {
                    dataType = DataTypeFactory.getIntervalYearMonthType(qualifier);
                    idx = stringValue.toLowerCase().indexOf(qualifier.getDescriptor());
                    if (idx != -1) {
                        stringValue = stringValue.substring(0, idx - 1);
                    }
                } else if (qualifier != IntervalQualifier.INTERVAL_UNKNOWN) {
                    dataType = DataTypeFactory.getIntervalDayTimeType(qualifier);
                    idx = stringValue.toLowerCase().indexOf(qualifier.getDescriptor());
                    if (idx != -1) {
                        stringValue = stringValue.substring(0, idx - 1);
                    }
                } else if ((stringValue.indexOf(80) == 0 || stringValue.indexOf(112) == 0) && stringValue.indexOf(84) < 0 && stringValue.indexOf(116) < 0 && stringValue.indexOf(68) < 0 && stringValue.indexOf(100) < 0) {
                    dataType = IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE;
                }
            } else if (dataType instanceof MemberType) {
                stringValue = UniqueNameParser.parseLastIdentifier(stringValue);
                dataType = DataTypeFactory.getVarcharType(stringValue.length());
            }
            dataType = this.getAdjustedDataType(dataType, stringValue);
            Value valueObject = (Value)dataType.createValue();
            valueObject.set(stringValue);
            SQLLiteral sqlLiteral = new SQLLiteral();
            sqlLiteral.setDataType(dataType);
            sqlLiteral.setValue(valueObject);
            SQLPlainQueryFormatter formatter = new SQLPlainQueryFormatter();
            sqlLiteral.accept(formatter, capabilities);
            buffer.append(((SQLAbstractUnformattedQueryFormatter)formatter).bufferToString());
        }
    }

    @Override
    public int hashCode() {
        if (this.internalValue != null) {
            return this.internalValue.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object pvi) {
        if (pvi instanceof V5ParameterValueItem) {
            return this.internalValue != null && this.internalValue.equals(((V5ParameterValueItem)pvi).getInternalValue());
        }
        return false;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ELEMENT_TYPE_NAME_DISPLAY, this.displayValue);
        ctx.property(ELEMENT_TYPE_NAME_USE, this.internalValue);
        ctx.property(ELEMENT_EXTERNAL_VALUE, this.externalValue);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ELEMENT_TYPE_NAME_DISPLAY)) {
            Object val = ctx.attributeValue(att);
            this.displayValue = (String)val;
        } else if (attName.equals(ELEMENT_TYPE_NAME_USE)) {
            Object val = ctx.attributeValue(att);
            this.internalValue = (String)val;
        } else if (attName.equals(ELEMENT_EXTERNAL_VALUE)) {
            Object val = ctx.attributeValue(att);
            this.externalValue = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }
}

