/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.planner;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.localprocessing.LocalProcessingNodeFactory;
import com.cognos.xqe.ast.ma.MANodeFactory;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.macro.MXNodeFactory;
import com.cognos.xqe.ast.mdx.parser.MDXNodeFactory;
import com.cognos.xqe.ast.olap.OLAPNodeFactory;
import com.cognos.xqe.ast.qep.QEPNodeFactory;
import com.cognos.xqe.ast.rqp.RQPNodeFactory;
import com.cognos.xqe.ast.rsapi.RSAPINodeFactory;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5QuerySubject;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5.update.V5UpdateSet;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PersistentQueryPlan;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.engine.V5Constants;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.olap.decoration.rulesfactory.OLAPDecorationRulesFactory;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.source.ISource;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.moser.GenerateJoinGraph;
import com.cognos.xqe.transformation.moser.GenerateV5QueryForTableStatistics;
import com.cognos.xqe.transformation.moser.GenerateV5QueryFromMoserFacetQuery;
import com.cognos.xqe.transformation.moser.GenerateV5QueryFromMoserJoinQuery;
import com.cognos.xqe.transformation.moser.GenerateV5QueryFromMoserTableQuery;
import com.cognos.xqe.transformation.moser.GenerateV5QueryFromMoserValidate;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqebifw.bibushandler.GenerateFunctionList;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;

public final class QueryPlanner {
    public static final String UTF_8 = "UTF-8";
    private static final String XML_ELEMENT_ERROR = "Error";
    private static final String XML_ATTRIBUTE_MESSAGE = "message";
    private static final String SQLQUERY = "sqlQuery";
    private static final String TYPE = "type";
    protected JDBCConnection connection;
    private static QueryPlanner instance = new QueryPlanner();

    private QueryPlanner() {
    }

    public static QueryPlanner getInstance() {
        return instance;
    }

    public static PlanningEnvironment setupEnvironment(IRequestEnvironment reqEnv) {
        return QueryPlanner.setupEnvironment(reqEnv, true);
    }

    public static PlanningEnvironment setupEnvironment(IRequestEnvironment reqEnv, boolean openPlanLog) {
        PlanningEnvironment environment = reqEnv.getEnvFactory().createPlanningEnvironment();
        XQETrace trace = null;
        if (openPlanLog) {
            trace = environment.openPlanningLog(reqEnv);
            QueryEngineLoggingUtils.addTraceLevels(trace, reqEnv);
            environment.determineJDBCTraceFileName(reqEnv);
        } else {
            trace = new XQETrace();
        }
        XQEUberNodeFactory uberNodeFactory = new XQEUberNodeFactory();
        uberNodeFactory.setTrace(trace);
        uberNodeFactory.setPlanningEnvironment(environment);
        uberNodeFactory.addNodeFactory(new RSAPINodeFactory());
        uberNodeFactory.addNodeFactory(new OLAPNodeFactory());
        uberNodeFactory.addNodeFactory(new SQLNodeFactory());
        uberNodeFactory.addNodeFactory(new XNodeFactory());
        uberNodeFactory.addNodeFactory(new LocalProcessingNodeFactory());
        uberNodeFactory.addNodeFactory(new MDXNodeFactory());
        uberNodeFactory.addNodeFactory(new RQPNodeFactory());
        uberNodeFactory.addNodeFactory(new QEPNodeFactory());
        uberNodeFactory.addNodeFactory(new MANodeFactory());
        uberNodeFactory.addNodeFactory(new MXNodeFactory());
        V5NodeFactory v5Factory = new V5NodeFactory();
        uberNodeFactory.addNodeFactory(v5Factory);
        uberNodeFactory.setV5NodeFactory(v5Factory);
        V5ExpNodeFactory v5ExpFactory = new V5ExpNodeFactory();
        uberNodeFactory.addNodeFactory(v5ExpFactory);
        uberNodeFactory.setV5ExpNodeFactory(v5ExpFactory);
        environment.setTrace(trace);
        environment.setNodeFactory(uberNodeFactory);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        environment.setRuleFactory(ruleFactory);
        EdgeElementFactory edgeElementFactory = new EdgeElementFactory();
        environment.setEdgeElementFactory(edgeElementFactory);
        environment.setPlanningActive(reqEnv);
        return environment;
    }

    private PlanningEnvironment setupQuery(Document aDocument, PlanningEnvironment planEnv) {
        Element rootElement = aDocument.getRootElement();
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv.getConnectionElement() == null) {
            execEnv.setConnectionElement(rootElement.element("connection"));
        }
        XQETrace trace = planEnv.getTrace();
        planEnv.enableReadV5SpecFormat();
        Element querySetElement = rootElement.element("querySet");
        if (querySetElement == null) {
            querySetElement = rootElement.element("V5QuerySet");
            planEnv.disableReadV5SpecFormat();
        }
        if (querySetElement == null) {
            trace.beginElement(XML_ELEMENT_ERROR, 0);
            trace.attribute(XML_ATTRIBUTE_MESSAGE, "Not a valid V5 query...");
            trace.endElement();
            return null;
        }
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory uberNodeFactory = planEnv.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)uberNodeFactory.createV5Node("querySet");
        planEnv.getNodeIndex().addNode(v5QuerySet);
        v5QuerySet.capture(planEnv, querySetElement);
        v5QuerySet.recordPropertyElements(rootElement);
        v5QuerySet.setRetrieveDatasetArray(reqEnv.getRetrieveDatasets(rootElement));
        planEnv.setRoot(v5QuerySet);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        planEnv.setNodeFactory(uberNodeFactory);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        planEnv.setRuleFactory(ruleFactory);
        planEnv.resetTreeHasBeenModified();
        return planEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plan(IXQEQueryNode node, PlanningEnvironment environment) {
        long startPlanTime = System.currentTimeMillis();
        if (node instanceof V5QuerySet) {
            CollectXQELogs xqeLogs = new CollectXQELogs(((RequestEnvironment)environment.getRequestEnvironment()).getOrCreateReportLogsDir());
            xqeLogs.logV5Request((V5QuerySet)node);
        }
        Writer planningTraceWriter = environment.getCurrentTraceWriter();
        environment.initializePlanning();
        boolean success = false;
        try {
            TransformationEngine.getInstance().applyTransformations(node, environment);
            success = true;
        }
        finally {
            block11: {
                if (planningTraceWriter != null) {
                    try {
                        planningTraceWriter.close();
                    }
                    catch (IOException ioe) {
                        if (!success) break block11;
                        throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ioe);
                    }
                }
            }
            long planTime = System.currentTimeMillis() - startPlanTime;
            environment.setPlanTime(planTime);
            IUsageIndicator planTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLAN_TIME, ((RequestEnvironment)environment.getRequestEnvironment()).getReportName());
            if (planTimeIndicator != null) {
                planTimeIndicator.add(planTime);
            }
            environment.setPlanTime(planTime);
        }
        this.setMoserDatasetLastModified(node, environment);
        environment.finalizePlanning();
        environment.setPlanningInactive();
    }

    private void setMoserDatasetLastModified(IXQEQueryNode qs, PlanningEnvironment planEnv) {
        IXQEQueryNode[] datasets = qs.getDescendantsOfType(401005, true);
        if (datasets != null && datasets.length > 0) {
            RSAPIDataset dataSet = (RSAPIDataset)datasets[0];
            MetadataConnection mdConn = planEnv.getMetadataConnection();
            if (mdConn != null && mdConn instanceof MoserMetadataConnection) {
                MoserMetadataConnection moserConn = (MoserMetadataConnection)mdConn;
                dataSet.setLastModified(moserConn.getDatasetLastModified());
            }
        }
    }

    public PlannedV5QuerySet planQuery(Document aDocument, PlanningEnvironment planEnv) {
        this.setupQuery(aDocument, planEnv);
        V5QuerySet querySet = (V5QuerySet)planEnv.getRoot();
        return this.planQuery(querySet, planEnv);
    }

    public PlannedV5QuerySet restoreQueryPlan(Document aDocument, PlanningEnvironment planEnv, PlannedV5QuerySet planTree) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        this.setupQuery(aDocument, planEnv);
        V5QuerySet querySet = (V5QuerySet)planEnv.getRoot();
        this.setupQueryPlan(querySet, planEnv);
        planTree.setPlanTime(System.currentTimeMillis());
        planTree.setPlanDuration(planEnv.getPlanTime());
        planTree.incrementUseCount();
        planTree.setMasterDetailProvider(reqEnv.getMasterDetailProvider());
        planTree.setCacheable(!querySet.isNonReusable());
        planTree.setGovernorsObj(((ExecutionEnvironment)planEnv.getExecutionEnvironment()).getGovernors());
        planTree.setOperation(reqEnv.getOperationName());
        planTree.setReportName(reqEnv.getReportName());
        planTree.setRetrieveDatasets(querySet.getRetrieveDatasetArray());
        planTree.setCachedCollationKey(((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getLocalCollationSequenceKey());
        if (querySet.isNoDataMode()) {
            planTree.setNoDataMode();
        }
        planEnv.setPlanningInactive();
        planEnv.setRoot(planTree);
        return planTree;
    }

    public PlannedV5QuerySet planQuery(V5QuerySet querySet, PlanningEnvironment planEnv) {
        List<ISource> sources;
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        ZipiBridge.setObjPath(ZipiContext.getQRDName());
        this.plan(querySet, planEnv);
        planEnv.setPlanningActive(reqEnv);
        planEnv.getTrace().removeTraceLevel(256);
        PlannedV5QuerySet plannedV5QuerySet = (PlannedV5QuerySet)planEnv.getNodeFactory().createXNode(501133);
        plannedV5QuerySet.setPlanTime(System.currentTimeMillis());
        plannedV5QuerySet.setPlanDuration(planEnv.getPlanTime());
        plannedV5QuerySet.incrementUseCount();
        plannedV5QuerySet.setMasterDetailProvider(reqEnv.getMasterDetailProvider());
        plannedV5QuerySet.setCacheable(!querySet.isNonReusable());
        plannedV5QuerySet.setGovernorsObj(((ExecutionEnvironment)planEnv.getExecutionEnvironment()).getGovernors());
        plannedV5QuerySet.setOperation(reqEnv.getOperationName());
        plannedV5QuerySet.setReportName(reqEnv.getReportName());
        plannedV5QuerySet.setRetrieveDatasets(querySet.getRetrieveDatasetArray());
        if (querySet.isExecutingSqlQuery()) {
            plannedV5QuerySet.setExecutingSqlQuery();
            Set sqlQueryFM = (Set)querySet.getPropertyValue("sqlQueryFM");
            if (sqlQueryFM != null) {
                plannedV5QuerySet.setSqlQueryFMPackages(sqlQueryFM);
            }
        }
        plannedV5QuerySet.setCachedCollationKey(((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getLocalCollationSequenceKey());
        if (querySet.isNoDataMode()) {
            plannedV5QuerySet.setNoDataMode();
        }
        if ((sources = querySet.getSources()) != null && !sources.isEmpty()) {
            plannedV5QuerySet.setSources(sources);
        }
        if (querySet.getQueryRefersToFMPackage()) {
            plannedV5QuerySet.setQueryRefersToFMPackage();
        }
        for (IXQEQueryNode child : querySet.getChildren()) {
            child.move(plannedV5QuerySet);
        }
        if (planEnv.getPlanningMode() == QTEPlanningEnvironment.PlanningMode.Compiling) {
            PersistentQueryPlan qp = planEnv.getQueryPlan();
            qp.addPlan(planEnv, plannedV5QuerySet);
        }
        planEnv.setPlanningInactive();
        planEnv.setRoot(plannedV5QuerySet);
        long effectiveDataCacheExpiry = RQPUtilities.getDataCacheExpiryFromGovernors(planEnv, plannedV5QuerySet);
        if (effectiveDataCacheExpiry > 0L && plannedV5QuerySet.getChild(0) != null && plannedV5QuerySet.getChild(0).getType() == 401005) {
            RSAPIDataset dataSet = (RSAPIDataset)plannedV5QuerySet.getChild(0);
            dataSet.setDataCacheExpiry(effectiveDataCacheExpiry);
        }
        return plannedV5QuerySet;
    }

    public static void logEnvMap(RequestEnvironment reqEnv, PlanningEnvironment planEnv, String loc) {
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RequestAdapter", LogLevel.INFO);
        if (logger.isOn(LogLevel.INFO)) {
            ParameterAccessCoordinator p = reqEnv.getParameterAccessCoordinator(planEnv);
            String envContent = p.getEnvMapAsCSV();
            String bld = "_env @" + loc + "\n" + envContent;
            logger.log(LogLevel.INFO, bld);
        }
    }

    public PlannedV5QuerySet planQueryAllowPlanReuse(Document requestDocument, PlanningEnvironment planEnv, String planKey) {
        Element rootElement = requestDocument.getRootElement();
        Element parametersElement = rootElement.element("parameters");
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        reqEnv.initializeRequestPAC(requestDocument.getRootElement());
        QueryPlanner.logEnvMap(reqEnv, planEnv, "planQuery");
        String[] retrievedDatasets = reqEnv.getRetrieveDatasets(rootElement);
        if (retrievedDatasets != null && retrievedDatasets.length != 0) {
            StringBuilder qrdNames = new StringBuilder();
            for (String qrdName : retrievedDatasets) {
                qrdNames.append(qrdName);
            }
            ZipiContext.clearAndSetQRDName(qrdNames.toString());
        }
        reqEnv.setRetrieveDatasets(retrievedDatasets);
        PlannedV5QuerySet planTree = this.getCachedPlanAndMergeParameters(requestDocument, planKey, planEnv, parametersElement);
        if (planTree == null) {
            if (this.useQueryPlans(requestDocument)) {
                planEnv.setPlanningMode(QTEPlanningEnvironment.PlanningMode.Compiling);
                planTree = this.planQuery(requestDocument, planEnv);
                QueryPlanner.setCachingPropertiesOnPlanTree(planTree, planKey, reqEnv);
                if (planTree != null) {
                    this.saveQueryPlan(planEnv, planTree);
                }
            } else {
                planTree = this.planQuery(requestDocument, planEnv);
                QueryPlanner.setCachingPropertiesOnPlanTree(planTree, planKey, reqEnv);
            }
        } else if (planEnv.getPlanningMode() == QTEPlanningEnvironment.PlanningMode.Compiled) {
            planTree = this.restoreQueryPlan(requestDocument, planEnv, planTree);
            QueryPlanner.setCachingPropertiesOnPlanTree(planTree, planKey, reqEnv);
        } else {
            planTree.resetProfilingInfo(reqEnv);
            ZipiBridge.setObjPath(ZipiContext.getQRDName());
        }
        return planTree;
    }

    public PlannedV5QuerySet planQueryAllowPlanReuse(V5QuerySet querySet, PlanningEnvironment planEnv) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        XQETrace t = new XQETrace();
        t.addStream(bw);
        querySet.dump(t, false);
        t.flush();
        t.close();
        String planKey = sw.toString();
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        PlannedV5QuerySet planTree = this.getCachedPlanAndMergeParameters(null, planKey, planEnv, null);
        if (planTree == null) {
            planTree = this.planQuery(querySet, planEnv);
            QueryPlanner.setCachingPropertiesOnPlanTree(planTree, planKey, reqEnv);
        }
        return planTree;
    }

    public static void setCachingPropertiesOnPlanTree(PlannedV5QuerySet planTree, String planKey, IRequestEnvironment reqEnv) {
        Governors gov;
        Parameters parameters;
        planTree.setRequestParameters(reqEnv.getRequestParameters());
        planTree.setPlanKey(planKey);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (executionEnvironment.getConnectionSearchPath() != null || executionEnvironment.getDataSourceConnectionName() != null) {
            planTree.setCacheable(false);
        }
        planTree.setResolvedMacros(reqEnv.getResolvedMacros());
        if (reqEnv.isValidateRequest() || reqEnv.isMixedRequest()) {
            planTree.setCacheable(false);
        }
        if ((parameters = reqEnv.getRequestParameters()).containsParameterWithNullOrNilValue()) {
            planTree.setCacheable(false);
        }
        if ((gov = planTree.getGovernorsObj()) != null && gov.getReportAsDatasource()) {
            planTree.setCacheable(false);
        }
        TreeMap<String, ParameterValues> paramValuesUsedbySC = new TreeMap<String, ParameterValues>();
        for (Parameter param : planTree.getRequestParameters().values()) {
            ParameterValues pv;
            if (!param.isUsedByScrollCursor() || (pv = param.getParameterValueItems()) == null) continue;
            paramValuesUsedbySC.put(param.getName(), pv);
        }
        planTree.setParamValuesUsedByScrollCursor(paramValuesUsedbySC);
    }

    public PlannedV5QuerySet getCachedPlanAndMergeParameters(Document requestDocument, String planKey, PlanningEnvironment planEnv, Element parametersElement) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        PlannedV5QuerySet planTree = null;
        Parameters parameters = reqEnv.getRequestParameters();
        if (!(reqEnv.isValidateRequest() || reqEnv.isMixedRequest() || parameters.containsParameterWithNullOrNilValue())) {
            planTree = QueryEngine.getInstance().getCacheManager().getPlanTree(planKey, planEnv);
        }
        if (planTree == null && requestDocument != null && this.useQueryPlans(requestDocument)) {
            planTree = this.prepareQueryPlan(planEnv, reqEnv, requestDocument);
        }
        if (planTree != null) {
            QueryPlanner.reactivatePlanningEnvironment(reqEnv, planEnv);
            if (null == planEnv.getMetadataConnection()) {
                MetadataConnection mdConnection = planTree.getMetadataConnection();
                planEnv.setMetdataConnection(mdConnection);
            }
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            if (planEnv.getMetadataConnection() != null) {
                List<IModelDataSource> modelDataSources = planEnv.getMetadataConnection().getModelDataSources();
                for (IModelDataSource modelDS : modelDataSources) {
                    executionEnvironment.getOrAddDataSource(modelDS);
                }
            }
            Parameters cachedParameters = planTree.getRequestParameters();
            executionEnvironment.getMultiRequestContext().getRequestParameters().mergeCachedParameters(cachedParameters, reqEnv);
            if (planTree.getMasterDetailProvider() != null) {
                reqEnv.setMasterDetailProvider(planTree.getMasterDetailProvider());
            } else {
                planTree.setMasterDetailProvider(reqEnv.getMasterDetailProvider());
            }
            if (parametersElement != null) {
                parameters.prepare(parametersElement, planEnv);
            }
            planTree.resetProfilingInfo((IRequestEnvironment)planEnv.getRequestEnvironment());
            String collationKey = planTree.getCachedCollationKey();
            if (collationKey != null) {
                executionEnvironment.registerDataSourceCollationInformation(collationKey, null);
            }
        }
        return planTree;
    }

    public IXQEQueryNode planDescribeDataSourceQuery(Document requestDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = this.setupDescribeDataSourceQuery(requestDocument, reqEnv);
        IXQEQueryNode node = environment.getRoot();
        reqEnv.initializeRequestPAC(requestDocument.getRootElement());
        this.plan(node, environment);
        return node;
    }

    public IXQEQueryNode planMetadataQuery(Document aDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = this.setupMetadataQuery(aDocument, reqEnv);
        IXQEQueryNode node = environment.getRoot();
        this.plan(node, environment);
        environment.closePlanningLog();
        return node;
    }

    public IXQEQueryNode planMoserQuery(Document aDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = this.setupMoserQuery(aDocument, reqEnv);
        IXQEQueryNode node = environment.getRoot();
        this.plan(node, environment);
        environment.closePlanningLog();
        return node;
    }

    private PlanningEnvironment setupMoserQuery(Document requestDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = QueryPlanner.setupEnvironment(reqEnv);
        Element rootElement = requestDocument.getRootElement();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv.getConnectionElement() == null) {
            execEnv.setConnectionElement(rootElement.element("connection"));
        }
        XQETrace trace = environment.getTrace();
        reqEnv.initializeRequestPAC(requestDocument.getRootElement());
        QueryPlanner.logEnvMap(reqEnv, environment, "setupMoserQuery");
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator(environment);
        ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).setPAC(pac);
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory uberNodeFactory = environment.getNodeFactory();
        Element functionSpec = rootElement.element("moserFunction");
        String moserFunctionType = "unknown";
        for (Object item : functionSpec.elements()) {
            Element name = ((Element)item).element("name");
            if (!name.getStringValue().equals("moserFunctionType")) continue;
            moserFunctionType = ((Element)item).element("value").getStringValue();
            break;
        }
        if (moserFunctionType.equals("getFacetValues")) {
            GenerateV5QueryFromMoserFacetQuery.generateV5QuerySet(environment, functionSpec);
        } else if (moserFunctionType.equals("getTableValues")) {
            GenerateV5QueryFromMoserTableQuery.generateV5QuerySet(environment, functionSpec);
        } else if (moserFunctionType.equals(V5Constants.GETJOINVALUES)) {
            GenerateV5QueryFromMoserJoinQuery.generateV5QuerySet(environment, functionSpec);
        } else if (moserFunctionType.equals("validate") || moserFunctionType.equals("validateAll")) {
            GenerateV5QueryFromMoserValidate.generateV5QuerySet(environment, functionSpec);
        } else if (moserFunctionType.equals("getTableStatistics")) {
            GenerateV5QueryForTableStatistics.generateV5QuerySet(environment, functionSpec);
        } else if (moserFunctionType.equals("getFunctionList")) {
            GenerateFunctionList.generateMAQuery(environment, functionSpec);
        } else if (moserFunctionType.equals("joingraph")) {
            GenerateJoinGraph.generateV5QuerySet(environment, functionSpec);
        } else {
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserFunctionType, moserFunctionType);
        }
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        environment.setNodeFactory(uberNodeFactory);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        environment.setRuleFactory(ruleFactory);
        return environment;
    }

    public V5UpdateSet planUpdateQuery(Document requestDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = null;
        environment = this.setupUpdateQuery(requestDocument, reqEnv);
        V5UpdateSet updateSet = (V5UpdateSet)environment.getRoot();
        reqEnv.initializeRequestPAC(requestDocument.getRootElement());
        this.plan(updateSet, environment);
        return updateSet;
    }

    private PlanningEnvironment setupMetadataQuery(Document requestDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = QueryPlanner.setupEnvironment(reqEnv);
        Element rootElement = requestDocument.getRootElement();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv.getConnectionElement() == null) {
            execEnv.setConnectionElement(rootElement.element("connection"));
        }
        XQETrace trace = environment.getTrace();
        IXQEQueryNode node = null;
        String nodeName = rootElement.getName();
        if (!nodeName.equals("Metadata")) {
            trace.beginElement(XML_ELEMENT_ERROR, 0);
            trace.attribute(XML_ATTRIBUTE_MESSAGE, "Not a valid MA query...");
            trace.endElement();
            return null;
        }
        reqEnv.initializeRequestPAC(requestDocument.getRootElement());
        QueryPlanner.logEnvMap(reqEnv, environment, "setupMetadataQuery");
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator(environment);
        ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).setPAC(pac);
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory uberNodeFactory = environment.getNodeFactory();
        node = uberNodeFactory.createNode(1101013);
        ((MAQueryNode)node).capture(environment, rootElement);
        environment.setRoot(node);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        environment.setNodeFactory(uberNodeFactory);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        environment.setRuleFactory(ruleFactory);
        return environment;
    }

    private PlanningEnvironment setupDescribeDataSourceQuery(Document aDocument, RequestEnvironment reqEnv) {
        Element querySubjectElement;
        XQETrace trace;
        PlanningEnvironment environment = QueryPlanner.setupEnvironment(reqEnv);
        Element rootElement = aDocument.getRootElement();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv.getConnectionElement() == null) {
            execEnv.setConnectionElement(rootElement.element("connection"));
        }
        boolean loggingOn = ((trace = environment.getTrace()).getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        Element modelPathEle = rootElement.element("modelPath");
        String modelPath = modelPathEle.getText();
        modelPath = modelPath.trim();
        String modelType = modelPathEle.attributeValue(TYPE);
        XQENodeFactory uberNodeFactory = environment.getNodeFactory();
        Element sqlQueryElement = rootElement.element(SQLQUERY);
        if (sqlQueryElement != null) {
            V5SqlQuery v5SqlQuery = (V5SqlQuery)uberNodeFactory.createV5Node(SQLQUERY);
            environment.getNodeIndex().addNode(v5SqlQuery);
            v5SqlQuery.capture(environment, sqlQueryElement);
            v5SqlQuery.setModel(modelPath);
            environment.setRoot(v5SqlQuery);
        }
        if ((querySubjectElement = rootElement.element("querySubject")) != null) {
            V5QuerySubject v5QuerySubject = (V5QuerySubject)uberNodeFactory.createV5Node("querySubject");
            environment.getNodeIndex().addNode(v5QuerySubject);
            v5QuerySubject.capture(environment, querySubjectElement);
            v5QuerySubject.setModel(modelPath);
            environment.setRoot(v5QuerySubject);
        }
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, (IExecutionEnvironment)environment.getExecutionEnvironment(), true);
        reqEnv.setModelPath(modelPath);
        environment.setMetdataConnection(metadataConnection);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        environment.setNodeFactory(uberNodeFactory);
        OLAPDecorationRulesFactory ruleFactory = new OLAPDecorationRulesFactory();
        environment.setRuleFactory(ruleFactory);
        return environment;
    }

    private PlanningEnvironment setupUpdateQuery(Document aDocument, RequestEnvironment reqEnv) {
        PlanningEnvironment environment = QueryPlanner.setupEnvironment(reqEnv);
        Element rootElement = aDocument.getRootElement();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv.getConnectionElement() == null) {
            execEnv.setConnectionElement(rootElement.element("connection"));
        }
        XQETrace trace = environment.getTrace();
        Element updateSetElement = rootElement.element("updateSet");
        if (updateSetElement == null) {
            trace.beginElement(XML_ELEMENT_ERROR, 0);
            trace.attribute(XML_ATTRIBUTE_MESSAGE, "Not a valid V5 UpdateSet...");
            trace.endElement();
            return null;
        }
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory uberNodeFactory = environment.getNodeFactory();
        V5UpdateSet v5UpdateSet = (V5UpdateSet)uberNodeFactory.createNode(101070);
        environment.getNodeIndex().addNode(v5UpdateSet);
        v5UpdateSet.capture(environment, updateSetElement);
        Element modelPathEle = updateSetElement.element("modelPath");
        String modelPath = modelPathEle.getText();
        modelPath = modelPath.trim();
        String modelType = modelPathEle.attributeValue(TYPE);
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, (IExecutionEnvironment)environment.getExecutionEnvironment(), true);
        v5UpdateSet.setMetadataConnection(metadataConnection);
        reqEnv.setModelPath(modelPath);
        environment.setMetdataConnection(metadataConnection);
        environment.setRoot(v5UpdateSet);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        environment.setNodeFactory(uberNodeFactory);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        return environment;
    }

    public static void reactivatePlanningEnvironment(RequestEnvironment reqEnv, PlanningEnvironment planEnv) {
        XQETrace trace = planEnv.openPlanningLog(reqEnv);
        QueryEngineLoggingUtils.addTraceLevels(trace, reqEnv);
        planEnv.setPlanningActive(reqEnv);
    }

    public PlannedV5QuerySet planConvertedToV5Query(IXQEQueryNode rootQueryNode, PlanningEnvironment planEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        this.plan(rootQueryNode, planEnv);
        planEnv.setPlanningActive(reqEnv);
        planEnv.getTrace().removeTraceLevel(256);
        PlannedV5QuerySet plannedV5QuerySet = (PlannedV5QuerySet)planEnv.getNodeFactory().createXNode(501133);
        plannedV5QuerySet.setPlanTime(System.currentTimeMillis());
        plannedV5QuerySet.setPlanDuration(planEnv.getPlanTime());
        plannedV5QuerySet.incrementUseCount();
        plannedV5QuerySet.setMasterDetailProvider(reqEnv.getMasterDetailProvider());
        plannedV5QuerySet.setCacheable(false);
        plannedV5QuerySet.setGovernorsObj(((ExecutionEnvironment)planEnv.getExecutionEnvironment()).getGovernors());
        IXQEQueryNode v5QuerySet = rootQueryNode.getChild(0);
        for (IXQEQueryNode child : v5QuerySet.getChildren()) {
            child.move(plannedV5QuerySet);
        }
        v5QuerySet.extract();
        planEnv.setPlanningInactive();
        planEnv.setRoot(plannedV5QuerySet);
        return plannedV5QuerySet;
    }

    private PlannedV5QuerySet prepareQueryPlan(PlanningEnvironment planEnv, RequestEnvironment reqEnv, Document requestDocument) {
        List<IModelDataSource> dataSources;
        PlannedV5QuerySet result = null;
        MetadataConnection metadataConnection = planEnv.getMetadataConnection();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)planEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(reqEnv, "mfwRequest");
            String modelPath = reqEnv.getModelPath();
            metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(reqEnv.getModelType(), modelPath), modelPath, execEnv, true);
            MetricsService.endCollectingMetric(reqEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        planEnv.setMetdataConnection(metadataConnection);
        result = PersistentQueryPlan.readPlan(planEnv, reqEnv, requestDocument);
        if (result != null) {
            planEnv.setPlanningMode(QTEPlanningEnvironment.PlanningMode.Compiled);
        }
        return result;
    }

    private void setupQueryPlan(V5QuerySet querySet, PlanningEnvironment environment) {
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        ParameterAccessCoordinator pac = ((RequestEnvironment)environment.getRequestEnvironment()).getParameterAccessCoordinator(environment);
        ParameterMapsApp hintMap = new ParameterMapsApp("_governor", IParameterMaps.EPRIORITY.CQE_REQUEST.getKey());
        if (querySet.containsRequestHints()) {
            for (V5QuerySet.RequestHint requestHint : V5QuerySet.RequestHint.values()) {
                String hintName = requestHint.getPropertyName();
                Object value = querySet.getPropertyValue(hintName);
                if (value == null) continue;
                if (value instanceof String) {
                    hintMap.set("_governor", hintName, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    hintMap.set("_governor", hintName, Boolean.toString((Boolean)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                hintMap.set("_governor", hintName, Integer.toString((Integer)value));
            }
        }
        if (hintMap.getSize() > 0) {
            pac.addParameterMap(hintMap);
        }
        Governors governors = new Governors();
        governors.loadGovernors(pac);
        querySet.setGovernors(governors);
        execEnv.setGovernors(governors);
    }

    private void saveQueryPlan(PlanningEnvironment env, PlannedV5QuerySet qs) {
        PersistentQueryPlan qp = env.getQueryPlan();
        IXQEQueryNode[] datasets = qs.getDescendantsOfType(401005, true);
        if (datasets != null && datasets.length > 0) {
            RSAPIDataset dataSet = (RSAPIDataset)datasets[0];
            dataSet.setQueryPlan(qp.getBytes(env));
        }
    }

    private boolean useQueryPlans(Document requestDocument) {
        Element child;
        String value;
        boolean result = false;
        Element v5RootElement = requestDocument.getRootElement();
        List list = v5RootElement.elements("useQueryPlans");
        if (list.size() > 0 && (value = (child = (Element)list.get(0)).attributeValue("value")) != null && value.equals("true")) {
            result = true;
        }
        return result;
    }
}

