/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.IProfiledIterator;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.Timer;

public abstract class BaseIterator
implements IIterator,
IProfiledIterator {
    private long count;
    private long cpuTime;
    private long elapsedTime;
    protected Integer nodeId;
    private boolean profilingEnabled;
    private int edgeOrdinal;
    protected final XDataContext context;

    public BaseIterator(XDataContext xDataContext, Integer id) {
        if (null == xDataContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "XDataContext cannot be null");
        }
        this.context = xDataContext;
        this.nodeId = id;
        this.edgeOrdinal = -1;
        if (IteratorProfilingManager.getInstance().register(this)) {
            this.count = 0L;
            this.elapsedTime = 0L;
            this.profilingEnabled = true;
        }
    }

    public void enableProfiling() {
        this.profilingEnabled = true;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    @Override
    public final Object next() {
        if (this.context.isCanceled()) {
            throw new OperationCanceledException(this.context.getCancelSource());
        }
        long elapsedStart = 0L;
        long cpuStart = 0L;
        if (this.profilingEnabled) {
            elapsedStart = System.nanoTime();
            cpuStart = Timer.getCurrentThreadCpuTime();
        }
        Object row = this.nextImpl();
        ++this.count;
        if (this.profilingEnabled) {
            this.cpuTime += Timer.getCurrentThreadCpuTime() - cpuStart;
            this.elapsedTime += System.nanoTime() - elapsedStart;
        }
        return row;
    }

    public abstract Object nextImpl();

    protected boolean getProfilingEnabled() {
        return this.profilingEnabled;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public void startTimer() {
        this.elapsedTime = System.nanoTime();
        this.cpuTime = Timer.getCurrentThreadCpuTime();
    }

    public void stopTimer() {
        this.cpuTime = Timer.getCurrentThreadCpuTime() - this.cpuTime;
        this.elapsedTime = System.nanoTime() - this.elapsedTime;
    }

    @Override
    public long getTotalCPUTime() {
        return this.cpuTime;
    }

    @Override
    public long getTotalElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Integer getNodeId() {
        return this.nodeId;
    }

    public int getEdgeNumber() {
        return this.edgeOrdinal;
    }

    public void setEdgeNumber(int edgeO) {
        this.edgeOrdinal = edgeO;
    }

    public XDataContext getDataContext() {
        return this.context;
    }

    @Override
    public void release() {
    }

    public long positionOnRow(long detailRowNumber, boolean top) {
        return -1L;
    }
}

