/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;

public class CachedResultSetManagerAdapter {
    private static final int THRESHOLD_DEFAULT = 250;
    private static final int MAX_MEMORY_DEFAULT = 4;
    private CachedResultSetManager cacheManager = null;

    public CachedResultSetManagerAdapter() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int memory = config.getIntProperty("general.queryReuse.data[@maxMemory]", 4);
        int threshold = config.getIntProperty("general.queryReuse.data[@threshold]", 250);
        this.cacheManager = new CachedResultSetManager(true, memory, threshold);
    }

    public void configure() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int memory = config.getIntProperty("general.queryReuse.data[@maxMemory]", 4);
        int threshold = config.getIntProperty("general.queryReuse.data[@threshold]", 250);
        this.cacheManager.configure(true, memory, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITabularResultSet getOrCreateResultSet(XDataContext context, XNode executionPlan, ReleasableResourceTracker tracker, String key) {
        ITabularResultSet oResult = null;
        XNode xNode = executionPlan;
        synchronized (xNode) {
            IUsageIndicator indicator;
            oResult = this.cacheManager.getCachedResultSet(key);
            if (oResult == null) {
                indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.REUSED_QUERY_CACHE_MISSES, context.getEnvironment().getRequestEnvironment().getReportName());
                if (indicator != null) {
                    indicator.add(1L);
                }
            } else {
                indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.REUSED_QUERY_CACHE_HITS, context.getEnvironment().getRequestEnvironment().getReportName());
                if (indicator != null) {
                    indicator.add(1L);
                }
            }
            if (oResult == null) {
                TabularHybridResultSet iResult = null;
                XDataContext detachedContext = new XDataContext(null, context.getEnvironment());
                detachedContext.incrementRefCount();
                try {
                    iResult = (TabularHybridResultSet)executionPlan.execute(detachedContext);
                }
                finally {
                    detachedContext.decrementRefCount();
                }
                if (context.getEnvironment().getRequestEnvironment().isValidateRequest()) {
                    return iResult;
                }
                oResult = this.cacheManager.createCachedResultSet(detachedContext, iResult, null, tracker, key, null);
            }
        }
        return oResult;
    }

    public void clearCache() {
        this.cacheManager.release();
    }

    public void clearCachedResultSet(long idleTime) {
        this.cacheManager.removeResultSet(idleTime);
    }

    public void removeResultSet(String key) {
        this.cacheManager.removeResultSet(key);
    }

    public int getMaxMemory() {
        return this.cacheManager.getMaxMemory();
    }

    public void setMaxMemory(int newValue) {
        this.cacheManager.setMaxMemory(newValue);
    }

    public int getThreshold() {
        return this.cacheManager.getThreshold();
    }

    public void setThreshold(int newValue) {
        this.cacheManager.setThreshold(newValue);
    }
}

