/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XIteratorAdaptor;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.mdx.CubeResultScrollableIteratorWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LinkedStack;
import java.util.Iterator;

public class CubicsDimensionalResultSet
extends XResultSetBase
implements ICubeResultSet {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.WARN);
    static final long serialVersionUID = 1L;
    private IResultSet resultSet;

    public CubicsDimensionalResultSet(XDataContext xDataContext, IResultSet theResultSet, Integer theNodeId) {
        super(xDataContext, theNodeId);
        this.resultSet = theResultSet;
    }

    @Override
    public XIterator getAxisIterator(int axisNumber) {
        if (axisNumber < 0 || axisNumber >= this.resultSet.getNumberOfAxes()) {
            return null;
        }
        return new XIteratorAdaptor(this.getDataContext(), this.resultSet.getAxis(axisNumber).iterator(), this.nodeId);
    }

    @Override
    public XCellIterator getCellIterator() {
        return new CubicsCellIterator(this.getDataContext(), this.nodeId);
    }

    @Override
    public int getNumAxes() {
        return this.resultSet.getNumberOfAxes();
    }

    @Override
    public ITuple getSlicer() {
        ISet slicer = this.resultSet.getSlicer();
        if (slicer.size() == 0L) {
            return null;
        }
        return slicer.getTuple(0L);
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        Set set = (Set)this.resultSet.getAxis(axisNumber);
        return new CubeResultScrollableIteratorWrapper(this.getDataContext(), this.nodeId, set.getScrollableIterator());
    }

    @Override
    public IDimension[] getDimensions(int axisNumber) {
        return this.resultSet.getAxis(axisNumber).getDimensions();
    }

    @Override
    public long getAxisSize(int axisNumber) {
        return this.resultSet.getAxis(axisNumber).size();
    }

    @Override
    public int getNumTabularMeasures() {
        return 0;
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public IResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
    }

    @Override
    public void releaseImpl() {
    }

    protected void closeCube() {
        InterpreterContext context = this.getDataContext().getInterpreterContext();
        if (context == null) {
            return;
        }
        ICube cube = context.getCube();
        if (cube instanceof DMRCube) {
            try {
                ((DMRCube)cube).close();
            }
            catch (Exception e) {
                LOGGER.log(e);
            }
        }
    }

    class CubicsCellIterator
    extends XCellIterator {
        private Iterator<ICell> iterator;

        CubicsCellIterator(XDataContext xDataContext, Integer theNodeId) {
            super(xDataContext, theNodeId);
            this.iterator = CubicsDimensionalResultSet.this.resultSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ICell nextImpl() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            ICell c = this.iterator.next();
            if (null != c) {
                ++this.currentOrdinal;
            }
            return c;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean hasPipelineIterator() {
            return this.iterator instanceof PipelineIterator;
        }
    }
}

