/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.SetBase;
import com.cognos.xqe.resultsets.md.Tuple;
import org.apache.commons.collections.set.ListOrderedSet;

public class Set
extends SetBase {
    private static final long serialVersionUID = 1L;
    private Tuple[] tuples;

    public Set() {
        this.tuples = new Tuple[0];
    }

    public Set(Tuple tuple) {
        this(new Tuple[]{tuple});
    }

    public Set(Tuple[] aTuples) {
        this.tuples = aTuples;
    }

    @Override
    public Object copy() {
        Set clone = (Set)super.copy();
        clone.tuples = (Tuple[])this.tuples.clone();
        return clone;
    }

    @Override
    public ITuple getTuple(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new Error("Attempting to index a tuple greater than the largest possible index.");
        }
        return this.tuples[(int)index];
    }

    @Override
    public ISet removeDimension(IDimension d, boolean retainDuplicates) {
        SetBase result;
        if (this.contains(d)) {
            this.resetDimensionCardinality();
            if (!this.isEmpty()) {
                ListOrderedSet localTuples = new ListOrderedSet();
                if (!retainDuplicates) {
                    localTuples = ListOrderedSet.decorate((java.util.Set)localTuples);
                }
                int j = 0;
                while ((long)j < this.size()) {
                    ITuple t = this.getTuple(j);
                    t = t.remove(d);
                    localTuples.add((Object)t);
                    ++j;
                }
                result = new Set((Tuple[])localTuples.toArray((Object[])new Tuple[0]));
            } else {
                result = new Set();
            }
        } else {
            result = (SetBase)this.copy();
        }
        return result;
    }

    @Override
    public ISet removeHierarchy(IHierarchy h, boolean retainDuplicates) {
        SetBase result;
        if (this.contains(h)) {
            this.resetDimensionCardinality();
            if (!this.isEmpty()) {
                ListOrderedSet localTuples = new ListOrderedSet();
                if (!retainDuplicates) {
                    localTuples = ListOrderedSet.decorate((java.util.Set)localTuples);
                }
                int j = 0;
                while ((long)j < this.size()) {
                    ITuple t = this.getTuple(j);
                    t = t.remove(h);
                    localTuples.add((Object)t);
                    ++j;
                }
                result = new Set((Tuple[])localTuples.toArray((Object[])new Tuple[0]));
            } else {
                result = new Set();
            }
        } else {
            result = (SetBase)this.copy();
        }
        return result;
    }

    @Override
    public long size() {
        return this.tuples.length;
    }
}

