/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultset.interfaces.IDataItemInfo;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ILevelInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.BaseScrollableIterator;
import com.cognos.xqe.resultsets.md.Set;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class SetBase
implements Cloneable,
ISet {
    private int[] dimensionCardinality;

    @Override
    public abstract ITuple getTuple(long var1);

    @Override
    public abstract ISet removeDimension(IDimension var1, boolean var2);

    @Override
    public abstract long size();

    @Override
    public boolean isLargeSet() {
        return this.size() < 0L;
    }

    @Override
    public Object copy() {
        try {
            SetBase clone = (SetBase)super.clone();
            if (this.dimensionCardinality != null) {
                clone.dimensionCardinality = (int[])this.dimensionCardinality.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public boolean contains(IDimension dimension) {
        boolean result = false;
        if (this.size() > 0L) {
            result = this.getTuple(0L).contains(dimension);
        }
        return result;
    }

    @Override
    public boolean contains(IHierarchy hierarchy) {
        boolean result = false;
        if (this.size() > 0L) {
            result = this.getTuple(0L).contains(hierarchy);
        }
        return result;
    }

    @Override
    public IDimension[] getDimensions() {
        if (this.size() > 0L) {
            return this.getTuple(0L).getDimensions();
        }
        return new IDimension[0];
    }

    @Override
    public IHierarchy[] getHierarchies() {
        if (this.size() > 0L) {
            return this.getTuple(0L).getHierarchies();
        }
        return new IHierarchy[0];
    }

    @Override
    public int[] getDimensionCardinality() {
        if (this.dimensionCardinality == null) {
            int i;
            IHierarchy[] hiers = this.getHierarchies();
            HashSet[] hs = new HashSet[hiers.length];
            for (int i2 = 0; i2 < hs.length; ++i2) {
                hs[i2] = new HashSet();
            }
            IIterator it = this.iterator();
            Tuple t = (Tuple)it.next();
            while (t != null) {
                for (i = 0; i < t.size(); ++i) {
                    hs[i].add(t.getMember(i));
                }
                t = (Tuple)it.next();
            }
            this.dimensionCardinality = new int[hiers.length];
            for (i = 0; i < hs.length; ++i) {
                this.dimensionCardinality[i] = hs[i].size();
            }
        }
        return this.dimensionCardinality;
    }

    @Override
    public IDataItemInfo[] getDataItemInfo(IDimension d) {
        return null;
    }

    @Override
    public ILevelInfo[] getLevelInfo(int index) {
        return null;
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        ListOrderedSet result = new ArrayList();
        result = ListOrderedSet.decorate((List)((List)result));
        IIterator it = this.iterator();
        Tuple t = (Tuple)it.next();
        while (t != null) {
            IMember m = t.getMember(d);
            if (m != null) {
                result.add(m);
            }
            t = (Tuple)it.next();
        }
        return result.toArray(new IMember[result.size()]);
    }

    @Override
    public IMember[][] getMembers(IDimension[] d) {
        IMember[][] result = new IMember[d.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getMembers(d[i]);
        }
        return result;
    }

    @Override
    public IMember[] getMembers(IHierarchy h) {
        ListOrderedSet result = new ListOrderedSet();
        result = ListOrderedSet.decorate((java.util.Set)result);
        IIterator setIter = this.iterator();
        while (setIter.hasNext()) {
            Tuple tuple = (Tuple)((ITuple)setIter.next()).copy();
            IMember m = tuple.getMember(h);
            if (m == null || result.contains((Object)m)) continue;
            result.add((Object)m);
        }
        return (IMember[])result.toArray((Object[])new IMember[result.size()]);
    }

    @Override
    public IMember[][] getMembers(IHierarchy[] h) {
        IMember[][] result = new IMember[h.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getMembers(h[i]);
        }
        return result;
    }

    @Override
    public long[] getOrdinals(ITuple tuple) {
        return this.getOrdinals(tuple, true);
    }

    public long[] getOrdinals(ITuple tuple, boolean exactMatch) {
        long[] result = new long[]{};
        int count = 0;
        int i = 0;
        IIterator it = this.iterator();
        if (exactMatch) {
            Tuple t = (Tuple)it.next();
            while (t != null) {
                if (t.equals(tuple)) {
                    if (count == result.length) {
                        long[] newIndexes = new long[result.length + 1];
                        System.arraycopy(result, 0, newIndexes, 0, result.length);
                        result = newIndexes;
                    }
                    result[count++] = i;
                }
                ++i;
                t = (Tuple)it.next();
            }
        } else {
            Tuple t = (Tuple)it.next();
            while (t != null) {
                if (t.contains(tuple)) {
                    if (count == result.length) {
                        long[] newIndexes = new long[result.length + 1];
                        System.arraycopy(result, 0, newIndexes, 0, result.length);
                        result = newIndexes;
                    }
                    result[count++] = i;
                }
                ++i;
                t = (Tuple)it.next();
            }
        }
        return result;
    }

    @Override
    public ISet getSingleTupleSet() {
        if (this.dimensionCardinality == null) {
            this.getDimensionCardinality();
        }
        ArrayList<IMember> al = new ArrayList<IMember>();
        if (this.size() > 0L) {
            ITuple t = this.getTuple(0L);
            for (int i = 0; i < this.dimensionCardinality.length; ++i) {
                if (this.dimensionCardinality[i] != 1) continue;
                al.add(t.getMember(i));
            }
        }
        return new Set(new Tuple(al.toArray(new IMember[0])));
    }

    @Override
    public ISet getMultipleTupleSets() {
        ISet singleTupleSet = this.getSingleTupleSet();
        return this.removeHierarchies(singleTupleSet.getHierarchies(), true);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public ISet removeDimensions(IDimension[] d) {
        return this.removeDimensions(d, true);
    }

    @Override
    public ISet removeHierarchies(IHierarchy[] h, boolean retainDuplicates) {
        ISet result = this;
        for (int i = 0; i < h.length; ++i) {
            result = result.removeHierarchy(h[i], retainDuplicates);
        }
        return result;
    }

    @Override
    public ISet removeDimensions(IDimension[] d, boolean retainDuplicates) {
        ISet result = this;
        for (int i = 0; i < d.length; ++i) {
            result = result.removeDimension(d[i], retainDuplicates);
        }
        return result;
    }

    @Override
    public ISet removeDimension(IDimension d) {
        return this.removeDimension(d, true);
    }

    @Override
    public void resetDimensionCardinality() {
        this.dimensionCardinality = null;
    }

    @Override
    public IIterator iterator() {
        return new SetIterator(this);
    }

    @Override
    public IIterator iterator(long start, long count) {
        return new SetIterator(this, start, count);
    }

    public IScrollableIterator getScrollableIterator() {
        return new SetIterator(this);
    }

    public IIterator dimensionOrderedIterator(IDimension[] dimensionOrder) {
        return new DimensionOrderedSetIterator((ISet)this, dimensionOrder);
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (!(other instanceof ISet)) {
            return -1;
        }
        ISet otherSet = (ISet)other;
        if (this.size() < otherSet.size()) {
            return -1;
        }
        if (this.size() > otherSet.size()) {
            return 1;
        }
        CompareToBuilder ctb = new CompareToBuilder();
        for (long i = 0L; i < this.size(); ++i) {
            ctb.append((Object)this.getTuple(i), (Object)otherSet.getTuple(i));
        }
        return ctb.toComparison();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof ISet)) {
            return false;
        }
        ISet otherSet = (ISet)other;
        if (this.size() != otherSet.size()) {
            return false;
        }
        for (long i = 0L; i < this.size(); ++i) {
            if (this.getTuple(i).equals(otherSet.getTuple(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        for (long i = 0L; i < this.size(); ++i) {
            hcb.append((Object)this.getTuple(i));
        }
        return hcb.toHashCode();
    }

    public final class DimensionOrderedSetIterator
    extends SetIterator {
        private HashMap<IDimension, Integer> dimensionToIndex;

        private DimensionOrderedSetIterator(ISet cjs, IDimension[] dimensionOrder) {
            super(cjs);
            this.dimensionToIndex = new HashMap();
            for (int i = 0; i < dimensionOrder.length; ++i) {
                this.dimensionToIndex.put(dimensionOrder[i], XQEIntegerPool.getInteger(i));
            }
        }

        @Override
        public Object nextImpl() {
            Tuple t = (Tuple)super.next();
            IMember[] members = new IMember[t.size()];
            for (int i = 0; i < members.length; ++i) {
                IMember m = t.getMember(i);
                Integer index = this.dimensionToIndex.get(m.getLevel().getHierarchy().getDimension());
                members[index.intValue()] = m;
            }
            t = new Tuple(members, false);
            return t;
        }
    }

    public class SetIterator
    extends BaseScrollableIterator {
        protected ISet s;
        protected long index;
        protected long lastTupleOrdinal;
        private IDimension[] currentMemberDims;
        final long startPos;
        private ITuple tupleToReturn;

        public IDimension[] getCurrentMemberDims() {
            return this.currentMemberDims;
        }

        public void setCurrentMemberDims(IDimension[] theCurrentMemberDims) {
            this.currentMemberDims = theCurrentMemberDims;
        }

        protected SetIterator(ISet aS) {
            this(aS, 0L, aS.size());
        }

        protected SetIterator(ISet aS, long start, long count) {
            super(XDataContext.current(), TransformationEngine.DUMMY_NODEID);
            this.index = 0L;
            this.s = aS;
            this.index = start;
            this.lastTupleOrdinal = start + count > this.s.size() ? this.s.size() : start + count;
            if (this.lastTupleOrdinal > 0L) {
                ITuple aTuple = this.s.getTuple(0L);
                IMember[] sourceMembers = aTuple.getMembers();
                this.tupleToReturn = new Tuple(new IMember[sourceMembers.length]);
            }
            this.startPos = start;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public Object nextImpl() {
            if (this.index >= this.lastTupleOrdinal) {
                return null;
            }
            ITuple t = this.s.getTuple(this.index++);
            return this.copyTupleToReturnTuple(t);
        }

        protected ITuple copyTupleToReturnTuple(ITuple aTuple) {
            IMember[] sourceMembers = aTuple.getMembers();
            IMember[] targetMembers = this.tupleToReturn.getMembers();
            System.arraycopy(sourceMembers, 0, targetMembers, 0, targetMembers.length);
            return this.tupleToReturn;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.lastTupleOrdinal;
        }

        public long getEdgeSize() {
            return SetBase.this.size();
        }

        @Override
        public boolean absolute(long iIndex) {
            return iIndex >= this.startPos && iIndex < this.lastTupleOrdinal;
        }

        @Override
        public Object current() {
            if (SetBase.this.size() == 0L) {
                return null;
            }
            ITuple aTuple = this.s.getTuple(this.index);
            return this.copyTupleToReturnTuple(aTuple);
        }

        @Override
        public boolean hasPrevious() {
            return this.index != this.startPos;
        }

        @Override
        public Object previousImpl() {
            if (this.hasPrevious()) {
                ITuple aTuple = this.s.getTuple(++this.index);
                return this.copyTupleToReturnTuple(aTuple);
            }
            return null;
        }

        @Override
        public void reset() {
            this.index = this.startPos;
        }
    }
}

