/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.rsapi.RSAPICell;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeCoordinates;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.xqejapi.IRSAPICellIterator;

public class RSAPICellIterator
implements IRSAPICellIterator,
IReleasable {
    private static final int NEXT_CELL_INITIAL = 0;
    private static final int NEXT_CELL_NOT_READ = 1;
    private static final int NEXT_CELL_READ = 2;
    private int mNextCellRead;
    private XScrollableCellIterator mHResultSetCellIterator;
    private RSAPICell mCell;
    private int mRowNumber;
    private boolean mEodEncountered;
    private RSAPICell mNextCell;
    private int mNumEdges;
    private RSAPIEdgeCoordinates[] mEdgeCoordinates;
    private boolean[] mEmptyEdges;
    private int mOuterMostEdge;
    private boolean mAllowNonNumericCellValues;

    public RSAPICellIterator(RSAPIDataset dataset, RSAPIResultSet resultSet, int[] startRowNumbers, int[] numRows, int[] numCoordinates, RSAPIEdgeIterator[] edgeIterators) {
        RSAPICellRowset cellRowset = dataset.getCellRowset();
        try {
            this.loadConfigurationSettings(dataset.getAllowNonNumericCellValue());
            this.mEmptyEdges = this.identifyEmptyEdges(edgeIterators);
            this.mNumEdges = edgeIterators.length;
            this.mNextCellRead = 0;
            if (resultSet != null) {
                this.mHResultSetCellIterator = resultSet.getCellIterator();
            }
            this.mCell = new RSAPICell(cellRowset, this.mNumEdges);
            this.mEdgeCoordinates = new RSAPIEdgeCoordinates[this.mNumEdges];
            RSAPIEdgeCoordinates priorEdgeInfo = null;
            for (int i = 0; i < this.mNumEdges; ++i) {
                if (this.isEdgeEmpty(i)) continue;
                this.mEdgeCoordinates[i] = numCoordinates == null ? new RSAPIEdgeCoordinates(resultSet, edgeIterators[i], i == this.mOuterMostEdge, startRowNumbers[i], numRows[i], -1, priorEdgeInfo) : new RSAPIEdgeCoordinates(resultSet, edgeIterators[i], i == this.mOuterMostEdge, startRowNumbers[i], numRows[i], numCoordinates[i], priorEdgeInfo);
                priorEdgeInfo = this.mEdgeCoordinates[i];
            }
            this.reset();
            boolean isPipelining = this.mHResultSetCellIterator.hasPipelineIterator();
            if (!isPipelining && !this.mHResultSetCellIterator.hasNext()) {
                this.mEodEncountered = !dataset.getIncludeEmptyCells();
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    private boolean isEdgeEmpty(int position) {
        return this.mEmptyEdges[position];
    }

    private boolean[] identifyEmptyEdges(RSAPIEdgeIterator[] edgeIterators) {
        int i;
        boolean[] emptyEdges = new boolean[edgeIterators.length];
        for (i = 0; i < edgeIterators.length; ++i) {
            if (edgeIterators[i] == null || !edgeIterators[i].getEdge().isEmpty()) continue;
            emptyEdges[i] = true;
        }
        for (i = edgeIterators.length - 1; i >= 0; --i) {
            if (emptyEdges[i]) continue;
            this.mOuterMostEdge = i;
            break;
        }
        return emptyEdges;
    }

    @Override
    public boolean hasNext() {
        this.positionOnNextRow();
        return !this.mEodEncountered;
    }

    @Override
    public RSAPICell next() {
        this.positionOnNextRow();
        this.mNextCellRead = 2;
        return this.mNextCell;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.mNumEdges; ++i) {
            if (this.isEdgeEmpty(i)) continue;
            this.getEdgeCoordindates(i).reset();
        }
        this.mEodEncountered = false;
        this.mNextCellRead = 0;
        this.mNextCell = null;
        this.mRowNumber = 0;
    }

    public int getNextRowNumber() {
        return ++this.mRowNumber;
    }

    private void positionOnNextRow() {
        if (this.mEodEncountered) {
            this.mNextCell = null;
            return;
        }
        if (this.mNextCellRead == 0) {
            for (int i = 0; i < this.mNumEdges; ++i) {
                RSAPIEdgeCoordinates coordinates = this.getEdgeCoordindates(i);
                if (coordinates == null || !coordinates.isStartCoordinateAtEnd()) continue;
                this.mEodEncountered = true;
                this.mNextCell = null;
                return;
            }
        }
        if (this.mNextCellRead == 1) {
            return;
        }
        if (this.mNextCellRead == 2) {
            this.toNextCell(0);
            if (this.mEodEncountered) {
                this.mNextCell = null;
                return;
            }
        }
        ICell cell = null;
        int ordinal = this.computeOrdinal();
        if (this.mHResultSetCellIterator != null) {
            cell = this.mHResultSetCellIterator.byOrdinal(ordinal);
            IValue cellValue = cell == null ? DoubleValue.NULL_VALUE : cell.getValue();
            this.mCell.setCellValue(cellValue, this.mAllowNonNumericCellValues);
        }
        this.mCell.setCellOrdinal(ordinal);
        for (int i = 0; i < this.mNumEdges; ++i) {
            if (this.isEdgeEmpty(i)) {
                this.mCell.setCoordinate(i, -1);
                continue;
            }
            this.mCell.setCoordinate(i, this.getEdgeCoordindates(i).getCoordinateOfNextCell());
        }
        this.mCell.setRowNumber(this.getNextRowNumber());
        this.mNextCellRead = 1;
        this.mNextCell = this.mCell;
    }

    private int computeOrdinal() {
        return this.getEdgeCoordindates(this.mOuterMostEdge).computeOrdinal();
    }

    private void toNextCell(int edge) {
        if (edge >= this.mNumEdges) {
            this.mEodEncountered = true;
            return;
        }
        if (this.isEdgeEmpty(edge)) {
            this.toNextCell(edge + 1);
            return;
        }
        RSAPIEdgeCoordinates coordinates = this.getEdgeCoordindates(edge);
        coordinates.toNextCoordinate();
        if (coordinates.isEOD()) {
            this.toNextCell(edge + 1);
            if (!this.mEodEncountered) {
                coordinates.reset();
            }
        }
    }

    private RSAPIEdgeCoordinates getEdgeCoordindates(int ordinal) {
        return this.mEdgeCoordinates[ordinal];
    }

    private void loadConfigurationSettings(Boolean allowNonNumeric) {
        this.mAllowNonNumericCellValues = false;
        if (allowNonNumeric != null) {
            this.mAllowNonNumericCellValues = allowNonNumeric;
        } else {
            MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
            XQEConfiguration configuration = multiRequestContext.getXQEConfiguration();
            if (configuration == null) {
                return;
            }
            if (multiRequestContext.fetchBooleanConfiguration("resultSet.allowNonNumericCellValues[@enabled]", false)) {
                this.mAllowNonNumericCellValues = true;
            }
        }
    }

    @Override
    public void release() {
        if (this.mHResultSetCellIterator != null) {
            this.mHResultSetCellIterator.release();
            this.mHResultSetCellIterator = null;
        }
    }
}

