/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEProperty;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.ObjectType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.MetadataConstants;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RSAPIDataItem
implements IXQEProperty,
IXQEPersist {
    private static final String ATTRIBUTE_CURRENCY_CODE = "currencyCode";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_Q_ITEM_MODEL_REF = "qItemModelRef";
    private static final String VALUE_TRUE = "true";
    private static final String STRING_PROPERTY_FORMAT_ID = "formatId";
    private static final String XQE_CUSTOM_PROPERTY_NAME = "XQE_CUSTOM_PROPERTY_NAME";
    public static final String SAP_BUSINESS_KEY = "SAP_BUSINESS_KEY";
    public static final String LINK_PARAMS = "link_parameters";
    private String mName;
    private boolean mNullable = true;
    private boolean mNotApplicableGroupbody = false;
    private boolean mNotApplicable = false;
    private String mLabel;
    private IDataType mType;
    private RSAPIUsage mUsage = RSAPIUsage.NOT_SPECIFIED;
    private RSAPIUsage mOrgUsage = RSAPIUsage.NOT_SPECIFIED;
    private String mCurrencyCode;
    private String mFormat;
    private FormatId mFormatId;
    int mSolveOrder = 0;
    private boolean mIsGroupbodyMeasure = false;
    ILevel[] mLevels;
    String mModelReferenceStr;
    IMetadata mModelReference;
    String mModelId;
    String mModelCalculationID;
    private String mPropertyName;
    private IDataType mPropertyDataType;
    private IDataType mMasterDatasetDataType;
    private List<String> mDependency;
    private boolean mDirectModelReference = true;
    private boolean mIndirectModelReference = true;
    private boolean useModelLabelsForIndirectModelRefs = false;
    private boolean mIsConstant = false;
    private int mSourceRowsetId = -1;
    private List<Integer> mAdditionalDataItemIndices;
    boolean mPreserveMetadata = false;
    private String mResolvedAggregate = null;
    private boolean mIsCustomProperty = false;
    private String mSqlColumnName = null;
    private int mSqlColumnIndex = -1;
    private boolean mAdjustDataTypeFromResultSet = false;
    private boolean mValidateFromFM = false;
    private Parameter linkParam = null;
    public static final String STRING_DATAITEM = "dataItem";
    private static final String STRING_SUBTYPE = "subtype";
    private static final String STRING_NAME = "name";
    private static final String STRING_LABEL = "label";
    private static final String STRING_USAGE = "usage";
    private static final String STRING_COLON = ":";
    private static final String STRING_COMMA_SPACE = ", ";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String STRING_NULLABLE = "nullable";
    private static final String STRING_SOLVEORDER = "solveOrder";
    private static final String STRING_DATATYPE = "datatype";
    private static final String STRING_CCL_DATATYPE = "cclDatatype";
    private static final String ATTRIBUTE_MODEL_ID = "model_ID";
    private static final String STRING_CONSTANT = "constant";
    private static final String SQLCOLUMNNAME = "sqlColumnName";
    private static final String SQLCOLUMNINDEX = "sqlColumnIndex";
    private static final String STRING_PROPERTY_DATA_TYPE = "propertyDataType";
    private static final String STRING_PROPERTY_NAME = "propertyName";

    public int getSourceRowsetId() {
        return this.mSourceRowsetId;
    }

    public void setSourceRowsetId(int sourceRowsetId) {
        this.mSourceRowsetId = sourceRowsetId;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public void setDirectModelReference(boolean directModelRef) {
        this.mDirectModelReference = directModelRef;
    }

    private boolean isDirectModelReference() {
        return this.mDirectModelReference;
    }

    public void setIndirectModelReference(boolean indirectModelRef) {
        this.mIndirectModelReference = indirectModelRef;
    }

    private boolean isIndirectModelReference() {
        return this.mIndirectModelReference;
    }

    public void setUseModelLabelsForIndirectModelRefs(boolean value) {
        this.useModelLabelsForIndirectModelRefs = value;
    }

    private boolean getUseModelLabelsForIndirectModelRefs() {
        return this.useModelLabelsForIndirectModelRefs;
    }

    public void setValidateFromFM(boolean validateFromFM) {
        this.mValidateFromFM = validateFromFM;
    }

    private boolean isValidateFromFM() {
        return this.mValidateFromFM;
    }

    public void setDataType(IDataType type) {
        if (type == MemberType.MEMBERTYPE || type == LevelType.LEVELTYPE || type == HierarchyType.HIERARCHYTYPE) {
            this.mType = MemberType.MEMBERTYPE;
            return;
        }
        if (this.isCustomProperty()) {
            return;
        }
        this.mType = type;
        if (!this.isValidateFromFM() && (type == XmlType.XMLTYPE || type == ObjectType.OBJECTTYPE || type != null && DataTypeCode.isPeriodType(type.getCCLTypeCode()))) {
            this.mType = StringType.DEFAULTSTRINGTYPE;
        }
    }

    public void setDependency(List<String> dependency) {
        this.mDependency = dependency;
    }

    public void setCurrencyCode(String currencyCode) {
        this.mCurrencyCode = currencyCode;
    }

    public void setFormat(String format) {
        this.mFormat = format;
    }

    public void setFormatID(FormatId formatId) {
        this.mFormatId = formatId;
    }

    public String getName() {
        return this.mName;
    }

    public String getLabel() {
        if (this.mLabel != null) {
            return this.mLabel;
        }
        if (this.isDirectModelReference() && this.getModelReference() != null) {
            return this.getModelReference().getCaption();
        }
        if (this.getUseModelLabelsForIndirectModelRefs() && this.isIndirectModelReference() && this.getModelReference() != null) {
            return this.getModelReference().getCaption();
        }
        return this.getName();
    }

    public IDataType getDataType() {
        return this.mType;
    }

    public List<String> getDependency() {
        return this.mDependency;
    }

    public IDataType getPropertyDataType() {
        return this.mPropertyDataType;
    }

    public void setPropertyDataType(IDataType type) {
        this.mPropertyDataType = type;
    }

    public IDataType getBaseDataType() {
        if (this.mPropertyDataType != null) {
            return this.mPropertyDataType;
        }
        return this.mType;
    }

    public String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public FormatId getFormatId() {
        return this.mFormatId;
    }

    public String getSqlColumnName() {
        return this.mSqlColumnName;
    }

    public void setSqlColumnName(String name) {
        this.mSqlColumnName = name;
    }

    public int getSqlColumnIndex() {
        return this.mSqlColumnIndex;
    }

    public void setSqlColumnIndex(int index) {
        this.mSqlColumnIndex = index;
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, 0, false);
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, int datatypesToDisplay, boolean isRefDataItem) {
        if (isRefDataItem) {
            writer.beginElement("refDataItem", -1);
        } else {
            writer.beginElement(STRING_DATAITEM, -1);
        }
        writer.attribute(STRING_NAME, this.getName());
        if (this.getLabel() != null) {
            writer.attribute(STRING_LABEL, this.getLabel());
        }
        if (completeDump) {
            if (this.getDataType() != null) {
                if (this.isCustomProperty() && this.getPropertyDataType() != null) {
                    IDataType dType = this.getPropertyDataType();
                    if ((datatypesToDisplay == 0 || datatypesToDisplay == 2) && this.getPropertyDataType().getSubType() == DataSubType.TEXTTYPE) {
                        dType = StringType.DEFAULTSTRINGTYPE;
                        if (datatypesToDisplay == 2) {
                            datatypesToDisplay = 1;
                        }
                    }
                    this.datatypeToXML(writer, dType, datatypesToDisplay);
                } else {
                    this.datatypeToXML(writer, this.getDataType(), datatypesToDisplay);
                }
            } else {
                writer.attribute(STRING_DATATYPE, "");
            }
            writer.attribute(STRING_SUBTYPE, this.getUsage().toString());
            writer.attribute(STRING_NULLABLE, this.getNullable());
            writer.attribute(STRING_SOLVEORDER, this.getSolveOrder());
            if (this.getCurrencyCode() != null) {
                writer.attribute(ATTRIBUTE_CURRENCY_CODE, this.getCurrencyCode());
            }
            if (this.getFormat() != null) {
                writer.attribute(ATTRIBUTE_FORMAT, this.getFormat());
                writer.attribute(STRING_PROPERTY_FORMAT_ID, FormatService.getInstance().getFormatStringId(this.getFormatId()));
            }
            if (this.getPropertyName() != null) {
                writer.attribute(STRING_PROPERTY_NAME, this.getPropertyName());
            }
            if (this.getPropertyDataType() != null) {
                writer.attribute(STRING_PROPERTY_DATA_TYPE, this.getPropertyDataType().getTypeName());
            }
            if (this.isConstant()) {
                writer.attribute(STRING_CONSTANT, VALUE_TRUE);
            }
            if (this.getQueryItemModelId() != null) {
                writer.attribute(ATTRIBUTE_Q_ITEM_MODEL_REF, this.getQueryItemModelId());
            }
            if (this.getModelReference() != null) {
                writer.attribute(ATTRIBUTE_MODEL_ID, this.getModelReference().getID());
            }
            if (this.getSqlColumnName() != null) {
                writer.attribute(SQLCOLUMNNAME, this.getSqlColumnName());
            }
            if (this.getSqlColumnIndex() >= 0) {
                writer.attribute(SQLCOLUMNINDEX, this.getSqlColumnIndex());
            }
        }
        writer.endElement();
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, true);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STRING_DATAITEM);
        stringBuilder.append(OPEN_PARENTHESIS);
        stringBuilder.append(STRING_NAME);
        stringBuilder.append(STRING_COLON);
        stringBuilder.append(this.getName());
        if (this.getLabel() != null) {
            stringBuilder.append(STRING_COMMA_SPACE);
            stringBuilder.append(STRING_LABEL);
            stringBuilder.append(STRING_COLON);
            stringBuilder.append(this.getLabel());
        }
        stringBuilder.append(STRING_COMMA_SPACE);
        stringBuilder.append(STRING_USAGE);
        stringBuilder.append(STRING_COLON);
        stringBuilder.append((Object)this.getUsage());
        stringBuilder.append(CLOSE_PARENTHESIS);
        return stringBuilder.toString();
    }

    public void setSolveOrder(int solveOrder) {
        this.mSolveOrder = solveOrder;
    }

    public int getSolveOrder() {
        return this.mSolveOrder;
    }

    public void setNullable(boolean nullable) {
        this.mNullable = nullable;
    }

    public void setNotApplicableGroupbody() {
        this.mNotApplicableGroupbody = true;
    }

    public void setNotApplicable() {
        this.mNotApplicable = true;
    }

    public boolean getNullable() {
        return this.mNullable;
    }

    public void setUsage(RSAPIUsage usage) {
        this.mUsage = usage == RSAPIUsage.IDENTIFIER && (this.getPropertyName() != null || this.isCanonicalProperty()) ? RSAPIUsage.ATTRIBUTE : usage;
        if (this.getOrgUsage() == RSAPIUsage.NOT_SPECIFIED) {
            this.setOrgUsage(this.mUsage);
        }
    }

    public RSAPIUsage getUsage() {
        return this.mUsage;
    }

    public void setOrgUsage(RSAPIUsage usage) {
        this.mOrgUsage = usage;
    }

    public RSAPIUsage getOrgUsage() {
        return this.mOrgUsage;
    }

    public String getModelReferenceStr() {
        return this.mModelReferenceStr;
    }

    public void setModelReferenceStr(String ref) {
        this.mModelReferenceStr = ref;
    }

    public IMetadata getModelReference() {
        return this.mModelReference;
    }

    public void setModelReference(IMetadata reference) {
        this.mModelReference = reference;
        this.setIsCustomProperty(this.mModelReference != null && MetadataType.isQueryItem(this.mModelReference) && ((IQueryItem)this.mModelReference).getHierarchy() != null);
        if (!this.isCustomProperty()) {
            this.setPropertyName(null);
            this.mPropertyDataType = null;
            return;
        }
        RoleTypeEnum roleType = RoleTypeEnum.fromRsapi(reference.getUniqueName());
        if (roleType == null && reference.getUniqueName().equals(MetadataConstants.DESCRIPTION)) {
            roleType = RoleTypeEnum.MEMBER_DESCRIPTION;
        }
        if (roleType != null && (roleType == RoleTypeEnum.DIMENSION_UNIQUE_NAME || roleType == RoleTypeEnum.HIERARCHY_UNIQUE_NAME || roleType == RoleTypeEnum.LEVEL_LABEL || roleType == RoleTypeEnum.LEVEL_NUMBER || roleType == RoleTypeEnum.LEVEL_UNIQUE_NAME || roleType == RoleTypeEnum.MEMBER_CAPTION || roleType == RoleTypeEnum.MEMBER_DESCRIPTION || roleType == RoleTypeEnum.MEMBER_UNIQUE_NAME || roleType == RoleTypeEnum.PARENT_UNIQUE_NAME)) {
            this.mType = roleType.getDataType();
            if (this.isDirectModelReference()) {
                this.mLabel = reference.getCaption();
            }
            this.mModelReference = null;
            return;
        }
        if (reference.getProperty(XQE_CUSTOM_PROPERTY_NAME) != null) {
            this.setPropertyName((String)reference.getProperty(XQE_CUSTOM_PROPERTY_NAME));
        } else if (reference instanceof IQueryItemOfLevel && reference.isDMR()) {
            this.setPropertyName(reference.getName());
        } else {
            this.setPropertyName(reference.getUniqueName());
        }
        this.mType = this.mPropertyDataType = reference.getDataType();
        if (this.mPropertyDataType == VarcharType.DEFAULTVARCHARTYPE || this.mPropertyDataType == CharType.DEFAULTCHARTYPE) {
            this.mPropertyDataType = StringType.DEFAULTSTRINGTYPE;
        }
    }

    public boolean isCustomProperty() {
        return this.mIsCustomProperty;
    }

    public void setIsCustomProperty(boolean value) {
        this.mIsCustomProperty = value;
    }

    public String getQueryItemModelId() {
        return this.mModelId;
    }

    public void setQueryItemModelId(String modelId) {
        this.mModelId = modelId;
    }

    public String getModelCalculationID() {
        return this.mModelCalculationID;
    }

    public void setModelCalculationID(String modelId) {
        this.mModelCalculationID = modelId;
    }

    protected void capture(Element inputNode) {
        Attribute attribute = inputNode.attribute(STRING_NAME);
        this.setName(attribute.getStringValue());
        attribute = inputNode.attribute(STRING_PROPERTY_DATA_TYPE);
        if (attribute != null) {
            this.mPropertyDataType = DataTypeFactory.getType(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(STRING_PROPERTY_NAME)) != null) {
            this.setPropertyName(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(STRING_DATATYPE)).getStringValue().compareToIgnoreCase("member") == 0) {
            this.setDataType(MemberType.MEMBERTYPE);
        } else {
            this.setDataType(DataTypeFactory.getType(attribute.getStringValue()));
        }
        attribute = inputNode.attribute(STRING_SUBTYPE);
        this.setUsage(RSAPIUsage.getUsageByName(attribute.getStringValue()));
        attribute = inputNode.attribute(STRING_NULLABLE);
        if (attribute.getStringValue().compareTo(VALUE_TRUE) == 0) {
            this.setNullable(true);
        } else {
            this.setNullable(false);
        }
        attribute = inputNode.attribute(STRING_SOLVEORDER);
        Integer solveOrder = new Integer(attribute.getStringValue());
        this.setSolveOrder(solveOrder);
        attribute = inputNode.attribute(STRING_CONSTANT);
        if (attribute != null && attribute.getStringValue().compareTo(VALUE_TRUE) == 0) {
            this.setIsConstant(true);
        } else {
            this.setIsConstant(false);
        }
        attribute = inputNode.attribute(ATTRIBUTE_Q_ITEM_MODEL_REF);
        if (attribute != null) {
            this.setQueryItemModelId(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_MODEL_ID)) != null) {
            this.setModelReferenceStr(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_FORMAT)) != null) {
            this.setFormat(attribute.getStringValue());
            this.setFormatID(FormatService.getInstance().registerV5Format(attribute.getStringValue(), null));
        }
        if ((attribute = inputNode.attribute(STRING_LABEL)) != null) {
            this.setLabel(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_CURRENCY_CODE)) != null) {
            this.setCurrencyCode(attribute.getStringValue());
        }
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public void setPropertyName(String value) {
        this.mPropertyName = value;
    }

    public void setMasterDatasetDataType(IDataType dType) {
        this.mMasterDatasetDataType = dType;
    }

    public IDataType getMasterDatasetDataType() {
        return this.mMasterDatasetDataType;
    }

    public boolean isMemberProperty() {
        return this.isCustomProperty() || this.isCanonicalProperty();
    }

    public boolean isCanonicalProperty() {
        return RSAPIUtilities.isCanonicalProperty(this.mType);
    }

    public boolean isNotApplicableGroupbody() {
        return this.mNotApplicableGroupbody;
    }

    public boolean isNotApplicable() {
        return this.mNotApplicable;
    }

    private void datatypeToXML(XMLWriter writer, IDataType dataType, int datatypesToDisplay) {
        if (datatypesToDisplay == 0 || datatypesToDisplay == 2) {
            writer.attribute(STRING_DATATYPE, dataType.toString());
        }
        if (datatypesToDisplay == 1) {
            writer.attribute(STRING_DATATYPE, DataTypeCode.getCCLTypeName(dataType.getCCLTypeCode()));
        }
        if (datatypesToDisplay == 2) {
            writer.attribute(STRING_CCL_DATATYPE, DataTypeCode.getCCLTypeName(dataType.getCCLTypeCode()));
        }
    }

    public boolean isGroupbodyMeasure() {
        return this.mIsGroupbodyMeasure;
    }

    public void setIsGroupbodyMeasure(boolean isGroupbodyMeasure) {
        this.mIsGroupbodyMeasure = isGroupbodyMeasure;
    }

    public boolean isConstant() {
        return this.mIsConstant;
    }

    public void setIsConstant(boolean isConstant) {
        this.mIsConstant = isConstant;
    }

    public void addAdditionalDataItemIndex(int index) {
        if (this.mAdditionalDataItemIndices == null) {
            this.mAdditionalDataItemIndices = new ArrayList<Integer>();
        }
        this.mAdditionalDataItemIndices.add(index);
    }

    public void addAdditionalDataItemIndies(List<Integer> indices) {
        if (indices != null) {
            for (int i : indices) {
                this.addAdditionalDataItemIndex(i);
            }
        }
    }

    public List<Integer> getAdditionalDataItemIndices() {
        return this.mAdditionalDataItemIndices;
    }

    public boolean getPreserveMetadata() {
        return this.mPreserveMetadata;
    }

    public void setPreserveMetadata(boolean val) {
        this.mPreserveMetadata = val;
    }

    public String getResolvedAggregateType() {
        return this.mResolvedAggregate;
    }

    public void setResolvedAggregateType(String aggr) {
        this.mResolvedAggregate = aggr;
    }

    public boolean isMeasure() {
        boolean bMeasure = false;
        IMetadata metadata = this.getModelReference();
        if (metadata != null) {
            MetadataType metadataType = metadata.getObjectType();
            bMeasure = MetadataType.LEVEL == metadataType ? MetadataType.isMeasureDimension(((ILevel)metadata).getDimension()) : MetadataType.isMeasure(metadata);
        }
        return bMeasure;
    }

    public boolean getAdjustDataTypeFromResultSet() {
        return this.mAdjustDataTypeFromResultSet;
    }

    public void setAdjustDataTypeFromResultSet(boolean val) {
        this.mAdjustDataTypeFromResultSet = val;
    }

    public void setLinkParam(Parameter p) {
        this.linkParam = p;
    }

    public void adjustParamDataType(IDataType dType) {
        if (this.linkParam != null) {
            this.linkParam.setAdjustedDataType(dType);
        }
    }

    public boolean needAdjustDataType() {
        byte cclTypeCode = this.getDataType().getCCLTypeCode();
        return cclTypeCode == 22 || cclTypeCode == 23 || cclTypeCode == 24 || this.getAdjustDataTypeFromResultSet();
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            ctx.property(STRING_NAME, this.getName());
            if (this.getLabel() != null) {
                ctx.property(STRING_LABEL, this.getLabel());
            }
            if (this.getDataType() != null) {
                ctx.property(STRING_DATATYPE, this.getDataType());
            }
            ctx.property(STRING_SUBTYPE, this.getUsage().toString());
            ctx.property(STRING_NULLABLE, this.getNullable());
            ctx.property(STRING_SOLVEORDER, this.getSolveOrder());
            if (this.getCurrencyCode() != null) {
                ctx.property(ATTRIBUTE_CURRENCY_CODE, this.getCurrencyCode());
            }
            if (this.getFormat() != null) {
                ctx.property(ATTRIBUTE_FORMAT, this.getFormat());
                ctx.property(STRING_PROPERTY_FORMAT_ID, FormatService.getInstance().getFormatStringId(this.getFormatId()));
            }
            if (this.getPropertyName() != null) {
                ctx.property(STRING_PROPERTY_NAME, this.getPropertyName());
            }
            if (this.getPropertyDataType() != null) {
                ctx.property(STRING_PROPERTY_DATA_TYPE, this.getPropertyDataType().getTypeName());
            }
            if (this.isConstant()) {
                ctx.property(STRING_CONSTANT, VALUE_TRUE);
            }
            if (this.getQueryItemModelId() != null) {
                ctx.property(ATTRIBUTE_Q_ITEM_MODEL_REF, this.getQueryItemModelId());
            }
            if (this.getModelReference() != null) {
                ctx.property(ATTRIBUTE_MODEL_ID, this.getModelReference().getID());
            }
            if (this.getSqlColumnName() != null) {
                ctx.property(SQLCOLUMNNAME, this.getSqlColumnName());
            }
            if (this.getSqlColumnIndex() >= 0) {
                ctx.property(SQLCOLUMNINDEX, this.getSqlColumnIndex());
            }
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Object value;
            Attribute att = node.attribute(i);
            String attname = att.getName();
            if (attname.equals(STRING_NAME)) {
                value = ctx.attributeValue(att);
                this.mName = (String)value;
                continue;
            }
            if (attname.equals(STRING_LABEL)) {
                value = ctx.attributeValue(att);
                this.mLabel = (String)value;
                continue;
            }
            if (attname.equals(STRING_DATATYPE)) {
                value = ctx.attributeValue(att);
                this.mType = (IDataType)value;
                continue;
            }
            if (attname.equals(STRING_SUBTYPE)) {
                value = ctx.attributeValue(att);
                this.mUsage = RSAPIUsage.getUsageByName((String)value);
                continue;
            }
            if (attname.equals(STRING_NULLABLE)) {
                value = ctx.attributeValue(att);
                this.mNullable = (Boolean)value;
                continue;
            }
            if (attname.equals(STRING_SOLVEORDER)) {
                value = ctx.attributeValue(att);
                this.mSolveOrder = (Integer)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_CURRENCY_CODE)) {
                value = ctx.attributeValue(att);
                this.mCurrencyCode = (String)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_FORMAT)) {
                value = ctx.attributeValue(att);
                this.mFormat = (String)value;
                this.mFormatId = FormatService.getInstance().registerV5Format((String)value, null);
                continue;
            }
            if (attname.equals(STRING_PROPERTY_NAME)) {
                value = ctx.attributeValue(att);
                this.mPropertyName = (String)value;
                continue;
            }
            if (attname.equals(STRING_PROPERTY_DATA_TYPE)) {
                value = ctx.attributeValue(att);
                this.mPropertyDataType = (IDataType)value;
                continue;
            }
            if (attname.equals(STRING_CONSTANT)) {
                value = ctx.attributeValue(att);
                this.mIsConstant = (Boolean)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_Q_ITEM_MODEL_REF)) {
                value = ctx.attributeValue(att);
                this.mModelId = (String)value;
                continue;
            }
            if (attname.equals(ATTRIBUTE_MODEL_ID)) {
                PlanningEnvironment env = ctx.getPlanningEnvironment();
                Object value2 = ctx.attributeValue(att);
                this.setModelReference(env.getMetadataConnection().bindMetadataReference((String)value2));
                continue;
            }
            if (attname.equals(SQLCOLUMNNAME)) {
                value = ctx.attributeValue(att);
                this.mSqlColumnName = (String)value;
                continue;
            }
            if (!attname.equals(SQLCOLUMNINDEX)) continue;
            value = ctx.attributeValue(att);
            this.mSqlColumnIndex = (Integer)value;
        }
    }
}

