/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.util.SQLCursorCollectionFormatter;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQEUnrecoverableConnectionException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDatasetContext;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIReportLayoutException;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.IXRunnableTree;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.datasets.DatasetInfoExtended;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.rowInfo.RowInfo;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.IOException;
import java.io.Writer;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RSAPIDataset
extends XNode
implements IRSAPIDataset {
    private static final long serialVersionUID = 0L;
    protected static final String NODE_TYPE_NAME = "rsapiDataset";
    private static final String RESULTS_ELEMENT = "results";
    private static final String EXECUTION_ELEMENT = "execution";
    private static final String RUNTREE_ELEMENT = "runtree";
    private static final String DATASET_INFO = "datasetInfo";
    private static final String STRING_PROPERTY_EDGES = "edges";
    private static final String STRING_PROPERTY_CELL_ROWSET = "cellRowset";
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    public static final String LOG_ATTEMPTS_TO_FIX_OLAP_MEMBER_RULES_ENABLED = "queryExecution.logAttemptsToFixOLAPMemberRules[@enabled]";
    private String mName;
    private String mRefQueryName;
    private String mOriginalRefQueryName = null;
    private final List<RSAPIPartialDataset> activePartialDatasets = new ArrayList<RSAPIPartialDataset>();
    private List<RSAPIEdge> mEdges;
    RSAPIEdge[] mEdgeArray;
    private RSAPICellRowset mCellRowset;
    private boolean mAllRows;
    private boolean mUseSAPMUNAsBusinessKey;
    private String mUniqueID;
    private boolean emptyEdgesIdentified;
    private boolean hasEmptyEdge;
    private boolean dataTypesAdjusted;
    private boolean noMetadataMode = false;
    private boolean mHasSampledData = false;
    private static final int REPORT_TYPE_INVALID = 0;
    private static final int REPORT_TYPE_DETAIL_LIST = 1;
    private static final int REPORT_TYPE_GROUP_LIST = 2;
    private static final int REPORT_TYPE_CROSS_TAB = 3;
    private static final int NUM_EDGES_LIST = 1;
    private static final int DEFAULT_MAX_ATTEMPTS_DUE_TO_CONNECTION = 3;
    private int mReportType;
    private String cognosSQL;
    private String sqlComments;
    private SQLCursorCollectionFormatter nativeSQLCursors = new SQLCursorCollectionFormatter();
    private Governors governors;
    private Integer xMdxNodeId;
    private boolean includeEmptyCells;
    private boolean isForSqlQuery = false;
    private boolean isForOLAPQuery;
    private boolean isForRelationalOLAPQuery;
    private boolean isForDetailQuery;
    public static final String XMDX_NODE_ID = "xmdxNodeId";
    Map<Integer, List<RowInfo>> restRowInfo = null;
    private static final XQELogger DATASET_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Dataset", LogLevel.INFO);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private Set<String> queryFeedbacks;
    private Boolean allowNonNumericCellValues = null;
    private boolean generateDerivedRowsInRSAPI = false;
    private boolean forDMR = false;
    private boolean forXtabRel = false;
    private boolean transferMembers = false;
    private int maxAttemptsToRecoverFromConnection = 3;
    private boolean forceNewConnectionOnLastAttempt = true;
    private List<Integer> xV5ReinsertEdgePathElementsTargets = null;
    private boolean sqlToMessageFolder = false;
    private byte[] queryPlan = null;
    private boolean vqeEnabled;
    private DatasetInfoExtended dataSetInfoEx;
    private Date lastModified;
    private long dataCacheExpiry = -1L;
    private long currentDataCacheExpiry = -1L;
    private Boolean mReturnDataItemNameInPartialDataset = null;
    private static final String STRING_NAME = "name";
    private static final String STRING_REF_QUERY = "refQuery";
    private static final String STRING_ORIG_REF_QUERY = "originalRefQuery";
    private static final String STRING_ALL_ROWS = "allRows";
    private static final String STRING_LAST_MODIFIED = "lastModified";
    private static final String STRING_CURRENT_DATA_CACHE_EXPIRY = "currentDataCacheExpiry";
    private static final String STRING_DATA_CACHE_EXPIRY = "dataCacheExpiry";

    public RSAPIDataset() {
        this.mEdges = new ArrayList<RSAPIEdge>();
        this.mUniqueID = new UID().toString();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.maxAttemptsToRecoverFromConnection = config.getIntProperty("general.unrecoverableConnectionRecovery[@maxAttempts]", 3);
        this.forceNewConnectionOnLastAttempt = config.getBooleanProperty("general.unrecoverableConnectionRecovery[@forceNewConnectionOnLastAttempt]", true);
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public int getType() {
        return 401005;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setRefQueryName(String name) {
        this.mRefQueryName = name;
    }

    public void setOriginalRefQueryName(String name) {
        this.mOriginalRefQueryName = name;
    }

    public void addEdge(RSAPIEdge edge) {
        this.mEdges.add(edge);
    }

    public void setCellRowset(RSAPICellRowset rowset) {
        this.mCellRowset = rowset;
    }

    public void setOptimizeForAllRows(boolean allRows) {
        this.mAllRows = allRows;
    }

    public boolean getOptimizeForAllRows() {
        return this.mAllRows;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getRefQueryName() {
        return this.mRefQueryName;
    }

    public String getOriginalRefQueryName() {
        return this.mOriginalRefQueryName;
    }

    public RSAPIEdge[] getEdges() {
        if (this.mEdges.size() == 0) {
            return new RSAPIEdge[0];
        }
        if (this.mEdgeArray != null && this.mEdges.size() == this.mEdgeArray.length) {
            return this.mEdgeArray;
        }
        this.mEdgeArray = new RSAPIEdge[this.mEdges.size()];
        int i = 0;
        for (RSAPIEdge edge : this.mEdges) {
            this.mEdgeArray[i++] = edge;
        }
        return this.mEdgeArray;
    }

    public RSAPICellRowset getCellRowset() {
        return this.mCellRowset;
    }

    protected RSAPIEdge getListReportEdge() {
        if (this.getNumEdges() > 1) {
            return null;
        }
        return this.mEdges.get(0);
    }

    public RSAPIEdge getEdge(int ordinal) {
        return this.mEdges.get(ordinal);
    }

    protected int getEdgeOrdinal(RSAPIEdge edge) {
        for (int i = 0; i < this.mEdges.size(); ++i) {
            RSAPIEdge currentEdge = this.mEdges.get(i);
            if (currentEdge.getOrdinal() != edge.getOrdinal()) continue;
            return i;
        }
        return -1;
    }

    protected boolean getIsOptimizedForAllRows() {
        return this.mAllRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPIPartialDataset getPartialDataset(int[] startRowNumber, int[] numRows, boolean includeContext, boolean includeContextValues, IExecutionEnvironment executionEnvironment, boolean reExecute) {
        RSAPIResultSet resultSet = null;
        RSAPIPartialDataset partialDataset = null;
        int reTry = 1;
        int attemptToFixOLAPMemberRules = 0;
        while (reTry == 1 && attemptToFixOLAPMemberRules < 2) {
            reTry = 0;
            try {
                ROLAPContext.queryEnter(executionEnvironment);
                try {
                    if (attemptToFixOLAPMemberRules == 1) {
                        reExecute = true;
                    }
                    resultSet = this.execute(executionEnvironment, reExecute);
                    try {
                        partialDataset = new RSAPIPartialDataset(this, resultSet, startRowNumber, numRows, includeContext, includeContextValues);
                    }
                    catch (RuntimeException ex) {
                        try {
                            this.releaseResultset(executionEnvironment);
                        }
                        catch (Throwable ex2) {
                            ERROR_LOGGER.log(ex2);
                        }
                        throw ex;
                    }
                    catch (Throwable ex) {
                        try {
                            this.releaseResultset(executionEnvironment);
                        }
                        catch (Throwable ex2) {
                            ERROR_LOGGER.log(ex2);
                        }
                        throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
                    }
                }
                finally {
                    ROLAPContext.queryExit(executionEnvironment);
                }
            }
            catch (XQERuntimeException xre) {
                int[] stateVars = new int[]{reTry, attemptToFixOLAPMemberRules};
                stateVars = RSAPIDataset.handleAttemptToFixOLAPMemberRules(this, xre, stateVars);
                reTry = stateVars[0];
                attemptToFixOLAPMemberRules = stateVars[1];
            }
        }
        return partialDataset;
    }

    public static int[] handleAttemptToFixOLAPMemberRules(XNode xNode, XQERuntimeException xre, int[] stateVars) {
        if (xre.getMessageKey() != XQEMessageKeys.DEC_AttemptToFixOLAPMemberRules) {
            throw xre;
        }
        List<IXQEQueryNode> xmdxNodes = xNode.getDescendantsOfCategoryOrdered(501017, false);
        if (xmdxNodes.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToRetrieveXMdxNode);
        }
        XMdx xMDXNode = (XMdx)xmdxNodes.get(0);
        IDataSource dataSource = xMDXNode.getDataSource();
        int reTry = stateVars[0];
        int attemptToFixOLAPMemberRules = stateVars[1];
        if (attemptToFixOLAPMemberRules == 0 && xre.getMessageKey() == XQEMessageKeys.DEC_AttemptToFixOLAPMemberRules && (reTry = RSAPIDataset.handleAttemptToFixOLAPMemberRules(dataSource, xre)) == 1) {
            ++attemptToFixOLAPMemberRules;
        }
        RSAPIDataset.rethrowAttemptToFixOLAPMemberRules(reTry, attemptToFixOLAPMemberRules, xre, dataSource);
        stateVars[0] = reTry;
        stateVars[1] = attemptToFixOLAPMemberRules;
        return stateVars;
    }

    protected static int handleAttemptToFixOLAPMemberRules(IDataSource dataSource, XQERuntimeException xre) {
        int reTry = 0;
        if (dataSource == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToRetrieveDataSourceFromXMdx);
        }
        IDataSourceCapabilities dataSourceCapabilities = dataSource.getCapabilities();
        if (dataSourceCapabilities == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToRetrieveCapabilitiesFromDataSource, dataSource.getName());
        }
        boolean useCheckMemberRulesSecondaryQuery = dataSourceCapabilities.getUseCheckMemberRulesSecondaryQuery();
        if (!useCheckMemberRulesSecondaryQuery) {
            dataSourceCapabilities.setUseCheckMemberRulesSecondaryQuery(true);
            reTry = 1;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (configuration.getBooleanProperty(LOG_ATTEMPTS_TO_FIX_OLAP_MEMBER_RULES_ENABLED, false)) {
                ERROR_LOGGER.log(xre);
            }
        }
        return reTry;
    }

    protected static void rethrowAttemptToFixOLAPMemberRules(int reTry, int attemptToFixOLAPMemberRules, XQERuntimeException xre, IDataSource dataSource) {
        if (reTry == 0) {
            if (attemptToFixOLAPMemberRules == 1) {
                dataSource.getCapabilities().setUseCheckMemberRulesSecondaryQuery(false);
            }
            throw xre;
        }
    }

    public RSAPIResultSet execute(IExecutionEnvironment environment, boolean reExecute) {
        int reTry = 1;
        int attemptToFixOLAPMemberRules = 0;
        int attempt = 0;
        boolean forceNewConnection = false;
        while (reTry == 1 && attemptToFixOLAPMemberRules < 2) {
            reTry = 0;
            try {
                if (attemptToFixOLAPMemberRules == 1 || attempt > 0) {
                    reExecute = true;
                }
                if (this.maxAttemptsToRecoverFromConnection != 0 && attempt == this.maxAttemptsToRecoverFromConnection && this.forceNewConnectionOnLastAttempt) {
                    forceNewConnection = true;
                }
                RSAPIResultSet resultSet = this.executeRetry(environment, reExecute, forceNewConnection);
                return resultSet;
            }
            catch (XQEUnrecoverableConnectionException xuce) {
                if (!xuce.attemptedToRecover() && ++attempt <= this.maxAttemptsToRecoverFromConnection) {
                    ERROR_LOGGER.log(xuce);
                    reTry = 1;
                    continue;
                }
                xuce.setAttemptedToRecover(true);
                throw xuce;
            }
            catch (XQERuntimeException xre) {
                int[] stateVars = new int[]{reTry, attemptToFixOLAPMemberRules};
                stateVars = RSAPIDataset.handleAttemptToFixOLAPMemberRules(this, xre, stateVars);
                reTry = stateVars[0];
                attemptToFixOLAPMemberRules = stateVars[1];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSAPIResultSet executeRetry(IExecutionEnvironment environment, boolean reExecute, boolean forceNewConnection) {
        RSAPIResultSet resultSet;
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        XQETrace trace = environment.getTrace();
        if (trace == null) {
            trace = new XQETrace();
            QueryEngineLoggingUtils.addExecutionTraceLevels(trace, environment.getRequestEnvironment());
            environment.setTrace(trace);
        }
        if ((resultSet = multiRequestContext.getResultset(this)) == null) {
            QueryEngineLoggingUtils.dumpRuntreeLog(environment, this);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        CollectXQELogs xqeLogs = new CollectXQELogs(reqEnv.getOrCreateReportLogsDir());
        xqeLogs.logRuntree(reqEnv, this.getRefQueryName(), this);
        if (reExecute || resultSet == null) {
            multiRequestContext.removeResultset(this);
            if (resultSet != null) {
                resultSet.release();
            }
            Writer logWriter = null;
            int traceLevel = trace.getTraceLevel();
            if ((trace.getTraceLevel() & 0x800) != 0) {
                logWriter = TraceLogManager.getInstance().createExecutionTraceWriter(reqEnv);
                reqEnv.setCurrentTraceWriter(logWriter);
                trace.addStream(logWriter);
                trace.beginElement(EXECUTION_ELEMENT, -1);
                trace.beginElement(RUNTREE_ELEMENT, -1);
                this.dump(trace);
                trace.endElement();
                trace.beginElement(RESULTS_ELEMENT, -1);
                trace.removeTraceLevel(1024);
            }
            XDataContext dataContext = environment.pushDataContext();
            if (forceNewConnection) {
                dataContext.setProperty("forceNewConnection", Boolean.TRUE);
            }
            dataContext.setRsapiDatasetName(this.getName());
            try {
                resultSet = ((IXRunnableTree)((Object)this.getChild(0))).execute(dataContext, this);
            }
            finally {
                environment.popDataContext(dataContext);
                if (this.getDescendantsOfType(501053, false).length != 0) {
                    QueryEngineLoggingUtils.dumpProfilingLog(environment, this);
                }
                if (logWriter != null) {
                    try {
                        trace.endElement();
                        trace.endElement();
                        trace.removeStream(logWriter);
                        trace.addTraceLevel(traceLevel);
                        trace.removeTraceLevel(2048);
                        reqEnv.setCurrentTraceWriter(null);
                        logWriter.close();
                    }
                    catch (IOException ioe) {
                        ERROR_LOGGER.log(ioe);
                    }
                }
            }
            multiRequestContext.setResultset(this, resultSet);
            if (QueryEngineLoggingUtils.isRuntreeEnabled(reqEnv)) {
                TraceLogManager.getInstance().closeTrace(reqEnv);
            }
        }
        RSAPIEdge[] edges = this.getEdges();
        int numEdges = edges.length;
        for (int i = 0; i < numEdges; ++i) {
            edges[i].setMaxRowsRetrieved();
        }
        return resultSet;
    }

    public RSAPIPartialDataset getPartialDataset(int[] startRowNumber, int[] numRows, boolean includeContext, boolean includeContextValues) {
        return this.getPartialDataset(startRowNumber, numRows, includeContext, includeContextValues, (IExecutionEnvironment)((PlanningEnvironment)this.getPlanningEnvironment()).getExecutionEnvironment(), false);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.toXMLString(trace, true, true);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        this.getChild(0).dumpFormattedXMLQuery(trace);
    }

    public void serialize(ExecutionEnvironment executionEnv, XMLWriter writer, boolean completeDump, boolean internal) {
        this.serialize(executionEnv, writer, completeDump, internal, 0);
    }

    public void serialize(ExecutionEnvironment executionEnv, XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        this.adjustDataItemTypes(executionEnv);
        this.toXMLString(writer, completeDump, internal, datatypesToDisplay);
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, internal, 0);
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        if (!internal) {
            writer.beginElement(DATASET_INFO, -1);
        }
        writer.attribute(STRING_NAME, this.mName);
        if (this.xMdxNodeId != null) {
            writer.attribute(XMDX_NODE_ID, this.xMdxNodeId);
        }
        if (internal) {
            if (this.mOriginalRefQueryName != null) {
                writer.attribute(STRING_ORIG_REF_QUERY, this.mOriginalRefQueryName);
            }
            writer.attribute(STRING_REF_QUERY, this.mRefQueryName);
            writer.attribute(STRING_ALL_ROWS, this.mAllRows);
            if (this.lastModified != null) {
                writer.attribute(STRING_LAST_MODIFIED, this.lastModified);
            }
            if (this.dataCacheExpiry > 0L) {
                writer.attribute(STRING_DATA_CACHE_EXPIRY, this.dataCacheExpiry);
            }
            if (this.currentDataCacheExpiry > 0L) {
                writer.attribute(STRING_CURRENT_DATA_CACHE_EXPIRY, this.currentDataCacheExpiry);
            }
        }
        if (!internal) {
            writer.attribute("numEdges", this.mEdges.size());
        }
        for (RSAPIEdge edge : this.mEdges) {
            edge.toXMLString(writer, completeDump, internal, datatypesToDisplay);
        }
        if (this.mCellRowset != null) {
            this.mCellRowset.toXMLString(writer, completeDump, internal, datatypesToDisplay);
        }
        if (!internal) {
            writer.endElement();
        }
    }

    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, true);
    }

    public int getNumEdges() {
        return this.mEdges.size();
    }

    @Override
    public int isValidPlannedQuery() {
        return this.getChild(0).isValidPlannedQuery();
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public void setUniqueID(String id) {
        this.mUniqueID = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        RSAPIDatasetContext ctx = RSAPIDatasetContext.enter(this);
        try {
            this.assignAttributeValues(inputNode);
            List childList = inputNode.elements();
            for (Element child : childList) {
                if (child.getName().compareTo("edge") == 0) {
                    this.captureEdge(env, child);
                    continue;
                }
                if (child.getName().compareTo(STRING_PROPERTY_CELL_ROWSET) == 0) {
                    this.captureCellRowset(env, child);
                    continue;
                }
                this.captureXTree(env, child);
            }
            this.validateReportLayout();
        }
        finally {
            ctx.exit();
        }
    }

    private void assignAttributeValues(Element inputNode) {
        Attribute attribute = inputNode.attribute(STRING_NAME);
        if (attribute != null) {
            this.setName(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(STRING_REF_QUERY)) != null) {
            this.setRefQueryName(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(STRING_ORIG_REF_QUERY)) != null) {
            this.setOriginalRefQueryName(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute(STRING_ALL_ROWS)) != null) {
            if (attribute.getStringValue().compareTo(TRUE) == 0) {
                this.setOptimizeForAllRows(true);
            } else {
                this.setOptimizeForAllRows(false);
            }
        }
    }

    private void captureXTree(PlanningEnvironment env, Element inputNode) {
        XQENodeFactory nodeFactory = env.getNodeFactory();
        XNode xTree = (XNode)nodeFactory.createNodeByName(inputNode.getName());
        xTree.capture(env, inputNode);
        this.addChild(xTree, 0);
    }

    private void captureEdge(PlanningEnvironment env, Element inputNode) {
        RSAPIEdge edge = new RSAPIEdge();
        edge.setDataset(this);
        edge.capture(env, inputNode);
        this.addEdge(edge);
    }

    private void captureCellRowset(PlanningEnvironment env, Element inputNode) {
        RSAPICellRowset cellRowset = new RSAPICellRowset();
        cellRowset.capture(env, inputNode);
        this.setCellRowset(cellRowset);
    }

    public boolean isListReport() {
        return this.mReportType == 1 || this.mReportType == 2;
    }

    public boolean isInvalidReport() {
        return this.mReportType == 0;
    }

    public boolean isDetailListReport() {
        return this.mReportType == 1;
    }

    public boolean isCrossTabReport() {
        return this.mReportType == 3;
    }

    public boolean isForDetailQuery() {
        return this.isForDetailQuery;
    }

    public void validateReportLayout() {
        if (this.mReportType != 0) {
            return;
        }
        int numEdges = this.getNumEdges();
        if (numEdges > 1) {
            this.mReportType = 3;
        } else if (numEdges == 1) {
            V5QueryResultDefinition v5QRD;
            IXQEQueryNode[] qrds = this.getDescendantsOfType(101055, false);
            if (qrds.length > 0 && !(v5QRD = (V5QueryResultDefinition)qrds[0]).isList()) {
                this.mReportType = 3;
            }
            if (this.mReportType == 0) {
                RSAPIEdgeRowset rowset = this.getListReportEdge().getRootRowset();
                this.mReportType = rowset.getNestedRowset() == null && rowset.getRefDataItem() == null ? 1 : 2;
            }
        }
        if (this.mReportType == 0) {
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_InvalidResultDataset, this.getName());
        }
        this.ensureRowsetsValidForReportType();
        this.validateInterRowsetRelationships();
    }

    private void ensureRowsetsValidForReportType() {
        if (this.isCrossTabReport()) {
            for (RSAPIEdge edge : this.getEdges()) {
                this.ensureRowsetsValidForCrossTab(edge.getRootRowset(), edge.getName());
            }
        } else if (this.isListReport()) {
            this.ensureRowsetsValidForList(this.getListReportEdge().getRootRowset());
        }
    }

    public void validateInterRowsetRelationships() {
        for (RSAPIEdge edge : this.getEdges()) {
            edge.validateInterRowsetRelationships(edge.getRootRowset());
        }
    }

    private void ensureRowsetsValidForList(RSAPIEdgeRowset rowset) {
        RSAPIEdgeRowset siblingRowset = rowset.getSiblingRowset();
        if (siblingRowset != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_SiblingRowsetInList, rowsetId.toString(), rowset.getName());
        }
        RSAPIEdgeRowset nestedRowset = rowset.getNestedRowset();
        if (nestedRowset != null) {
            if (rowset.getRefDataItem() == null) {
                Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
                throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_NoRefDataItemInNonLeafRowset, rowsetId.toString(), rowset.getName());
            }
            this.ensureRowsetsValidForList(nestedRowset);
        }
    }

    private void ensureRowsetsValidForCrossTab(RSAPIEdgeRowset rowset, String edgeName) {
        if (rowset == null) {
            return;
        }
        if (rowset.getRefDataItem() == null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_NoRefDataItemInCrossTab, (Object)edgeName, (Object)rowset.getName(), (Object)rowsetId.toString());
        }
        if (rowset.getHeaderRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_HeaderRowsetInCrossTab, (Object)edgeName, (Object)rowset.getName(), (Object)rowsetId.toString());
        }
        if (rowset.getFooterRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_FooterRowsetInCrossTab, (Object)edgeName, (Object)rowset.getName(), (Object)rowsetId.toString());
        }
        this.ensureRowsetsValidForCrossTab(rowset.getNestedRowset(), edgeName);
        this.ensureRowsetsValidForCrossTab(rowset.getSiblingRowset(), edgeName);
    }

    public void identifyEmptyEdges() {
        int position = 0;
        for (RSAPIEdge edge : this.getEdges()) {
            boolean edgeHasDataItems = false;
            for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                if (rowset.getRefDataItem() == null && rowset.getNumDataItems() <= 0) continue;
                edgeHasDataItems = true;
                break;
            }
            if (edgeHasDataItems) {
                edge.setHybridResultSetEdgePosition(position++);
                continue;
            }
            edge.setHybridResultSetEdgePosition(-1);
            this.hasEmptyEdge = true;
        }
        this.emptyEdgesIdentified = true;
    }

    public boolean getEmptyEdgesIdentified() {
        return this.emptyEdgesIdentified;
    }

    public boolean hasEmptyEdge() {
        return this.hasEmptyEdge;
    }

    public void adjustDataItemTypes() {
        this.dataTypesAdjusted = true;
        if (!this.isCrossTabReport()) {
            return;
        }
        for (RSAPIEdge edge : this.getEdges()) {
            for (int j = 0; j < edge.getNumRowsets(); ++j) {
                RSAPIEdgeRowset rowset = edge.getRowset(j);
                RSAPIDataItem dataItem = rowset.getRefDataItem();
                IDataType datatype = dataItem.getDataType();
                if (null == datatype) {
                    datatype = VariantType.VARIANT;
                }
                if (datatype.getSubType() == DataSubType.NUMERICTYPE && dataItem.getUsage() == RSAPIUsage.IDENTIFIER || dataItem.getUsage() == RSAPIUsage.UNKNOWN) continue;
                if (dataItem.getDataType() != MemberType.MEMBERTYPE && dataItem.getUsage() != RSAPIUsage.FACT && dataItem.getUsage() != RSAPIUsage.ATTRIBUTE) {
                    dataItem.setDataType(MemberType.MEMBERTYPE);
                }
                if (dataItem.getDataType() != null) continue;
                dataItem.setDataType(VariantType.VARIANT);
            }
        }
    }

    private boolean needAdjustDataType() {
        RSAPIEdge[] edges;
        for (RSAPIEdge edge : edges = this.getEdges()) {
            for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                for (RSAPIDataItem dataItem : rowset.getDataItems()) {
                    if (!dataItem.needAdjustDataType()) continue;
                    return true;
                }
                RSAPIDataItem refDataItem = rowset.getRefDataItem();
                if (refDataItem == null || !refDataItem.needAdjustDataType()) continue;
                return true;
            }
        }
        return false;
    }

    public void adjustDataItemTypes(ExecutionEnvironment executionEnv) {
        if (!this.isListReport()) {
            return;
        }
        XValueDecoration xNode = (XValueDecoration)this.getFirstDescendantOfTypeOrdered(501043, false);
        if (xNode == null) {
            return;
        }
        boolean bValidateFromFM = false;
        if ("validate".equals(((RequestEnvironment)executionEnv.getRequestEnvironment()).getOperationName()) && "FMRequest".equals(((RequestEnvironment)executionEnv.getRequestEnvironment()).getRequestID())) {
            bValidateFromFM = true;
        }
        if (!this.needAdjustDataType() && !bValidateFromFM) {
            return;
        }
        RSAPIResultSet resultSet = this.execute(executionEnv, false);
        IRowsetInfo rowsetInfo = resultSet.getResultSet().getTabularRowsetInfo();
        if (null == rowsetInfo) {
            return;
        }
        List<SQLAlias> aliasList = xNode.getAliasList();
        if (null == aliasList) {
            return;
        }
        RSAPIEdge[] edges = this.getEdges();
        for (int j = 0; j < rowsetInfo.getNumColumns(); ++j) {
            IColumnInfo columnInfo = rowsetInfo.getColumnInfo(j);
            SQLAlias aliasNode = aliasList.get(j);
            for (RSAPIEdge edge : edges) {
                for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                    RSAPIDataItem dataItem;
                    if (!rowset.getName().equals(aliasNode.getRowsetName()) || (dataItem = this.findRSAPIDataItem(rowset, aliasNode)) == null || !dataItem.needAdjustDataType() && !bValidateFromFM) continue;
                    if (bValidateFromFM) {
                        dataItem.setValidateFromFM(bValidateFromFM);
                    }
                    dataItem.setDataType(columnInfo.getDataType());
                    dataItem.adjustParamDataType(columnInfo.getDataType());
                    dataItem.setAdjustDataTypeFromResultSet(false);
                }
            }
        }
    }

    private RSAPIDataItem findRSAPIDataItem(RSAPIEdgeRowset rowset, SQLAlias aliasNode) {
        for (RSAPIDataItem dataItem : rowset.getDataItems()) {
            if (!dataItem.getName().equals(aliasNode.getColumnName())) continue;
            return dataItem;
        }
        RSAPIDataItem refDataItem = rowset.getRefDataItem();
        if (refDataItem != null && refDataItem.getName().equals(aliasNode.getColumnName())) {
            return refDataItem;
        }
        return null;
    }

    public boolean getDataTypesAdjusted() {
        return this.dataTypesAdjusted;
    }

    public void releaseResultset(IExecutionEnvironment executionEnvironment) {
        MultiRequestContext context;
        RSAPIResultSet result;
        if (DATASET_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Releasing resultset for RSAPIDataset with id=").append(this.getUniqueID());
            DATASET_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if ((result = (context = executionEnvironment.getMultiRequestContext()).removeResultset(this)) != null) {
            result.release();
        }
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        RSAPIDataset rsapiNode = (RSAPIDataset)node;
        rsapiNode.mEdges.addAll(this.mEdges);
        rsapiNode.mRefQueryName = this.mRefQueryName;
        rsapiNode.mName = this.mName;
        rsapiNode.mReportType = this.mReportType;
        rsapiNode.mOriginalRefQueryName = this.mOriginalRefQueryName;
    }

    public String getCognosSQL() {
        return this.cognosSQL;
    }

    public void setCognosSQL(String sql) {
        this.cognosSQL = sql;
    }

    @Override
    public String getSQLComments() {
        return this.sqlComments;
    }

    public void setSQLComments(String comments) {
        this.sqlComments = comments;
    }

    @Override
    public Governors getGovernors() {
        if (this.governors != null) {
            return this.governors;
        }
        IXQEQueryNode parent = this.getParent();
        if (parent == null) {
            this.throwInternalError("Governors not found.");
        }
        return parent.getGovernors();
    }

    @Override
    public void setGovernors(Governors g) {
        this.governors = g;
    }

    public boolean isUseSAPMUNAsBusinessKey() {
        return this.mUseSAPMUNAsBusinessKey;
    }

    public void setUseSAPMUNAsBusinessKey(boolean useSAPMUNAsBusinessKey) {
        this.mUseSAPMUNAsBusinessKey = useSAPMUNAsBusinessKey;
    }

    void registerPartialDataset(RSAPIPartialDataset thePartialDataset) {
        this.activePartialDatasets.add(thePartialDataset);
    }

    void deregisterPartialDataset(RSAPIPartialDataset thePartialDataset) {
        this.activePartialDatasets.remove(thePartialDataset);
    }

    public RSAPIPartialDataset[] getActivePartialDatasets() {
        return this.activePartialDatasets.toArray(new RSAPIPartialDataset[0]);
    }

    public void setXmdxNodeId(Integer nodeId) {
        this.xMdxNodeId = nodeId;
    }

    public final void setReportType(int type) {
        this.mReportType = type;
    }

    public void setIncludeEmptyCells(boolean aIncludeEmptyCells) {
        this.includeEmptyCells = aIncludeEmptyCells;
    }

    public boolean getIncludeEmptyCells() {
        return this.includeEmptyCells;
    }

    public void setQueryFeedbacks(Set<String> feedbacks) {
        this.queryFeedbacks = feedbacks;
    }

    @Override
    public boolean queryFeedbackIsRequested(String feedback) {
        if (this.queryFeedbacks == null) {
            return false;
        }
        return this.queryFeedbacks.contains(feedback);
    }

    public Boolean getAllowNonNumericCellValue() {
        return this.allowNonNumericCellValues;
    }

    public void setAllowNonNumericCellValue(Boolean flag) {
        this.allowNonNumericCellValues = flag;
    }

    public boolean isGenerateDerivedRowsInRSAPI() {
        return this.generateDerivedRowsInRSAPI;
    }

    public void setGenerateDerivedRowsInRSAPI(boolean flag) {
        this.generateDerivedRowsInRSAPI = flag;
    }

    public void setNoMetadataMode() {
        this.noMetadataMode = true;
    }

    public boolean isNoMetadataMode() {
        return this.noMetadataMode;
    }

    public boolean forDMRReport() {
        return this.forDMR;
    }

    public void setForDMRReport(boolean setting) {
        this.forDMR = setting;
    }

    public boolean forXtabRelational() {
        return this.forXtabRel;
    }

    public void setForXtabRelational(boolean setting) {
        this.forXtabRel = setting;
    }

    public boolean transferMembers() {
        return this.transferMembers;
    }

    public void setTransferMembers(boolean setting) {
        this.transferMembers = setting;
    }

    @Override
    public SQLCursorCollectionFormatter getExecutionSQLCursors() {
        return this.nativeSQLCursors;
    }

    @Override
    public boolean hasDQPostProcessing() {
        return ((XNode)this.getChild(0)).hasDQPostProcessing();
    }

    @Override
    public IValue getJDBCTabularResultSet(XDataContext context) {
        return ((XNode)this.getChild(0)).getJDBCTabularResultSet(context);
    }

    @Override
    public boolean loadInBackground() {
        if (this.getChild(0) instanceof XNode) {
            XNode xn = (XNode)this.getChild(0);
            return xn.loadInBackground();
        }
        return false;
    }

    public boolean projectsMeasures() {
        for (RSAPIEdge edge : this.getEdges()) {
            for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                RSAPIDataItem dataItem;
                if (rowset.isFooterRowset() || rowset.isHeaderRowset()) continue;
                if (rowset.getRefDataItem() != null && (dataItem = rowset.getRefDataItem()).getUsage() == RSAPIUsage.FACT && !dataItem.isGroupbodyMeasure()) {
                    return true;
                }
                for (RSAPIDataItem dataItem2 : rowset.getDataItems()) {
                    if (dataItem2.getUsage() != RSAPIUsage.FACT || dataItem2.isGroupbodyMeasure()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<Integer> getXV5ReinsertEdgePathElementsTargets() {
        return this.xV5ReinsertEdgePathElementsTargets;
    }

    public void addXV5ReinsertEdgePathElementsTarget(Integer edgeOrdinal) {
        if (edgeOrdinal == null) {
            return;
        }
        if (this.xV5ReinsertEdgePathElementsTargets == null) {
            this.xV5ReinsertEdgePathElementsTargets = new ArrayList<Integer>();
        }
        if (!this.xV5ReinsertEdgePathElementsTargets.contains(edgeOrdinal)) {
            this.xV5ReinsertEdgePathElementsTargets.add(edgeOrdinal);
        }
    }

    public void setSqlToMessageFolderToTrue() {
        this.sqlToMessageFolder = true;
    }

    @Override
    public boolean getSqlToMessageFolder() {
        return this.sqlToMessageFolder;
    }

    public void setQueryPlan(byte[] plan) {
        this.queryPlan = plan;
    }

    @Override
    public byte[] getQueryPlan() {
        return this.queryPlan;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(STRING_NAME, this.mName);
        if (this.xMdxNodeId != null) {
            ctx.property(XMDX_NODE_ID, this.xMdxNodeId);
        }
        ctx.property(STRING_REF_QUERY, this.mRefQueryName);
        ctx.property(STRING_ALL_ROWS, this.mAllRows);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(STRING_PROPERTY_EDGES, this.mEdges);
        if (this.mCellRowset != null) {
            ctx.elementProperty(STRING_PROPERTY_CELL_ROWSET, this.mCellRowset);
        }
    }

    public RSAPIEdgeRowset getEdgeRowsetByName(String name) {
        RSAPIEdgeRowset result = null;
        if (this.mEdges != null) {
            Iterator<RSAPIEdge> iter = this.mEdges.iterator();
            while (result == null && iter.hasNext()) {
                RSAPIEdge edge = iter.next();
                RSAPIEdgeRowset[] rowsets = edge.getRowsets();
                for (int count = 0; result == null && count < rowsets.length; ++count) {
                    RSAPIEdgeRowset rowset = rowsets[count];
                    if (!rowset.getName().equals(name)) continue;
                    result = rowset;
                }
            }
        }
        return result;
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attName = att.getName();
        Object value = ctx.attributeValue(att);
        if (attName.equals(STRING_NAME)) {
            this.mName = (String)value;
        } else if (attName.equals(XMDX_NODE_ID)) {
            this.xMdxNodeId = (Integer)value;
        } else if (attName.equals(STRING_REF_QUERY)) {
            this.mRefQueryName = (String)value;
        } else if (attName.equals(STRING_ALL_ROWS)) {
            this.mAllRows = (Boolean)value;
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null) {
            Object value = ctx.elementValue(node);
            if (pname.equals(STRING_PROPERTY_EDGES)) {
                this.mEdges = (List)value;
            } else if (pname.equals(STRING_PROPERTY_CELL_ROWSET)) {
                this.mCellRowset = (RSAPICellRowset)value;
            }
        }
    }

    @Override
    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        ctx.setOwner(this);
        super.restoreChildren(ctx, node);
        ctx.resetOwner();
    }

    public boolean isVectorizedQueryExecutionEnabled() {
        return this.vqeEnabled;
    }

    public void setVectorizedQueryExecutionEnabled(boolean enabled) {
        this.vqeEnabled = enabled;
    }

    public DatasetInfoExtended addExtendedDatasetInfoIfNotExist() {
        if (this.dataSetInfoEx == null) {
            this.dataSetInfoEx = new DatasetInfoExtended(this.mName);
        }
        return this.getExtendedDatasetInfo();
    }

    public DatasetInfoExtended getExtendedDatasetInfo() {
        return this.dataSetInfoEx;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public long getDataCacheExpiry() {
        if (this.dataCacheExpiry <= 0L) {
            return 0L;
        }
        return this.dataCacheExpiry;
    }

    public void setDataCacheExpiry(long dataCacheExpiry) {
        if (dataCacheExpiry > 0L) {
            this.dataCacheExpiry = dataCacheExpiry;
        }
    }

    public long getCurrentDataCacheExpiry() {
        if (this.currentDataCacheExpiry <= 0L) {
            return 0L;
        }
        return this.currentDataCacheExpiry;
    }

    public void setCurrentDataCacheExpiry(long currentDataCacheExpiry) {
        if (currentDataCacheExpiry > 0L) {
            this.currentDataCacheExpiry = currentDataCacheExpiry;
        }
    }

    public void setForSqlQuery(boolean forSqlquery) {
        this.isForSqlQuery = forSqlquery;
    }

    public void setForDetailQuery(boolean forDetailquery) {
        this.isForDetailQuery = forDetailquery;
    }

    public boolean getForSqlQuery() {
        return this.isForSqlQuery;
    }

    public void setForOLAPQuery(boolean forOLAPquery) {
        this.isForOLAPQuery = forOLAPquery;
    }

    public boolean isForOLAPQuery() {
        return this.isForOLAPQuery;
    }

    public void setForRelationalOLAPQuery(boolean forRelationalOLAPquery) {
        this.isForRelationalOLAPQuery = forRelationalOLAPquery;
    }

    public boolean isForRelationalOLAPQuery() {
        return this.isForRelationalOLAPQuery;
    }

    public static void transferDataItemTypes(RSAPIDataset fromDataset, RSAPIDataset toDataset) {
        RSAPIEdge[] fromEdges = fromDataset.getEdges();
        RSAPIEdge[] toEdges = toDataset.getEdges();
        for (int iEdge = 0; iEdge < toEdges.length; ++iEdge) {
            RSAPIEdgeRowset[] fromRowsets = fromEdges[iEdge].getRowsets();
            RSAPIEdgeRowset[] toRowsets = toEdges[iEdge].getRowsets();
            for (int iRowset = 0; iRowset < toRowsets.length; ++iRowset) {
                RSAPIDataItem[] fromDItems = fromRowsets[iRowset].getDataItems();
                RSAPIDataItem[] toDItems = toRowsets[iRowset].getDataItems();
                for (int iItem = 0; iItem < toDItems.length; ++iItem) {
                    if (!toDItems[iItem].needAdjustDataType()) continue;
                    toDItems[iItem].setDataType(fromDItems[iItem].getDataType());
                    toDItems[iItem].setAdjustDataTypeFromResultSet(false);
                }
                RSAPIDataItem refDataItem = toRowsets[iRowset].getRefDataItem();
                if (refDataItem == null || !refDataItem.needAdjustDataType()) continue;
                refDataItem.setDataType(fromRowsets[iRowset].getRefDataItem().getDataType());
            }
        }
    }

    public boolean hasNonDetailGroupBody() {
        for (RSAPIEdge edge : this.getEdges()) {
            if (!edge.hasNonDetailGroupBody()) continue;
            return true;
        }
        return false;
    }

    public void setHasSampledData() {
        this.mHasSampledData = true;
    }

    public boolean hasSampledData() {
        return this.mHasSampledData;
    }

    public Map<Integer, List<RowInfo>> getRESTRowInfo() {
        return this.restRowInfo;
    }

    public void setRESTRowInfo(Map<Integer, List<RowInfo>> aRowInfo) {
        this.restRowInfo = aRowInfo;
    }

    public void setReturnDataItemNameInPartialDataset(PlanningEnvironment env) {
        if (this.mReturnDataItemNameInPartialDataset == null) {
            boolean defaultSetting = true;
            if (null != env && null != env.getMultiRequestContext()) {
                boolean value = env.getMultiRequestContext().fetchBooleanConfiguration("general.rsapi.returnDataItemNameInPartialDataset[@enabled]", defaultSetting);
                this.mReturnDataItemNameInPartialDataset = new Boolean(value);
            } else {
                this.mReturnDataItemNameInPartialDataset = new Boolean(defaultSetting);
            }
        }
    }

    public boolean getReturnDataItemNameInPartialDataset() {
        return this.mReturnDataItemNameInPartialDataset != null && this.mReturnDataItemNameInPartialDataset != false;
    }
}

