/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEProperty;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIReportLayoutException;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIEdge;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RSAPIEdge
implements IRSAPIEdge,
IXQEProperty,
IXQEPersist {
    private static final String STRING_PROPERTY_ROWSETS = "rowsets";
    private static final String STRING_PROPERTY_ROWSET_ID = "rowsetId";
    private static final String STRING_ROOT_ROWSET = "rootRowset";
    private static final String STRING_ALL_ROWS = "allRows";
    private static final String STRING_NEXT_ROWSET_ID = "nextRowsetId";
    private static final String STRING_MAX_ROWS_RETRIEVED = "maxRowsRetrieved";
    private static final int UNKNOWN_NUMBER_OF_COORDINATES = -1;
    public static final int NO_HYBRID_RESULT_EDGE = -1;
    private String mName;
    private int mOrdinal;
    RSAPIEdgeRowset mRootRowset;
    Map<Integer, RSAPIEdgeRowset> mRowsets = new TreeMap<Integer, RSAPIEdgeRowset>();
    private boolean mAllRows;
    private int mNextRowsetId = 0;
    private RSAPIDataset mDataset;
    private int mHybridResultSetEdgePosition;
    RSAPIEdgeRowset[] mRowsetArray;
    private int mMaxRowsRetrieved = 0;
    private static final String ATTRIBUTE_NUM_ROWSETS = "numRowsets";
    private static final String STRING_NAME = "name";
    public static final String STRING_EDGE = "edge";
    private static final String STRING_ORDINAL = "ordinal";
    private static final String STRING_HYBRIDRESULTSET_EDGE_POSITION = "hybridResultSetEdgePosition";
    private static final String STRING_TRUE = "true";
    public static final int REPORT_ROWSET = -1;
    private static final String STRING_EMPTY = "empty";

    public boolean isAllRows() {
        return this.mAllRows;
    }

    public void setAllRows(boolean allRows) {
        this.mAllRows = allRows;
    }

    public RSAPIEdge() {
    }

    public RSAPIEdge(int nextRowsetId) {
        this.mNextRowsetId = nextRowsetId;
    }

    public void setName(String name) {
        this.mName = name != null ? name : null;
    }

    public void setOrdinal(int ordinal) {
        this.mOrdinal = ordinal;
    }

    public void addRowset(RSAPIEdgeRowset rowset) {
        this.addRowsetToMap(rowset);
    }

    public void setRootRowset(RSAPIEdgeRowset rowset) {
        this.mRootRowset = rowset;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public int getPositionalOrdinal() {
        return this.getDataset().getEdgeOrdinal(this);
    }

    @Override
    public int getNumRowsets() {
        return this.mRowsets.size();
    }

    @Override
    public int getNumCoordinates(boolean mustCalculate) {
        return -1;
    }

    public RSAPIEdgeRowset[] getRowsets() {
        if (this.mRowsets.size() == 0) {
            return new RSAPIEdgeRowset[0];
        }
        if (this.mRowsetArray != null && this.mRowsetArray.length == this.mRowsets.size()) {
            return this.mRowsetArray;
        }
        this.mRowsetArray = new RSAPIEdgeRowset[this.mRowsets.size()];
        int i = 0;
        for (Map.Entry<Integer, RSAPIEdgeRowset> entry : this.mRowsets.entrySet()) {
            this.mRowsetArray[i++] = entry.getValue();
        }
        return this.mRowsetArray;
    }

    public RSAPIEdgeRowset getRowset(int rowsetId) {
        return this.mRowsets.get(XQEIntegerPool.getInteger(rowsetId));
    }

    private void addRowsetToMap(RSAPIEdgeRowset rowset) {
        this.mRowsets.put(XQEIntegerPool.getInteger(rowset.getRowsetId()), rowset);
        if (rowset.getHeaderRowset() != null) {
            this.addRowsetToMap(rowset.getHeaderRowset());
            rowset.getHeaderRowset().setParentRowset(rowset.getParentRowset());
        }
        if (rowset.getFooterRowset() != null) {
            this.addRowsetToMap(rowset.getFooterRowset());
            rowset.getFooterRowset().setParentRowset(rowset.getParentRowset());
        }
        if (rowset.getNestedRowset() != null) {
            this.addRowsetToMap(rowset.getNestedRowset());
            rowset.getNestedRowset().setParentRowset(rowset);
        }
        if (rowset.getSiblingRowset() != null) {
            this.addRowsetToMap(rowset.getSiblingRowset());
            rowset.getSiblingRowset().setParentRowset(rowset.getParentRowset());
        }
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, internal, 0);
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        if (internal) {
            writer.beginElement(STRING_EDGE, -1);
        } else {
            writer.beginElement("edgeInfo", -1);
        }
        writer.attribute(STRING_NAME, this.mName);
        if (internal) {
            writer.attribute(STRING_ORDINAL, this.getDataset().getEdgeOrdinal(this));
            if (this.getHybridResultSetEdgePosition() == -1) {
                writer.attribute(STRING_EMPTY, STRING_TRUE);
            }
        } else {
            writer.attribute(STRING_ORDINAL, this.mOrdinal);
        }
        if (internal) {
            writer.attribute(STRING_HYBRIDRESULTSET_EDGE_POSITION, this.mHybridResultSetEdgePosition);
        }
        if (!internal) {
            if (this.mRowsets == null) {
                writer.attribute(ATTRIBUTE_NUM_ROWSETS, 0);
            } else {
                writer.attribute(ATTRIBUTE_NUM_ROWSETS, this.mRowsets.size());
            }
        }
        if (completeDump && this.mRowsets != null) {
            for (Map.Entry<Integer, RSAPIEdgeRowset> entry : this.mRowsets.entrySet()) {
                entry.getValue().toXMLString(writer, completeDump, internal, datatypesToDisplay);
            }
        }
        writer.endElement();
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, true);
    }

    public RSAPIEdgeRowset getRootRowset() {
        return this.mRootRowset;
    }

    public int getNextRowsetId() {
        return this.mNextRowsetId++;
    }

    public int getLastRowsetId() {
        return this.mNextRowsetId;
    }

    protected void capture(PlanningEnvironment env, Element inputNode) {
        this.assignAttributeValues(inputNode);
        List childList = inputNode.elements();
        for (Element child : childList) {
            Attribute attribute = child.attribute(STRING_PROPERTY_ROWSET_ID);
            Integer rowsetId = new Integer(attribute.getStringValue());
            RSAPIEdgeRowset edgeRowset = this.getRowset(rowsetId);
            if (edgeRowset == null) {
                edgeRowset = new RSAPIEdgeRowset();
                edgeRowset.setEdge(this);
            }
            edgeRowset.capture(this, env, child);
            this.addRowset(edgeRowset);
        }
        this.identifyRootRowset();
    }

    private void identifyRootRowset() {
        for (RSAPIEdgeRowset rowset : this.getRowsets()) {
            if (rowset.getParentRowset() != null || rowset.isFooterRowset() || rowset.isHeaderRowset()) continue;
            this.setRootRowset(rowset);
            break;
        }
    }

    private void assignAttributeValues(Element inputNode) {
        this.setName(inputNode.attribute(STRING_NAME).getStringValue());
        Integer ordinal = new Integer(inputNode.attribute(STRING_ORDINAL).getStringValue());
        this.setOrdinal(ordinal);
        Attribute attribute = inputNode.attribute(STRING_EMPTY);
        if (attribute != null && attribute.getStringValue().equalsIgnoreCase(STRING_TRUE)) {
            this.setHybridResultSetEdgePosition(-1);
        }
        if ((attribute = inputNode.attribute(STRING_HYBRIDRESULTSET_EDGE_POSITION)) != null) {
            Integer hybridResultSetEdgePosition = new Integer(attribute.getStringValue());
            this.setHybridResultSetEdgePosition(hybridResultSetEdgePosition);
        }
    }

    public void setDataset(RSAPIDataset dataset) {
        this.mDataset = dataset;
    }

    public RSAPIDataset getDataset() {
        return this.mDataset;
    }

    public int getHybridResultSetEdgePosition() {
        return this.mHybridResultSetEdgePosition;
    }

    protected void setHybridResultSetEdgePosition(int position) {
        this.mHybridResultSetEdgePosition = position;
    }

    public boolean isEmpty() {
        return this.mHybridResultSetEdgePosition == -1;
    }

    protected void validateInterRowsetRelationships(RSAPIEdgeRowset rowset) {
        if (rowset == null) {
            return;
        }
        if (rowset.getHeaderRowset() != null) {
            this.validateSummaryRowsetRelationships(rowset.getParentRowset(), rowset.getHeaderRowset());
        }
        if (rowset.getFooterRowset() != null) {
            this.validateSummaryRowsetRelationships(rowset.getParentRowset(), rowset.getFooterRowset());
        }
        if (rowset.getSiblingRowset() != null) {
            if (rowset.getSiblingRowset().getParentRowset() != rowset.getParentRowset()) {
                Integer rowsetId = XQEIntegerPool.getInteger(rowset.getSiblingRowset().getRowsetId());
                Integer parentRowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
                throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_RowsetHasInvalidParentRowset, rowset.getSiblingRowset().getName(), (Object)rowsetId.toString(), (Object)rowset.getName(), (Object)parentRowsetId.toString());
            }
            this.validateInterRowsetRelationships(rowset.getSiblingRowset());
        }
    }

    private void validateSummaryRowsetRelationships(RSAPIEdgeRowset parent, RSAPIEdgeRowset rowset) {
        if (rowset.getParentRowset() != parent) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            Integer parentRowsetId = XQEIntegerPool.getInteger(parent.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_RowsetHasInvalidParentRowset, rowset.getName(), (Object)rowsetId.toString(), (Object)parent.getName(), (Object)parentRowsetId.toString());
        }
        if (rowset.getNestedRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_SummaryRowsetWithNestedRowset, rowset.getName(), rowsetId.toString());
        }
        if (rowset.getSiblingRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_SummaryRowsetWithSiblingRowset, rowset.getName(), rowsetId.toString());
        }
        if (rowset.getHeaderRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_SummaryRowsetWithHeaderRowset, rowset.getName(), rowsetId.toString());
        }
        if (rowset.getFooterRowset() != null) {
            Integer rowsetId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            throw new RSAPIReportLayoutException(XQEMessageKeys.RSA_SummaryRowsetWithFooterRowset, rowset.getName(), rowsetId.toString());
        }
    }

    public void setMaxRowsRetrieved() {
        Governors governors;
        int numEdges = this.mDataset.getEdges().length;
        if ((numEdges == 1 && this.mOrdinal == 0 || numEdges > 1 && this.mOrdinal == 1) && (governors = this.mDataset.getGovernors()) != null && governors.getMaxRowsRetrieved() > 0) {
            int maxRowsRetrieved;
            this.mMaxRowsRetrieved = maxRowsRetrieved = governors.getMaxRowsRetrieved();
        }
    }

    public int getMaxRowsRetrieved() {
        return this.mMaxRowsRetrieved;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            ctx.property(STRING_NAME, this.mName);
            ctx.property(STRING_ORDINAL, this.mOrdinal);
            if (this.mRootRowset != null) {
                ctx.property(STRING_ROOT_ROWSET, this.mRootRowset.getRowsetId());
            }
            ctx.property(STRING_ALL_ROWS, this.mAllRows);
            ctx.property(STRING_NEXT_ROWSET_ID, this.mNextRowsetId);
            ctx.property(STRING_MAX_ROWS_RETRIEVED, this.mMaxRowsRetrieved);
            ctx.property(STRING_HYBRIDRESULTSET_EDGE_POSITION, this.mHybridResultSetEdgePosition);
            if (this.mRowsets != null) {
                ctx.elementProperty(STRING_PROPERTY_ROWSETS, this.mRowsets);
            }
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Object value;
            Attribute att = node.attribute(i);
            String attname = att.getName();
            if (attname.equals(STRING_NAME)) {
                value = ctx.attributeValue(att);
                this.mName = (String)value;
                continue;
            }
            if (attname.equals(STRING_ORDINAL)) {
                value = ctx.attributeValue(att);
                this.mOrdinal = (Integer)value;
                continue;
            }
            if (attname.equals(STRING_ALL_ROWS)) {
                value = ctx.attributeValue(att);
                this.mAllRows = (Boolean)value;
                continue;
            }
            if (attname.equals(STRING_NEXT_ROWSET_ID)) {
                value = ctx.attributeValue(att);
                this.mNextRowsetId = (Integer)value;
                continue;
            }
            if (attname.equals(STRING_MAX_ROWS_RETRIEVED)) {
                value = ctx.attributeValue(att);
                this.mMaxRowsRetrieved = (Integer)value;
                continue;
            }
            if (!attname.equals(STRING_HYBRIDRESULTSET_EDGE_POSITION)) continue;
            value = ctx.attributeValue(att);
            this.mHybridResultSetEdgePosition = (Integer)value;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        ctx.setOwner(this);
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            String pname = child.attributeValue("pname");
            if (pname == null || !pname.equals(STRING_PROPERTY_ROWSETS)) continue;
            Object value = ctx.elementValue(child);
            this.mRowsets = (Map)value;
            this.restoreRowsets(child, node);
        }
        ctx.resetOwner();
    }

    private void restoreRowsets(Element node, Element edgeNode) {
        int rootRowsetId = -1;
        String rootRowsetIdAttr = edgeNode.attributeValue(STRING_ROOT_ROWSET);
        if (rootRowsetIdAttr != null) {
            rootRowsetId = Integer.parseInt(rootRowsetIdAttr);
        }
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child;
            String id;
            Element entry = (Element)childList.get(i);
            List entryList = entry.elements();
            if (entryList.size() != 2 || (id = (child = (Element)entryList.get(1)).attributeValue(STRING_PROPERTY_ROWSET_ID)) == null) continue;
            int rowsetId = Integer.valueOf(id);
            RSAPIEdgeRowset rowset = this.mRowsets.get(rowsetId);
            if (rowset != null) {
                rowset.setEdge(this);
                rowset.restoreRelations(child, this.mRowsets);
            }
            if (rootRowsetId != rowsetId) continue;
            this.mRootRowset = rowset;
        }
    }

    public boolean hasNonDetailGroupBody() {
        for (RSAPIEdgeRowset rowset : this.getRowsets()) {
            if (rowset.getRefDataItem() == null || rowset.getNumDataItems() <= 0) continue;
            return true;
        }
        return false;
    }
}

