/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPITabularRow;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.Queue;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class RSAPITabularIterator
implements IReleasable {
    private XIterator mIterator;
    private boolean mEod;
    private boolean generateEndFooters = false;
    private boolean generateOverallHeader = false;
    private int mRowNumber = -1;
    private RSAPITabularRow[] mTabularRows;
    private IRow mRow;
    private RSAPIEdge mEdge;
    private boolean[] mRemoveRowFromQueueOfRows;
    private int[] mRowsetParents;
    private Queue mQueueOfRows;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    XQETrace iteratorTrace = null;

    public RSAPITabularIterator(RSAPIEdge edge, XIterator iterator, boolean isCrossTabReport) {
        try {
            this.mEdge = edge;
            this.mIterator = iterator;
            this.setQueueOfRows(new Queue());
            this.mTabularRows = new RSAPITabularRow[edge.getNumRowsets()];
            this.mRemoveRowFromQueueOfRows = new boolean[edge.getNumRowsets()];
            this.initializeRows(isCrossTabReport);
            this.initializeRowsetParents();
            if (edge.getDataset().isGenerateDerivedRowsInRSAPI() && !isCrossTabReport) {
                this.generateOverallHeader = true;
                this.generateEndFooters = true;
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    private void initializeRowsetParents() {
        this.mRowsetParents = new int[this.mEdge.getNumRowsets()];
        for (int i = 0; i < this.mEdge.getNumRowsets(); ++i) {
            this.mRowsetParents[i] = this.mEdge.getRowset(i).getParentRowset() != null ? this.mEdge.getRowset(i).getParentRowset().getRowsetId() : -1;
        }
    }

    private void initializeRows(boolean isCrossTabReport) {
        for (int i = 0; i < this.mEdge.getNumRowsets(); ++i) {
            this.mTabularRows[i] = new RSAPITabularRow(this.mEdge.getRowset(i), this, isCrossTabReport);
        }
    }

    public RSAPITabularRow next() {
        if (this.mEod) {
            return null;
        }
        this.openIteratorTrace();
        RSAPITabularRow row = this.getNextTabularRow();
        this.traceRow("inRow", row);
        if (row == null) {
            this.closeIteratorTrace();
            this.mEod = true;
        }
        return row;
    }

    public RSAPITabularRow peek() {
        if (this.mEod) {
            return null;
        }
        this.loadRowsFromTabularIterator();
        if (this.getQueueOfRows().size() == 0) {
            return null;
        }
        this.removeExtraneousRowsOfData();
        return (RSAPITabularRow)this.getQueueOfRows().first();
    }

    private RSAPITabularRow getNextTabularRow() {
        if (this.getQueueOfRows().size() == 0 && this.generateOverallHeader) {
            this.generateOverallHeader = false;
            RSAPIEdgeRowset root = this.mEdge.getRootRowset();
            if (root.getHeaderRowset() != null && root.getHeaderRowset().isEmpty()) {
                RSAPITabularRow overallHeaderRow = this.mTabularRows[root.getHeaderRowset().getRowsetId()];
                overallHeaderRow.setRowNumber(this.mRowNumber++);
                overallHeaderRow.setParentRowsetId(-1);
                return overallHeaderRow;
            }
        }
        this.loadRowsFromTabularIterator();
        if (this.getQueueOfRows().size() == 0 && this.generateEndFooters) {
            this.generateEndFooters = false;
            this.generateNestedFooterRows(this.mEdge.getRootRowset(), true);
            this.identifyParentRowsets();
            if (this.getQueueOfRows().size() > 0) {
                this.mEod = false;
            }
        }
        if (this.getQueueOfRows().size() == 0) {
            return null;
        }
        RSAPITabularRow ret = (RSAPITabularRow)this.getQueueOfRows().take();
        if (this.mEdge.getDataset().isGenerateDerivedRowsInRSAPI()) {
            this.generateDerivedDataItems(ret);
        }
        return ret;
    }

    private void generateNestedFooterRows(RSAPIEdgeRowset rowset, boolean includeSelf) {
        if (!includeSelf) {
            rowset = rowset.getNestedRowset();
        }
        ArrayList<RSAPITabularRow> emptyFooters = new ArrayList<RSAPITabularRow>();
        while (rowset != null) {
            RSAPIEdgeRowset footerRowset = rowset.getFooterRowset();
            if (footerRowset != null) {
                RSAPITabularRow footerRow = null;
                if (footerRowset.isDerivedRowset()) {
                    footerRow = (RSAPITabularRow)this.mTabularRows[footerRowset.getRowsetId()].copy();
                }
                if (footerRow != null) {
                    emptyFooters.add(0, footerRow);
                    footerRow.setRowNumber(this.mRowNumber);
                }
            }
            rowset = rowset.getNestedRowset();
        }
        for (RSAPITabularRow footer : emptyFooters) {
            this.getQueueOfRows().put(footer);
        }
    }

    private void removeExtraneousRowsOfData() {
        RSAPITabularRow row;
        while ((row = (RSAPITabularRow)this.getQueueOfRows().first()) != null && row.isGrouped() && !row.isControlBreak()) {
            this.getQueueOfRows().take();
        }
        for (int rowsetId = 0; rowsetId < this.mEdge.getNumRowsets(); ++rowsetId) {
            if (this.getCurrentListOfRowsToRemove()[rowsetId]) {
                for (int j = 0; j < this.getQueueOfRows().size(); ++j) {
                    RSAPITabularRow row2 = (RSAPITabularRow)this.getQueueOfRows().get(j);
                    if (row2.getRowsetId() != rowsetId) continue;
                    this.getQueueOfRows().remove(row2);
                    break;
                }
            }
            this.getCurrentListOfRowsToRemove()[rowsetId] = false;
        }
    }

    private void loadRowsFromTabularIterator() {
        if (this.getQueueOfRows().size() > 0) {
            return;
        }
        this.mRow = (IRow)this.mIterator.next();
        if (this.mRow == null) {
            this.mEod = true;
            return;
        }
        this.constructV5Rows(this.mRow);
        this.identifyParentRowsets();
        this.removeExtraneousRowsOfData();
        this.identifyDetailRows();
        if (this.mEdge.getDataset().isGenerateDerivedRowsInRSAPI()) {
            while (!this.mEod && this.getQueueOfRows().size() == 0) {
                this.loadRowsFromTabularIterator();
            }
        }
    }

    private void identifyParentRowsets() {
        for (int i = 0; i < this.getQueueOfRows().size(); ++i) {
            RSAPITabularRow row = (RSAPITabularRow)this.getQueueOfRows().get(i);
            int parentRowsetId = row.getParentRowsetIdAsPerReportLayout();
            boolean parentFound = false;
            RSAPIEdgeRowset rowset = row.getRowset();
            if (rowset.isDerivedRowset()) {
                row.setParentRowsetId(parentRowsetId);
                continue;
            }
            if (parentRowsetId != -1 && (rowset = this.mEdge.getRowset(parentRowsetId)).isDerivedRowset()) {
                row.setParentRowsetId(parentRowsetId);
                continue;
            }
            while (parentRowsetId != -1 && !parentFound) {
                for (int j = 0; j < this.getQueueOfRows().size(); ++j) {
                    RSAPITabularRow parentRow;
                    if (j == i || (parentRow = (RSAPITabularRow)this.getQueueOfRows().get(j)).getRowsetId() != parentRowsetId) continue;
                    parentFound = true;
                    break;
                }
                if (parentFound) continue;
                RSAPIEdgeRowset parentRowset = this.mEdge.getRowset(parentRowsetId);
                if (parentRowset.getSiblingRowset() != null) {
                    parentRowsetId = parentRowset.getSiblingRowset().getRowsetId();
                    continue;
                }
                parentRowsetId = this.mRowsetParents[parentRowsetId];
            }
            row.setParentRowsetId(parentRowsetId);
        }
    }

    private void constructV5Rows(IRow row) {
        ++this.mRowNumber;
        this.markAllRowsetsAsNonDetail();
        for (int inx = 0; inx < row.getNumColumns(); ++inx) {
            this.processContext((ContextBase)((Object)row.getColumn(inx)), inx == row.getNumColumns() - 1);
        }
    }

    private void processContext(ContextBase contextBase, boolean lastColumn) {
        int dataItemIndex = contextBase.getDataItemIndex();
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)contextBase.getRowset();
        if (rowset == null) {
            return;
        }
        int rowsetId = rowset.getRowsetId();
        if (dataItemIndex == -3) {
            this.removeRowFromCurrentRows(rowsetId);
            return;
        }
        if (!this.isRowsetAtBackOfQueue(rowsetId)) {
            this.mTabularRows[rowsetId].setColumnsNull();
            this.mTabularRows[rowsetId].setRowNumber(this.mRowNumber);
        }
        if (dataItemIndex == -2) {
            if (!this.mEdge.getDataset().isGenerateDerivedRowsInRSAPI()) {
                this.getQueueOfRows().put(this.mTabularRows[rowsetId]);
            }
            return;
        }
        boolean firstRead = this.mTabularRows[rowsetId].getFirstRowRead();
        this.mTabularRows[rowsetId].assignColumnValue(contextBase.getDataItemIndex(), (IValue)((Object)contextBase));
        RSAPITabularRow newRow = this.mTabularRows[rowsetId];
        RSAPIEdgeRowset nestedRowset = rowset.getNestedRowset();
        if (this.mEdge.getDataset().isGenerateDerivedRowsInRSAPI() && newRow.isGrouped() && newRow.isControlBreak()) {
            if (firstRead) {
                this.generateNestedFooterRows(rowset, false);
            }
            this.storeGroupKeyForNestedRowset(contextBase, rowset.getRowsetId(), rowset.getNestedRowset());
        }
        if (!this.isRowsetAtBackOfQueue(rowsetId)) {
            this.getQueueOfRows().put(this.mTabularRows[rowsetId]);
        }
        if (this.mEdge.getDataset().isGenerateDerivedRowsInRSAPI()) {
            if (!(rowset.isHeaderRowset() || rowset.isFooterRowset() || newRow.isGrouped() && newRow.isControlBreak())) {
                return;
            }
            if (rowset.isHeaderRowset() && rowset.getParentRowset() != null && lastColumn) {
                nestedRowset = rowset.getParentRowset().getNestedRowset();
            }
            if (nestedRowset == null) {
                return;
            }
            boolean genNestedHeader = false;
            RSAPIEdgeRowset nestedHeader = nestedRowset.getHeaderRowset();
            if (nestedHeader != null && nestedHeader.isDerivedRowset()) {
                this.mTabularRows[nestedHeader.getRowsetId()].setRowNumber(this.mRowNumber);
                this.getQueueOfRows().put(this.mTabularRows[nestedHeader.getRowsetId()]);
                genNestedHeader = true;
            }
            if (nestedRowset.isDerivedRowset() && (rowset.isHeaderRowset() || nestedRowset.getHeaderRowset() == null || genNestedHeader)) {
                this.mTabularRows[nestedRowset.getRowsetId()].setRowNumber(this.mRowNumber);
                this.getQueueOfRows().put(this.mTabularRows[nestedRowset.getRowsetId()]);
            }
        }
    }

    private void storeGroupKeyForNestedRowset(ContextBase contextBase, int srcRowsetId, RSAPIEdgeRowset nestedRowset) {
        if (nestedRowset != null) {
            this.storeGroupKeyForChildRowset(contextBase, srcRowsetId, nestedRowset);
            this.storeGroupKeyForNestedRowset(contextBase, srcRowsetId, nestedRowset.getNestedRowset());
        }
    }

    private void storeGroupKeyForChildRowset(ContextBase contextBase, int srcRowsetId, RSAPIEdgeRowset childRowset) {
        if (contextBase == null || childRowset == null) {
            return;
        }
        if (childRowset.getNumDerivedDataItems() > 0) {
            int refIndex = 0;
            if (childRowset.getRefDataItem() != null) {
                ++refIndex;
                RSAPIDataItem dataItem = childRowset.getRefDataItem();
                if (dataItem.getSourceRowsetId() == srcRowsetId) {
                    ContextBase storeValue = (ContextBase)((IValue)((Object)contextBase)).copy();
                    storeValue.setRowset(childRowset);
                    storeValue.setDataItemIndex(-1);
                    this.mTabularRows[childRowset.getRowsetId()].copyColumnValue(0, (IValue)((Object)storeValue));
                }
            }
            for (int i = 0; i < childRowset.getNumDataItems(); ++i) {
                RSAPIDataItem dataItem = childRowset.getDataItem(i);
                if (dataItem.getSourceRowsetId() != srcRowsetId) continue;
                ContextBase storeValue = (ContextBase)((IValue)((Object)contextBase)).copy();
                storeValue.setRowset(childRowset);
                storeValue.setDataItemIndex(i);
                this.mTabularRows[childRowset.getRowsetId()].copyColumnValue(i + refIndex, (IValue)((Object)storeValue));
            }
        }
        if (!childRowset.isHeaderRowset() && !childRowset.isFooterRowset()) {
            this.storeGroupKeyForChildRowset(contextBase, srcRowsetId, childRowset.getHeaderRowset());
            this.storeGroupKeyForChildRowset(contextBase, srcRowsetId, childRowset.getFooterRowset());
        }
        while (childRowset.getSiblingRowset() != null) {
            childRowset = childRowset.getSiblingRowset();
            this.storeGroupKeyForNestedRowset(contextBase, srcRowsetId, childRowset);
        }
    }

    private void generateDerivedDataItems(RSAPITabularRow row) {
        RSAPIEdgeRowset rowset = row.getRowset();
        for (int i = 0; i < rowset.getNumDataItems(); ++i) {
            RSAPIDataItem dataItem = rowset.getDataItem(i);
            int sourceRowsetId = dataItem.getSourceRowsetId();
            if (sourceRowsetId == -1) continue;
            int col = i;
            if (rowset.getRefDataItem() != null) {
                ++col;
            }
            if (row.getColumn(col) == null || row.getColumn(col).isNull()) {
                RSAPITabularRow sourceRow = this.mTabularRows[sourceRowsetId];
                Object sourceValue = sourceRow.getColumn(0).copy();
                row.copyColumnValue(col, (IValue)sourceValue);
            }
            ContextBase value = (ContextBase)((Object)row.getColumn(col));
            value.setRowset(rowset);
            value.setDataItemIndex(i);
        }
    }

    private void identifyDetailRows() {
        for (int i = 0; i < this.getQueueOfRows().size(); ++i) {
            RSAPITabularRow row = (RSAPITabularRow)this.getQueueOfRows().get(i);
            if (row.isDetail() || row.isSummary()) continue;
            boolean nestedRowExists = false;
            for (int j = i + 1; j < this.getQueueOfRows().size(); ++j) {
                RSAPITabularRow nextRow = (RSAPITabularRow)this.getQueueOfRows().get(j);
                if (!this.rowIsDescendant(row.getRowsetId(), nextRow.getRowsetId())) continue;
                nestedRowExists = true;
                break;
            }
            row.setIsDetail(!nestedRowExists);
        }
    }

    private void markAllRowsetsAsNonDetail() {
        for (int i = 0; i < this.mTabularRows.length; ++i) {
            if (this.mTabularRows[i].isSummary()) continue;
            this.mTabularRows[i].setIsDetail(false);
        }
    }

    private void removeRowFromCurrentRows(int rowsetId) {
        this.getCurrentListOfRowsToRemove()[rowsetId] = true;
    }

    private boolean isRowsetAtBackOfQueue(int rowsetId) {
        if (this.getQueueOfRows().isEmpty()) {
            return false;
        }
        return this.getQueueOfRows().last() == this.mTabularRows[rowsetId];
    }

    protected void resetRowsetControlBreaks(RSAPIEdgeRowset rowset) {
        if (rowset.getNestedRowset() != null) {
            this.resetRowsetControlBreaks(rowset.getNestedRowset());
        }
        if (rowset.getSiblingRowset() != null) {
            this.resetRowsetControlBreaks(rowset.getSiblingRowset());
        }
        this.mTabularRows[rowset.getRowsetId()].resetControlBreak();
    }

    private Queue getQueueOfRows() {
        return this.mQueueOfRows;
    }

    private void setQueueOfRows(Queue queue) {
        this.mQueueOfRows = queue;
    }

    private boolean[] getCurrentListOfRowsToRemove() {
        return this.mRemoveRowFromQueueOfRows;
    }

    protected boolean rowIsDescendant(int parentRowsetId, int rowsetId) {
        while (rowsetId != -1) {
            if (this.mRowsetParents[rowsetId] == parentRowsetId) {
                return true;
            }
            rowsetId = this.mRowsetParents[rowsetId];
        }
        return false;
    }

    public XDataContext getDataContext() {
        return this.mIterator.getDataContext();
    }

    @Override
    public void release() {
        if (this.mIterator != null) {
            try {
                this.mIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mIterator = null;
            }
        }
        this.mTabularRows = null;
        this.mQueueOfRows.clear();
    }

    public long positionOnRow(long detailRowNumber, boolean fromTop) {
        return this.mIterator.positionOnRow(detailRowNumber, fromTop);
    }

    protected void openIteratorTrace() {
        if (this.iteratorTrace != null) {
            return;
        }
        XDataContext context = this.mIterator.getDataContext();
        if (!context.getEnvironment().getRSAPITabularIteratorLogging()) {
            return;
        }
        this.iteratorTrace = new XQETrace();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String iteratorName = this.getClass().getSimpleName();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd-HHmmssSSS");
        BufferedOutputStream outputStream = null;
        String xqeLogsFolder = configuration.getXqeLogsDirectory();
        File logFile = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(xqeLogsFolder).append(File.separator).append(iteratorName);
        stringBuilder.append(this.mEdge.getOrdinal());
        String dash = "-";
        stringBuilder.append("-");
        long currentTime = System.currentTimeMillis();
        stringBuilder.append(dateFormat.format(new Date(currentTime)));
        if (context.getEnvironment().getRequestEnvironment().getReportName() != null) {
            stringBuilder.append("-");
            stringBuilder.append(context.getEnvironment().getRequestEnvironment().getReportName());
        }
        stringBuilder.append(".xml");
        String fileName = stringBuilder.toString();
        logFile = new File(fileName);
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (FileNotFoundException e) {
            mErrorLogger.log(e);
            return;
        }
        BufferedWriter logWriter = null;
        try {
            logWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
            this.iteratorTrace.addStream(logWriter);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (Throwable e) {
                mErrorLogger.log(e);
                return;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)uee);
        }
        this.iteratorTrace.beginElement(iteratorName, this.mEdge.getOrdinal());
        this.iteratorTrace.attribute("edgeOrdinal", this.mEdge.getOrdinal());
        this.iteratorTrace.attribute("edgeName", this.mEdge.getName());
    }

    protected void closeIteratorTrace() {
        if (this.iteratorTrace == null) {
            return;
        }
        try {
            this.iteratorTrace.endElement();
            this.iteratorTrace.flush();
        }
        catch (Throwable t) {
            mErrorLogger.log(t);
        }
    }

    protected void traceRow(String rowName, RSAPITabularRow aRow) {
        if (this.iteratorTrace == null) {
            return;
        }
        try {
            this.iteratorTrace.beginElement(rowName, -1);
            if (aRow != null) {
                for (int j = 0; j < aRow.getNumColumns(); ++j) {
                    if (aRow.getColumn(j) instanceof ContextMember) {
                        ((ContextMember)aRow.getColumn(j)).toXML(this.iteratorTrace);
                        continue;
                    }
                    if (aRow.getColumn(j) instanceof ContextBase) {
                        ((ContextBase)((Object)aRow.getColumn(j))).toXML(this.iteratorTrace);
                        continue;
                    }
                    aRow.getColumn(j).toXML(this.iteratorTrace);
                }
            }
            this.iteratorTrace.endElement();
            this.iteratorTrace.flush();
        }
        catch (Throwable t) {
            mErrorLogger.log(t);
        }
    }
}

