/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableCellIterator;
import com.cognos.xqe.resultsets.md.Cell;
import java.util.ArrayList;
import java.util.HashMap;

public class ScrollableCellIterator
implements IScrollableCellIterator {
    public static final int STARTING_POSITION = -1;
    private ArrayList<Object> valueList = new ArrayList(1024);
    private int position = -1;
    private ICellIterator input;
    private HashMap<Long, Cell> ordinalMap;

    public ScrollableCellIterator(ICellIterator tabIt) {
        this.input = tabIt;
        this.ordinalMap = new HashMap();
        if (this.input.hasNext()) {
            this.addValue(this.input.next());
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.valueList.size() == 0) {
            return false;
        }
        return this.position - 1 >= 0;
    }

    @Override
    public boolean hasNext() {
        if (this.valueList.size() == 0) {
            return false;
        }
        if (this.position + 1 < this.valueList.size()) {
            return true;
        }
        if (this.input.hasNext()) {
            this.addValue(this.input.next());
            return true;
        }
        return false;
    }

    @Override
    public long getIndex() {
        return this.position;
    }

    @Override
    public ICell next() {
        return (ICell)this.valueList.get(++this.position);
    }

    @Override
    public ICell previous() {
        return (ICell)this.valueList.get(--this.position);
    }

    @Override
    public ICell current() {
        return (ICell)this.valueList.get(this.position);
    }

    @Override
    public boolean absolute(long index) {
        if (index < -1L) {
            return false;
        }
        int size = this.valueList.size() - 1;
        if (index >= (long)size) {
            while (this.hasNext() && (long)size <= index) {
                this.next();
                ++size;
            }
        }
        if (index >= (long)this.valueList.size()) {
            return false;
        }
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The iterator position greater than 2147483647 is not supported");
        }
        this.position = (int)index;
        return true;
    }

    @Override
    public boolean reset() {
        this.position = -1;
        return true;
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        ICell result = this.ordinalMap.get(ordinal);
        if (result == null && (long)this.valueList.size() <= ordinal) {
            this.absolute(this.valueList.size() - 1);
            while (this.hasNext() && (result = this.next()).getOrdinal() != ordinal) {
                if (result.getOrdinal() <= ordinal) continue;
                result = null;
                break;
            }
        }
        return result;
    }

    private void addValue(ICell value) {
        this.ordinalMap.put(value.getOrdinal(), (Cell)value);
        this.valueList.add(value);
    }

    @Override
    public void release() {
    }
}

