/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class XCellIteratorAdaptor
extends XCellIterator {
    private ICellIterator sourceIterator;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public XCellIteratorAdaptor(XDataContext xDataContext, ICellIterator source, Integer id) {
        super(xDataContext, id);
        this.sourceIterator = source;
    }

    @Override
    public void release() {
        if (null != this.sourceIterator) {
            try {
                this.sourceIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.sourceIterator = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.sourceIterator.hasNext();
    }

    @Override
    public ICell nextImpl() {
        ICell result = this.sourceIterator.next();
        if (null != result) {
            this.currentOrdinal = result.getOrdinal();
        }
        return result;
    }

    @Override
    public boolean hasPipelineIterator() {
        if (this.sourceIterator instanceof XCellIterator) {
            return ((XCellIterator)this.sourceIterator).hasPipelineIterator();
        }
        return false;
    }
}

