/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.IProfiled;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.resultset.interfaces.IBackgroundLoadable;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Timer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XNode
extends XQEBaseQueryNode
implements Serializable,
IExecutable,
IBackgroundLoadable,
IProfiled,
IVectorContext {
    private static final long serialVersionUID = 1L;
    protected static final String ID = "id";
    protected static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    public static final int RSAPI_SUPPORTED_QUERY = -1;
    protected int contextNo;
    protected XVectorContext vContext;
    public static final String ZIPI_RUNTREE_ACTION = "DQExecuteRuntree";
    private final ThreadLocal<Long> elapsedTime = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return new Long(0L);
        }
    };
    private final ThreadLocal<Long> cpuTime = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return new Long(0L);
        }
    };
    private final ThreadLocal<Long> rowCount = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return new Long(0L);
        }
    };

    public void serialize(String fileName) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this);
            oos.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    protected void dumpProfilingInfo(XQETrace trace) {
        long nRows;
        long ownCPUTime;
        long totalCPUTime;
        long ownElapsedTime;
        if (!IteratorProfilingManager.getInstance().isProfilingEnabled()) {
            return;
        }
        long totalElapsedTime = this.getTotalElapsedTime();
        if (totalElapsedTime > 0L) {
            trace.attribute("totalElapsedTime", totalElapsedTime);
        }
        if ((ownElapsedTime = this.getOwnElapsedTime()) > 0L) {
            trace.attribute("ownElapsedTime", ownElapsedTime);
        }
        if ((totalCPUTime = this.getTotalCPUTime()) > 0L) {
            trace.attribute("totalCPUTime", totalCPUTime);
        }
        if ((ownCPUTime = this.getOwnCPUTime()) > 0L) {
            trace.attribute("ownCPUTime", ownCPUTime);
        }
        if ((nRows = this.getRowCount()) > 0L) {
            trace.attribute("nRows", nRows);
        }
    }

    public void resetProfilingInfo(IRequestEnvironment reqEnv) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(reqEnv)) {
            return;
        }
        this.elapsedTime.set(0L);
        this.cpuTime.set(0L);
        this.rowCount.set(0L);
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XNode)) continue;
            ((XNode)child).resetProfilingInfo(reqEnv);
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (includeRuntimeSpecifics) {
            this.dumpProfilingInfo(trace);
        }
    }

    public boolean hasDQPostProcessing() {
        return false;
    }

    public IValue getJDBCTabularResultSet(XDataContext context) {
        return null;
    }

    protected void capture(PlanningEnvironment env, Element inputNode, int start) {
        Attribute cxtNoAttribute;
        XQENodeFactory nodeFactory = env.getNodeFactory();
        List childList = inputNode.elements();
        int nChildren = childList.size() - start;
        int j = start;
        for (int i = 0; i < nChildren; ++i) {
            Element child;
            XNode xChild;
            if ((xChild = (XNode)nodeFactory.createNodeByName((child = (Element)childList.get(j++)).getName())) == null) continue;
            this.addChild(xChild);
            xChild.capture(env, child);
        }
        Attribute nodeIdAttribute = inputNode.attribute(ID);
        if (nodeIdAttribute != null) {
            this.setNodeId(Integer.parseInt(nodeIdAttribute.getValue()));
        }
        if ((cxtNoAttribute = inputNode.attribute(ATTRIBUTE_CONTEXTNO)) != null) {
            this.setContextNo(Integer.valueOf(cxtNoAttribute.getValue()));
        }
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        this.capture(env, inputNode, 0);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement(this.getNodeTypeName(), -1);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int isValidPlannedQuery() {
        int status = -1;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            status = this.getChild(i).isValidPlannedQuery();
            if (status == -1) continue;
            return status;
        }
        return status;
    }

    public int isRSAPISupportedQuery() {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode childNode = this.getChild(i);
            if (childNode.isQueryNode()) {
                return childNode.getId();
            }
            int status = ((XNode)childNode).isRSAPISupportedQuery();
            if (status == -1) continue;
            return status;
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.getNodeTypeName();
    }

    public int getContextNo() {
        return this.contextNo;
    }

    public void setContextNo(int theContextNo) {
        this.contextNo = theContextNo;
    }

    @Override
    public boolean isQueryNode() {
        return false;
    }

    public boolean isDecorationNode() {
        return false;
    }

    protected void startTimer(XQETrace traceObj) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(traceObj)) {
            return;
        }
        this.elapsedTime.set(System.nanoTime());
        this.cpuTime.set(Timer.getCurrentThreadCpuTime());
    }

    protected void stopTimer(XQETrace traceObj) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(traceObj)) {
            return;
        }
        this.cpuTime.set(Timer.getCurrentThreadCpuTime() - this.cpuTime.get());
        this.elapsedTime.set(System.nanoTime() - this.elapsedTime.get());
    }

    @Override
    public final IValue execute(XDataContext context) {
        IValue result = null;
        try {
            this.beginTrace(context);
            result = this.executeImpl(context);
            this.endTrace(context, result);
        }
        catch (Throwable throwable) {
            this.endTrace(context, result);
            throw throwable;
        }
        return result;
    }

    protected IValue executeImpl(XDataContext context) {
        throw new UnsupportedOperationException();
    }

    private void beginTrace(XDataContext context) {
        XQETrace traceObj = context.getTrace();
        this.beginTrace(traceObj);
        this.startTimer(traceObj);
    }

    private void endTrace(XDataContext context, IValue result) {
        XQETrace traceObj = context.getTrace();
        this.stopTimer(traceObj);
        this.endTrace(traceObj, result);
    }

    protected void beginTrace(XQETrace trace) {
        if (QueryEngineLoggingUtils.isRuntreeExecutionLoggingEnabled(trace)) {
            this.beginTrace(trace, this.getNodeTypeName(), this.getId());
        }
    }

    protected void beginTrace(XQETrace trace, String nodeTypeName, Integer id) {
        if (QueryEngineLoggingUtils.isRuntreeExecutionLoggingEnabled(trace)) {
            trace.beginElement(nodeTypeName, id);
            trace.beginElement("in", -1);
            this.traceInParameters(trace);
            trace.endElement();
            trace.beginElement("exec", -1);
        }
    }

    protected void endTrace(XQETrace trace, IValue retVal) {
        if (QueryEngineLoggingUtils.isRuntreeExecutionLoggingEnabled(trace)) {
            trace.endElement();
            trace.beginElement("out", -1);
            if (retVal != null) {
                retVal.toXML(trace);
            }
            trace.endElement();
            trace.endElement();
        }
    }

    protected void traceInParameters(XQETrace trace) {
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        return propertiesMap;
    }

    @Override
    public long getTotalElapsedTime() {
        return this.elapsedTime.get();
    }

    public void setTotalElapsedTime(long time) {
        this.elapsedTime.set(time);
    }

    public void addTotalElapsedTime(long time) {
        this.elapsedTime.set(this.elapsedTime.get() + time);
    }

    public long getOwnElapsedTime() {
        if (this.getTotalElapsedTime() == 0L) {
            return 0L;
        }
        long time = 0L;
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XNode)) continue;
            time += ((XNode)child).getTotalElapsedTime();
        }
        return this.getTotalElapsedTime() - time;
    }

    @Override
    public long getTotalCPUTime() {
        return this.cpuTime.get();
    }

    public void setTotalCPUTime(long time) {
        this.cpuTime.set(time);
    }

    public void addTotalCPUTime(long time) {
        this.cpuTime.set(this.cpuTime.get() + time);
    }

    public long getOwnCPUTime() {
        if (this.getTotalCPUTime() == 0L) {
            return 0L;
        }
        long time = 0L;
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XNode)) continue;
            time += ((XNode)child).getTotalCPUTime();
        }
        return this.getTotalCPUTime() - time;
    }

    public void setRowCount(long count) {
        this.rowCount.set(count);
    }

    public void addRowCount(long count) {
        this.rowCount.set(this.rowCount.get() + count);
    }

    public long getRowCount() {
        return this.rowCount.get();
    }

    @Override
    public boolean loadInBackground() {
        boolean ret = false;
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof IBackgroundLoadable)) continue;
            ret = ((IBackgroundLoadable)((Object)child)).loadInBackground() || ret;
        }
        return ret;
    }

    public SQLSortKey.NullOrdering[] getNullOrdering() {
        return ((XNode)this.getChild(0)).getNullOrdering();
    }

    @Override
    public void clearPlanningEnvironment() {
        this.environment.setPlanningInactive();
        ((PlanningEnvironment)this.environment).clearLevelInfoCache();
        super.clearPlanningEnvironment();
    }

    @Override
    public void recursiveSetPlanningEnvironment(IPlanningEnvironment planningEnvironment) {
        this.environment = planningEnvironment;
        super.recursiveSetPlanningEnvironment(planningEnvironment);
    }

    @Override
    public XVectorContext getVectorizationContext() {
        if (this.getNumberChildren() == 0) {
            return null;
        }
        return ((IVectorContext)((Object)this.getChild(0))).getVectorizationContext();
    }

    public void setVectorizationContext(XVectorContext vectorContext) {
        this.vContext = vectorContext;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_CONTEXTNO, this.contextNo);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String name = att.getName();
        if (name.equals(ATTRIBUTE_CONTEXTNO)) {
            Object value = ctx.attributeValue(att);
            this.contextNo = (Integer)value;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }
}

