/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XSamplingTabularIterator;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.exception.XRuntimeException;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XTabularResultSetSample
extends XTabularResultSet {
    private static final double ONE_TENTH = 0.1;
    private static final double ONE_POINT_ONE = 1.1;
    private static final double ONE_HUNDRED = 100.0;
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_SAMPLE_PERCENT = "samplePercent";
    private static final String ATTRIBUTE_SAMPLE_ROW_COUNT = "sampleRowCount";
    private static final String ATTRIBUTE_SAMPLE_SEED = "sampleSeed";
    private Double samplePercent = null;
    private Integer sampleRowCount = null;
    private Long sampleSeed = null;

    @Override
    protected IValue executeImpl(XDataContext context) throws XRuntimeException {
        RSAPIDataset dataset = (RSAPIDataset)this.getAncestorOfType(401005);
        return new TabularHybridResultSet(context, new XResultSetSample(context, dataset), this.getId());
    }

    @Override
    public int getType() {
        return 501208;
    }

    public Double getSamplePercent() {
        return this.samplePercent;
    }

    public void setSamplePercent(double theSamplePercent) {
        this.samplePercent = theSamplePercent;
    }

    public Integer getSampleRowCount() {
        return this.sampleRowCount;
    }

    public void setSampleRowCount(int theSampleRowCount) {
        this.sampleRowCount = theSampleRowCount;
    }

    public Long getSampleSeed() {
        return this.sampleSeed;
    }

    public void setSampleSeed(long theSampleSeed) {
        this.sampleSeed = theSampleSeed;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (this.getSamplePercent() != null) {
            trace.attribute(ATTRIBUTE_SAMPLE_PERCENT, this.getSamplePercent());
        }
        if (this.getSampleRowCount() != null) {
            trace.attribute(ATTRIBUTE_SAMPLE_ROW_COUNT, this.getSampleRowCount());
        }
        if (this.getSampleSeed() != null) {
            trace.attribute(ATTRIBUTE_SAMPLE_SEED, this.getSampleSeed());
        }
        trace.attribute("contextNo", this.getContextNo());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute sampleSeedAttr;
        Attribute sampleRowCountAttr;
        Attribute samplePercentAttr = inputNode.attribute(ATTRIBUTE_SAMPLE_PERCENT);
        if (samplePercentAttr != null) {
            this.setSamplePercent(Double.valueOf(samplePercentAttr.getValue()));
        }
        if ((sampleRowCountAttr = inputNode.attribute(ATTRIBUTE_SAMPLE_ROW_COUNT)) != null) {
            this.setSampleRowCount(Integer.valueOf(sampleRowCountAttr.getValue()));
        }
        if ((sampleSeedAttr = inputNode.attribute(ATTRIBUTE_SAMPLE_SEED)) != null) {
            this.setSampleSeed(Long.valueOf(sampleSeedAttr.getValue()));
        }
        super.capture(env, inputNode);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.samplePercent != null) {
            ctx.property(ATTRIBUTE_SAMPLE_PERCENT, this.samplePercent);
        }
        if (this.sampleRowCount != null) {
            ctx.property(ATTRIBUTE_SAMPLE_ROW_COUNT, this.sampleRowCount);
        }
        if (this.sampleSeed != null) {
            ctx.property(ATTRIBUTE_SAMPLE_SEED, this.sampleSeed);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_SAMPLE_PERCENT)) {
            Object val = ctx.attributeValue(att);
            this.samplePercent = (Double)val;
        } else if (attname.equals(ATTRIBUTE_SAMPLE_ROW_COUNT)) {
            Object val = ctx.attributeValue(att);
            this.sampleRowCount = (Integer)val;
        } else if (attname.equals(ATTRIBUTE_SAMPLE_SEED)) {
            Object val = ctx.attributeValue(att);
            this.sampleSeed = (Long)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    private final class XResultSetSample
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;
        private RSAPIDataset dataset;

        XResultSetSample(XDataContext context, RSAPIDataset theDataset) {
            super(context, XTabularResultSetSample.this.getId());
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XTabularResultSetSample.this.getChild(0))).execute(context);
            this.dataset = theDataset;
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XTableSampleIterator(this.getDataContext(), XTabularResultSetSample.this.getSamplePercent(), XTabularResultSetSample.this.getSampleRowCount(), XTabularResultSetSample.this.getSampleSeed());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        public final class XTableSampleIterator
        extends XTabularIterator {
            private XSamplingTabularIterator samplingIt;
            private ITabularIterator tabIt;

            private XTableSampleIterator(XDataContext context, Double percent, Integer rowCount, Long seed) {
                super(context, XTabularResultSetSample.this.getId());
                try {
                    double adjustedPercent;
                    if (percent == null) {
                        adjustedPercent = (double)rowCount.intValue() / (double)this.getResultRowCount();
                        if (adjustedPercent > 0.1) {
                            adjustedPercent *= 1.1;
                        }
                    } else {
                        adjustedPercent = percent / 100.0;
                    }
                    if (adjustedPercent < 1.0) {
                        XResultSetSample.this.dataset.setHasSampledData();
                    }
                    this.tabIt = XResultSetSample.this.iResultSet.getTabularIterator();
                    this.samplingIt = seed == null ? new XSamplingTabularIterator(context, (XTabularIterator)this.tabIt, XResultSetSample.this.rowsetInfo, adjustedPercent) : new XSamplingTabularIterator(context, (XTabularIterator)this.tabIt, XResultSetSample.this.rowsetInfo, adjustedPercent, seed);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getResultRowCount() {
                long resultRowCount = 0L;
                ITabularIterator countTabIt = XResultSetSample.this.iResultSet.getTabularIterator();
                try {
                    while (countTabIt.next() != null) {
                        ++resultRowCount;
                    }
                }
                finally {
                    countTabIt.release();
                }
                return resultRowCount;
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                return this.samplingIt.next();
            }

            @Override
            public long getIndex() {
                return this.samplingIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                if (this.samplingIt != null) {
                    try {
                        this.samplingIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.samplingIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

