/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma.member.response;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.ProviderException;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.missingMember.MissingMemberException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.runtree.ma.member.response.XMAMemberMetadata;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.util.MASubQueryBuilder;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;

public class XMAExplicitMemberResponse
extends XMAGenerateMemberResponse {
    private static final long serialVersionUID = 1L;
    public static final String PROP_IS_EXPLICIT_MEMBER = "explicitMember";
    public static final String PROP_REQUESTED_MUNS = "requestedMuns";
    private static final String ATTR_REQUESTED_MUN = "requestedMun";
    private static final String ERR_INVALID_MEMBER_NAME = "ERR_INVALID_MEMBER_NAME";

    protected Element toMAResponse(Element parentElement, IMember member, String requestedMUN) {
        Element memberElement = super.toMAResponse(parentElement, member);
        String mun = memberElement.attributeValue(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName());
        if (mun != null && requestedMUN != null && !mun.equals(requestedMUN)) {
            memberElement.addAttribute(ATTR_REQUESTED_MUN, requestedMUN);
        }
        return memberElement;
    }

    protected Element toMAResponse(Element parentElement, IRestrictions restrictions) {
        Element element = parentElement.addElement(MARequestedPropertiesEnum.MEMBER.getPropertyName());
        String mun = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        if (mun != null) {
            element.addAttribute(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName(), mun);
        }
        return element;
    }

    @Override
    public int getType() {
        return 501145;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void constructResultDom(XDataContext context, IXQEQueryNode child, Element memberElem) {
        Element parent = memberElem;
        boolean addMemberAsParent = (Boolean)this.getPropertyValue(PROP_IS_EXPLICIT_MEMBER);
        int numberOfRequestedMUNS = 0;
        ArrayList requestedMUNs = (ArrayList)this.getPropertyValue(PROP_REQUESTED_MUNS);
        if (requestedMUNs != null) {
            numberOfRequestedMUNS = requestedMUNs.size();
        }
        int numberOfMembersFound = 0;
        ITabularResultSet result = null;
        try {
            result = (ITabularResultSet)((XNode)child).execute(context);
        }
        catch (MDXEngineException mdxe) {
            if (mdxe.getMessageID().equals("X01427") || mdxe.getMessageID().equals("X01405")) {
                this.checkIfExceptionDueToMissingMembers(mdxe, context, requestedMUNs, numberOfRequestedMUNS);
            }
            throw mdxe;
        }
        catch (ProviderException pe) {
            IMessageKey mk;
            if (pe.getMessageKey() != null && (mk = pe.getMessageKey()).getName().equals(ERR_INVALID_MEMBER_NAME)) {
                this.checkIfExceptionDueToMissingMembers(pe, context, requestedMUNs, numberOfRequestedMUNS);
            }
            throw pe;
        }
        if (result == null && child.getType() == 501107) {
            this.toMAResponse(parent, ((XMAMemberMetadata)child).getRestrictions());
            return;
        }
        ITabularIterator iter = null;
        try {
            IRow row;
            iter = result.getTabularIterator();
            while ((row = (IRow)iter.next()) != null) {
                String requestedMun = null;
                if (numberOfMembersFound < numberOfRequestedMUNS) {
                    requestedMun = (String)requestedMUNs.get(numberOfMembersFound);
                }
                for (int i = 0; i < row.getNumColumns(); ++i) {
                    IMember member;
                    IValue value = row.getColumn(i);
                    if (!(value instanceof IMember) || !this.isRequestedMember(member = (IMember)value)) continue;
                    ROLAPContext.queryEnter((ExecutionEnvironment)context.getEnvironment());
                    try {
                        if (addMemberAsParent) {
                            parent = this.toMAResponse(parent, member, requestedMun);
                        } else {
                            this.toMAResponse(parent, member, requestedMun);
                        }
                        addMemberAsParent = false;
                        break;
                    }
                    finally {
                        ROLAPContext.queryExit((ExecutionEnvironment)context.getEnvironment());
                    }
                }
                ++numberOfMembersFound;
            }
        }
        finally {
            if (iter != null) {
                iter.release();
            }
            if (result != null) {
                result.release();
            }
        }
        int numberOfMissingMembers = numberOfRequestedMUNS - numberOfMembersFound;
        this.findMissingMembers(context, requestedMUNs, numberOfMissingMembers);
    }

    private void findMissingMembers(XDataContext dataContext, ArrayList<String> requestedMUNs, int numberOfMissingMembers) {
        if (numberOfMissingMembers <= 0) {
            return;
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        String missingMUN = null;
        if (requestedMUNs.size() > 1) {
            PlanningEnvironment mainPlanEnvironment = (PlanningEnvironment)this.getPlanningEnvironment();
            for (String startAtRef : requestedMUNs) {
                PlanningEnvironment planEnvironment = V5SubQueryBuilder.createPlanningEnvironment(execEnv, mainPlanEnvironment);
                IXQEQueryNode maRequest = MASubQueryBuilder.createMetadataRequest(planEnvironment, startAtRef);
                try {
                    MASubQueryBuilder.executeMetadataSubQuery(dataContext, planEnvironment, maRequest);
                }
                catch (MissingMemberException mme) {
                    if (--numberOfMissingMembers != 0) continue;
                    missingMUN = startAtRef;
                    break;
                }
            }
        } else {
            missingMUN = requestedMUNs.get(0);
        }
        if (missingMUN != null) {
            this.missingMember(reqEnv, missingMUN);
        }
    }

    private boolean isRequestedMember(IMember member) {
        if (!member.isContextMember()) {
            return true;
        }
        ContextMember context = (ContextMember)member;
        return context.getRowset() != null && !context.isFillerMember();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("keyDate", this.getPropertyValue("keyDate"));
        trace.attribute(PROP_REQUESTED_MUNS, this.getPropertyValue(PROP_REQUESTED_MUNS));
    }

    private void missingMember(RequestEnvironment reqEnvironment, String missingMUN) {
        Map<String, MissingMember> missingMembers = reqEnvironment.getRequestMissingMembers();
        MissingMember maMM = new MissingMember();
        String queryName = "maQuery";
        String dataItemName = "start_atRef";
        maMM.setQueryName(queryName);
        maMM.setRefDataItem(dataItemName);
        missingMembers.put(missingMUN, maMM);
        throw new MissingMemberException(reqEnvironment, missingMUN);
    }

    private void checkIfExceptionDueToMissingMembers(XQERuntimeException xre, XDataContext context, ArrayList<String> requestedMUNs, int numberOfRequestedMUNS) {
        if (numberOfRequestedMUNS > 0) {
            ExecutionEnvironment exeEnvironment = (ExecutionEnvironment)context.getEnvironment();
            RequestEnvironment reqEnv = (RequestEnvironment)exeEnvironment.getRequestEnvironment();
            this.findMissingMembers(context, requestedMUNs, numberOfRequestedMUNS);
            String munToThrow = null;
            Iterator<String> it = reqEnv.getRequestMissingMembers().keySet().iterator();
            if (it.hasNext()) {
                munToThrow = it.next();
            }
            throw new MissingMemberException(reqEnv, munToThrow);
        }
        throw xre;
    }
}

