/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma.member.response;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.ma4j.framework.MAQueryExecutor;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IVirtualDimension;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Element;

public class XMAGenerateMemberResponse
extends XMANode {
    private static final long serialVersionUID = 1L;
    public static final String PROP_KEY_DATE = "keyDate";
    public static final String PROP_MULTI_QUERY = "multiQuery";
    private ICube cube = null;
    private Set<MARequestedPropertiesEnum> memberProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element toMAResponse(Element parentElement, IMember member) {
        String cmdataSourceName = null;
        boolean needToRemoveCubeName = false;
        if (member.getDimension().isShareable()) {
            cmdataSourceName = ROLAPContext.getCMDataSourceName(this.getPlanningEnvironment());
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cmdataSourceName);
        }
        try {
            String mun;
            String v5Parent;
            Element element = parentElement.addElement(MARequestedPropertiesEnum.MEMBER.getPropertyName());
            String invalidXmlCharacterReplacement = MAQueryExecutor.getInvalidXmlCharacterReplacement();
            if (member.getDimension() != null) {
                element.addAttribute(MARequestedPropertiesEnum.DIMENSION_UNIQUE_NAME.getPropertyName(), this.getDimensionV5UniqueName(member, cmdataSourceName));
            }
            if (member.getLevel() != null) {
                element.addAttribute(MARequestedPropertiesEnum.LEVEL_NUMBER.getPropertyName(), Integer.toString(member.getLevel().getIndex()));
            }
            if ((v5Parent = this.getParentV5UniqueName(member, cmdataSourceName)) != null) {
                element.addAttribute(MARequestedPropertiesEnum.PARENT_UNIQUE_NAME.getPropertyName(), v5Parent);
            }
            element.addAttribute(MARequestedPropertiesEnum.PARENT_LEVEL.getPropertyName(), Integer.toString(member.getParentLevelNumber()));
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.CAPTION)) {
                String caption = member.getCaption();
                if (invalidXmlCharacterReplacement != null) {
                    caption = this.replaceInvalidXmlCharacter(caption, invalidXmlCharacterReplacement);
                }
                element.addAttribute(MARequestedPropertiesEnum.CAPTION.getPropertyName(), caption);
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.HIERARCHY_UNIQUE_NAME)) {
                element.addAttribute(MARequestedPropertiesEnum.HIERARCHY_UNIQUE_NAME.getPropertyName(), this.getHierarchyV5UniqueName(member, cmdataSourceName));
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.LEVEL_UNIQUE_NAME) && !member.getHierarchy().isParentChild()) {
                element.addAttribute(MARequestedPropertiesEnum.LEVEL_UNIQUE_NAME.getPropertyName(), this.getLevelV5UniqueName(member, cmdataSourceName));
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.BUSINESS_KEY) && member.getBusinessKeyValue() != null) {
                Value businessKeyValue = member.getBusinessKeyValue();
                String businessKey = ((Object)businessKeyValue).toString();
                element.addAttribute(MARequestedPropertiesEnum.BUSINESS_KEY.getPropertyName(), businessKey);
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME) && (mun = this.getMUN(member)) != null) {
                if (invalidXmlCharacterReplacement != null) {
                    mun = this.replaceInvalidXmlCharacter(mun, invalidXmlCharacterReplacement);
                }
                element.addAttribute(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName(), mun);
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.MEMBER_NAME)) {
                element.addAttribute(MARequestedPropertiesEnum.MEMBER_NAME.getPropertyName(), member.getName());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.DESCRIPTION)) {
                element.addAttribute(MARequestedPropertiesEnum.DESCRIPTION.getPropertyName(), member.getDescription());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.NUMBER_OF_PARENTS)) {
                element.addAttribute(MARequestedPropertiesEnum.NUMBER_OF_PARENTS.getPropertyName(), Integer.toString(member.getNumberOfParents()));
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.PPDS_CODE)) {
                element.addAttribute(MARequestedPropertiesEnum.PPDS_CODE.getPropertyName(), member.getUniqueID());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.TYPE)) {
                element.addAttribute(MARequestedPropertiesEnum.TYPE.getPropertyName(), member.getType().toMDDSType());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.ROLLUPTYPE)) {
                element.addAttribute(MARequestedPropertiesEnum.ROLLUPTYPE.getPropertyName(), member.getRollupType().toMDDSType());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.IS_SUPPRESSED)) {
                element.addAttribute(MARequestedPropertiesEnum.IS_SUPPRESSED.getPropertyName(), Boolean.valueOf(member.isSuppressed()).toString());
            }
            if (this.memberProperties.contains((Object)MARequestedPropertiesEnum.SUPPRESSED_PARENT_CODE)) {
                String parentCode = "";
                if (member.isSuppressed()) {
                    parentCode = member.getParent().getUniqueID();
                }
                element.addAttribute(MARequestedPropertiesEnum.SUPPRESSED_PARENT_CODE.getPropertyName(), parentCode);
            }
            Element element2 = element;
            return element2;
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    private String getDimensionV5UniqueName(IMember member, String cmdataSourceName) {
        String dimV5UniqueName = cmdataSourceName != null ? ((ShareableROLAPDimension)member.getDimension()).getV5UniqueName(cmdataSourceName) : member.getDimension().getV5UniqueName();
        return dimV5UniqueName;
    }

    private String getParentV5UniqueName(IMember member, String cmdataSourceName) {
        String v5Parent = null;
        IMember parent = member.getParent();
        if (parent != null) {
            v5Parent = cmdataSourceName != null && parent instanceof IROLAPMember ? ((IROLAPMember)parent).getV5UniqueName(cmdataSourceName) : parent.getV5UniqueName();
        } else if (member.getParentUniqueName() != null && member.getParentUniqueName().length() != 0) {
            v5Parent = this.getParentV5UniqueName(member);
        }
        return v5Parent;
    }

    private String getLevelV5UniqueName(IMember member, String cmdataSourceName) {
        String lun = cmdataSourceName != null ? ((IROLAPLevel)member.getLevel()).getV5UniqueName(cmdataSourceName) : member.getLevel().getV5UniqueName();
        return lun;
    }

    private String getHierarchyV5UniqueName(IMember member, String cmdataSourceName) {
        String hun = cmdataSourceName != null ? ((IROLAPHierarchy)member.getHierarchy()).getV5UniqueName(cmdataSourceName) : member.getHierarchy().getV5UniqueName();
        return hun;
    }

    @Override
    public int getType() {
        return 501113;
    }

    private String replaceInvalidXmlCharacter(String src, String replacement) {
        int codePoint;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < src.length(); i += Character.charCount(codePoint)) {
            codePoint = src.codePointAt(i);
            if (codePoint >= 32 && codePoint <= 55295 || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                out.append(Character.toChars(codePoint));
                continue;
            }
            out.append(replacement);
        }
        return out.toString();
    }

    @Override
    public IValue executeImpl(XDataContext context) {
        IXQEQueryNode[] children;
        Element responseElem = ((XMANode)this.getParent()).getResponseElement();
        if (this.executeMultiQueryWithResultStartCount(context, responseElem)) {
            return null;
        }
        for (IXQEQueryNode child : children = this.getChildren()) {
            this.constructResultDom(context, child, responseElem);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeMultiQueryWithResultStartCount(XDataContext context, Element responseElem) {
        int[] startAndCount = (int[])this.getPropertyValue(PROP_MULTI_QUERY);
        if (startAndCount == null) {
            return false;
        }
        if (startAndCount[1] == 0) {
            return true;
        }
        int queryOffset = 0;
        IMember explicitMember = null;
        Boolean addMemberAsParent = (Boolean)this.getPropertyValue("explicitMember");
        ArrayList requestedMUNs = (ArrayList)this.getPropertyValue("requestedMuns");
        if (addMemberAsParent != null && addMemberAsParent.booleanValue()) {
            if (requestedMUNs == null || requestedMUNs.size() != 1) {
                return true;
            }
            explicitMember = this.getExplicitMemberFromFirstQuery(context, (String)requestedMUNs.get(0));
            if (explicitMember == null) {
                return true;
            }
            queryOffset = 1;
        }
        ArrayList<IMember> collectedMembers = new ArrayList<IMember>();
        TreeMap<Integer, ArrayList<IMember>> collectedMembersByLevel = new TreeMap<Integer, ArrayList<IMember>>();
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        int resort = providerCapabilities.getIntegerValue("ReSortMembersFromHierarchySearch", 0);
        this.collectMembers(context, startAndCount, collectedMembers, collectedMembersByLevel, resort, queryOffset);
        MemberCaptionValueComparator cmp = new MemberCaptionValueComparator();
        if (resort == 1) {
            for (ArrayList<IMember> lst : collectedMembersByLevel.values()) {
                Collections.sort(lst, cmp);
                collectedMembers.addAll(lst);
            }
        } else if (resort == 2) {
            Collections.sort(collectedMembers, cmp);
        }
        Element parentEle = responseElem;
        if (explicitMember != null) {
            ROLAPContext.queryEnter(context.getEnvironment());
            try {
                parentEle = this.toMAResponse(parentEle, explicitMember);
            }
            finally {
                ROLAPContext.queryExit(context.getEnvironment());
            }
        }
        for (IMember member : collectedMembers) {
            ROLAPContext.queryEnter(context.getEnvironment());
            try {
                this.toMAResponse(parentEle, member);
            }
            finally {
                ROLAPContext.queryExit(context.getEnvironment());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMember getExplicitMemberFromFirstQuery(XDataContext context, String requestedMUN) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length < 1) {
            return null;
        }
        ITabularResultSet result = null;
        result = (ITabularResultSet)((XNode)children[0]).execute(context);
        ITabularIterator iter = null;
        try {
            IRow row;
            iter = result.getTabularIterator();
            block4: while ((row = (IRow)iter.next()) != null) {
                int i = 0;
                while (true) {
                    IMember member;
                    String v5Mun;
                    if (i >= row.getNumColumns()) continue block4;
                    IValue value = row.getColumn(i);
                    if (value instanceof IMember && (v5Mun = (member = (IMember)value).getV5UniqueName()).equals(requestedMUN)) {
                        IMember iMember = member;
                        return iMember;
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            if (iter != null) {
                iter.release();
            }
            if (result != null) {
                result.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectMembers(XDataContext context, int[] startAndCount, ArrayList<IMember> collectedMembers, TreeMap<Integer, ArrayList<IMember>> collectedMembersByLevel, int resort, int queryOffset) {
        int currentPos = 0;
        int currentSize = 0;
        IXQEQueryNode[] children = this.getChildren();
        block4: for (int pos = queryOffset; pos < children.length; ++pos) {
            IXQEQueryNode child = children[pos];
            ITabularResultSet result = null;
            result = (ITabularResultSet)((XNode)child).execute(context);
            ITabularIterator iter = null;
            try {
                iter = result.getTabularIterator();
                block5: while (true) {
                    IRow row;
                    if ((row = (IRow)iter.next()) == null) {
                        continue block4;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= row.getNumColumns()) continue block5;
                        IValue value = row.getColumn(i);
                        if (value instanceof IMember) {
                            if (currentPos >= startAndCount[0]) {
                                IMember member = (IMember)value;
                                if (resort == 1) {
                                    ArrayList<IMember> lst = collectedMembersByLevel.get(pos);
                                    if (lst == null) {
                                        lst = new ArrayList();
                                        collectedMembersByLevel.put(pos, lst);
                                    }
                                    lst.add(member);
                                } else {
                                    collectedMembers.add(member);
                                }
                                if (++currentSize >= startAndCount[1]) {
                                    return;
                                }
                            }
                            ++currentPos;
                        }
                        ++i;
                    }
                    break;
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                }
                if (result != null) {
                    result.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructResultDom(XDataContext context, IXQEQueryNode child, Element memberElem) {
        ITabularResultSet result = null;
        result = (ITabularResultSet)((XNode)child).execute(context);
        ITabularIterator iter = null;
        try {
            IRow row;
            iter = result.getTabularIterator();
            block6: while ((row = (IRow)iter.next()) != null) {
                int i = 0;
                while (true) {
                    if (i >= row.getNumColumns()) continue block6;
                    IValue value = row.getColumn(i);
                    if (value instanceof IMember) {
                        IMember member = (IMember)value;
                        ROLAPContext.queryEnter(context.getEnvironment());
                        try {
                            this.toMAResponse(memberElem, member);
                        }
                        finally {
                            ROLAPContext.queryExit(context.getEnvironment());
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            if (iter != null) {
                iter.release();
            }
            if (result != null) {
                result.release();
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(PROP_KEY_DATE, this.getPropertyValue(PROP_KEY_DATE));
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
    }

    public void setMemberProperties(Set<MARequestedPropertiesEnum> requiredProperties) {
        this.memberProperties = requiredProperties;
    }

    public Set<MARequestedPropertiesEnum> getMemberProperties() {
        return this.memberProperties;
    }

    private String getParentV5UniqueName(IMember member) {
        String v5UniqueName = null;
        if (null == this.getCube()) {
            this.setCube(member.getDimension().getCube());
        }
        if (member.getHierarchy() == null && member.getDimension() == null) {
            return v5UniqueName;
        }
        int levelNumber = member.getParentLevelNumber();
        if (-1 == levelNumber) {
            v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(member.getHierarchy(), member.getParentUniqueName());
        } else {
            String keyDate = (String)this.getPropertyValue(PROP_KEY_DATE);
            ILevel level = this.determineLevel(levelNumber, member.getDimension().getUniqueName(), member.getHierarchy().getUniqueName(), keyDate);
            v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(level, member.getParentUniqueName());
        }
        return v5UniqueName;
    }

    protected ILevel determineLevel(String levelUName, String dimensionUName, String hierarchyUName, String keyDate) {
        return this.determineLevel(levelUName, dimensionUName, hierarchyUName, keyDate, null, null);
    }

    protected ILevel determineLevel(String levelUName, String dimensionUName, String hierarchyUName, String keyDate, DateValue validFrom, DateValue validTo) {
        IDimension dimension = this.cube.getDimension(dimensionUName);
        IHierarchy hierarchy = null;
        ILevel level = null;
        if (dimension != null) {
            hierarchy = DataSourceTypeEnum.isSAPBW(this.getDataSource().getType()) ? dimension.getHierarchy(hierarchyUName, keyDate, validFrom, validTo) : dimension.getHierarchy(hierarchyUName);
            if (hierarchy == null && dimension.isMeasuresDimension()) {
                hierarchy = dimension.getDefaultHierarchy();
            }
            if ((level = hierarchy.getLevel(levelUName)) == null && dimension.isMeasuresDimension()) {
                level = hierarchy.getLevel(0);
            }
        }
        return level;
    }

    protected IDimension getDimension(String dimensionUName) {
        return this.cube.getDimension(dimensionUName);
    }

    protected IHierarchy getHierarchy(String dimensionUName, String hierarchyUName) {
        IDimension dimension = this.cube.getDimension(dimensionUName);
        if (dimension != null) {
            return dimension.getHierarchy(hierarchyUName);
        }
        return null;
    }

    protected ILevel determineLevel(int levelNumber, String dimensionUName, String hierarchyUName, String keyDate) {
        return this.determineLevel(levelNumber, dimensionUName, hierarchyUName, keyDate, null, null);
    }

    protected ILevel determineLevel(int levelNumber, String dimensionUName, String hierarchyUName, String keyDate, DateValue validFrom, DateValue validTo) {
        IDimension dimension = this.cube.getDimension(dimensionUName);
        if (dimension == null) {
            dimension = this.cube.queryDimension(dimensionUName);
        }
        IHierarchy hierarchy = null;
        ILevel level = null;
        if (dimension != null) {
            if (dimension.isMeasuresDimension()) {
                hierarchy = dimension.getHierarchy(hierarchyUName);
                if (null == hierarchy) {
                    hierarchy = dimension.getDefaultHierarchy();
                }
                if (null == (level = hierarchy.getLevel(levelNumber))) {
                    level = hierarchy.getLevel(0);
                }
            } else if (DataSourceTypeEnum.isSAPBW(this.cube.getModelDataSource().getInterface())) {
                hierarchy = dimension.getHierarchy(hierarchyUName, keyDate, validFrom, validTo);
                if (hierarchy == null && dimension instanceof IVirtualDimension) {
                    hierarchy = ((IVirtualDimension)dimension).queryHierarchy(hierarchyUName);
                }
            } else {
                hierarchy = dimension.getHierarchy(hierarchyUName);
            }
            level = hierarchy.getLevel(levelNumber);
        }
        return level;
    }

    public ICube getCube() {
        return this.cube;
    }

    public void setCube(ICube theCube) {
        this.cube = theCube;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501113) {
            return true;
        }
        return super.isOfCategory(category);
    }

    protected String getMUN(IMember member) {
        return member.getV5UniqueName();
    }

    private final class MemberCaptionValueComparator
    implements Comparator<IMember> {
        private MemberCaptionValueComparator() {
        }

        @Override
        public int compare(IMember lhs, IMember rhs) {
            Value lhsCap = lhs.getCaptionValue();
            Value rhsCap = rhs.getCaptionValue();
            if (lhsCap == null) {
                if (rhsCap == null) {
                    return 0;
                }
                return 1;
            }
            if (rhsCap == null) {
                return -1;
            }
            return lhsCap.compareTo(rhsCap);
        }
    }
}

