/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.providers.filedatasource.GenericDataSourceManager;
import com.cognos.xqe.data.providers.filedatasource.IGenericDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;

public class MDXQueryFake
extends MDXQuery {
    private String mdx = null;
    private String mdQuery = null;
    private int numberOfEdges = 0;
    private ICube cube;
    private String dataSourceName = new String();

    public MDXQueryFake(String mdxString, ICube aCube) {
        this.setMDX(mdxString);
        this.cube = aCube;
    }

    public MDXQueryFake(String mdxString, ICube aCube, String theDataSourceName) {
        this.setMDX(mdxString);
        if (aCube == null) {
            this.dataSourceName = theDataSourceName;
            GenericDataSourceManager dataSourceMgr = GenericDataSourceManager.getInstance();
            IGenericDataSource userDataSource = dataSourceMgr.findDataSource(this.dataSourceName);
            MetadataConnection metadataCon = userDataSource.getMetadataConnection();
            if (!(metadataCon instanceof NativeMetadataConnection)) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Expected NativeMetadataConnection");
            }
            NativeMetadataConnection connection = (NativeMetadataConnection)metadataCon;
            this.cube = connection.getCube(userDataSource.getCatalogName(), userDataSource.getCubeName());
            if (this.cube == null) {
                this.cube = connection.getCube(userDataSource.getCubeName());
            }
            if (this.cube == null) {
                throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_CubeNotFound, "");
            }
        } else {
            this.cube = aCube;
        }
    }

    @Override
    public String getMDX() {
        return this.mdx;
    }

    public void setMDX(String theMDX) {
        this.mdx = theMDX;
        this.mdQuery = theMDX;
    }

    @Override
    public String getMDQuery() {
        return this.mdQuery;
    }

    @Override
    public int getNumberOfEdges() {
        return this.numberOfEdges;
    }

    public void setNumberOfEdges(int numOfEdges) {
        this.numberOfEdges = numOfEdges;
    }

    @Override
    public ICube getReferencedCube() {
        if (null != this.cube) {
            return this.cube;
        }
        return super.getReferencedCube();
    }
}

