/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNodeCheckSum;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMdxLocal
extends XMdx {
    private static final long serialVersionUID = -4750995787678432548L;
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String ATTRIBUTE_CUBENAME = "cubeName";
    private static final String ATTRIBUTE_ISDMR = "isDMR";
    private static final String VALUE_TRUE = "true";
    private String vdFilter = null;
    private boolean hasUnresolvedDefaultMember = false;
    private String provider;
    private String cubeName;
    private boolean isDMR;
    private boolean isDMRCubeReuseEnabled;
    private ICube localCube;
    private String mTabResultSetName;
    private MDXLevelInfo levelInfoFromMDXQuery = null;
    HashMap<String, String> queryNamedSetNameToExpandedDefinitionMap = null;
    private boolean isExecuteForValidate = false;
    private List<BaseMember> pBaseMembers = null;
    private static ConcurrentMap<String, LRUMap> cacheMap = new ConcurrentHashMap<String, LRUMap>();
    public static final int KEYSET_SIZE = Integer.parseInt(System.getProperty("KEYSET_SIZE", "1000"));
    public static final int RESULTSET_SIZE_MAX = Integer.parseInt(System.getProperty("RESULTSET_SIZE_MAX", "500000"));
    public static final int RESULTSET_LRUMAP_MAXSIZE = Integer.parseInt(System.getProperty("RESULTSET_LRUMAP_MAXSIZE", "32"));
    HashMap<String, String> calculatedMemberUniqueNameMap = null;
    private HashMap<String, String> mapCMUniNameToFormatIds = null;

    public static void putInLocalCache(String threadId, ISet[] keyset, IResultSet rs) {
        LRUMap lmap = (LRUMap)cacheMap.get(threadId);
        if (lmap == null) {
            lmap = new LRUMap(RESULTSET_LRUMAP_MAXSIZE);
            cacheMap.put(threadId, lmap);
        }
        lmap.put((Object)keyset, (Object)rs);
    }

    public static LRUMap getLocalCache(String threadId) {
        return (LRUMap)cacheMap.get(threadId);
    }

    public static void removeLocalCache(String threadId) {
        cacheMap.remove(threadId);
    }

    @Override
    public int getType() {
        return 501053;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501053) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement(this.getNodeTypeName(), -1);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void computeCheckSum(XQEQueryNodeCheckSum checkSum) {
        for (IXQEQueryNode child : this.getChildren()) {
            checkSum.compute(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IValue iValue = this.tryToExecute(context);
            return iValue;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue tryToExecute(XDataContext context) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)context.getEnvironment();
        XDataContext subDataContext = execEnv.pushDataContext();
        IValue val = null;
        try {
            XMdxLocal primingRuntree = null;
            if (this.getMDXQuery() != null) {
                primingRuntree = this.getMDXQuery().getPlannedPrimingQuery();
            }
            if (primingRuntree != null) {
                long ticks = System.currentTimeMillis();
                primingRuntree.setHasUnResolvedDefaultMember(this.hasUnresolvedDefaultMember);
                primingRuntree.setVDFilter(this.getVDFilter());
                XMdxLocal.executeMDXQuery(primingRuntree, execEnv);
                XQEDebugLog.out.println("Priming query-Sub Query Execute Time:" + (System.currentTimeMillis() - ticks));
            }
            execEnv.setDataSource(this.getDataSource());
            val = ((XNode)this.getChild(0)).execute(subDataContext);
            XMdxLocal.removeLocalCache(Thread.currentThread().getName());
        }
        finally {
            execEnv.popDataContext(subDataContext);
        }
        return val;
    }

    public boolean isListReport() {
        return this.mdxQuery.isListReport();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.cubeName = inputNode.attributeValue(ATTRIBUTE_CUBENAME);
        this.isDMR = VALUE_TRUE.equals(inputNode.attributeValue(ATTRIBUTE_ISDMR));
        String dataSourceName = inputNode.attributeValue(ATTRIBUTE_DATASOURCE);
        MetadataConnection connection = MetadataService.getInstance().getConnection("MFW4J", env.getModelPath(), (IExecutionEnvironment)env.getExecutionEnvironment(), true);
        IModelDataSource modelDS = connection.getModelDataSource(dataSourceName);
        ICube cube = modelDS.getCube();
        if (cube == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_CubeNotFound, this.cubeName);
        }
        IDataSource ds = ((ExecutionEnvironment)env.getExecutionEnvironment()).getOrAddDataSource(modelDS);
        this.setDataSource(ds);
        Attribute nodeIdAttribute = inputNode.attribute("id");
        if (nodeIdAttribute != null) {
            this.setNodeId(XQEIntegerPool.getInteger(Integer.parseInt(nodeIdAttribute.getValue())));
        }
        Element child = (Element)inputNode.elements().get(1);
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_CUBENAME, this.cubeName);
        trace.attribute(ATTRIBUTE_ISDMR, this.isDMR);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    public void setProviderName(String clazz) {
        this.provider = clazz;
    }

    public String getProviderName() {
        return this.provider;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    protected void beginTrace(XQETrace trace, String nodeTypeName, Integer id) {
        if (trace != null && (trace.getTraceLevel() & 0x800) != 0) {
            trace.beginElement(nodeTypeName, id);
            trace.beginElement("in", -1);
            this.traceInParameters(trace);
            trace.endElement();
            trace.beginElement("exec", -1);
        }
    }

    @Override
    protected void endTrace(XQETrace trace, IValue retVal) {
        if (trace != null && (trace.getTraceLevel() & 0x800) != 0) {
            trace.endElement();
            trace.beginElement("out", -1);
            if (retVal != null) {
                retVal.toXML(trace);
            }
            trace.endElement();
            trace.endElement();
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (IXQEQueryNode child : this.getChildren()) {
            child.dump(trace, includeRuntimeSpecifics);
        }
        trace.endElement();
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        XMdxLocal copy = (XMdxLocal)node;
        copy.setCube(this.cubeName);
        copy.setDataSource(this.dataSource);
        copy.setProviderName(this.provider);
    }

    public void setLocalCube(ICube acube) {
        this.localCube = acube;
    }

    public ICube getLocalCube() {
        return this.localCube;
    }

    public boolean isDMR() {
        return this.isDMR;
    }

    public void setIsDMR(boolean b) {
        this.isDMR = b;
    }

    public boolean isDMRCubeReuseEnabled() {
        return this.isDMRCubeReuseEnabled;
    }

    public void setIsDMRCubeReuseEnabled(boolean b) {
        this.isDMRCubeReuseEnabled = b;
    }

    public void setTabularResultSetName(String tabResultSetName) {
        this.mTabResultSetName = tabResultSetName;
    }

    public String getTabularResultSetName() {
        return this.mTabResultSetName;
    }

    public MDXLevelInfo getLevelInfoProperty() {
        return this.levelInfoFromMDXQuery;
    }

    public void setLevelInfoProperty(MDXLevelInfo levelInfo) {
        this.levelInfoFromMDXQuery = levelInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMDXQuery(XMdxLocal xmdxLocal, ExecutionEnvironment environment) {
        if (environment.getTrace() == null) {
            XQETrace trace = new XQETrace();
            environment.setTrace(trace);
        }
        QueryEngineLoggingUtils.addExecutionTraceLevels(environment.getTrace(), environment.getRequestEnvironment());
        QueryEngineLoggingUtils.dumpRuntreeLog(environment, xmdxLocal);
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setInternalUse(false);
        envHelper.setUpEnvironment(false);
        ExecutionEnvironment newExecEnv = envHelper.getExecutionEnvironment();
        try {
            XDataContext dataContext = newExecEnv.pushDataContext();
            IValue result = null;
            try {
                result = xmdxLocal.execute(dataContext);
            }
            finally {
                newExecEnv.popDataContext(dataContext);
                if (result != null && result instanceof ResultSetValue) {
                    ((ResultSetValue)result).release();
                }
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
        QueryEngineLoggingUtils.dumpProfilingLog(environment, xmdxLocal);
    }

    public void setCalculatedMemberUniqueNameMap(HashMap<String, String> map) {
        this.calculatedMemberUniqueNameMap = map;
    }

    public HashMap<String, String> getCalculatedMemberUniqueNameMap() {
        return this.calculatedMemberUniqueNameMap;
    }

    public void registerFormatIds(HashMap<String, String> f) {
        this.mapCMUniNameToFormatIds = f;
    }

    public String getCalculatedMemberFormatId(String uniName) {
        if (this.mapCMUniNameToFormatIds == null) {
            return null;
        }
        return this.mapCMUniNameToFormatIds.get(uniName);
    }

    public void setQueryNamedSetNameToExpandedDefinitionMap(HashMap<String, String> map) {
        this.queryNamedSetNameToExpandedDefinitionMap = map;
    }

    public HashMap<String, String> getQueryNamedSetNameToExpandedDefinitionMap() {
        return this.queryNamedSetNameToExpandedDefinitionMap;
    }

    public static String getExpandedNamedSetDefinition(IXQEQueryNode node, String namedSetName) {
        XMdxLocal xMdxLocal = (XMdxLocal)node.getAncestorOfType(501053);
        if (xMdxLocal != null && xMdxLocal.queryNamedSetNameToExpandedDefinitionMap != null) {
            return xMdxLocal.queryNamedSetNameToExpandedDefinitionMap.get(namedSetName);
        }
        return null;
    }

    public boolean getExecuteForValidate() {
        return this.isExecuteForValidate;
    }

    public void setExecuteForValidate(boolean b) {
        this.isExecuteForValidate = b;
    }

    public List<BaseMember> getBaseMembersInQuery() {
        if (this.pBaseMembers == null) {
            this.pBaseMembers = CollectionCast.downcast(this.mdxQuery.getDescendantsOfTypeOrdered(1067, false), IXQEQueryNode.class, BaseMember.class);
        }
        return this.pBaseMembers;
    }

    public String getVDFilter() {
        return this.vdFilter;
    }

    public void setVDFilter(String valueDetailFilter) {
        this.vdFilter = valueDetailFilter;
    }

    public boolean hasUnResolvedDefaultMember() {
        return this.hasUnresolvedDefaultMember;
    }

    public void setHasUnResolvedDefaultMember(boolean hasUnresolvedDFM) {
        this.hasUnresolvedDefaultMember = hasUnresolvedDFM;
    }
}

