/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabRowHandler;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.metadata.Catalog;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XRelationalCrosstab
extends XNode {
    private static final long serialVersionUID = -5063917123330036663L;
    private HashMap<ArrayList<String>, RelationalCrosstabCube> cacheCubes = null;
    private ArrayList<Parameter> mdParams = null;
    private ArrayList<String> key = null;

    @Override
    public int getType() {
        return 501088;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return ((IExecutable)((Object)this.getChild(0))).execute(context);
    }

    public RelationalCrosstabCube getCube(ExecutionEnvironment exeEnvironment, Catalog catalog, ICube modelCube, XMdxLocal xmdxLocal) {
        RelationalCrosstabCube cube;
        if (!(modelCube instanceof CubeWrapper)) {
            return null;
        }
        ArrayList<String> params = ((CubeWrapper)modelCube).getCubeParameters();
        if (params == null) {
            return null;
        }
        if (this.mdParams == null) {
            this.mdParams = new ArrayList();
            this.key = new ArrayList();
            for (String name : params) {
                Parameter p = new Parameter(name);
                p.setMasterDetailLinkParameter(true);
                this.mdParams.add(p);
                this.key.add(null);
            }
        }
        for (int i = 0; i < this.mdParams.size(); ++i) {
            IDataType dataType;
            ParameterValues v = exeEnvironment.getMultiRequestContext().getRequestParameters().getParameterValueItems(this.mdParams.get(i));
            List<String> l = v.getExternalValues(true);
            if (l.size() != 1) {
                RelationalCrosstabCube cube2 = this.cacheCubes.get(this.key);
                cube2 = new RelationalCrosstabCube(catalog, modelCube, null);
                this.setCubeLoaded(cube2);
                return cube2;
            }
            String keyValue = l.get(0);
            if (v.getAssociatedParameter().getDataType() != null && ((dataType = v.getAssociatedParameter().getDataType()).getSubType() == DataSubType.DATETIMETYPE || dataType.getCCLTypeCode() == 11 || dataType.getCCLTypeCode() == 10)) {
                Value valueObject = (Value)dataType.createValue();
                valueObject.set(keyValue);
                keyValue = valueObject.getString();
            }
            this.key.set(i, keyValue);
        }
        if (this.cacheCubes == null) {
            this.cacheCubes = new HashMap();
            RelationalCrosstabCube.loadFromTabularQuery((RSAPIDataset)this.getChild(1), new TabularResultRowHandler(catalog, modelCube, xmdxLocal));
        }
        if ((cube = this.cacheCubes.get(this.key)) == null) {
            cube = new RelationalCrosstabCube(catalog, modelCube, null);
            this.setCubeLoaded(cube);
        }
        return cube;
    }

    protected void setCubeLoaded(RelationalCrosstabCube cube) {
        cube.setLoaded();
        ArrayList<IMember> measures = new ArrayList<IMember>();
        ArrayList<Level> lowestLevelsInDimensions = new ArrayList<Level>();
        cube.initializeCubeForLoading(lowestLevelsInDimensions, measures);
        List<IDimension> dimensions = cube.getDimensions();
        for (IDimension dim : dimensions) {
            if (dim.isMeasuresDimension()) continue;
            IHierarchy defaultHierarchy = dim.getDefaultHierarchy();
            defaultHierarchy.getDefaultMember();
        }
        for (Level lvl : lowestLevelsInDimensions) {
            if (lvl == null) continue;
            for (Level currentLevel = (Level)lvl.getHierarchy().getLevel(0); currentLevel != null; currentLevel = (DMRLevel)currentLevel.getNextLevel()) {
                currentLevel.setGotAllMembers();
            }
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    public final class TabularResultRowHandler
    implements RSAPIRowCallback {
        private Catalog catalogFromCaller = null;
        private ICube modelCubeFromCaller = null;
        private XMdxLocal xmdxLocalFromCaller = null;
        private int countOfRun = 1;
        private ArrayList<Value> values = null;
        private ArrayList<Value> currentValues = null;
        private RSAPIRowCallback currentHandler = null;
        private HashMap<ArrayList<String>, RSAPIRowCallback> cacheHandlers = null;
        private HashMap<ILevel, HashMap<ArrayList<Value>, DMRMember>> cachedDMRMembers = null;

        private TabularResultRowHandler(Catalog catalog, ICube modelCube, XMdxLocal xmdxLocal) {
            this.catalogFromCaller = catalog;
            this.modelCubeFromCaller = modelCube;
            this.xmdxLocalFromCaller = xmdxLocal;
            this.cacheHandlers = new HashMap();
            this.cachedDMRMembers = new HashMap();
        }

        @Override
        public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            if (this.countOfRun == 1) {
                this.firstRun(row, columns, formatIDs);
            } else {
                this.secondRun(row, columns, formatIDs);
            }
        }

        protected void firstRun(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            this.getBreakValues(row);
            if (this.values == null || !this.values.equals(this.currentValues)) {
                if (this.values == null) {
                    this.values = new ArrayList();
                } else {
                    this.values.clear();
                }
                ArrayList<String> brkKey = new ArrayList<String>();
                for (Value v : this.currentValues) {
                    this.values.add((Value)v.copy());
                    brkKey.add(v.toString());
                }
                if (this.cacheHandlers.containsKey(brkKey)) {
                    this.currentHandler = this.cacheHandlers.get(brkKey);
                } else {
                    RelationalCrosstabCube cube = new RelationalCrosstabCube(this.catalogFromCaller, this.modelCubeFromCaller, null);
                    cube.setLoaded();
                    XRelationalCrosstab.this.cacheCubes.put(brkKey, cube);
                    ArrayList<IMember> measures = new ArrayList<IMember>();
                    ArrayList<Level> lowestLevelsInDimensions = new ArrayList<Level>();
                    cube.initializeCubeForLoading(lowestLevelsInDimensions, measures);
                    RelationalCrosstabRowHandler hdler = new RelationalCrosstabRowHandler(this.xmdxLocalFromCaller, cube, lowestLevelsInDimensions, measures, this.cachedDMRMembers);
                    this.cacheHandlers.put(brkKey, hdler);
                    this.currentHandler = hdler;
                }
            }
            this.currentHandler.consumeRow(row, columns, formatIDs);
        }

        private void getBreakValues(RSAPIRow row) {
            if (this.currentValues == null) {
                this.currentValues = new ArrayList();
                for (int i = 0; i < XRelationalCrosstab.this.mdParams.size(); ++i) {
                    this.currentValues.add((Value)row.getColumn(i));
                }
            } else {
                for (int i = 0; i < XRelationalCrosstab.this.mdParams.size(); ++i) {
                    this.currentValues.set(i, (Value)row.getColumn(i));
                }
            }
        }

        protected void secondRun(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            this.getBreakValues(row);
            if (this.values == null || !this.values.equals(this.currentValues)) {
                if (this.values == null) {
                    this.values = new ArrayList();
                } else {
                    this.values.clear();
                }
                ArrayList<String> brkKey = new ArrayList<String>();
                for (Value v : this.currentValues) {
                    this.values.add((Value)v.copy());
                    brkKey.add(v.toString());
                }
                this.currentHandler = this.cacheHandlers.get(brkKey);
            }
            this.currentHandler.consumeRow(row, columns, formatIDs);
        }

        @Override
        public boolean reRun() {
            boolean bR = false;
            for (RSAPIRowCallback hdler : this.cacheHandlers.values()) {
                bR = hdler.reRun();
            }
            if (bR) {
                this.currentValues = null;
                this.values = null;
                this.currentHandler = null;
                ++this.countOfRun;
            }
            return bR;
        }

        @Override
        public boolean needReIterateRows() {
            for (RSAPIRowCallback hdler : this.cacheHandlers.values()) {
                if (!hdler.needReIterateRows()) continue;
                return true;
            }
            return false;
        }
    }
}

