/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.XCubeResultSet;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.dom4j.Element;

public class XRemoveAxes
extends XNode {
    private static final String AXIS_NUMBER = "axisNumber";
    private static final String AXIS = "axis";
    private static final long serialVersionUID = 0L;
    private int[] axesToRemove;

    public void setAxesToRemove(int[] axes) {
        this.axesToRemove = axes;
    }

    @Override
    public int getType() {
        return 501025;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        ICubeResultSet cubeResultSet = (ICubeResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        if (this.axesToRemove == null) {
            cubeResultSet.release();
            throw new IllegalStateException();
        }
        CubeHybridResultSet resultSet = new CubeHybridResultSet(context, new XRemoveAxesCubeResultSet(context, cubeResultSet), this.getId(), CacheHints.cacheNone());
        return resultSet;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elementsList = inputNode.elements(AXIS);
        ListIterator it = elementsList.listIterator();
        int[] axes = new int[elementsList.size()];
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            axes[i] = Integer.parseInt(anElement.attributeValue(AXIS_NUMBER));
            it.remove();
            ++i;
        }
        this.setAxesToRemove(axes);
        super.capture(env, inputNode);
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        int i;
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpProperties(trace);
        for (i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        for (i = 0; i < this.axesToRemove.length; ++i) {
            trace.beginElement(AXIS, -1);
            trace.attribute(AXIS_NUMBER, Integer.toString(this.axesToRemove[i]));
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private class XRemoveAxesCubeResultSet
    extends XCubeResultSet {
        private Map<Integer, Integer> edgeOrdinalMapping;
        private int numAxes;

        XRemoveAxesCubeResultSet(XDataContext context, ICubeResultSet result) {
            super(context, result, XRemoveAxes.this.getId());
            this.edgeOrdinalMapping = new HashMap<Integer, Integer>();
            this.numAxes = -1;
            this.numAxes = result.getNumAxes() - XRemoveAxes.this.axesToRemove.length;
            this.buildEdgeOrdinalMapping();
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            Integer mappedOrdinal = this.edgeOrdinalMapping.get(XQEIntegerPool.getInteger(axisNumber));
            if (mappedOrdinal == null) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getAxisIterator(mappedOrdinal);
        }

        @Override
        public long getAxisSize(int axisNumber) {
            Integer mappedOrdinal = this.edgeOrdinalMapping.get(XQEIntegerPool.getInteger(axisNumber));
            if (mappedOrdinal == null) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getAxisSize(mappedOrdinal);
        }

        @Override
        public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
            Integer mappedOrdinal = this.edgeOrdinalMapping.get(XQEIntegerPool.getInteger(axisNumber));
            if (mappedOrdinal == null) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getScrollableAxisIterator(mappedOrdinal);
        }

        @Override
        public XScrollableCellIterator getScrollableCellIterator() {
            return this.getBaseResultSet().getScrollableCellIterator();
        }

        @Override
        public ITuple getSlicer() {
            return this.getBaseResultSet().getSlicer();
        }

        @Override
        public int getNumAxes() {
            return this.numAxes;
        }

        private void buildEdgeOrdinalMapping() {
            int axesToRemoveIndex = 0;
            int originalIndex = 0;
            int mappedIndex = 0;
            while (mappedIndex < this.numAxes) {
                if (axesToRemoveIndex < XRemoveAxes.this.axesToRemove.length && mappedIndex == XRemoveAxes.this.axesToRemove[axesToRemoveIndex]) {
                    ++originalIndex;
                    if (++axesToRemoveIndex < this.numAxes) continue;
                    return;
                }
                Integer mappedOrdinal = XQEIntegerPool.getInteger(mappedIndex++);
                Integer originalOrdinal = XQEIntegerPool.getInteger(originalIndex++);
                this.edgeOrdinalMapping.put(mappedOrdinal, originalOrdinal);
            }
        }

        @Override
        public void releaseImpl() {
            if (this.edgeOrdinalMapping != null) {
                this.edgeOrdinalMapping.clear();
                this.edgeOrdinalMapping = null;
            }
            super.releaseImpl();
        }
    }
}

