/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RenameMUN;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RenameV5;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractOLAPColumn
extends AbstractOLAPEdgeElement {
    private RSAPIEdgeRowset rowset = null;
    private int dataItemIndex = -1;
    private String dataItemName = null;
    private IHierarchy hierarchy = null;
    private boolean isHierarchyNormalization = false;
    private boolean isQueryCalculation = false;
    private boolean isCalculationCM = false;
    private boolean isV5CalculatedMember = false;
    private boolean isReportSummary = false;
    private boolean isContextMember = false;
    private boolean isRaggedCompensation = false;
    private boolean isUnbalancedCompensation = false;
    private EdgeMappingRules rules = new EdgeMappingRules();
    private IMember stCurrentMember = null;
    private IMember stPreviousMember = null;
    private boolean stRendered = false;
    private AbstractMDXSet cogMDXGroup = null;
    private int cogMDXGroupId = -1;
    private boolean couldResolveToEmptySet = false;
    private SortedMap<Integer, List<Integer>> dataitemIndixesProjectingSameSet = null;

    public AbstractOLAPColumn() {
        this.rules.setOwner(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.setCurrentMember(null);
        this.setPreviousMember(null);
        this.setRendered(false);
        this.rules.reset();
        this.rules.resetNextMemberListIndex();
        GenerateContext generateContext = (GenerateContext)this.getActionOfTypeForMUN(2, null);
        if (generateContext != null) {
            generateContext.reset();
        }
    }

    @Override
    public void partialReset() {
        super.partialReset();
        this.setCurrentMember(null);
        this.setPreviousMember(null);
        this.rules.reset();
        this.rules.resetNextMemberListIndex();
        GenerateContext generateContext = (GenerateContext)this.getActionOfTypeForMUN(2, null);
        if (generateContext != null) {
            generateContext.reset();
        }
    }

    @Override
    public boolean isColumn() {
        return true;
    }

    public RSAPIEdgeRowset getRowset() {
        return this.rowset;
    }

    public void setRowset(RSAPIEdgeRowset aRowset) {
        this.rowset = aRowset;
        this.setDataItemName();
    }

    public void setDataItemIndex(RSAPIDataItem dataItem) {
        this.dataItemIndex = this.rowset.getDataItemOrdinal(dataItem);
    }

    public int getDataItemIndex() {
        return this.dataItemIndex;
    }

    public void setDataItemIndex(int aDataItemIndex) {
        this.dataItemIndex = aDataItemIndex;
    }

    private void setDataItemName() {
        if (this.getDataItem() != null) {
            this.dataItemName = this.getDataItem().getName();
        }
    }

    public void setDataItemName(String aDataItemName) {
        this.dataItemName = aDataItemName;
    }

    public String getDataItemName() {
        return this.dataItemName;
    }

    public RSAPIDataItem getDataItem() {
        RSAPIDataItem dataItem = null;
        if (this.rowset != null) {
            boolean noDataItemIndex;
            boolean bl = noDataItemIndex = this.dataItemIndex == -1;
            if (noDataItemIndex && this.rowset.getRefDataItem() != null) {
                return this.rowset.getRefDataItem();
            }
            if (!noDataItemIndex && this.rowset.getDataItem(this.dataItemIndex) != null) {
                return this.rowset.getDataItem(this.dataItemIndex);
            }
        }
        return dataItem;
    }

    public void setHierarchy(IHierarchy aHierarchy) {
        this.hierarchy = aHierarchy;
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public boolean isRagged() {
        if (this.hierarchy != null) {
            return !this.hierarchy.getDimension().isMeasuresDimension() && this.hierarchy.isRagged();
        }
        return false;
    }

    public boolean isUnbalanced() {
        if (this.hierarchy != null) {
            return !this.hierarchy.getDimension().isMeasuresDimension() && this.hierarchy.isUnbalanced();
        }
        return false;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputEdgeElement, int edgeOrdinal) {
        super.capture(env, inputEdgeElement, edgeOrdinal);
        Attribute attribute = inputEdgeElement.attribute("dataItemIndex");
        if (attribute != null) {
            this.setDataItemIndex(Integer.parseInt(attribute.getValue()));
        }
        if ((attribute = inputEdgeElement.attribute("rowsetId")) != null) {
            RSAPIEdgeRowset aRowset = EdgeMappingUtils.getRowset(attribute.getStringValue(), edgeOrdinal);
            this.setRowset(aRowset);
        }
        if ((attribute = inputEdgeElement.attribute("isHierarchyNormalization")) != null) {
            this.setHierarchyNormalization(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isQueryCalculation")) != null) {
            this.setQueryCalculation(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isCalculationCM")) != null) {
            this.setCalculationCM(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isV5CalculatedMember")) != null) {
            this.setV5CalculatedMember(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isReportSummary")) != null) {
            this.setReportSummary(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isContextMember")) != null) {
            this.setContextMember(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isRaggedCompensation")) != null) {
            this.setRaggedCompensation(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("isUnbalancedCompensation")) != null) {
            this.setUnbalancedCompensation(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        if ((attribute = inputEdgeElement.attribute("couldResolveToEmptySet")) != null) {
            this.setCouldResolveToEmptySet(attribute.getStringValue().equals(Boolean.TRUE.toString()));
        }
        this.setHierarchy(EdgeMappingUtils.captureHierarchy(env, inputEdgeElement));
        List childList = inputEdgeElement.elements();
        ListIterator listIterator = childList.listIterator();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            if (!elementName.equals("rules")) continue;
            this.rules.capture(anElement);
        }
    }

    @Override
    public void dumpExtraAttibutes(XQETrace trace) {
        if (this.getRowset() != null) {
            trace.attribute("rowsetId", this.rowset.getRowsetId());
            trace.attribute("rowsetName", this.rowset.getName());
        }
        if (this.getDataItemIndex() != -1) {
            trace.attribute("dataItemIndex", this.dataItemIndex);
        }
        if (this.getDataitemIndixesProjectingSameSet() != null && !this.getDataitemIndixesProjectingSameSet().isEmpty()) {
            trace.attribute("dataitemIndixesProjectingSameSet", this.getDataitemIndixesProjectingSameSet().toString());
        }
        if (this.dataItemName != null) {
            trace.attribute("dataItemName", this.dataItemName);
        }
        if (this.getHierarchy() != null) {
            trace.attribute("hierarchy", this.hierarchy.getV5UniqueName());
            if (this.isRagged()) {
                trace.attribute("ragged", this.isRagged());
            }
            if (this.isUnbalanced()) {
                trace.attribute("unbalanced", this.isUnbalanced());
            }
        }
        if (this.isHierarchyNormalization()) {
            trace.attribute("isHierarchyNormalization", Boolean.TRUE.toString());
        }
        if (this.isQueryCalculation()) {
            trace.attribute("isQueryCalculation", Boolean.TRUE.toString());
        }
        if (this.isCalculationCM()) {
            trace.attribute("isCalculationCM", Boolean.TRUE.toString());
        }
        if (this.isV5CalculatedMember()) {
            trace.attribute("isV5CalculatedMember", Boolean.TRUE.toString());
        }
        if (this.isReportSummary()) {
            trace.attribute("isReportSummary", Boolean.TRUE.toString());
        }
        if (this.isContextMember()) {
            trace.attribute("isContextMember", Boolean.TRUE.toString());
        }
        if (this.isRaggedCompensation()) {
            trace.attribute("isRaggedCompensation", Boolean.TRUE.toString());
        }
        if (this.isUnbalancedCompensation()) {
            trace.attribute("isUnbalancedCompensation", Boolean.TRUE.toString());
        }
        if (this.getCogMDXGroup() != null) {
            trace.attribute("CogMDXGroup", this.getCogMDXGroup());
        }
        if (this.getCogMDXGroupId() != -1) {
            trace.attribute("CogMDXGroupId", this.getCogMDXGroupId());
        }
        if (this.getCurrentMember() != null) {
            trace.attribute("currMember", this.getCurrentMember().getUniqueName());
        }
        if (this.getPreviousMember() != null) {
            trace.attribute("prevMember", this.getPreviousMember().getUniqueName());
        }
        if (this.wasRendered()) {
            trace.attribute("rendered", this.wasRendered());
        }
        if (this.couldResolveToEmptySet()) {
            trace.attribute("couldResolveToEmptySet", this.couldResolveToEmptySet());
        }
    }

    @Override
    public void dumpExtraElements(XQETrace trace) {
        if (this.rules != null) {
            this.rules.dump(trace);
        }
    }

    protected static IHierarchy bindHierarchy(PlanningEnvironment env, String hierarchyName) {
        MetadataConnection mc = MetadataService.getInstance().getConnection("MFW4J", env.getModelPath(), (IExecutionEnvironment)env.getExecutionEnvironment(), true);
        IMetadata mo = mc.bindMetadataReference(hierarchyName);
        if (mo instanceof IDimension) {
            mo = ((IDimension)mo).getDefaultHierarchy();
        }
        if (mo == null || !(mo instanceof IHierarchy)) {
            throw new XQERuntimeException(XQEMessageKeys.DEC_InvalidHierarchyBinding, hierarchyName);
        }
        return (IHierarchy)mo;
    }

    public boolean isFillerTag() {
        return this.getRules().isFillerTag();
    }

    @Override
    public boolean accept(ITuple aTuple, boolean modifyState) {
        boolean doRulesApply = false;
        int tuplePosition = this.getTuplePosition();
        IMember firstMember = aTuple.getMember(tuplePosition);
        IMember fillerTagMember = null;
        if (this.isContext() && aTuple.getMembers().length > tuplePosition + 1 && CalcMemberReferencePrefixes.isFillerTag(aTuple.getMember(tuplePosition + 1))) {
            fillerTagMember = aTuple.getMember(1);
        }
        if (fillerTagMember == null && this.isContext() && !this.isUnbalanced() && aTuple.getMembers().length > tuplePosition + 1 && ((OLAPRowCycle)this.getParentRow()).getRow(0).getNumberOfColumns() > tuplePosition + 1 && ((OLAPRowCycle)this.getParentRow()).getRow(0).getColumn(tuplePosition + 1).isFillerTag()) {
            return doRulesApply;
        }
        doRulesApply = this.rules.applies(modifyState, firstMember);
        if (doRulesApply && fillerTagMember != null) {
            doRulesApply = ((OLAPRowCycle)this.getParentRow()).getRow(0).acceptSkippingCMRules(aTuple);
        }
        return doRulesApply;
    }

    @Override
    public boolean map(ITuple aTuple) {
        boolean isProviderMemberSameAsPreviouslyAccepted;
        AbstractOLAPRow parentRow = this.getParentRow();
        boolean doRulesApply = false;
        boolean memberIsAKnownCalcAndIsNotMappedByThis = false;
        IMember targetMember = aTuple.getMember(this.getTuplePosition());
        boolean isKnownCalculation = false;
        String targetMemberUniqueName = null;
        String[] munArray = new String[]{targetMemberUniqueName};
        isKnownCalculation = this.isKnownMDXCalculation(targetMember, munArray);
        targetMemberUniqueName = munArray[0];
        if (this.getRulesType() != 4 && this.getRulesType() != 7 && isKnownCalculation) {
            memberIsAKnownCalcAndIsNotMappedByThis = true;
            List<EdgeMappingRules.MemberDescriptor> calcDescriptors = this.getRules().getCalculatedMemberList();
            if (calcDescriptors != null && !calcDescriptors.isEmpty()) {
                for (EdgeMappingRules.MemberDescriptor calcDescriptor : calcDescriptors) {
                    if (!calcDescriptor.isCalculation() || !calcDescriptor.getMUN().equals(targetMemberUniqueName)) continue;
                    memberIsAKnownCalcAndIsNotMappedByThis = false;
                    break;
                }
            }
        }
        if (memberIsAKnownCalcAndIsNotMappedByThis) {
            doRulesApply = false;
        } else {
            if (targetMemberUniqueName == null) {
                boolean isCalculatedMember;
                boolean bl = isCalculatedMember = targetMember.isDataBaseCalculation() || targetMember.isCalculatedMember();
                if (!isCalculatedMember && targetMember.getLevel().getIndex() == 0) {
                    targetMemberUniqueName = targetMember.getUniqueName();
                }
            }
            if (targetMemberUniqueName != null && targetMemberUniqueName.contains(".[NOMEMBER]")) {
                boolean hasMUNRules;
                boolean bl = hasMUNRules = this.getRulesType() == 2 || this.getRulesType() == 6 || this.getRulesType() == 5;
                if (!hasMUNRules) {
                    doRulesApply = false;
                } else {
                    List<EdgeMappingRules.MemberDescriptor> memberDescriptors = this.getRules().getMemberDescriptorList();
                    boolean hasNoMember = false;
                    for (EdgeMappingRules.MemberDescriptor memberDescriptor : memberDescriptors) {
                        if (!memberDescriptor.isNoMember()) continue;
                        hasNoMember = true;
                        break;
                    }
                    doRulesApply = !hasNoMember ? false : this.accept(aTuple, true);
                }
            } else {
                doRulesApply = this.accept(aTuple, true);
            }
        }
        if (doRulesApply && !isKnownCalculation) {
            doRulesApply = this.doRaggedContextApply(aTuple);
        }
        if (!doRulesApply) {
            if (!this.isContext()) {
                this.setDone(true);
            }
            if (this.isContext() && ((OLAPContextColumn)this).isLocked() == 0) {
                ((OLAPContextColumn)this).setLocked(-1);
            }
            return false;
        }
        IMember providerMember = aTuple.getMember(this.rules.getTuplePosition());
        IMember previouslyAcceptedMember = this.getCurrentMember();
        String previouslyAcceptedMemberMUN = null;
        if (previouslyAcceptedMember != null) {
            previouslyAcceptedMemberMUN = previouslyAcceptedMember.isContextMember() ? ((ContextMember)previouslyAcceptedMember).getMember().getUniqueName() : previouslyAcceptedMember.getUniqueName();
        }
        boolean bl = isProviderMemberSameAsPreviouslyAccepted = previouslyAcceptedMemberMUN != null && previouslyAcceptedMemberMUN.equals(providerMember.getUniqueName());
        if (this.isContext()) {
            OLAPRowCycle parentCycle = (OLAPRowCycle)parentRow;
            OLAPContextColumn notRenderedContextColumn = EdgeMappingUtils.isNestingANotRenderedContextColumn(parentCycle);
            if (notRenderedContextColumn != null && !isProviderMemberSameAsPreviouslyAccepted) {
                String notRenderedUniqueName;
                boolean mixedRuleType;
                if (parentCycle.getUnbalancedTuple() != null) {
                    AbstractOLAPColumn.handlePendingUnbalancedLeaf(aTuple, parentCycle, notRenderedContextColumn);
                    return true;
                }
                OLAPRowCycle notRenderedCycle = (OLAPRowCycle)notRenderedContextColumn.getParentRow();
                boolean bl2 = mixedRuleType = notRenderedContextColumn.getRulesType() == 5 || notRenderedContextColumn.getRulesType() == 6;
                if (notRenderedCycle.isNestingSameHierarchy() && mixedRuleType && EdgeMappingUtils.isCalculatedMemberUniqueName(notRenderedUniqueName = notRenderedContextColumn.getCurrentMember().getUniqueName())) {
                    AbstractOLAPColumn.handleCalculationAddedToLevelSet(aTuple, parentCycle, notRenderedContextColumn);
                    return true;
                }
                StringBuilder discardingContextMember = new StringBuilder("We are about to discard context member ");
                discardingContextMember.append(previouslyAcceptedMember.getUniqueName());
                discardingContextMember.append(" stored in  ");
                discardingContextMember.append(this.getClass().getSimpleName());
                discardingContextMember.append("(");
                discardingContextMember.append(this.getId().toString());
                discardingContextMember.append(")");
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, discardingContextMember.toString());
            }
            if (((OLAPContextColumn)this).isLocked() == 0) {
                ((OLAPContextColumn)this).setLocked(1);
            }
        }
        if (previouslyAcceptedMember != null) {
            this.setPreviousMember(previouslyAcceptedMember);
        }
        if (!isProviderMemberSameAsPreviouslyAccepted) {
            this.setCurrentMember(providerMember);
            if (this.isContext()) {
                ((OLAPContextColumn)this).setCurrentTuple(aTuple);
            }
        }
        if (!this.isContext()) {
            boolean isDoneLastColumnOfLastNonCycleRowNestedDirectlyUnderRootCycle;
            this.setDone(this.rules.isDone());
            if (parentRow.isSummaryRow() && parentRow.getParentRow() != parentRow.getRootRowCycle()) {
                this.setDone(true);
            }
            boolean bl3 = isDoneLastColumnOfLastNonCycleRowNestedDirectlyUnderRootCycle = this.isDone() && parentRow.getParentRow() == parentRow.getRootRowCycle() && ((OLAPRowCycle)parentRow.getParentRow()).isLastRow(parentRow) && this == parentRow.getColumn(parentRow.getNumberOfColumns() - 1);
            if (isDoneLastColumnOfLastNonCycleRowNestedDirectlyUnderRootCycle) {
                boolean resetCycle = true;
                if (parentRow.getFirstColumn().getRulesType() != 4 || parentRow.getFirstColumn().getActionOfTypeForMUN(12, null) == null) {
                    for (int i = 0; i < parentRow.getNumberOfColumns() - 1; ++i) {
                        AbstractOLAPColumn previousColumn = parentRow.getColumn(i);
                        if (previousColumn.isDone()) continue;
                        resetCycle = false;
                        break;
                    }
                }
                if (resetCycle) {
                    ((OLAPRowCycle)parentRow.getParentRow()).stResetCycle = resetCycle;
                }
            }
        }
        return true;
    }

    protected static void handleCalculationAddedToLevelSet(ITuple aTuple, OLAPRowCycle targetCycle, OLAPContextColumn notRenderedContextColumn) {
        OLAPContextColumn targetColumn;
        ITuple mappedTuple;
        OLAPRowCycle notRenderedCycle = (OLAPRowCycle)notRenderedContextColumn.getParentRow();
        int numOfTupleMembers = aTuple.getMembers().length;
        notRenderedCycle.mapUnbalancedTuple(numOfTupleMembers);
        notRenderedCycle.setMappedTuple(notRenderedCycle.getUnbalancedTuple());
        notRenderedCycle.setUnbalancedTuple(null);
        int notRenderedCycleTuplePosition = notRenderedContextColumn.getTuplePosition();
        IHierarchy notRenderedHierarchy = notRenderedContextColumn.getHierarchy();
        while (notRenderedCycle != targetCycle) {
            ITuple pendingTuple = notRenderedCycle.getMappedTuple();
            if (!notRenderedHierarchy.equals((notRenderedCycle = (OLAPRowCycle)notRenderedCycle.getParentRow()).getFirstColumn().getHierarchy())) break;
            ContextMember member = (ContextMember)pendingTuple.getMember(notRenderedCycleTuplePosition);
            ContextMember context = notRenderedCycle.getFirstColumn().createContextMember();
            EdgeMappingUtils.setContextMember(context, member);
            notRenderedCycle.setMappedTuple(pendingTuple);
        }
        if ((mappedTuple = targetCycle.getMappedTuple()).getMember((targetColumn = (OLAPContextColumn)targetCycle.getFirstColumn()).getTuplePosition()) == null) {
            IMember[] members = mappedTuple.getMembers();
            members[targetColumn.getTuplePosition()] = targetColumn.createContextMember();
            mappedTuple = new Tuple(members);
        }
        targetCycle.setMappedTuple(mappedTuple);
        targetCycle.getRootRowCycle().setstPostponedInputForHandlingPrevUnbalanced(aTuple);
    }

    protected static void handlePendingUnbalancedLeaf(ITuple aTuple, OLAPRowCycle targetCycle, OLAPContextColumn notRenderedContextColumn) {
        OLAPContextColumn targetColumn;
        ITuple unbalancedTuple;
        OLAPRowCycle notRenderedCycle = (OLAPRowCycle)notRenderedContextColumn.getParentRow();
        int notRenderedCycleTuplePosition = notRenderedContextColumn.getTuplePosition();
        IHierarchy notRenderedHierarchy = notRenderedContextColumn.getHierarchy();
        while (notRenderedCycle != targetCycle) {
            ITuple pendingTuple = notRenderedCycle.getUnbalancedTuple();
            if (!notRenderedHierarchy.equals((notRenderedCycle = (OLAPRowCycle)notRenderedCycle.getParentRow()).getFirstColumn().getHierarchy())) break;
            ContextMember member = (ContextMember)pendingTuple.getMember(notRenderedCycleTuplePosition);
            ContextMember context = notRenderedCycle.getFirstColumn().createContextMember();
            EdgeMappingUtils.setContextMember(context, member);
            notRenderedCycle.setUnbalancedTuple(pendingTuple);
        }
        if ((unbalancedTuple = targetCycle.getUnbalancedTuple()).getMember((targetColumn = (OLAPContextColumn)targetCycle.getFirstColumn()).getTuplePosition()) == null) {
            IMember[] members = unbalancedTuple.getMembers();
            members[targetColumn.getTuplePosition()] = targetColumn.createContextMember();
            unbalancedTuple = new Tuple(members);
        }
        targetCycle.setMappedTuple(unbalancedTuple);
        targetCycle.clearUnbalancedTuple();
        targetCycle.getRootRowCycle().clearUnbalancedTuple();
        targetCycle.getRootRowCycle().setstPostponedInputForHandlingPrevUnbalanced(aTuple);
    }

    private boolean doRaggedContextApply(ITuple aTuple) {
        boolean doRulesApply = true;
        if (!this.isRagged() || this.isHierarchyNormalization() || this.getRulesType() == 4 || !this.getIterator().isAncestorsQueryRequired()) {
            return doRulesApply;
        }
        IMember ancestorMember = null;
        OLAPRowCycle currAncestorRowCycle = (OLAPRowCycle)this.getParentRow().getParentRow();
        if (currAncestorRowCycle == null) {
            return false;
        }
        OLAPContextColumn currContextColumn = null;
        while (currAncestorRowCycle.getFirstColumn() != null && (currContextColumn = (OLAPContextColumn)currAncestorRowCycle.getFirstColumn()).getHierarchy().equals(this.getHierarchy())) {
            ancestorMember = currContextColumn.getCurrentMember();
            if (ancestorMember != null) {
                IMember descendant = aTuple.getMember(this.getTuplePosition());
                if (ancestorMember.getUniqueName().equals(descendant.getUniqueName())) {
                    if ((currAncestorRowCycle = (OLAPRowCycle)currAncestorRowCycle.getParentRow()) != null) continue;
                    return false;
                }
                if (!this.validateRelationship(aTuple, ancestorMember)) {
                    if (currAncestorRowCycle.isUsingHierarchize()) {
                        this.getIterator().setRetrySameTupleIn(true);
                        boolean cleanCurrentMember = true;
                        while (cleanCurrentMember) {
                            currContextColumn = (OLAPContextColumn)currAncestorRowCycle.getFirstColumn();
                            currAncestorRowCycle.stResetCycle = true;
                            currContextColumn.setCurrentMember(null);
                            currAncestorRowCycle = (OLAPRowCycle)currAncestorRowCycle.getParentRow();
                            if (currAncestorRowCycle != null && (currContextColumn = (OLAPContextColumn)currAncestorRowCycle.getFirstColumn()) != null && currContextColumn.getHierarchy().equals(this.getHierarchy()) && (ancestorMember = currContextColumn.getCurrentMember()) != null && !this.validateRelationship(aTuple, ancestorMember)) {
                                cleanCurrentMember = true;
                            }
                            cleanCurrentMember = false;
                        }
                    }
                    return false;
                }
            }
            currAncestorRowCycle = (OLAPRowCycle)currAncestorRowCycle.getParentRow();
        }
        return true;
    }

    public boolean validateRelationship(ITuple aTuple, IMember ancestor) {
        IMember descendant = aTuple.getMember(this.rules.getTuplePosition());
        IMember ancestorMember = ancestor;
        if (descendant.getLevel().getIndex() < ancestor.getLevel().getIndex()) {
            ancestorMember = descendant;
            descendant = ancestor;
        }
        Set<IMember> memberAncestry = this.getIterator().getMemberAncestry(descendant, this.getTuplePosition(), this.getIterator().getLowestProjectedLevel(this.getHierarchy()).getIndex(), 0);
        String ancestorMUN = ancestorMember.getUniqueName();
        for (IMember member : memberAncestry) {
            if (!member.getUniqueName().equals(ancestorMUN)) continue;
            return true;
        }
        return false;
    }

    public int getRulesType() {
        return this.rules.getType();
    }

    public IMember getCurrentMember() {
        return this.stCurrentMember;
    }

    public void setCurrentMember(IMember aMember) {
        this.stCurrentMember = aMember;
    }

    public boolean wasRendered() {
        return this.stRendered;
    }

    public void setRendered(boolean rendered) {
        this.stRendered = rendered;
    }

    protected IMember getPreviousMember() {
        return this.stPreviousMember;
    }

    protected void setPreviousMember(IMember aMember) {
        this.stPreviousMember = aMember;
    }

    public boolean hasMemberChanged() {
        if (this.getPreviousMember() == null && this.getCurrentMember() != null) {
            return true;
        }
        if (this.getPreviousMember() != null && this.getCurrentMember() == null) {
            return true;
        }
        if (this.getPreviousMember() == null && this.getCurrentMember() == null) {
            return false;
        }
        if (this.getPreviousMember() != null && this.getCurrentMember() != null) {
            String currentMUN = null;
            currentMUN = this.getCurrentMember().isContextMember() ? ((ContextMember)this.getCurrentMember()).getMember().getUniqueName() : this.getCurrentMember().getUniqueName();
            String previousMUN = null;
            previousMUN = this.getPreviousMember().isContextMember() ? ((ContextMember)this.getPreviousMember()).getMember().getUniqueName() : this.getPreviousMember().getUniqueName();
            if (currentMUN.equals(previousMUN)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasSingleMUN() {
        return this.rules.hasSingleMUN();
    }

    public ContextMember createContextMember() {
        if (this.getCurrentMember() == null) {
            return null;
        }
        ContextMember aContextMember = this.createContextMember1();
        this.setCurrentMember(aContextMember);
        return aContextMember;
    }

    @Override
    protected void getTabularMeasures(Set<RSAPIDataItem> tabularMeasures) {
        if (tabularMeasures == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "tabularMeasures == null");
        }
        RSAPIEdgeRowset aRowset = this.getRowset();
        RSAPIDataItem dataItem = null;
        if (aRowset != null) {
            dataItem = this.getDataItemIndex() >= 0 ? aRowset.getDataItem(this.getDataItemIndex()) : aRowset.getRefDataItem();
        }
        if (tabularMeasures.contains(dataItem)) {
            return;
        }
        if (dataItem == null) {
            return;
        }
        if (this.getRowset().isFooterRowset() || this.getRowset().isHeaderRowset()) {
            return;
        }
        if (dataItem.getUsage() == RSAPIUsage.FACT) {
            tabularMeasures.add(dataItem);
        }
    }

    @Override
    public void getDataItemIdexesForSummary(int rowsetId, List<Integer> dataItemIdexes) {
        if (dataItemIdexes == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "dataItemIdexes == null");
        }
        if (this.isHierarchyNormalization) {
            return;
        }
        if (this.getRowset() == null || this.getRowset().getRowsetId() != rowsetId) {
            return;
        }
        if (!this.getRowset().isFooterRowset() && !this.getRowset().isHeaderRowset()) {
            return;
        }
        Integer aDataItemIndex = XQEIntegerPool.getInteger(this.getDataItemIndex());
        if (dataItemIdexes.contains(aDataItemIndex)) {
            return;
        }
        dataItemIdexes.add(aDataItemIndex);
    }

    public int getTuplePosition() {
        return this.rules.getTuplePosition();
    }

    public boolean isHierarchyNormalization() {
        return this.isHierarchyNormalization;
    }

    public void setHierarchyNormalization(boolean hierarchyNormalization) {
        this.isHierarchyNormalization = hierarchyNormalization;
    }

    public boolean isQueryCalculation() {
        return this.isQueryCalculation;
    }

    public void setQueryCalculation(boolean v5QueryCalc) {
        this.isQueryCalculation = v5QueryCalc;
    }

    public boolean isCalculationCM() {
        return this.isCalculationCM;
    }

    public void setCalculationCM(boolean value) {
        this.isCalculationCM = value;
    }

    public boolean isV5CalculatedMember() {
        return this.isV5CalculatedMember;
    }

    public void setV5CalculatedMember(boolean v5Calc) {
        this.isV5CalculatedMember = v5Calc;
    }

    public boolean isReportSummary() {
        return this.isReportSummary;
    }

    public void setReportSummary(boolean reportSummary) {
        this.isReportSummary = reportSummary;
    }

    public boolean isSummaryColumn() {
        return this.getRowset() != null && (this.getRowset().isFooterRowset() || this.getRowset().isHeaderRowset());
    }

    public boolean isContext() {
        return false;
    }

    public List<Integer> flagRenderedColumns(List<Integer> ids) {
        List<Integer> pendingIds = new ArrayList<Integer>();
        pendingIds.addAll(ids);
        block0: for (Integer id : ids) {
            AbstractOLAPRow parentRow;
            if (!this.getId().equals(id)) continue;
            this.setRendered(true);
            pendingIds.remove(id);
            parentRow.setRemoved(false);
            for (parentRow = this.getParentRow(); parentRow != null; parentRow = parentRow.getParentRow()) {
                if (parentRow.isCycle()) {
                    ((OLAPRowCycle)parentRow).setEverRendered(true);
                }
                if (pendingIds.isEmpty()) continue block0;
                pendingIds = parentRow.flagRenderedColumns(pendingIds);
            }
        }
        return pendingIds;
    }

    @Override
    protected AbstractOLAPColumn findColumnById(Integer targetId) {
        if (this.getId().equals(targetId)) {
            return this;
        }
        return null;
    }

    @Override
    public AbstractOLAPEdgeElement copy(EdgeElementFactory edgeElementFactory, boolean setAbstractMDXSetProp) {
        CogMDXGroup group;
        AbstractOLAPColumn abstractOLAPColumn = (AbstractOLAPColumn)super.copy(edgeElementFactory, setAbstractMDXSetProp);
        if (setAbstractMDXSetProp && this.getCogMDXGroup() != null) {
            abstractOLAPColumn.setCogMDXGroup(this.getCogMDXGroup());
            this.getCogMDXGroup().setAbstractOLAPColumn(abstractOLAPColumn);
        }
        if (setAbstractMDXSetProp) {
            abstractOLAPColumn.setCogMDXGroupId(this.getCogMDXGroupId());
        }
        abstractOLAPColumn.setDataItemIndex(this.getDataItemIndex());
        abstractOLAPColumn.setDataItemName(this.getDataItemName());
        abstractOLAPColumn.setHierarchy(this.getHierarchy());
        abstractOLAPColumn.setContextMember(this.isContextMember());
        abstractOLAPColumn.setHierarchyNormalization(this.isHierarchyNormalization());
        abstractOLAPColumn.setQueryCalculation(this.isQueryCalculation());
        abstractOLAPColumn.setCalculationCM(this.isCalculationCM());
        abstractOLAPColumn.setV5CalculatedMember(this.isV5CalculatedMember());
        abstractOLAPColumn.setReportSummary(this.isReportSummary());
        abstractOLAPColumn.setRaggedCompensation(this.isRaggedCompensation());
        abstractOLAPColumn.setUnbalancedCompensation(this.isUnbalancedCompensation());
        abstractOLAPColumn.setRowset(this.getRowset());
        abstractOLAPColumn.setDataitemIndixesProjectingSameSet(this.getDataitemIndixesProjectingSameSet());
        this.getRules().copy(abstractOLAPColumn.getRules());
        GenerateContext generateContext = (GenerateContext)abstractOLAPColumn.getActionOfTypeForMUN(2, null);
        if (generateContext != null) {
            generateContext.setContextColumnOwner(abstractOLAPColumn);
        }
        abstractOLAPColumn.setCouldResolveToEmptySet(this.couldResolveToEmptySet());
        if (this.isV5CalculatedMember() && this.getCogMDXGroup() != null && this.getCogMDXGroup().getType() == 1027 && (group = (CogMDXGroup)this.getCogMDXGroup()).getNumberChildren() != 0 && group.getChild(0) != null) {
            List<MDXCalculatedMemberReference> calcs = ((AbstractMDXSet)group.getChild(0)).getProjectedCalculatedMembers();
            for (MDXCalculatedMemberReference calc : calcs) {
                calc.addEdgeMappingColumn(abstractOLAPColumn.getId());
            }
        }
        return abstractOLAPColumn;
    }

    @Override
    public AbstractOLAPEdgeElement exactCopy(EdgeElementFactory edgeElementFactory) {
        AbstractOLAPColumn abstractOLAPColumn = (AbstractOLAPColumn)super.exactCopy(edgeElementFactory);
        if (this.getCogMDXGroup() != null) {
            abstractOLAPColumn.setCogMDXGroup(this.getCogMDXGroup());
            this.getCogMDXGroup().setAbstractOLAPColumn(abstractOLAPColumn);
        }
        abstractOLAPColumn.setCogMDXGroupId(this.getCogMDXGroupId());
        abstractOLAPColumn.setDataItemIndex(this.getDataItemIndex());
        abstractOLAPColumn.setDataItemName(this.getDataItemName());
        abstractOLAPColumn.setHierarchy(this.getHierarchy());
        abstractOLAPColumn.setContextMember(this.isContextMember());
        abstractOLAPColumn.setHierarchyNormalization(this.isHierarchyNormalization());
        abstractOLAPColumn.setQueryCalculation(this.isQueryCalculation());
        abstractOLAPColumn.setCalculationCM(this.isCalculationCM());
        abstractOLAPColumn.setV5CalculatedMember(this.isV5CalculatedMember());
        abstractOLAPColumn.setReportSummary(this.isReportSummary());
        abstractOLAPColumn.setRaggedCompensation(this.isRaggedCompensation());
        abstractOLAPColumn.setUnbalancedCompensation(this.isUnbalancedCompensation());
        abstractOLAPColumn.setDataitemIndixesProjectingSameSet(this.getDataitemIndixesProjectingSameSet());
        abstractOLAPColumn.setRowset(this.getRowset());
        this.getRules().copy(abstractOLAPColumn.getRules());
        GenerateContext generateContext = (GenerateContext)abstractOLAPColumn.getActionOfTypeForMUN(2, null);
        if (generateContext != null) {
            generateContext.setContextColumnOwner(abstractOLAPColumn);
        }
        abstractOLAPColumn.setCouldResolveToEmptySet(this.couldResolveToEmptySet());
        return abstractOLAPColumn;
    }

    @Override
    public void updateMissingAbstractMDXSetProp(AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
        if (this.getCogMDXGroup() == null && abstractOLAPEdgeElement.isColumn()) {
            this.setAbstractMDXSetProperties(((AbstractOLAPColumn)abstractOLAPEdgeElement).getCogMDXGroup());
            this.getCogMDXGroup().setAbstractOLAPColumn(this);
            this.getCogMDXGroup().setAbstractOLAPRow(this.getParentRow());
        }
    }

    public EdgeMappingRules getRules() {
        return this.rules;
    }

    public void setRules(EdgeMappingRules aRules) {
        this.rules = aRules;
    }

    public void addRule(AbstractMDXMember abstractMDXMember) {
        if (this.rules == null) {
            this.rules = new EdgeMappingRules();
            this.rules.setOwner(this);
        }
        if (abstractMDXMember.getType() == 1013 && !((MDXCalculatedMemberReference)abstractMDXMember).isAlternateMeasureRef()) {
            MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)abstractMDXMember;
            boolean queryCalculation = calcRef.isQueryCalculation() || calcRef.isReportSummary();
            this.setQueryCalculation(queryCalculation);
            this.setV5CalculatedMember(calcRef.isV5CalculatedMember());
            this.setReportSummary(calcRef.isReportSummary());
        }
        this.rules.addMember(abstractMDXMember);
    }

    public void addRule(IHierarchy aHierarchy) {
        if (this.rules == null) {
            this.rules = new EdgeMappingRules();
            this.rules.setOwner(this);
        }
        this.rules.addHierarchy(aHierarchy);
    }

    public void addRule(IHierarchy aHierarchy, int type) {
        if (this.rules == null) {
            this.rules = new EdgeMappingRules();
            this.rules.setOwner(this);
        }
        this.addRule(aHierarchy);
        int mergedType = this.rules.mergeRuleType(type, false);
        if (mergedType != type) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mergedType != type");
        }
    }

    public void addRule(ILevel aLevel) {
        if (this.rules == null) {
            this.rules = new EdgeMappingRules();
            this.rules.setOwner(this);
        }
        this.rules.addLevel(aLevel);
    }

    public void setTuplePosition(int aTuplePosition) {
        this.rules.setTuplePosition(aTuplePosition);
    }

    public void rebuildMUNRules(OLAPRowCycle rootRowCycle, EdgeElementFactory edgeElementFactory) {
        this.rules.rebuildMUNRules(rootRowCycle, edgeElementFactory);
    }

    public void rebuildMUNRulesForPowerCubeRootAliases() {
        this.rules.rebuildMUNRulesForPowerCubeRootAliases();
    }

    public void rebuildMUNRulesForNoMember() {
        this.rules.rebuildMUNRulesForNoMember();
    }

    public void rebuildMUNRulesForReplacedRootMember(BaseMember replacedRootMember, AbstractMDXMember replacement, ActionFactory actionFactory) {
        this.rules.rebuildMUNRulesForReplacedRootMember(replacedRootMember, replacement, actionFactory);
    }

    public void cleanDeletedMemberDescriptors() {
        this.rules.cleanDeletedMemberDescriptors();
    }

    protected ContextMember createContextMember1() {
        OLAPContextColumn contexColumn;
        IMember aBaseMember = this.getCurrentMember();
        RSAPIEdgeRowset aRowset = this.getRowset();
        RSAPIDataItem[] dataItems = null;
        if (aRowset == null && this.getRulesType() == 4 && (contexColumn = (OLAPContextColumn)this.parentRow.getParentRow().getFirstColumn()) != null && (aRowset = contexColumn.getRowset()) != null) {
            dataItems = aRowset.getDataItems();
        }
        int aDataItemIndex = this.getDataItemIndex();
        boolean isSummary = false;
        if (aRowset != null) {
            boolean bl = isSummary = aRowset.isFooterRowset() || aRowset.isHeaderRowset();
        }
        if (isSummary && this.isHierarchyNormalization()) {
            isSummary = false;
        }
        boolean isQueryCalc = this.isQueryCalculation();
        boolean isV5CalcMember = this.isV5CalculatedMember();
        boolean isRepSummary = this.isReportSummary();
        if (isQueryCalc && isV5CalcMember && isRepSummary) {
            isQueryCalc = false;
        }
        if (isSummary) {
            isQueryCalc = true;
        }
        if (aBaseMember.isContextMember()) {
            if (isSummary && ((ContextMember)aBaseMember).isSummary()) {
                return (ContextMember)aBaseMember;
            }
            aBaseMember = ((ContextMember)aBaseMember).getBaseMember();
        }
        int edgeOrdinal = -1;
        if (aRowset != null) {
            edgeOrdinal = aRowset.getEdge().getPositionalOrdinal();
        }
        ContextMember aContextMember = new ContextMember();
        aContextMember.setMember(aBaseMember);
        aContextMember.setEdgeOrdinal(edgeOrdinal);
        if (isQueryCalc) {
            aContextMember.setQueryCalculation(isQueryCalc);
        }
        if (isSummary) {
            aContextMember.setSummary(isSummary);
        }
        if (aBaseMember.isCalculatedMember() && aBaseMember instanceof CalculatedMember) {
            aContextMember.setFillerMember(((CalculatedMember)aBaseMember).isFillerMember());
        }
        boolean isKnownMDXCalculation = false;
        if (this.rules.getType() != 7) {
            isKnownMDXCalculation = this.isKnownMDXCalculation(aBaseMember, null);
        }
        if (this.rules.getType() == 7 || isKnownMDXCalculation) {
            aContextMember.setCalculatedMember(true);
        }
        aContextMember.setRowset(aRowset);
        aContextMember.setDataItemIndex(aDataItemIndex);
        aContextMember.setOlapEdgeMappingColumnId(this.getId());
        if (this.dataitemIndixesProjectingSameSet != null) {
            aContextMember = this.handleDataitemIndixesProjectingSameSet(aRowset, aContextMember);
        }
        if (dataItems != null) {
            OLAPContextColumn contexColumn2 = (OLAPContextColumn)this.parentRow.getParentRow().getFirstColumn();
            ContextMember context = contexColumn2.createContextMember();
            aContextMember.copyGroupBodyMeasures(context);
        }
        return aContextMember;
    }

    public boolean isKnownMDXCalculation(IMember aBaseMember, String[] baseMemberMUN) {
        boolean isKnownCalculation;
        boolean bl = isKnownCalculation = aBaseMember.isDataBaseCalculation() || aBaseMember.isCalculatedMember();
        if (isKnownCalculation || aBaseMember.getLevel().getIndex() == 0) {
            String mun = aBaseMember.getUniqueName();
            if (baseMemberMUN != null) {
                baseMemberMUN[0] = mun;
            }
            isKnownCalculation = this.rules.isKnownCalculation(mun);
        }
        return isKnownCalculation;
    }

    private ContextMember handleDataitemIndixesProjectingSameSet(RSAPIEdgeRowset aRowset, ContextMember aContextMember) {
        if (aRowset != null) {
            aContextMember.setAdditionalDataItemIndices((List)this.dataitemIndixesProjectingSameSet.get(aRowset.getRowsetId()));
        }
        ContextBase startMember = null;
        ContextMember endMember = null;
        for (Map.Entry<Integer, List<Integer>> diEntry : this.dataitemIndixesProjectingSameSet.entrySet()) {
            RSAPIEdgeRowset currRowset = this.getRowsetOnSameEdge(diEntry.getKey());
            if (currRowset == aRowset) continue;
            ContextMember nestedContextMember = (ContextMember)aContextMember.copy();
            nestedContextMember.setRowset(currRowset);
            List<Integer> additionalDataItemIndices = diEntry.getValue();
            if (currRowset.getRefDataItem() == null) {
                nestedContextMember.setDataItemIndex(additionalDataItemIndices.get(0));
            }
            nestedContextMember.setAdditionalDataItemIndices(additionalDataItemIndices);
            if (startMember == null) {
                startMember = nestedContextMember;
            }
            if (endMember != null) {
                nestedContextMember.setContextMember(endMember);
            }
            endMember = nestedContextMember;
        }
        if (endMember != null) {
            startMember.setContextMember(aContextMember);
            aContextMember = endMember;
        }
        return aContextMember;
    }

    protected RSAPIEdgeRowset getRowsetOnSameEdge(int rowsetId) {
        RSAPIEdgeRowset aRowset = null;
        if (this.rowset != null) {
            RSAPIEdge edge = this.rowset.getEdge();
            aRowset = edge.getRowset(rowsetId);
        }
        return aRowset;
    }

    public AbstractMDXSet getCogMDXGroup() {
        return this.cogMDXGroup;
    }

    public void setCogMDXGroup(AbstractMDXSet aCogMDXGroup) {
        this.cogMDXGroup = aCogMDXGroup;
    }

    public void setAbstractMDXSetProperties(AbstractMDXSet aAbstractMDXSet) {
        this.setCogMDXGroup(aAbstractMDXSet);
        if (this.cogMDXGroup != null) {
            this.setCogMDXGroupId(aAbstractMDXSet.getId());
            this.setCouldResolveToEmptySet(this.cogMDXGroup.couldResolveToEmptySet(true, true, false));
        }
    }

    public int getCogMDXGroupId() {
        return this.cogMDXGroupId;
    }

    public void setCogMDXGroupId(int aCogMDXGroupId) {
        this.cogMDXGroupId = aCogMDXGroupId;
    }

    public int getNumOfCalculations() {
        if (this.getRules().getCalculatedMemberList() == null) {
            return 0;
        }
        return this.getRules().getCalculatedMemberList().size();
    }

    public boolean isContextMember() {
        return this.isContextMember;
    }

    public void setContextMember(boolean value) {
        this.isContextMember = value;
    }

    public boolean isRaggedCompensation() {
        return this.isRaggedCompensation;
    }

    public void setRaggedCompensation(boolean value) {
        this.isRaggedCompensation = value;
    }

    public boolean isUnbalancedCompensation() {
        return this.isUnbalancedCompensation;
    }

    public void setUnbalancedCompensation(boolean value) {
        this.isUnbalancedCompensation = value;
    }

    public int getMeasuresFinalTuplePosition() {
        if (!this.getHierarchy().getDimension().isMeasuresDimension()) {
            return -1;
        }
        if (this.doesActionTypeApplies(7) || this.doesActionTypeApplies(10)) {
            return -1;
        }
        for (IEdgeElementMappingAction action : this.actions) {
            if (action.getType() != 6) continue;
            return ((RelocateNestedLevelCalculation)action).getTo();
        }
        return this.getTuplePosition();
    }

    public void rebuildMUNForRename(String oldMUN, String newMUN) {
        for (IEdgeElementMappingAction action : this.actions) {
            if (action.getTargetUniqueName() == null || !action.getTargetUniqueName().equals(oldMUN)) continue;
            if (action.getType() == 8) {
                ((RenameV5)action).setTargetUniqueName(newMUN);
            }
            if (action.getType() != 9) continue;
            ((RenameMUN)action).setTargetUniqueName(newMUN);
        }
    }

    public boolean isMUNTypeAndAllRulesHaveBeenApplied() {
        return this.getRules().isMUNTypeAndAllRulesHaveBeenApplied();
    }

    public SortedMap<Integer, List<Integer>> getDataitemIndixesProjectingSameSet() {
        return this.dataitemIndixesProjectingSameSet;
    }

    public void setDataitemIndixesProjectingSameSet(SortedMap<Integer, List<Integer>> aDataitemIndixMap) {
        this.dataitemIndixesProjectingSameSet = aDataitemIndixMap;
    }

    public void resetNextMemberListIndex() {
        this.rules.resetNextMemberListIndex();
        GenerateContext generateContext = (GenerateContext)this.getActionOfTypeForMUN(2, null);
        if (generateContext != null) {
            generateContext.resetNextMemberListIndex();
        }
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        if (this.getRowset() != null) {
            propertiesMap.put("rowsetId", XQEIntegerPool.getInteger(this.rowset.getRowsetId()).toString());
            propertiesMap.put("rowsetName", this.rowset.getName());
        }
        if (this.getDataItemIndex() != -1) {
            propertiesMap.put("dataItemIndex", XQEIntegerPool.getInteger(this.dataItemIndex).toString());
        }
        if (this.getDataitemIndixesProjectingSameSet() != null && !this.getDataitemIndixesProjectingSameSet().isEmpty()) {
            propertiesMap.put("dataitemIndixesProjectingSameSet", this.getDataitemIndixesProjectingSameSet().toString());
        }
        if (this.dataItemName != null) {
            propertiesMap.put("dataItemName", this.dataItemName);
        }
        if (this.getHierarchy() != null) {
            propertiesMap.put("hierarchy", this.hierarchy.getV5UniqueName());
            if (this.isRagged()) {
                propertiesMap.put("ragged", Boolean.TRUE.toString());
            }
            if (this.isUnbalanced()) {
                propertiesMap.put("unbalanced", Boolean.TRUE.toString());
            }
        }
        if (this.isHierarchyNormalization()) {
            propertiesMap.put("isHierarchyNormalization", Boolean.TRUE.toString());
        }
        if (this.isQueryCalculation()) {
            propertiesMap.put("isQueryCalculation", Boolean.TRUE.toString());
        }
        if (this.isCalculationCM()) {
            propertiesMap.put("isCalculationCM", Boolean.TRUE.toString());
        }
        if (this.isV5CalculatedMember()) {
            propertiesMap.put("isV5CalculatedMember", Boolean.TRUE.toString());
        }
        if (this.isReportSummary()) {
            propertiesMap.put("isReportSummary", Boolean.TRUE.toString());
        }
        if (this.isContextMember()) {
            propertiesMap.put("isContextMember", Boolean.TRUE.toString());
        }
        if (this.isRaggedCompensation()) {
            propertiesMap.put("isRaggedCompensation", Boolean.TRUE.toString());
        }
        if (this.isUnbalancedCompensation()) {
            propertiesMap.put("isUnbalancedCompensation", Boolean.TRUE.toString());
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            propertiesMap.put("rules", this.rules.getCheckSumPropertiesMap().toString());
        }
        return propertiesMap;
    }

    public boolean couldResolveToEmptySet() {
        return this.couldResolveToEmptySet;
    }

    public void setCouldResolveToEmptySet(boolean value) {
        this.couldResolveToEmptySet = value;
    }
}

