/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CopyContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.InsertCrosstabSpacer;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OLAPRow
extends AbstractOLAPRow {
    private static final int INVALID_ROWSET_ID = -9;
    protected ITuple stLastAcceptedTuple = null;

    @Override
    public boolean map(ITuple aTuple) {
        this.resetMapping();
        if (this.isFillerTagRow() != 1 && aTuple.getMembers().length > this.getFirstColumn().getTuplePosition() + 1 && CalcMemberReferencePrefixes.isFillerTag(aTuple.getMember(this.getFirstColumn().getTuplePosition() + 1))) {
            this.setDone(true);
            return false;
        }
        boolean isDone = true;
        IMember[] previousMembers = new IMember[this.getNumberOfColumns()];
        IMember[] currentMembers = new IMember[this.getNumberOfColumns()];
        int index = -1;
        for (AbstractOLAPColumn column : this.columns) {
            previousMembers[++index] = column.getPreviousMember();
            currentMembers[index] = column.getCurrentMember();
            if (!column.map(aTuple)) {
                this.setDone(true);
                if (column != this.getFirstColumn()) {
                    for (int i = index; i > -1; --i) {
                        this.getColumn(i).setPreviousMember(previousMembers[i]);
                        this.getColumn(i).setCurrentMember(currentMembers[i]);
                    }
                }
                return false;
            }
            AbstractOLAPRow siblingRow = null;
            if (column.isDone() && this.columns.get(this.columns.size() - 1) == column) {
                siblingRow = ((OLAPRowCycle)this.getParentRow()).getNextSiblingRow(this);
                boolean foundNoCycleSibling = siblingRow != null && !siblingRow.isCycle();
                boolean singleMeasureMultipleTimesInEdgePath = false;
                if (foundNoCycleSibling) {
                    singleMeasureMultipleTimesInEdgePath = this.isSingleMeasureMultipleTimesInEdgePath(siblingRow);
                }
                if (!singleMeasureMultipleTimesInEdgePath) {
                    siblingRow = ((OLAPRowCycle)this.getParentRow()).getPreviousSiblingRow(this);
                    boolean bl = foundNoCycleSibling = siblingRow != null && !siblingRow.isCycle();
                    if (foundNoCycleSibling) {
                        singleMeasureMultipleTimesInEdgePath = this.isSingleMeasureMultipleTimesInEdgePath(siblingRow);
                    }
                }
                if (singleMeasureMultipleTimesInEdgePath) {
                    isDone = true;
                } else if (this.getFirstColumn() != column && column.doesActionTypeApplies(6)) {
                    AbstractOLAPColumn previousColumn = this.getColumn(this.getColumnIndex(column) - 1);
                    if (previousColumn.getRules().getType() == 4 && previousColumn.doesActionTypeApplies(12)) {
                        isDone = true;
                    } else {
                        siblingRow = null;
                    }
                } else {
                    siblingRow = null;
                }
            }
            if (siblingRow == null) {
                boolean bl = isDone = isDone && column.isDone();
            }
            if (!column.hasMemberChanged()) continue;
            int currIndex = this.indexOf(column);
            for (int i = currIndex + 1; i < this.getNumberOfColumns(); ++i) {
                this.getColumn(i).reset();
            }
        }
        this.setLastAcceptedTuple(aTuple);
        if (this.isTag()) {
            this.setDone(true);
            this.applyRowActions(3, 4);
            return true;
        }
        if (this.isHierarchyNormalization()) {
            this.setDone(isDone);
            if (this.doesActionTypeApplies(7)) {
                this.setRemoved(true);
            }
            return true;
        }
        this.createMappedTuple(aTuple);
        this.setDone(isDone);
        return true;
    }

    public int getColumnIndex(AbstractOLAPColumn column) {
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            if (this.getColumn(i) != column) continue;
            return i;
        }
        return -1;
    }

    private boolean isSingleMeasureMultipleTimesInEdgePath(AbstractOLAPRow siblingRow) {
        boolean singleMeasureMultipleTimesInEdgePath = false;
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            if (i >= siblingRow.getNumberOfColumns()) continue;
            AbstractOLAPColumn columnOfThis = this.getColumn(i);
            AbstractOLAPColumn columnOfSibling = siblingRow.getColumn(i);
            if (columnOfThis.getCogMDXGroupId() != columnOfSibling.getCogMDXGroupId()) break;
            if (!columnOfThis.getHierarchy().getDimension().isMeasuresDimension() || i != this.getNumberOfColumns() - 1 || !columnOfThis.getRules().overlaps(columnOfSibling.getRules())) continue;
            singleMeasureMultipleTimesInEdgePath = true;
        }
        return singleMeasureMultipleTimesInEdgePath;
    }

    public void createMappedTuple(ITuple aTuple) {
        List<Integer> actionResults;
        boolean projectsMeasures;
        IMember[] mappedMembers = null;
        int numOfMembers = aTuple.getMembers().length;
        AbstractOLAPColumn lastColumn = this.getColumn(this.getNumberOfColumns() - 1);
        int lastTuplePosition = lastColumn.getTuplePosition();
        MDXHierInfo mdxHierInfo = this.getIterator().getXParent().getEdgeLevelInfo().getHierarchyInfo();
        int numProjHier = mdxHierInfo.getNumProjectedHierarchies();
        boolean bl = projectsMeasures = numProjHier != mdxHierInfo.getNumberOfNonMeasureHierarchiesProjected();
        if (numOfMembers > lastTuplePosition + 1 && numOfMembers == numProjHier && lastColumn.isReportSummary() && !projectsMeasures) {
            numOfMembers = lastTuplePosition + 1;
        }
        mappedMembers = new IMember[numOfMembers];
        for (AbstractOLAPColumn currColumn : this.columns) {
            OLAPContextColumn contextColumn;
            OLAPRowCycle contextCycle;
            RelocateNestedLevelCalculation rnlcAction = (RelocateNestedLevelCalculation)currColumn.getActionOfTypeForMUN(6, null);
            boolean rnlcActionApplies = false;
            if (rnlcAction != null) {
                rnlcActionApplies = true;
                rnlcAction.setApplied(false);
            }
            if (currColumn.getTuplePosition() == numOfMembers) break;
            if (currColumn.getRulesType() == 4 && currColumn.isContextMember()) continue;
            ContextMember aContextMember = currColumn.createContextMember();
            if (currColumn.getRulesType() == 4 && currColumn.isHierarchyNormalization() && currColumn.getParentRow().getParentRow() != null && currColumn.getParentRow().getParentRow().getFirstColumn() != null && (contextCycle = (OLAPRowCycle)currColumn.getParentRow().getParentRow()).doesActionTypeApplies(13) && (contextColumn = (OLAPContextColumn)currColumn.getParentRow().getParentRow().getFirstColumn()).getCurrentMember().isContextMember()) {
                aContextMember = (ContextMember)contextColumn.getCurrentMember().copy();
                currColumn.setCurrentMember(aContextMember);
            }
            aContextMember = EdgeMappingUtils.applyRenamingActions(currColumn, aContextMember);
            CopyContext copyContext = (CopyContext)currColumn.getActionOfTypeForMUN(12, null);
            if (copyContext != null) {
                ContextMember contextToSet = copyContext.getContextMember();
                if (rnlcActionApplies) {
                    int indexOfCurrColumn = this.columns.indexOf(currColumn);
                    boolean foundIt = false;
                    for (int i = indexOfCurrColumn - 1; i > -1; --i) {
                        AbstractOLAPColumn previousColumn = (AbstractOLAPColumn)this.columns.get(i);
                        if (previousColumn.getRulesType() != 4) continue;
                        previousColumn.setCurrentMember(contextToSet);
                        foundIt = true;
                        break;
                    }
                    if (!foundIt) {
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!EdgeMappingRules.CM_TYPE");
                    }
                } else {
                    aContextMember.setContextMember(contextToSet);
                }
            }
            lastTuplePosition = currColumn.getTuplePosition();
            mappedMembers[lastTuplePosition] = aContextMember;
        }
        if (this.columns.size() < numOfMembers) {
            int edgeOrdinal = this.getIterator().getXParent().getEdgeOrdinal();
            for (int i = lastTuplePosition + 1; i < numOfMembers; ++i) {
                ContextMember aContextMember = new ContextMember();
                aContextMember.setMember(this.getLastAcceptedTuple().getMember(i));
                aContextMember.setEdgeOrdinal(edgeOrdinal);
                mappedMembers[i] = aContextMember;
            }
        }
        if (!(actionResults = this.applyRowActions(3, 4)).contains(7) && !actionResults.contains(4)) {
            this.setMappedTuple(new Tuple(mappedMembers));
            this.applyCrosstabSpacer();
            if (this.getParentRow() == this.getRootRowCycle()) {
                this.applyRowActions(5, 5);
            }
            this.setLinkedRowRendered();
        } else {
            if (actionResults.contains(4)) {
                for (AbstractOLAPRow suppressedRow = this; suppressedRow != null; suppressedRow = suppressedRow.getParentRow()) {
                    suppressedRow.setSuppressed(true);
                }
            }
            if (actionResults.contains(7)) {
                this.setRemoved(true);
            }
        }
    }

    private void applyCrosstabSpacer() {
        AbstractOLAPColumn secondColumn;
        GenerateContext generateContext;
        RSAPIEdgeRowset rowset = null;
        this.getIterator().setPendingSpacerParent(null);
        InsertCrosstabSpacer insertCrosstabSpacerAtRoot = (InsertCrosstabSpacer)this.getRootRowCycle().getActionOfTypeForMUN(13, null);
        if (insertCrosstabSpacerAtRoot != null) {
            AbstractOLAPRow spacerNeighbor = this;
            while (spacerNeighbor.getFirstColumn() != null) {
                CrosstabSpacerDescriptor descriptor;
                AbstractOLAPColumn neighborColumn = spacerNeighbor.getFirstColumn();
                GenerateContext generateContext2 = (GenerateContext)neighborColumn.getActionOfTypeForMUN(2, null);
                if (generateContext2 != null) {
                    neighborColumn = generateContext2.getContextColumn(generateContext2.getNumberOfContextColumns() - 1);
                }
                if ((rowset = neighborColumn.getRowset()) != null && (descriptor = insertCrosstabSpacerAtRoot.findSpacerForRSAPIRowset(rowset, false)) != null) {
                    this.getIterator().setSpacerParent(this.getRootRowCycle());
                    break;
                }
                if (spacerNeighbor.getParentRow() == this.getRootRowCycle()) break;
                spacerNeighbor = spacerNeighbor.getParentRow();
            }
        }
        InsertCrosstabSpacer insertCrosstabSpacer = (InsertCrosstabSpacer)this.getParentRow().getActionOfTypeForMUN(13, null);
        AbstractOLAPRow spacerParent = null;
        if (insertCrosstabSpacer == null) {
            insertCrosstabSpacer = (InsertCrosstabSpacer)this.getActionOfTypeForMUN(13, null);
            if (insertCrosstabSpacer != null) {
                if (insertCrosstabSpacer.getSpacerList().get(0).getPosition() == 4) {
                    spacerParent = this;
                    rowset = this.getFirstRowset();
                } else {
                    spacerParent = this;
                    rowset = spacerParent.getLastRowset();
                }
            }
        } else {
            spacerParent = this.getParentRow();
            rowset = this.getFirstRowset();
        }
        if (insertCrosstabSpacer == null) {
            boolean isValueNonDetailGroupBody = false;
            int rowsetId = -9;
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                AbstractOLAPColumn currColumn = this.getColumn(i);
                if (i != 0 || !currColumn.isContextMember() || currColumn.getRowset() == null) {
                    if (i == 0 || currColumn.getRowset() == null || rowsetId != currColumn.getRowset().getRowsetId()) break;
                    isValueNonDetailGroupBody = true;
                    break;
                }
                rowsetId = currColumn.getRowset().getRowsetId();
                rowset = currColumn.getRowset();
            }
            if (isValueNonDetailGroupBody && this.getParentRow().getParentRow() != null && (insertCrosstabSpacer = (InsertCrosstabSpacer)this.getParentRow().getParentRow().getActionOfTypeForMUN(13, null)) != null) {
                List<CrosstabSpacerDescriptor> descriptors = insertCrosstabSpacer.getSpacerList();
                for (CrosstabSpacerDescriptor descriptor : descriptors) {
                    if (!descriptor.applies(rowset, false)) continue;
                    spacerParent = this.getParentRow().getParentRow();
                    break;
                }
                if (spacerParent == null) {
                    insertCrosstabSpacer = null;
                    rowset = null;
                }
            }
        }
        if (insertCrosstabSpacer == null) {
            return;
        }
        CrosstabSpacerDescriptor spacerDescriptor = insertCrosstabSpacer.findSpacerForRSAPIRowset(rowset, false);
        AbstractOLAPColumn columnProvidingContextToSpacer = OLAPRow.getColumnProvidingContextToSpacer(spacerParent, spacerDescriptor);
        OLAPContextColumn contextColumn = null;
        if (spacerParent == this.getParentRow() && this.getNumberOfColumns() > 1 && (generateContext = (GenerateContext)(secondColumn = this.getColumn(1)).getActionOfTypeForMUN(2, null)) != null) {
            contextColumn = generateContext.getContextColumn(generateContext.getNumberOfContextColumns() - 1);
            columnProvidingContextToSpacer = contextColumn;
            rowset = contextColumn.getRowset();
            spacerDescriptor = insertCrosstabSpacer.findSpacerForRSAPIRowset(rowset, false);
        }
        if (columnProvidingContextToSpacer != null && insertCrosstabSpacer.getSpacerMember() != null && !columnProvidingContextToSpacer.getCurrentMember().getUniqueName().equals(insertCrosstabSpacer.getSpacerMember().getUniqueName())) {
            insertCrosstabSpacer.resetCrosstabSpacerDescriptors();
            spacerDescriptor = insertCrosstabSpacer.findSpacerForRSAPIRowset(rowset, false);
        }
        if (spacerDescriptor != null) {
            if (this.getIterator().getSpacerParent() == null) {
                this.getIterator().setSpacerParent(spacerParent);
            } else if (insertCrosstabSpacerAtRoot != null) {
                List<CrosstabSpacerDescriptor> rootSpacerList = insertCrosstabSpacerAtRoot.getSpacerList();
                List<CrosstabSpacerDescriptor> spacerList = insertCrosstabSpacer.getSpacerList();
                boolean isNested = false;
                for (CrosstabSpacerDescriptor rootSpacer : rootSpacerList) {
                    for (CrosstabSpacerDescriptor spacer : spacerList) {
                        RSAPIEdgeRowset spacerRowset;
                        RSAPIEdgeRowset rootSpacerRowset = rootSpacer.getRSAPIEdgeRowset();
                        isNested = this.areRowsetsNested(rootSpacerRowset, spacerRowset = spacer.getRSAPIEdgeRowset());
                        if (!isNested) continue;
                        break;
                    }
                    if (!isNested) continue;
                    break;
                }
                if (!isNested) {
                    boolean rootGoesFirst = false;
                    for (CrosstabSpacerDescriptor rootSpacer : rootSpacerList) {
                        for (CrosstabSpacerDescriptor spacer : spacerList) {
                            RSAPIEdgeRowset rootSpacerRowset = rootSpacer.getRSAPIEdgeRowset();
                            RSAPIEdgeRowset spacerRowset = spacer.getRSAPIEdgeRowset();
                            for (RSAPIEdgeRowset rootSapcerSiblingRowset = rootSpacerRowset.getSiblingRowset(); rootSapcerSiblingRowset != null && !(rootGoesFirst = this.areRowsetsNested(rootSapcerSiblingRowset, spacerRowset)); rootSapcerSiblingRowset = rootSapcerSiblingRowset.getSiblingRowset()) {
                            }
                            if (!rootGoesFirst) continue;
                            break;
                        }
                        if (!rootGoesFirst) continue;
                        break;
                    }
                    if (!rootGoesFirst) {
                        this.getIterator().setSpacerParent(spacerParent);
                        this.getIterator().setPendingSpacerParent(this.getRootRowCycle());
                    } else {
                        this.getIterator().setPendingSpacerParent(spacerParent);
                    }
                }
            }
            if (columnProvidingContextToSpacer != null) {
                insertCrosstabSpacer.setSpacerMember(columnProvidingContextToSpacer.getCurrentMember());
            }
            if (contextColumn != null) {
                insertCrosstabSpacer.setMatchedByAGeneratedContextMember(true);
            }
        }
    }

    public static AbstractOLAPColumn getColumnProvidingContextToSpacer(AbstractOLAPRow spacerParent, CrosstabSpacerDescriptor spacerDescriptor) {
        RSAPIEdgeRowset columnRowset;
        OLAPColumn column;
        int i;
        if (spacerParent.isCycle()) {
            return spacerParent.getFirstColumn();
        }
        if (spacerDescriptor != null) {
            RSAPIEdgeRowset spacerRowset = spacerDescriptor.getRSAPIEdgeRowset();
            for (i = 0; i < spacerParent.getNumberOfColumns(); ++i) {
                column = (OLAPColumn)spacerParent.getColumn(i);
                columnRowset = column.getRowset();
                if (columnRowset == null || !columnRowset.getRefDataItem().getName().equals(spacerRowset.getRefDataItem().getName())) continue;
                return column;
            }
        }
        boolean lastRowsetFound = false;
        for (i = spacerParent.getNumberOfColumns() - 1; i > -1; --i) {
            column = (OLAPColumn)spacerParent.getColumn(i);
            columnRowset = column.getRowset();
            if (columnRowset == null) continue;
            if (lastRowsetFound) {
                return column;
            }
            lastRowsetFound = true;
        }
        return null;
    }

    private boolean areRowsetsNested(RSAPIEdgeRowset parentRowset, RSAPIEdgeRowset childRowset) {
        RSAPIEdgeRowset currRowset = parentRowset;
        while (currRowset != null) {
            if (currRowset == childRowset) {
                return true;
            }
            RSAPIEdgeRowset currRowsetCopy = currRowset;
            for (currRowset = currRowset.getSiblingRowset(); currRowset != null; currRowset = currRowset.getSiblingRowset()) {
                if (currRowset != childRowset) continue;
                return true;
            }
            currRowset = currRowsetCopy.getNestedRowset();
        }
        return false;
    }

    public ITuple removeTupleMembers(ITuple mappedTuple) {
        int position;
        if (mappedTuple == null) {
            IMessageKey.Param1 msgKey = XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL;
            throw new OLAPEdgeMappingException(msgKey, "this.getMappedTuple() == null");
        }
        IMember[] tupleMembers = mappedTuple.getMembers();
        ArrayList<Integer> positionsToRemove = new ArrayList<Integer>();
        for (AbstractOLAPColumn currColumn : this.columns) {
            if (!currColumn.doesActionTypeApplies(7)) continue;
            boolean isRealocateNLC = false;
            for (position = 0; position < tupleMembers.length; ++position) {
                Integer mappingColumnId;
                ContextMember tupleMember = (ContextMember)tupleMembers[position];
                if (tupleMember == null || !(mappingColumnId = XQEIntegerPool.getInteger(tupleMember.getOlapEdgeMappingColumnId())).equals(currColumn.getId())) continue;
                if (!isRealocateNLC && currColumn.doesActionTypeApplies(6)) {
                    isRealocateNLC = true;
                    continue;
                }
                isRealocateNLC = false;
                positionsToRemove.add(XQEIntegerPool.getInteger(position));
            }
        }
        if (!positionsToRemove.isEmpty()) {
            int newMemberCount = tupleMembers.length - positionsToRemove.size();
            IMember[] newTupleMembers = new IMember[newMemberCount];
            int newPosition = 0;
            for (position = 0; position < tupleMembers.length; ++position) {
                Integer pos = XQEIntegerPool.getInteger(position);
                boolean copy = true;
                for (Integer positionToRemove : positionsToRemove) {
                    if (!pos.equals(positionToRemove)) continue;
                    copy = false;
                    break;
                }
                if (!copy) continue;
                newTupleMembers[newPosition++] = tupleMembers[position];
            }
            Tuple newMappedTuple = new Tuple(newTupleMembers);
            return newMappedTuple;
        }
        return mappedTuple;
    }

    protected boolean isHierarchyNormalization() {
        AbstractOLAPColumn currColumn;
        boolean isHierNormalization = true;
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext() && ((currColumn = (AbstractOLAPColumn)iterator.next()).isContextMember() && !currColumn.isUnbalancedCompensation() || (isHierNormalization = currColumn.isHierarchyNormalization()))) {
        }
        return isHierNormalization;
    }

    public boolean setHierarchyNomalizationFlag() {
        boolean value = this.isHierarchyNormalization();
        for (OLAPRowCycle parentRow = (OLAPRowCycle)this.getParentRow(); parentRow != null; parentRow = (OLAPRowCycle)parentRow.getParentRow()) {
            if (parentRow.getParentRow() == null) continue;
            parentRow.setCurrentRowIsForHierNormalization(value);
        }
        return value;
    }

    public boolean isDetailRow() {
        for (AbstractOLAPColumn currColumn : this.columns) {
            if (currColumn.getDataItemIndex() != -1 && !((ContextMember)currColumn.getCurrentMember()).isSummary()) continue;
            return false;
        }
        return true;
    }

    public boolean containsMeasureDetailColumn() {
        AbstractOLAPColumn lastColumn = (AbstractOLAPColumn)this.columns.get(this.columns.size() - 1);
        return lastColumn.getHierarchy().getDimension().isMeasuresDimension() && lastColumn.getDataItemIndex() != -1;
    }

    public ITuple getLastAcceptedTuple() {
        return this.stLastAcceptedTuple;
    }

    public void setLastAcceptedTuple(ITuple aTuple) {
        this.stLastAcceptedTuple = aTuple;
    }

    @Override
    public void dumpExtraAttibutes(XQETrace trace) {
        super.dumpExtraAttibutes(trace);
        if (this.getLastAcceptedTuple() != null) {
            trace.attribute("lastAcceptedTuple", EdgeMappingUtils.tupleToString(this.getLastAcceptedTuple()));
        }
    }

    @Override
    protected void resetMapping() {
        super.resetMapping();
        this.setLastAcceptedTuple(null);
        for (IEdgeElementMappingAction action : this.actions) {
            action.reset();
        }
    }

    @Override
    public int getMeasuresFinalTuplePosition() {
        int measureColumnIndex = -1;
        for (AbstractOLAPColumn currColumn : this.columns) {
            ++measureColumnIndex;
            int measureTuplePosition = currColumn.getMeasuresFinalTuplePosition();
            if (measureTuplePosition == -1) continue;
            for (int prevColumnIndex = measureColumnIndex - 1; prevColumnIndex > -1; --prevColumnIndex) {
                AbstractOLAPColumn prevColumn = (AbstractOLAPColumn)this.columns.get(prevColumnIndex);
                if (!prevColumn.doesActionTypeApplies(7) || --measureTuplePosition != -1) continue;
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "measureTuplePosition == XOLAPEdgeMapping.UNKNOWN_INT_VALUE");
            }
            return measureTuplePosition;
        }
        return -1;
    }

    public void mapUnbalancedTuple(int numOfMembers) {
        IMember[] mappedMembers = null;
        mappedMembers = new IMember[numOfMembers];
        for (AbstractOLAPColumn currColumn : this.columns) {
            ContextMember aContextMember = currColumn.createContextMember();
            aContextMember = EdgeMappingUtils.applyRenamingActions(currColumn, aContextMember);
            mappedMembers[currColumn.getTuplePosition()] = aContextMember;
        }
        ITuple mappedTuple = new Tuple(mappedMembers);
        mappedTuple = this.removeTupleMembers(mappedTuple);
        ((OLAPRowCycle)this.getParentRow()).setUnbalancedTuple(mappedTuple);
    }
}

