/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class GenerateContext
extends AbstractAction {
    private static final String ELEMENT_CONTEXT_COLUMNS = "contextColumns";
    private List<AbstractOLAPColumn> contextColumns = new ArrayList<AbstractOLAPColumn>();

    @Override
    public String getName() {
        return "GenerateContext";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
        this.contextColumns.addAll(AbstractOLAPRow.captureColumns(env, inputAction, edgeOrdinal));
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            contextColumn.dump(trace);
        }
        trace.endElement();
    }

    @Override
    public void validate() {
        if (this.contextColumns.isEmpty()) {
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 4;
    }

    public ContextMember createContextMember(ContextMember aContextMember) {
        this.validate();
        AbstractOLAPColumn columnOwnerOfThis = (AbstractOLAPColumn)this.owner;
        Set<IMember> memberAncestry = columnOwnerOfThis.getIterator().getMemberAncestry(aContextMember, columnOwnerOfThis.getTuplePosition(), columnOwnerOfThis.getIterator().getLowestProjectedLevel(columnOwnerOfThis.getHierarchy()).getIndex(), 1);
        Object topContextMember = null;
        ArrayList<AbstractOLAPColumn> cmTypeContextColumns = null;
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            boolean contextNotFound = true;
            EdgeMappingRules contextRules = contextColumn.getRules();
            if (contextRules.getType() == 4) {
                cmTypeContextColumns = new ArrayList<AbstractOLAPColumn>();
                cmTypeContextColumns.add(contextColumn);
                continue;
            }
            if (contextRules.applies(false, columnOwnerOfThis.getCurrentMember())) {
                contextRules.applies(true, columnOwnerOfThis.getCurrentMember());
                contextColumn.setCurrentMember(aContextMember.getBaseMember());
                ContextMember ancestorContextMember = contextColumn.createContextMember();
                if (topContextMember == null) {
                    topContextMember = aContextMember;
                }
                ((ContextBase)topContextMember).setContextMember(ancestorContextMember);
                topContextMember = ancestorContextMember;
                contextNotFound = false;
                continue;
            }
            for (IMember ancestorMember : memberAncestry) {
                if (!contextRules.applies(true, ancestorMember)) continue;
                if (cmTypeContextColumns != null && !cmTypeContextColumns.isEmpty()) {
                    for (AbstractOLAPColumn cmTypeContextColumn : cmTypeContextColumns) {
                        topContextMember = this.setCurrentMemberAndCreateContextMember(aContextMember, (ContextMember)topContextMember, cmTypeContextColumn, ancestorMember);
                    }
                    cmTypeContextColumns.clear();
                    cmTypeContextColumns = null;
                }
                topContextMember = this.setCurrentMemberAndCreateContextMember(aContextMember, (ContextMember)topContextMember, contextColumn, ancestorMember);
                contextNotFound = false;
            }
            if (contextNotFound && topContextMember != null) {
                for (ContextMember ctxMember = aContextMember.getContextMember(); ctxMember != null; ctxMember = ctxMember.getContextMember()) {
                    if (!ctxMember.equals(topContextMember)) continue;
                    contextNotFound = false;
                    break;
                }
            }
            if (contextNotFound && columnOwnerOfThis.getRulesType() == 2 && contextRules.getType() == 2 && columnOwnerOfThis.isQueryCalculation() && contextColumn.isQueryCalculation()) {
                if (!(aContextMember.getBaseMember() instanceof CalculatedMember)) {
                    throw new IllegalStateException("!aContextMember.getBaseMember().isCalculatedMember()");
                }
                CalculatedMember calculatedMember = (CalculatedMember)aContextMember.getBaseMember();
                Member newMember = EdgeMappingUtils.replicateBaseMember(calculatedMember);
                String contextMUN = contextColumn.getRules().getMemberDescriptorList().get(0).getMUN();
                String[] parts = UniqueNameParser.parseNoThrow(contextMUN);
                newMember.setName(parts[parts.length - 1]);
                newMember.setUniqueName(contextMUN);
                contextColumn.setCurrentMember(newMember);
                ContextMember ancestorContextMember = contextColumn.createContextMember();
                if (topContextMember == null) {
                    topContextMember = aContextMember;
                }
                ((ContextBase)topContextMember).setContextMember(ancestorContextMember);
                topContextMember = ancestorContextMember;
                contextNotFound = false;
                continue;
            }
            if (!contextNotFound) continue;
            return null;
        }
        return aContextMember;
    }

    private ContextMember setCurrentMemberAndCreateContextMember(ContextMember aContextMember, ContextMember topContextMember, AbstractOLAPColumn contextColumn, IMember ancestorMember) {
        contextColumn.setCurrentMember(ancestorMember);
        ContextMember ancestorContextMember = contextColumn.createContextMember();
        if (topContextMember == null) {
            topContextMember = aContextMember;
        }
        while (topContextMember.getContextMember() != null) {
            topContextMember = topContextMember.getContextMember();
        }
        topContextMember.setContextMember(ancestorContextMember);
        topContextMember = ancestorContextMember;
        return topContextMember;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        GenerateContext newAction = (GenerateContext)super.copy(edgeElementFactory);
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            newAction.addContextColumn((OLAPContextColumn)((OLAPContextColumn)contextColumn).copy(edgeElementFactory, false));
        }
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        GenerateContext newAction = (GenerateContext)super.copy(edgeElementFactory);
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            newAction.addContextColumn((OLAPContextColumn)((OLAPContextColumn)contextColumn).exactCopy(edgeElementFactory));
        }
        return newAction;
    }

    public void addContextColumn(OLAPContextColumn contextColumn) {
        if (contextColumn == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "contextColumn == null");
        }
        this.contextColumns.add(contextColumn);
    }

    public OLAPContextColumn findApplicableContextColumn(IMember member) {
        OLAPContextColumn applicableContextColumn = null;
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            if (!contextColumn.getRules().applies(false, member)) continue;
            return (OLAPContextColumn)contextColumn;
        }
        return applicableContextColumn;
    }

    public void resetNextMemberListIndex() {
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            contextColumn.resetNextMemberListIndex();
        }
    }

    @Override
    public void reset() {
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            contextColumn.reset();
        }
    }

    public void setIterator(XOLAPEdgeMapping.OLAPEdgeMappingIterator anIterator) {
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            contextColumn.setIterator(anIterator);
        }
    }

    public void setContextColumnOwner(AbstractOLAPColumn owner) {
        for (AbstractOLAPColumn contextColumn : this.contextColumns) {
            ((OLAPContextColumn)contextColumn).setOwner(owner);
        }
    }

    public int getNumberOfContextColumns() {
        return this.contextColumns.size();
    }

    public OLAPContextColumn getContextColumn(int index) {
        return (OLAPContextColumn)this.contextColumns.get(index);
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.contextColumns != null) {
            ctx.elementProperty(ELEMENT_CONTEXT_COLUMNS, this.contextColumns);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_CONTEXT_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.contextColumns = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

