/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class LockContextColumn
extends AbstractAction {
    private static final String ATTRIBUTE_TARGET_ID = "targetId";
    private static final String ATTRIBUTE_TARGET_CLASS_NAME = "targetClassName";
    private Integer targetId = XQEIntegerPool.getInteger(-1);
    private String targetClassName = null;

    @Override
    public String getName() {
        return "LockContextColumn";
    }

    @Override
    public int getType() {
        return 5;
    }

    public Integer getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Integer aTargetId) {
        this.targetId = aTargetId;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetClassName(String aTargetClassName) {
        this.targetClassName = aTargetClassName;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
        Attribute attribute = inputAction.attribute("of");
        String attributeOf = attribute.getStringValue();
        int beginIndex = 0;
        int endIndex = attributeOf.indexOf("(");
        this.setTargetClassName(attributeOf.substring(beginIndex, endIndex));
        beginIndex = attributeOf.indexOf("=") + 1;
        endIndex = attributeOf.indexOf(")");
        Integer aTargetId = new Integer(attributeOf.substring(beginIndex, endIndex));
        this.setTargetId(aTargetId);
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        StringBuilder buffer = EdgeMappingUtils.createNodeIdString(this.getTargetClassName(), this.targetId);
        trace.attribute("of", buffer.toString());
        trace.endElement();
    }

    @Override
    public void validate() {
        if (this.targetId.equals(XQEIntegerPool.getInteger(-1)) || this.getTargetClassName() == null) {
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        LockContextColumn newAction = (LockContextColumn)super.copy(edgeElementFactory);
        newAction.setTargetClassName(this.getTargetClassName());
        newAction.setTargetId(this.getTargetId());
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        return this.copy(edgeElementFactory);
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put("of", this.getTargetId().toString());
        return propertiesMap;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_TARGET_ID, this.targetId);
        ctx.property(ATTRIBUTE_TARGET_CLASS_NAME, this.targetClassName);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_TARGET_ID)) {
            Object val = ctx.attributeValue(att);
            this.targetId = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_TARGET_CLASS_NAME)) {
            Object val = ctx.attributeValue(att);
            this.targetClassName = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }
}

