/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory;

import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementIndex;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementTypeEnum;

public class EdgeElementFactory {
    private final XQEIDGenerator idGenerator = new XQEIDGenerator();
    private final EdgeElementIndex edgeElementIndex = new EdgeElementIndex();
    private ActionFactory actionFactory = new ActionFactory();

    public final AbstractOLAPEdgeElement createEdgeElementByType(int type) {
        AbstractOLAPEdgeElement edgeElement = EdgeElementFactory.getEdgeElementByType(type);
        if (edgeElement != null) {
            edgeElement.setId(this.idGenerator.getNextID());
            this.edgeElementIndex.addElement(edgeElement);
        }
        return edgeElement;
    }

    public final AbstractOLAPEdgeElement createEdgeElementByName(String name) {
        AbstractOLAPEdgeElement edgeElement = EdgeElementFactory.getEdgeElementByName(name);
        if (edgeElement != null) {
            edgeElement.setId(this.idGenerator.getNextID());
            this.edgeElementIndex.addElement(edgeElement);
        }
        return edgeElement;
    }

    private XQEIDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    private AbstractOLAPEdgeElement getEdgeElementByID(Integer edgeElementId) {
        return this.edgeElementIndex.getElementByID(edgeElementId);
    }

    private static AbstractOLAPEdgeElement getEdgeElementByName(String name) {
        if (name == null) {
            return null;
        }
        Integer type = EdgeElementTypeEnum.NAME_TO_TYPE_MAP.get(name);
        if (type == null) {
            return null;
        }
        return EdgeElementFactory.getEdgeElementByType(type);
    }

    private static AbstractOLAPEdgeElement getEdgeElementByType(int type) {
        AbstractOLAPEdgeElement edgeElement = null;
        switch (type) {
            case 0: {
                edgeElement = new OLAPRow();
                break;
            }
            case 1: {
                edgeElement = new OLAPRowCycle();
                break;
            }
            case 2: {
                edgeElement = new OLAPColumn();
                break;
            }
            case 3: {
                edgeElement = new OLAPContextColumn();
                break;
            }
            default: {
                edgeElement = null;
            }
        }
        return edgeElement;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory anActionFactory) {
        this.actionFactory = anActionFactory;
    }
}

