/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.mdx.parser.ASTFactor;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.functions.MDXFunctionProcessorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.trace.XQETrace;

public class XMdxFactor
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private String sign;
    private static final String ATTRIBUTE_SIGN = "sign";

    @Override
    public int getType() {
        return 501062;
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTFactor factor = (ASTFactor)node;
        this.sign = factor.getParameter(ATTRIBUTE_SIGN);
        this.setPropertyValue(ATTRIBUTE_SIGN, this.sign);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Block result = null;
        Block factorValueB = (Block)this.executeXMdxChildNode(0, context);
        double factor = 1.0;
        if (this.sign != null && this.sign.equals("-")) {
            InterpreterContext interpreterContext = context.getInterpreterContext();
            try {
                factorValueB.getValues(interpreterContext);
            }
            catch (InterpreterException e) {
                throw new MDXEngineException(e);
            }
            factor = -1.0;
            Block[] wrkBlocks = new Block[]{factorValueB};
            Block block = new Block(interpreterContext, wrkBlocks);
            IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Object signedValue = null;
                if (blockObj[0] instanceof Double) {
                    Double value = (Double)blockObj[0];
                    signedValue = new Double(value * factor);
                } else if (blockObj[0] instanceof Value) {
                    signedValue = MDXFunctionProcessorFactory.negateValue(interpreterContext, (Value)blockObj[0]);
                    if (signedValue == null) {
                        double d = ((Value)blockObj[0]).getDouble() * factor;
                        signedValue = DataValueFactory.createDoubleValue();
                        ((Value)signedValue).set(d);
                        ((Value)signedValue).setFormatId(((Value)blockObj[0]).getFormatId());
                    }
                } else {
                    signedValue = blockObj[0];
                }
                block.add(blockIter, signedValue);
            }
            result = block;
        } else {
            result = factorValueB;
        }
        return new CubicsValue(result);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_SIGN);
    }
}

